/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.hapi;

import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DefaultTimeSeriesBrowse;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.hapi.HapiDataSource;
import org.autoplot.hapi.HapiServer;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONObject;

public class HapiDataSourceFactory
extends AbstractDataSourceFactory {
    public DataSource getDataSource(URI uri) throws Exception {
        return new HapiDataSource(uri);
    }

    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        URISplit split = URISplit.parse((String)surl);
        String server = split.file;
        if (server == null) {
            problems.add("server is not identified");
        } else if (!server.endsWith("hapi")) {
            problems.add("server name must end in /hapi");
        }
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        String id = (String)params.get("id");
        String timerange = (String)params.get("timerange");
        if (id == null) {
            problems.add("the parameter id is needed");
        }
        if (timerange == null) {
            problems.add("the timerange is needed");
        } else {
            try {
                DatumRangeUtil.parseTimeRange((String)timerange);
            }
            catch (ParseException ex) {
                problems.add("timerange cannot be parsed");
            }
        }
        return problems.size() > 0;
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "id=", "dataset identifier"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "parameters=", "load one parameter"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "timerange=", "time range"));
        } else if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String paramName = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc);
            if (paramName.equals("id")) {
                URI uri = cc.resourceURI;
                if (uri == null) {
                    throw new IllegalArgumentException("expected das2server location");
                }
                List<String> dss = HapiServer.getCatalogIds(uri.toURL());
                for (String ds : dss) {
                    if (!ds.startsWith(cc.completable)) continue;
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, ds));
                }
            } else if (paramName.equals("parameters")) {
                URI uri = cc.resourceURI;
                if (uri == null) {
                    throw new IllegalArgumentException("expected das2server location");
                }
                URISplit split = URISplit.parse((String)cc.surl);
                LinkedHashMap params = URISplit.parseParams((String)split.params);
                String id = (String)params.get("id");
                JSONArray dss = HapiServer.getParameters(uri.toURL(), id);
                for (int i = 0; i < dss.length(); ++i) {
                    JSONObject paramObject = dss.getJSONObject(i);
                    String name = paramObject.getString("name");
                    if (!name.startsWith(cc.completable)) continue;
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, name));
                }
            } else if (paramName.equals("timerange")) {
                URI uri = cc.resourceURI;
                if (uri == null) {
                    throw new IllegalArgumentException("expected das2server location");
                }
                URISplit split = URISplit.parse((String)cc.surl);
                LinkedHashMap params = URISplit.parseParams((String)split.params);
                String id = (String)params.get("id");
                JSONObject jo = HapiServer.getInfo(uri.toURL(), id);
                DatumRange dr = HapiServer.getSampleTimeRange(jo);
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, dr.toString().replaceAll("\\ ", "+")));
            }
        }
        return result;
    }

    public <T> T getCapability(Class<T> clazz) {
        if (clazz == TimeSeriesBrowse.class) {
            return (T)new DefaultTimeSeriesBrowse();
        }
        return (T)super.getCapability(clazz);
    }

    public boolean supportsDiscovery() {
        return true;
    }

    public boolean isFileResource() {
        return false;
    }
}

