/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.hapi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.autoplot.hapi.AbstractLineReader;
import org.autoplot.hapi.SingleFileBufferedReader;

public class PasteBufferedReader
implements AbstractLineReader {
    List<AbstractLineReader> readers;
    char delim = (char)9;
    boolean monotonicKludge = true;
    String greatestValue = null;

    public PasteBufferedReader() {
        this.readers = new ArrayList<AbstractLineReader>();
    }

    public void setDelim(char delim) {
        this.delim = delim;
    }

    public void pasteBufferedReader(AbstractLineReader r) {
        this.readers.add(r);
    }

    public void setMonotonicKludge(boolean t) {
        this.monotonicKludge = t;
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder b = new StringBuilder();
        boolean done = true;
        int col = 0;
        boolean skipNonMono = false;
        for (AbstractLineReader r : this.readers) {
            if (col > 0) {
                b.append(this.delim);
            }
            String s = r.readLine();
            if (col == 0 && s != null) {
                if (this.monotonicKludge && this.greatestValue != null && this.greatestValue.compareTo(s) > 0) {
                    skipNonMono = true;
                } else {
                    this.greatestValue = s;
                }
            }
            if (s != null && !skipNonMono) {
                b.append(s);
                done = false;
            }
            ++col;
        }
        if (done) {
            return null;
        }
        return b.toString();
    }

    @Override
    public void close() throws IOException {
        for (AbstractLineReader r : this.readers) {
            r.close();
        }
    }

    public static void main(String[] args) throws IOException {
        StringReader r1 = new StringReader("a\nb\nc\n");
        StringReader r2 = new StringReader("x\ny\nz\n");
        PasteBufferedReader r = new PasteBufferedReader();
        r.pasteBufferedReader(new SingleFileBufferedReader(new BufferedReader(r1)));
        r.pasteBufferedReader(new SingleFileBufferedReader(new BufferedReader(r2)));
        String s = r.readLine();
        while (s != null) {
            System.err.println(s);
            s = r.readLine();
        }
    }
}

