/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.aggregator;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.capability.Updating;
import org.das2.datum.DatumRange;
import org.das2.fsm.FileStorageModel;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.LocalFileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class AggregationPollUpdating
implements Updating {
    private static final Logger logger = Logger.getLogger("apdss.agg.updating");
    FileStorageModel fsm;
    DatumRange dr;
    long dirHash;
    long pollCyclePeriodSeconds = -1L;
    boolean dirty = false;
    boolean polling = false;
    private static final int LIMIT_SHORT_CYCLE_PERIOD_SECONDS = 1;
    private static final int LIMIT_SHORT_REMOTE_CYCLE_PERIOD_SECONDS = 10;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public AggregationPollUpdating(FileStorageModel fsm, DatumRange dr, long pollCyclePeriodSeconds) {
        this.fsm = fsm;
        this.dr = dr;
        if (fsm.getFileSystem() instanceof LocalFileSystem) {
            if (pollCyclePeriodSeconds < 1L) {
                logger.log(Level.FINE, "pollCyclePeriodSeconds too low, for local files it must be at least {0} seconds", 1);
                pollCyclePeriodSeconds = 1L;
            }
        } else if (pollCyclePeriodSeconds < 10L) {
            logger.log(Level.FINE, "pollCyclePeriodSeconds too low, for remote files it must be at least {0} seconds", 10);
            pollCyclePeriodSeconds = 10L;
        }
        this.pollCyclePeriodSeconds = pollCyclePeriodSeconds;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
        try {
            this.startPolling();
        }
        catch (IOException ex) {
            logger.severe(ex.getLocalizedMessage());
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
        if (!this.pcs.hasListeners(null)) {
            this.stopPolling();
        }
    }

    private long dirHash(DatumRange datumRange) throws IOException {
        String[] ss = this.fsm.getBestNamesFor(datumRange, (ProgressMonitor)new NullProgressMonitor());
        long hash = 1L;
        for (String s : ss) {
            FileObject fo = this.fsm.getFileSystem().getFileObject(s);
            Date lm = fo.lastModified();
            long sz = fo.getSize();
            hash = hash + 17L * (long)lm.hashCode() + 31L * sz + 31L * (long)s.hashCode();
        }
        return hash;
    }

    public void startPolling() throws IOException {
        logger.fine("start polling");
        if (this.dirHash != 0L || this.polling) {
            return;
        }
        this.dirHash = this.dirHash(this.dr);
        logger.log(Level.FINE, "start polling {0} in {1}", new Object[]{this.fsm, this.dr});
        Runnable run = new Runnable(){

            @Override
            public void run() {
                while (AggregationPollUpdating.this.dirHash != 0L) {
                    logger.log(Level.FINER, "polling {0} in {1}", new Object[]{AggregationPollUpdating.this.fsm, AggregationPollUpdating.this.dr});
                    try {
                        Thread.sleep(AggregationPollUpdating.this.pollCyclePeriodSeconds * 1000L);
                    }
                    catch (InterruptedException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    try {
                        long dirHash1 = AggregationPollUpdating.this.dirHash(AggregationPollUpdating.this.dr);
                        if (AggregationPollUpdating.this.dirHash != 0L && dirHash1 != AggregationPollUpdating.this.dirHash) {
                            AggregationPollUpdating.this.dirty = true;
                            AggregationPollUpdating.this.dirHash = dirHash1;
                        }
                        if (!AggregationPollUpdating.this.dirty || AggregationPollUpdating.this.dirHash != dirHash1) continue;
                        AggregationPollUpdating.this.pcs.firePropertyChange("dataSet", null, null);
                        AggregationPollUpdating.this.dirty = false;
                    }
                    catch (IOException ex) {
                        logger.severe(ex.toString());
                        throw new RuntimeException(ex);
                    }
                }
                AggregationPollUpdating.this.polling = false;
            }
        };
        this.polling = true;
        new Thread(run, "FilePollUpdating_" + this.dirHash).start();
    }

    public void stopPolling() {
        logger.log(Level.FINE, "stop polling {0} in {1}", new Object[]{this.fsm, this.dr});
        this.dirHash = 0L;
        this.polling = false;
    }

    public boolean isPolling() {
        return this.polling;
    }

    public static void main(String[] args) throws FileSystem.FileSystemOfflineException, UnknownHostException, URISyntaxException, IOException, InterruptedException {
        FileStorageModel fsm = FileStorageModel.create((FileSystem)FileSystem.create((URI)new URI("file:/home/jbf/eg/data/agg/")), (String)"hk_h0_mag_$Y$m$d_v02.cdf");
        AggregationPollUpdating a = new AggregationPollUpdating(fsm, null, 1L);
        a.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                logger.fine(evt.toString());
            }
        });
        a.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                logger.log(Level.FINE, "{0}  {1}", new Object[]{evt.getNewValue(), Thread.currentThread().getName()});
            }
        });
        Thread.sleep(6000L);
        a.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                logger.log(Level.FINE, "{0}  {1}  *** ", new Object[]{evt.getNewValue(), Thread.currentThread().getName()});
            }
        });
    }
}

