/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.RecentComboBox;
import org.autoplot.datasource.TimeRangeTool;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.UnrecognizedDataSourceException;
import org.autoplot.datasource.WindowManager;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;

public class CompletionsDataSourceEditor
extends JPanel
implements DataSourceEditorPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss");
    private static final int MAX_VAP_PREFIX = 14;
    String suri;
    boolean suriNoFile = false;
    List<JCheckBox> opsCbs;
    List<Control> opsComboBoxes;
    JComboBox arg0Cbs = null;
    String arg0Extra = null;
    JTextField arg0ExtraTF = null;
    Control arg0ComboBox = null;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JPanel optionsPanel;

    private static Control getFromComboBox(final JComboBox tcb) {
        return new Control(){

            @Override
            public String getValue() {
                return (String)tcb.getSelectedItem();
            }

            @Override
            public void setValue(String s) {
                tcb.setSelectedItem(s);
            }
        };
    }

    public CompletionsDataSourceEditor() {
        this.initComponents();
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(this.getFont().getSize());
    }

    private boolean isNotFile(String surl1) {
        URISplit split = URISplit.parse(surl1);
        return split.file == null || split.file.equals("") || split.file.equals("file:///");
    }

    private CompletionContext prepareContext(String surl1, int carotPos) {
        CompletionContext cc = new CompletionContext();
        int qpos = surl1.lastIndexOf(63, carotPos);
        if (qpos == -1 && carotPos == surl1.length()) {
            int icolon = surl1.indexOf(":");
            if (this.suriNoFile) {
                surl1 = surl1.substring(0, icolon) + ":?" + surl1.substring(icolon + 1);
                qpos = icolon + 1;
            } else {
                surl1 = surl1 + "?";
                qpos = surl1.length() - 1;
            }
            carotPos = surl1.length();
        }
        cc.surl = surl1;
        cc.surlpos = carotPos;
        if (qpos != -1 && qpos < carotPos) {
            int eqpos = surl1.lastIndexOf(61, carotPos - 1);
            int amppos = surl1.lastIndexOf(38, carotPos - 1);
            if (amppos == -1) {
                amppos = qpos;
            }
            if (eqpos > amppos) {
                cc.context = CompletionContext.CONTEXT_PARAMETER_VALUE;
                cc.completable = surl1.substring(eqpos + 1, carotPos);
                cc.completablepos = carotPos - (eqpos + 1);
            } else {
                cc.context = CompletionContext.CONTEXT_PARAMETER_NAME;
                cc.completable = surl1.substring(amppos + 1, carotPos);
                cc.completablepos = carotPos - (amppos + 1);
            }
        }
        return cc;
    }

    private List<CompletionContext> getCompletions(DataSourceFactory factory, String surl1, CompletionContext cc, ProgressMonitor mon) throws URISyntaxException, Exception {
        List<CompletionContext> result;
        URISplit split = URISplit.parse(surl1);
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            String resourceUri = CompletionContext.get(CompletionContext.CONTEXT_FILE, cc);
            if (resourceUri != null) {
                URI uri = DataSetURI.getURI(CompletionContext.get(CompletionContext.CONTEXT_FILE, cc));
                cc.resourceURI = DataSetURI.getResourceURI(uri);
            }
            cc.params = split.params;
            result = factory.getCompletions(cc, mon);
        } else if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            if (this.suriNoFile) {
                cc.resourceURI = null;
            } else {
                URI uri = DataSetURI.getURI(CompletionContext.get(CompletionContext.CONTEXT_FILE, cc));
                cc.resourceURI = DataSetURI.getResourceURI(uri);
            }
            cc.params = split.params;
            if (factory == null) {
                throw new IllegalArgumentException("unable to find data source factory");
            }
            result = factory.getCompletions(cc, mon);
        } else {
            throw new IllegalArgumentException("we aren't in the query section");
        }
        return result;
    }

    private void populateFromCompletions(DataSourceFactory dsf, ProgressMonitor mon) throws URISyntaxException, Exception {
        int i = this.suri.indexOf("?");
        if (i == -1) {
            int icolon = this.suri.indexOf(":");
            if (this.suriNoFile && icolon > -1 && icolon < 14) {
                this.suri = this.suri.substring(0, icolon) + ":?" + this.suri.substring(icolon + 1);
                i = icolon + 2;
            } else {
                this.suri = this.suri + "?";
                i = this.suri.length();
            }
        } else {
            ++i;
        }
        URISplit split = URISplit.parse(this.suri);
        LinkedHashMap<String, String> map = URISplit.parseParams(split.params);
        CompletionContext cc = this.prepareContext(this.suri, i);
        List<CompletionContext> first = this.getCompletions(dsf, this.suri, cc, mon);
        ArrayList<CompletionContext> arg0 = new ArrayList<CompletionContext>();
        for (CompletionContext cc1 : first) {
            if (cc1.implicitName == null || !cc1.implicitName.equals("arg_0")) continue;
            arg0.add(cc1);
        }
        first.removeAll(arg0);
        this.opsCbs = new ArrayList<JCheckBox>();
        this.opsComboBoxes = new ArrayList<Control>();
        boolean empty = true;
        if (arg0.size() > 0) {
            int ib;
            JPanel optPanel = new JPanel(new BorderLayout());
            empty = false;
            String val = (String)map.get("arg_0");
            if (val != null && (ib = val.indexOf("[")) > -1 && val.endsWith("]")) {
                this.arg0Extra = val.substring(ib);
            }
            int isel = -1;
            ArrayList<String> arg0options = new ArrayList<String>();
            for (int ii = 0; ii < arg0.size(); ++ii) {
                String s;
                if (((CompletionContext)arg0.get((int)ii)).completable.equals(((CompletionContext)arg0.get((int)ii)).label)) {
                    ((CompletionContext)arg0.get((int)ii)).label = null;
                }
                if (((CompletionContext)arg0.get((int)ii)).completable.equals("") && (s = ((CompletionContext)arg0.get((int)ii)).label) != null && s.trim().length() > 0) {
                    optPanel.add("North", new JLabel(s));
                }
                if (((CompletionContext)arg0.get((int)ii)).label != null) {
                    arg0options.add(((CompletionContext)arg0.get((int)ii)).completable + ": " + ((CompletionContext)arg0.get((int)ii)).label);
                } else {
                    arg0options.add(((CompletionContext)arg0.get((int)ii)).completable);
                }
                if (!((CompletionContext)arg0.get((int)ii)).completable.equals(val)) continue;
                isel = ii;
            }
            JComboBox<Object> jopts = new JComboBox<Object>(arg0options.toArray());
            optPanel.add("Center", jopts);
            if (isel != -1) {
                jopts.setSelectedIndex(isel);
            }
            this.arg0ComboBox = CompletionsDataSourceEditor.getFromComboBox(jopts);
            if (this.arg0Extra != null) {
                this.arg0ExtraTF = new JTextField(12);
                this.arg0ExtraTF.setText(this.arg0Extra);
                this.arg0ExtraTF.setToolTipText("subset specifier like [2:] or [-100:]");
                optPanel.add("East", this.arg0ExtraTF);
            }
            this.arg0Cbs = jopts;
            optPanel.setMaximumSize(new Dimension(10000, 16));
            this.optionsPanel.add(optPanel);
            this.optionsPanel.add(Box.createVerticalStrut(8));
        }
        for (CompletionContext cc1 : first) {
            int pos;
            String ss = CompletionContext.insert(cc, cc1);
            JPanel optPanel = new JPanel(new BorderLayout());
            final JCheckBox jcheckBox = new JCheckBox(cc1.label);
            optPanel.add("West", jcheckBox);
            this.opsCbs.add(jcheckBox);
            empty = false;
            if (cc1.doc != null && cc1.doc.trim().length() > 0) {
                optPanel.add("North", new JLabel(cc1.doc));
            }
            if ((pos = ss.indexOf(cc1.completable)) > -1) {
                pos += cc1.completable.length();
            }
            CompletionContext cc2 = this.prepareContext(ss, pos > -1 ? pos : ss.length());
            if (cc2.context != null) {
                JPanel control;
                List<CompletionContext> second = this.getCompletions(dsf, ss, cc2, mon);
                ArrayList<String> options = new ArrayList<String>();
                String key = cc1.completable;
                if (key != null) {
                    int ii = key.indexOf("=");
                    if (ii > -1) {
                        key = key.substring(0, ii);
                    }
                } else {
                    logger.warning("bad key in uri");
                    continue;
                }
                String val = (String)map.get(key);
                if (val != null) {
                    // empty if block
                }
                int isel = -1;
                String deft = null;
                for (int ii = 0; ii < second.size(); ++ii) {
                    CompletionContext cc3 = second.get(ii);
                    if (cc3.completable.equals(val)) {
                        isel = ii;
                    }
                    if (cc3.label.startsWith(cc3.completable + ":")) {
                        options.add(cc3.label);
                    } else {
                        if (cc3.completable.equals(cc3.label)) {
                            cc3.label = null;
                        }
                        if (cc3.completable.equals(cc3.label)) {
                            options.add(cc3.label);
                        } else if (cc3.label == null) {
                            options.add(cc3.completable);
                        } else {
                            options.add(cc3.completable + ": " + cc3.label);
                        }
                    }
                    if (!cc3.completable.startsWith("<double") && !cc3.completable.startsWith("<int")) continue;
                    deft = "";
                    jcheckBox.setToolTipText((cc1.doc != null ? cc1.doc + " " : "") + cc3.completable);
                }
                if (key.equals("timerange")) {
                    JPanel valuePanel = new JPanel();
                    valuePanel.setLayout(new BoxLayout(valuePanel, 0));
                    RecentComboBox tcb = new RecentComboBox();
                    tcb.setPreferenceNode("timerange");
                    Dimension x = tcb.getPreferredSize();
                    x.width = Integer.MAX_VALUE;
                    tcb.setMaximumSize(x);
                    tcb.setAlignmentX(0.0f);
                    tcb.setText(val);
                    ImageIcon fileIcon = new ImageIcon(CompletionsDataSourceEditor.class.getResource("/org/autoplot/datasource/calendar.png"));
                    JButton button = new JButton(fileIcon);
                    button.addActionListener(e -> {
                        TimeRangeTool tt = new TimeRangeTool();
                        tt.setSelectedRange(tcb.getSelectedItem().toString());
                        int r = WindowManager.showConfirmDialog(this, tt, "Select Time Range", 2);
                        if (r == 0) {
                            tcb.setSelectedItem(tt.getSelectedRange());
                        }
                    });
                    button.setToolTipText("Time Range Tool");
                    valuePanel.add(tcb);
                    button.setAlignmentX(0.0f);
                    valuePanel.add(button);
                    control = valuePanel;
                    Control c = CompletionsDataSourceEditor.getFromComboBox(tcb);
                    this.opsComboBoxes.add(c);
                } else {
                    final JComboBox<Object> jopts = new JComboBox<Object>(options.toArray());
                    jopts.setEditable(true);
                    optPanel.add("Center", jopts);
                    if (isel != -1) {
                        jopts.setSelectedIndex(isel);
                        jcheckBox.setSelected(true);
                    } else if (deft != null) {
                        jopts.setSelectedItem(deft);
                    }
                    jcheckBox.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            jopts.setEnabled(jcheckBox.isSelected());
                        }
                    });
                    jopts.setEnabled(jcheckBox.isSelected());
                    this.opsComboBoxes.add(CompletionsDataSourceEditor.getFromComboBox(jopts));
                    optPanel.setMaximumSize(new Dimension(10000, 16));
                    control = optPanel;
                }
                this.optionsPanel.add(control);
                this.optionsPanel.add(Box.createVerticalStrut(8));
                continue;
            }
            this.opsComboBoxes.add(null);
        }
        if (empty) {
            String id = split.vapScheme == null ? "for " + split.ext : split.vapScheme;
            this.optionsPanel.add(new JLabel("<html><i>Data source " + id + " provides no completions, so presumably there are no options available.</i></html>"));
        }
        this.optionsPanel.add(Box.createGlue());
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void setURI(String uri) {
        this.suri = uri;
        this.suriNoFile = this.isNotFile(uri);
        URISplit split = URISplit.parse(this.suri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        for (Map.Entry e : params.entrySet()) {
            String s = (String)e.getKey();
            String v = (String)e.getValue();
            for (int i = 0; i < this.opsCbs.size(); ++i) {
                if (!this.opsCbs.get(i).getText().equals(s + "=")) continue;
                this.opsCbs.get(i).setSelected(true);
                if (this.opsComboBoxes.get(i) == null) continue;
                this.opsComboBoxes.get(i).setValue(v);
            }
        }
    }

    @Override
    public String getURI() {
        StringBuilder base = new StringBuilder(this.suri);
        int j = base.indexOf("?");
        if (j == -1 || this.suriNoFile) {
            int icolon = this.suri.indexOf(58);
            if (this.suriNoFile && icolon > -1 && icolon < 14) {
                base = new StringBuilder(base.substring(0, icolon + 1));
            }
        } else {
            base = new StringBuilder(base.substring(0, j));
        }
        boolean amp = false;
        if (this.arg0Cbs != null) {
            String s;
            int i;
            if (!this.suriNoFile) {
                base.append("?");
            }
            if ((i = (s = String.valueOf(this.arg0Cbs.getSelectedItem())).indexOf(": ")) > -1) {
                s = s.substring(0, i);
            }
            base.append(s);
            amp = true;
        }
        if (this.arg0ExtraTF != null && this.arg0ExtraTF.getText().trim().length() > 0) {
            base.append(this.arg0ExtraTF.getText().trim());
        }
        for (int i = 0; i < this.opsCbs.size(); ++i) {
            String paramValue;
            int icolon;
            if (!this.opsCbs.get(i).isSelected()) continue;
            String paramName = this.opsCbs.get(i).getText();
            if (paramName.endsWith("=")) {
                paramName = paramName.substring(0, paramName.length() - 1);
            }
            if ((icolon = (paramValue = this.opsComboBoxes.get(i) != null ? String.valueOf(this.opsComboBoxes.get(i).getValue()) : "????").indexOf(58)) != -1 && !paramName.equalsIgnoreCase("timerange")) {
                paramValue = paramValue.substring(0, icolon);
            }
            if (amp) {
                base.append("&");
            } else {
                if (!this.suriNoFile) {
                    base.append("?");
                }
                amp = true;
            }
            base.append(paramName);
            base.append("=");
            base.append(paramValue);
        }
        this.suri = base.toString();
        return this.suri;
    }

    @Override
    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        this.suri = uri;
        this.suriNoFile = this.isNotFile(uri);
        DataSourceFactory dsf = DataSetURI.getDataSourceFactory(DataSetURI.getURI(uri), mon);
        if (dsf == null) {
            throw new UnrecognizedDataSourceException(uri);
        }
        this.populateFromCompletions(dsf, mon);
        return true;
    }

    @Override
    public boolean reject(String uri) throws Exception {
        URISplit split = URISplit.parse(uri);
        return split.file == null || split.file.equals("file:///");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.optionsPanel = new JPanel();
        this.jLabel1.setText("<html>Autoplot has attempted to create a GUI editor based on the completions of the data source. ");
        this.jLabel1.setVerticalAlignment(1);
        this.optionsPanel.setAlignmentY(0.0f);
        this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
        this.jScrollPane1.setViewportView(this.optionsPanel);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1, -1, 585, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 585, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1, -2, -1, -2).add(0, 377, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(35, 35, 35).add((Component)this.jScrollPane1, -1, 359, Short.MAX_VALUE))));
    }

    @Override
    public void markProblems(List<String> problems) {
    }

    private static interface Control {
        public String getValue();

        public void setValue(String var1);
    }
}

