/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.das2.util.LoggerManager;

public class GuiUtil {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.gui");

    private static void dumpAllMinSizes(String indent, Component c) {
        System.err.println(String.format("%s%s %d", indent, c.getName(), c.getMinimumSize().width));
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            for (int i = 0; i < jc.getComponentCount(); ++i) {
                GuiUtil.dumpAllMinSizes(indent + "  ", jc.getComponent(i));
            }
        }
    }

    public static void addResizeListenerToAll(JComponent c) {
        ComponentListener l = new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                int minw = e.getComponent().getMinimumSize().width;
                System.err.println("resize " + e.getComponent().getName() + " minw=" + e.getComponent().getMinimumSize().width + " " + e.getComponent().getWidth() + " " + e.getID());
                if (minw == e.getComponent().getWidth()) {
                    GuiUtil.dumpAllMinSizes("  ", e.getComponent());
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        };
        for (int i = 0; i < c.getComponentCount(); ++i) {
            c.getComponent(i).addComponentListener(l);
        }
    }

    public static boolean hasScrollPane(JComponent c) {
        if (c instanceof JScrollPane) {
            return true;
        }
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component child = c.getComponent(i);
            if (child instanceof JScrollPane) {
                return true;
            }
            if (!(child instanceof JComponent) || !GuiUtil.hasScrollPane((JComponent)child)) continue;
            return true;
        }
        return false;
    }

    private static void collectButtons(Component c, List<JButton> out) {
        if (c instanceof JButton) {
            out.add((JButton)c);
        }
        if (c instanceof Container) {
            for (Component child : ((Container)c).getComponents()) {
                GuiUtil.collectButtons(child, out);
            }
        }
    }

    public static void ensureAllButtonsVisible(Window dialog) {
        logger.fine("ensureAllButtonsVisible");
        SwingUtilities.invokeLater(() -> {
            ArrayList<JButton> children = new ArrayList<JButton>();
            GuiUtil.collectButtons(dialog, children);
            Rectangle result = new Rectangle(0, 0, 0, 0);
            int dlgWidth = dialog.getWidth();
            int dlgHeight = dialog.getHeight();
            for (JButton c : children) {
                Point p = SwingUtilities.convertPoint(c, 0, 0, dialog);
                int left = p.x;
                int top = p.y;
                int right = left + c.getWidth();
                int bottom = top + c.getHeight();
                if (c.getHeight() <= 0 || c.getWidth() <= 0) continue;
                Rectangle r = new Rectangle(left, top, c.getWidth(), c.getHeight());
                result.add(r);
            }
            Insets insets = dialog.getInsets();
            int requireX = result.width + insets.left + insets.right;
            int requireY = result.height + insets.top + insets.bottom;
            if (dialog.getWidth() < requireX || dialog.getHeight() < requireY) {
                if (dialog.getWidth() > requireX) {
                    requireX = dialog.getWidth();
                }
                if (dialog.getHeight() > requireY) {
                    requireY = dialog.getHeight();
                }
                dialog.setPreferredSize(new Dimension(requireX, requireY));
                dialog.setSize(new Dimension(requireX, requireY));
                dialog.pack();
                dialog.validate();
            }
        });
    }

    public static void ensureAllButtonsVisibleSoon(final Window dialog) {
        logger.fine("ensureAllButtonsVisibleSoon");
        dialog.addComponentListener(new ComponentAdapter(){
            private boolean first = true;

            @Override
            public void componentShown(ComponentEvent e) {
                if (this.first) {
                    this.first = false;
                    GuiUtil.ensureAllButtonsVisible(dialog);
                }
            }
        });
    }
}

