/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import org.autoplot.datasource.AutoplotSettings;
import org.das2.datum.LoggerManager;

public class RecentComboBoxModel
extends DefaultComboBoxModel
implements ActionListener {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.uri");
    private static final int RECENT_SIZE = 20;
    File bookmarksFolder = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks");
    File recentFile;
    InputVerifier verifier = null;

    public RecentComboBoxModel(String pref) {
        this.recentFile = new File(this.bookmarksFolder, "recent." + pref + ".txt");
        this.loadRecent();
    }

    public void setVerifier(InputVerifier v) {
        this.verifier = v;
    }

    private synchronized void loadRecent() {
        ArrayList<String> items = new ArrayList<String>(22);
        try {
            if (this.recentFile.exists()) {
                BufferedReader r = new BufferedReader(new FileReader(this.recentFile));
                String s = r.readLine();
                while (s != null) {
                    if (this.verifier != null && !this.verifier.verify(s)) {
                        s = r.readLine();
                        continue;
                    }
                    items.add(s);
                    s = r.readLine();
                }
            }
            Collections.reverse(items);
            ArrayList<String> nitems = new ArrayList<String>(items.size());
            for (int i = 0; i < items.size(); ++i) {
                String item = (String)items.get(i);
                if (nitems.contains(item)) continue;
                nitems.add(item);
            }
            items = nitems;
            int n = items.size();
            if (n > 20) {
                items = items.subList(n - 20, n);
            }
            super.removeAllElements();
            for (int i = 0; i < items.size(); ++i) {
                super.insertElementAt(items.get(i), i);
            }
            this.saveRecent(items);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private synchronized void saveRecent(List<String> items) {
        if (!this.recentFile.getParentFile().exists()) {
            return;
        }
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new FileWriter(this.recentFile));
            items = new ArrayList<String>(items);
            Collections.reverse(items);
            for (String s : items) {
                w.append(s, 0, s.length());
                w.append("\n");
            }
            w.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        org.das2.util.LoggerManager.logGuiEvent((ActionEvent)e);
        String s = this.getSelectedItem().toString();
        if (this.verifier != null && !this.verifier.verify(s)) {
            return;
        }
        BufferedWriter w = null;
        try {
            RecentComboBoxModel recentComboBoxModel = this;
            synchronized (recentComboBoxModel) {
                w = this.recentFile.exists() ? new BufferedWriter(new FileWriter(this.recentFile, true)) : new BufferedWriter(new FileWriter(this.recentFile));
                w.append(s, 0, s.length());
                w.append("\n");
                w.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        this.loadRecent();
    }

    public static interface InputVerifier {
        public boolean verify(String var1);
    }
}

