/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultEditorKit;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.DataSourceEditorPanelUtil;
import org.autoplot.datasource.RecentComboBox;
import org.autoplot.datasource.TimeRangeTool;
import org.autoplot.datasource.TimeRangeVerifier;
import org.autoplot.datasource.ui.PromptComboBoxEditor;
import org.das2.DasApplication;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.util.LoggerManager;
import org.jdesktop.layout.GroupLayout;

public class TimeRangeEditor
extends JPanel {
    private static final Logger logger = org.das2.datum.LoggerManager.getLogger((String)"apdss.gui");
    DatumRange range;
    DatumRange controlRange;
    public static final String PROP_USE_DOY = "useDoy";
    boolean useDoy;
    private String rescale;
    public static final String PROP_RESCALE = "rescale";
    public static final String PROP_RANGE = "range";
    private boolean suppressRecentComboBoxActionEvents;
    public static final String PROP_CONTROL_RANGE = "controlRange";
    DatumRange noOneListening;
    private String lastErrorText;
    private long lastErrorTime;
    DataSetSelector peer;
    private JButton browseButton;
    private JButton nextButton;
    private JButton prevButton;
    private RecentComboBox recentComboBox;
    private JButton timeRangeToolButton;
    private String alternatePeer;
    private String alternatePeerCard;
    private boolean cardSelected;
    public static final String PROP_CARDSELECTED = "cardSelected";

    public TimeRangeEditor() {
        this.controlRange = this.range = DatumRangeUtil.parseTimeRangeValid((String)"2010-01-01");
        this.useDoy = false;
        this.rescale = "";
        this.suppressRecentComboBoxActionEvents = false;
        this.noOneListening = this.range;
        this.lastErrorText = null;
        this.lastErrorTime = 0L;
        this.alternatePeerCard = null;
        this.cardSelected = false;
        this.initComponents();
        this.timeRangeToolButton.setActionCommand("timeRangeTool");
        this.nextButton.setActionCommand("next");
        this.prevButton.setActionCommand("previous");
        this.browseButton.setActionCommand("inspect");
        this.recentComboBox.setName("timeRangeEditor");
        this.recentComboBox.setMinimumSize(new Dimension(200, 30));
        this.recentComboBox.setPreferenceNode("timerange");
        this.recentComboBox.setEditor(new PromptComboBoxEditor("Time range to view (e.g. 2010-01-01)"));
        this.recentComboBox.setToolTipText("Recently entered time ranges");
        ((JComponent)this.recentComboBox.getEditor().getEditorComponent()).setToolTipText("Time Range, right-click for examples");
        this.recentComboBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TimeRangeEditor.this.parseRange();
            }
        });
        this.recentComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                if (!TimeRangeEditor.this.suppressRecentComboBoxActionEvents) {
                    TimeRangeEditor.this.parseRange();
                }
            }
        });
        this.recentComboBox.setVerifier(new TimeRangeVerifier());
        this.browseButton.setVisible(false);
        this.revalidate();
        this.addMousePopupListener();
    }

    public boolean isUseDoy() {
        return this.useDoy;
    }

    public void setUseDoy(boolean useDoy) {
        boolean old = this.useDoy;
        this.useDoy = useDoy;
        DatumRangeUtil.setUseDoy((boolean)useDoy);
        this.firePropertyChange(PROP_USE_DOY, old, useDoy);
    }

    public String getRescale() {
        return this.rescale;
    }

    public void setRescale(String rescale) {
        String oldRescale = this.rescale;
        this.rescale = rescale;
        DatumRange oldRange = this.range;
        try {
            this.range = DatumRangeUtil.rescale((DatumRange)this.controlRange, (String)rescale);
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.firePropertyChange(PROP_RESCALE, oldRescale, rescale);
        this.firePropertyChange(PROP_RANGE, oldRange, this.range);
    }

    public DatumRange getRange() {
        return this.range;
    }

    public void setRange(final DatumRange value) {
        if (!UnitsUtil.isTimeLocation((Units)value.getUnits())) {
            return;
        }
        final DatumRange oldValue = this.range;
        final DatumRange oldControlRange = this.controlRange;
        this.range = value;
        try {
            this.controlRange = this.rescale.length() == 0 ? value : DatumRangeUtil.rescaleInverse((DatumRange)value, (String)this.rescale);
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        if (oldValue != value && oldValue != null && !oldValue.equals((Object)value) && !this.suppressRecentComboBoxActionEvents) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimeRangeEditor.super.firePropertyChange(TimeRangeEditor.PROP_RANGE, oldValue, value);
                    TimeRangeEditor.super.firePropertyChange(TimeRangeEditor.PROP_CONTROL_RANGE, oldControlRange, TimeRangeEditor.this.controlRange);
                }
            });
        }
        this.suppressRecentComboBoxActionEvents = true;
        if (value == this.noOneListening) {
            this.recentComboBox.setSelectedItem("");
        } else {
            this.recentComboBox.setSelectedItem(this.controlRange.toString());
        }
        this.suppressRecentComboBoxActionEvents = false;
    }

    public void setControlRange(final DatumRange value) {
        if (!UnitsUtil.isTimeLocation((Units)value.getUnits())) {
            return;
        }
        if (value.width().value() == 0.0) {
            throw new IllegalArgumentException("range width cannot be zero.");
        }
        final DatumRange oldValue = this.controlRange;
        final DatumRange oldRange = this.range;
        this.controlRange = value;
        try {
            this.range = this.rescale.length() == 0 ? value : DatumRangeUtil.rescale((DatumRange)value, (String)this.rescale);
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        if (oldValue != value && oldValue != null && !oldValue.equals((Object)value) && !this.suppressRecentComboBoxActionEvents) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimeRangeEditor.super.firePropertyChange(TimeRangeEditor.PROP_CONTROL_RANGE, oldValue, value);
                    TimeRangeEditor.super.firePropertyChange(TimeRangeEditor.PROP_RANGE, oldRange, TimeRangeEditor.this.range);
                }
            });
        }
        this.suppressRecentComboBoxActionEvents = true;
        if (value == this.noOneListening) {
            this.recentComboBox.setSelectedItem("");
        } else {
            this.recentComboBox.setSelectedItem(value.toString());
        }
        this.suppressRecentComboBoxActionEvents = false;
    }

    public void setNoOneListeningRange(DatumRange dr) {
        this.noOneListening = dr;
    }

    public DatumRange getNoOneListeningRange() {
        return this.noOneListening;
    }

    private static boolean isUri(String text) {
        String pref;
        int icolon;
        boolean isUri = false;
        if (text.startsWith("/")) {
            isUri = true;
        }
        if (!isUri && (icolon = text.indexOf(58)) > -1 && Character.isLetter((pref = text.substring(0, icolon)).charAt(0)) && Pattern.matches("[a-zA-Z_\\+0-9]*", pref)) {
            isUri = true;
        }
        return isUri;
    }

    private void parseRange() {
        block8: {
            DatumRange value = this.controlRange;
            String text = (String)this.recentComboBox.getSelectedItem();
            if (text == null || text.equals("")) {
                return;
            }
            try {
                String rangeString = text;
                DatumRange dr = DatumRangeUtil.parseTimeRange((String)rangeString);
                this.setControlRange(dr);
            }
            catch (ParseException e) {
                boolean isUri = TimeRangeEditor.isUri(text);
                if (isUri) {
                    if (this.peer != null) {
                        this.peer.setValue(text);
                        this.peer.maybePlot(true);
                        return;
                    }
                    this.showErrorUsage(text, "Appears to be a dataset location, and this expects timeranges");
                }
                if (UnitsUtil.isTimeLocation((Units)value.getUnits())) {
                    this.showErrorUsage(text, "<html>" + e.getMessage());
                }
            }
            catch (IllegalArgumentException e) {
                if (value == null) break block8;
                this.setControlRange(value);
                if (e.getMessage().contains("min > max")) {
                    this.showErrorUsage(text, "min cannot be greater than max");
                }
                this.showErrorUsage(text, e.getMessage());
            }
        }
    }

    @Override
    public final void revalidate() {
        super.revalidate();
    }

    private void showErrorUsage(String text, String why) {
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            if (text != null && text.equals(this.lastErrorText) && System.currentTimeMillis() - this.lastErrorTime < 5000L) {
                return;
            }
            if (why != null) {
                JOptionPane.showMessageDialog(this, "<html>Unable to accept \"" + text + "\"<br>" + why + "<html>");
            } else {
                JOptionPane.showMessageDialog(this, "<html>Unable to accept \"" + text + "\"</html>");
            }
            this.lastErrorText = text;
            this.lastErrorTime = System.currentTimeMillis();
        }
    }

    private void initComponents() {
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.browseButton = new JButton();
        this.recentComboBox = new RecentComboBox();
        this.timeRangeToolButton = new JButton();
        this.setPreferredSize(new Dimension(384, 39));
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/prevPrev.png")));
        this.prevButton.setToolTipText("Step to the previous interval");
        this.prevButton.setMaximumSize(new Dimension(34, 20));
        this.prevButton.setMinimumSize(new Dimension(34, 20));
        this.prevButton.setPreferredSize(new Dimension(34, 20));
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeRangeEditor.this.prevButtonActionPerformed(evt);
            }
        });
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/nextNext.png")));
        this.nextButton.setToolTipText("Step to the next interval");
        this.nextButton.setMaximumSize(new Dimension(34, 24));
        this.nextButton.setMinimumSize(new Dimension(34, 24));
        this.nextButton.setPreferredSize(new Dimension(34, 24));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeRangeEditor.this.nextButtonActionPerformed(evt);
            }
        });
        this.browseButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/fileMag.png")));
        this.browseButton.setToolTipText("Inspect data source");
        this.browseButton.setEnabled(false);
        this.browseButton.setMargin(new Insets(2, 2, 2, 2));
        this.browseButton.setMaximumSize(new Dimension(20, 20));
        this.browseButton.setMinimumSize(new Dimension(20, 20));
        this.browseButton.setPreferredSize(new Dimension(20, 20));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeRangeEditor.this.browseButtonActionPerformed(evt);
            }
        });
        this.recentComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"2010-01-01", "2010-01-02"}));
        this.recentComboBox.setMinimumSize(new Dimension(120, 27));
        this.timeRangeToolButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/calendar.png")));
        this.timeRangeToolButton.setToolTipText("Time Range Tool");
        this.timeRangeToolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeRangeEditor.this.timeRangeToolButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.recentComboBox, -1, 202, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.timeRangeToolButton).addPreferredGap(0).add((Component)this.prevButton, -2, 40, -2).addPreferredGap(0).add((Component)this.nextButton, -2, 34, -2).addPreferredGap(0).add((Component)this.browseButton, -2, 30, -2)));
        layout.linkSize(new Component[]{this.nextButton, this.prevButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.browseButton, -1, 27, Short.MAX_VALUE).add((Component)this.nextButton, -1, -1, Short.MAX_VALUE).add((Component)this.prevButton, -1, -1, Short.MAX_VALUE).add((Component)this.timeRangeToolButton, 0, 0, Short.MAX_VALUE).add((Component)this.recentComboBox, -2, -1, -2));
        layout.linkSize(new Component[]{this.browseButton, this.nextButton, this.prevButton, this.recentComboBox, this.timeRangeToolButton}, 2);
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.setControlRange(this.controlRange.next());
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.setControlRange(this.controlRange.previous());
    }

    public void setDataSetSelectorPeer(DataSetSelector peer) {
        this.peer = peer;
        if (peer != null) {
            this.browseButton.setEnabled(true);
            this.browseButton.setVisible(true);
        } else {
            this.browseButton.setEnabled(false);
            this.browseButton.setVisible(false);
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        if (this.peer != null) {
            DataSourceEditorPanel edit;
            String surl = this.peer.getLastValue().trim();
            if (this.peer.isExpertMode()) {
                this.peer.setValue(surl);
            }
            for (String browseTriggerRegex : this.peer.browseTriggers.keySet()) {
                if (!Pattern.matches(browseTriggerRegex, surl)) continue;
                logger.finest("matches browse trigger");
                Action action = this.peer.browseTriggers.get(browseTriggerRegex);
                action.actionPerformed(new ActionEvent(this, 123, "dataSetSelect"));
                return;
            }
            try {
                edit = DataSourceEditorPanelUtil.getDataSourceEditorPanel(DataSetURI.getURIValid(surl));
                if (edit != null && edit.reject(surl)) {
                    edit = null;
                }
            }
            catch (URISyntaxException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                edit = null;
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                edit = null;
            }
            if (edit == null) {
                JOptionPane.showMessageDialog(this.prevButton, "<html>The selected plot element has no editor:<br>" + surl, "no editor", 0);
            } else {
                this.peer.browseSourceType();
            }
        }
    }

    private void timeRangeToolButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        TimeRangeTool t = new TimeRangeTool();
        t.setSelectedRange(this.controlRange.toString());
        if (0 == JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), t, "Select time range", 2, 1, new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/calendar.png")))) {
            String str = t.getSelectedRange();
            try {
                this.setControlRange(DatumRangeUtil.parseTimeRangeValid((String)str));
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.FINE, "unable to parse time/orbit: {0}", str);
            }
            this.recentComboBox.actionPerformed(new ActionEvent(this, 0, "triggerSaveRecent", 0));
        }
    }

    public static void main(String[] args) {
        TimeRangeEditor p = new TimeRangeEditor();
        p.addPropertyChangeListener(PROP_RANGE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println(evt.getOldValue() + " -> " + evt.getNewValue());
            }
        });
        JFrame f = new JFrame();
        f.setContentPane(p);
        f.pack();
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }

    public PropertyChangeListener getUriFocusListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TimeRangeEditor.this.browseButton.setToolTipText("<html>Edit data source<br>" + evt.getNewValue().toString() + "</html>");
            }
        };
    }

    public void setAlternatePeer(String label, String card) {
        this.alternatePeer = label;
        this.alternatePeerCard = card;
    }

    private void addMousePopupListener() {
        this.recentComboBox.getEditor().getEditorComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TimeRangeEditor.this.showPopup(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TimeRangeEditor.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TimeRangeEditor.this.showPopup(e);
                }
            }
        });
    }

    private void showPopup(MouseEvent e) {
        this.getPopupMenu().show(this, e.getX(), e.getY());
    }

    private JMenuItem exampleTime(final String s, String toolTip) {
        JMenuItem mi = new JMenuItem(new AbstractAction(s){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeRangeEditor.this.recentComboBox.setSelectedItem(s);
            }
        });
        mi.setToolTipText(toolTip);
        return mi;
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu result = new JPopupMenu();
        JMenuItem cutItem = result.add(new DefaultEditorKit.CutAction());
        cutItem.setText("Cut");
        JMenuItem copyItem = result.add(new DefaultEditorKit.CopyAction());
        copyItem.setText("Copy");
        JMenuItem pasteItem = result.add(new DefaultEditorKit.PasteAction());
        pasteItem.setText("Paste");
        JMenu examplesMenu = new JMenu("Examples");
        examplesMenu.add(this.exampleTime("2010 Jan", "Month of January"));
        examplesMenu.add(this.exampleTime("2010-01-01", "January 1, 2010"));
        examplesMenu.add(this.exampleTime("2010-01-01/2010-01-04", "ISO8601 range"));
        examplesMenu.add(this.exampleTime("P5D", "Last 5 Days to now"));
        examplesMenu.add(this.exampleTime("orbit:rbspa-pp:30", "Orbit 30 from rbspa-pp orbits file"));
        examplesMenu.add(this.exampleTime("orbit:http://das2.org/wiki/index.php/Orbits/rbspa-pp:30", "Orbit 30 from any orbits file"));
        result.add(examplesMenu);
        if (this.alternatePeerCard != null) {
            result.add(new JSeparator());
            result.add(new AbstractAction(this.alternatePeer){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    LoggerManager.logGuiEvent((ActionEvent)ev);
                    Container trp = TimeRangeEditor.this.getParent();
                    if (trp.getLayout() instanceof CardLayout) {
                        TimeRangeEditor.this.setCardSelected(false);
                    }
                }
            });
        }
        return result;
    }

    public boolean isCardSelected() {
        return this.cardSelected;
    }

    public void setCardSelected(boolean cardSelected) {
        boolean oldCardSelected = this.cardSelected;
        this.cardSelected = cardSelected;
        this.firePropertyChange(PROP_CARDSELECTED, oldCardSelected, cardSelected);
    }

    public void setCardSelectedNoEventKludge(boolean cardSelected) {
        boolean oldCardSelected = this.cardSelected;
        this.cardSelected = cardSelected;
    }

    public void makeThinner() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.recentComboBox);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        p2.add(this.timeRangeToolButton);
        p2.add(this.prevButton);
        p2.add(this.nextButton);
        this.recentComboBox.setMaximumSize(this.recentComboBox.getPreferredSize());
        this.prevButton.setPreferredSize(this.nextButton.getPreferredSize());
        this.prevButton.setMinimumSize(this.nextButton.getMinimumSize());
        this.prevButton.setMaximumSize(this.nextButton.getMaximumSize());
        this.add(p2);
        this.setMinimumSize(new Dimension(this.recentComboBox.getMinimumSize().width, this.recentComboBox.getMinimumSize().height + this.prevButton.getMinimumSize().height + 5));
        this.setPreferredSize(this.getMinimumSize());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.prevButton.setEnabled(enabled);
        this.nextButton.setEnabled(enabled);
        this.timeRangeToolButton.setEnabled(enabled);
        this.recentComboBox.setEnabled(enabled);
    }
}

