/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.model.FormulaParser;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.cf.BorderFormatting;
import org.apache.poi.hssf.record.cf.FontFormatting;
import org.apache.poi.hssf.record.cf.PatternFormatting;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;

public final class CFRuleRecord
extends Record {
    public static final short sid = 433;
    private byte field_1_condition_type;
    public static final byte CONDITION_TYPE_CELL_VALUE_IS = 1;
    public static final byte CONDITION_TYPE_FORMULA = 2;
    private byte field_2_comparison_operator;
    private int field_5_options;
    private static final BitField modificationBits = CFRuleRecord.bf(0x3FFFFF);
    private static final BitField alignHor = CFRuleRecord.bf(1);
    private static final BitField alignVer = CFRuleRecord.bf(2);
    private static final BitField alignWrap = CFRuleRecord.bf(4);
    private static final BitField alignRot = CFRuleRecord.bf(8);
    private static final BitField alignJustLast = CFRuleRecord.bf(16);
    private static final BitField alignIndent = CFRuleRecord.bf(32);
    private static final BitField alignShrin = CFRuleRecord.bf(64);
    private static final BitField notUsed1 = CFRuleRecord.bf(128);
    private static final BitField protLocked = CFRuleRecord.bf(256);
    private static final BitField protHidden = CFRuleRecord.bf(512);
    private static final BitField bordLeft = CFRuleRecord.bf(1024);
    private static final BitField bordRight = CFRuleRecord.bf(2048);
    private static final BitField bordTop = CFRuleRecord.bf(4096);
    private static final BitField bordBot = CFRuleRecord.bf(8192);
    private static final BitField bordTlBr = CFRuleRecord.bf(16384);
    private static final BitField bordBlTr = CFRuleRecord.bf(32768);
    private static final BitField pattStyle = CFRuleRecord.bf(65536);
    private static final BitField pattCol = CFRuleRecord.bf(131072);
    private static final BitField pattBgCol = CFRuleRecord.bf(262144);
    private static final BitField notUsed2 = CFRuleRecord.bf(0x380000);
    private static final BitField undocumented = CFRuleRecord.bf(0x3C00000);
    private static final BitField fmtBlockBits = CFRuleRecord.bf(0x7C000000);
    private static final BitField font = CFRuleRecord.bf(0x4000000);
    private static final BitField align = CFRuleRecord.bf(0x8000000);
    private static final BitField bord = CFRuleRecord.bf(0x10000000);
    private static final BitField patt = CFRuleRecord.bf(0x20000000);
    private static final BitField prot = CFRuleRecord.bf(0x40000000);
    private static final BitField alignTextDir = CFRuleRecord.bf(Integer.MIN_VALUE);
    private short field_6_not_used;
    private FontFormatting fontFormatting;
    private byte field_8_align_text_break;
    private byte field_9_align_text_rotation_angle;
    private short field_10_align_indentation;
    private short field_11_relative_indentation;
    private short field_12_not_used;
    private BorderFormatting borderFormatting;
    private PatternFormatting patternFormatting;
    private Ptg[] field_17_formula1;
    private Ptg[] field_18_formula2;

    private static BitField bf(int i) {
        return BitFieldFactory.getInstance(i);
    }

    private CFRuleRecord(byte conditionType, byte comparisonOperation) {
        this.field_1_condition_type = conditionType;
        this.field_2_comparison_operator = comparisonOperation;
        this.field_5_options = modificationBits.setValue(this.field_5_options, -1);
        this.field_5_options = fmtBlockBits.setValue(this.field_5_options, 0);
        this.field_5_options = undocumented.clear(this.field_5_options);
        this.field_6_not_used = (short)-32766;
        this.fontFormatting = null;
        this.field_8_align_text_break = 0;
        this.field_9_align_text_rotation_angle = 0;
        this.field_10_align_indentation = 0;
        this.field_11_relative_indentation = 0;
        this.field_12_not_used = 0;
        this.borderFormatting = null;
        this.patternFormatting = null;
        this.field_17_formula1 = null;
        this.field_18_formula2 = null;
    }

    private CFRuleRecord(byte conditionType, byte comparisonOperation, Ptg[] formula1, Ptg[] formula2) {
        this(conditionType, comparisonOperation);
        this.field_1_condition_type = 1;
        this.field_2_comparison_operator = comparisonOperation;
        this.field_17_formula1 = formula1;
        this.field_18_formula2 = formula2;
    }

    public static CFRuleRecord create(HSSFWorkbook workbook, String formulaText) {
        Ptg[] formula1 = CFRuleRecord.parseFormula(formulaText, workbook);
        return new CFRuleRecord(2, 0, formula1, null);
    }

    public static CFRuleRecord create(HSSFWorkbook workbook, byte comparisonOperation, String formulaText1, String formulaText2) {
        Ptg[] formula1 = CFRuleRecord.parseFormula(formulaText1, workbook);
        Ptg[] formula2 = CFRuleRecord.parseFormula(formulaText2, workbook);
        return new CFRuleRecord(1, comparisonOperation, formula1, formula2);
    }

    public CFRuleRecord(RecordInputStream in) {
        super(in);
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_condition_type = in.readByte();
        this.field_2_comparison_operator = in.readByte();
        int field_3_formula1_len = in.readUShort();
        int field_4_formula2_len = in.readUShort();
        this.field_5_options = in.readInt();
        this.field_6_not_used = in.readShort();
        if (this.containsFontFormattingBlock()) {
            this.fontFormatting = new FontFormatting(in);
        }
        if (this.containsBorderFormattingBlock()) {
            this.borderFormatting = new BorderFormatting(in);
        }
        if (this.containsPatternFormattingBlock()) {
            this.patternFormatting = new PatternFormatting(in);
        }
        if (field_3_formula1_len > 0) {
            this.field_17_formula1 = Ptg.readTokens(field_3_formula1_len, in);
        }
        if (field_4_formula2_len > 0) {
            this.field_18_formula2 = Ptg.readTokens(field_4_formula2_len, in);
        }
    }

    public byte getConditionType() {
        return this.field_1_condition_type;
    }

    public boolean containsFontFormattingBlock() {
        return this.getOptionFlag(font);
    }

    public void setFontFormatting(FontFormatting fontFormatting) {
        this.fontFormatting = fontFormatting;
        this.setOptionFlag(fontFormatting != null, font);
    }

    public FontFormatting getFontFormatting() {
        if (this.containsFontFormattingBlock()) {
            return this.fontFormatting;
        }
        return null;
    }

    public boolean containsAlignFormattingBlock() {
        return this.getOptionFlag(align);
    }

    public void setAlignFormattingUnchanged() {
        this.setOptionFlag(false, align);
    }

    public boolean containsBorderFormattingBlock() {
        return this.getOptionFlag(bord);
    }

    public void setBorderFormatting(BorderFormatting borderFormatting) {
        this.borderFormatting = borderFormatting;
        this.setOptionFlag(borderFormatting != null, bord);
    }

    public BorderFormatting getBorderFormatting() {
        if (this.containsBorderFormattingBlock()) {
            return this.borderFormatting;
        }
        return null;
    }

    public boolean containsPatternFormattingBlock() {
        return this.getOptionFlag(patt);
    }

    public void setPatternFormatting(PatternFormatting patternFormatting) {
        this.patternFormatting = patternFormatting;
        this.setOptionFlag(patternFormatting != null, patt);
    }

    public PatternFormatting getPatternFormatting() {
        if (this.containsPatternFormattingBlock()) {
            return this.patternFormatting;
        }
        return null;
    }

    public boolean containsProtectionFormattingBlock() {
        return this.getOptionFlag(prot);
    }

    public void setProtectionFormattingUnchanged() {
        this.setOptionFlag(false, prot);
    }

    public void setComparisonOperation(byte operation) {
        this.field_2_comparison_operator = operation;
    }

    public byte getComparisonOperation() {
        return this.field_2_comparison_operator;
    }

    public int getOptions() {
        return this.field_5_options;
    }

    private boolean isModified(BitField field) {
        return !field.isSet(this.field_5_options);
    }

    private void setModified(boolean modified, BitField field) {
        this.field_5_options = field.setBoolean(this.field_5_options, !modified);
    }

    public boolean isLeftBorderModified() {
        return this.isModified(bordLeft);
    }

    public void setLeftBorderModified(boolean modified) {
        this.setModified(modified, bordLeft);
    }

    public boolean isRightBorderModified() {
        return this.isModified(bordRight);
    }

    public void setRightBorderModified(boolean modified) {
        this.setModified(modified, bordRight);
    }

    public boolean isTopBorderModified() {
        return this.isModified(bordTop);
    }

    public void setTopBorderModified(boolean modified) {
        this.setModified(modified, bordTop);
    }

    public boolean isBottomBorderModified() {
        return this.isModified(bordBot);
    }

    public void setBottomBorderModified(boolean modified) {
        this.setModified(modified, bordBot);
    }

    public boolean isTopLeftBottomRightBorderModified() {
        return this.isModified(bordTlBr);
    }

    public void setTopLeftBottomRightBorderModified(boolean modified) {
        this.setModified(modified, bordTlBr);
    }

    public boolean isBottomLeftTopRightBorderModified() {
        return this.isModified(bordBlTr);
    }

    public void setBottomLeftTopRightBorderModified(boolean modified) {
        this.setModified(modified, bordBlTr);
    }

    public boolean isPatternStyleModified() {
        return this.isModified(pattStyle);
    }

    public void setPatternStyleModified(boolean modified) {
        this.setModified(modified, pattStyle);
    }

    public boolean isPatternColorModified() {
        return this.isModified(pattCol);
    }

    public void setPatternColorModified(boolean modified) {
        this.setModified(modified, pattCol);
    }

    public boolean isPatternBackgroundColorModified() {
        return this.isModified(pattBgCol);
    }

    public void setPatternBackgroundColorModified(boolean modified) {
        this.setModified(modified, pattBgCol);
    }

    private boolean getOptionFlag(BitField field) {
        return field.isSet(this.field_5_options);
    }

    private void setOptionFlag(boolean flag, BitField field) {
        this.field_5_options = field.setBoolean(this.field_5_options, flag);
    }

    public Ptg[] getParsedExpression1() {
        return this.field_17_formula1;
    }

    public Ptg[] getParsedExpression2() {
        return this.field_18_formula2;
    }

    protected void validateSid(short id) {
        if (id != 433) {
            throw new RecordFormatException("NOT A CFRULE RECORD");
        }
    }

    public short getSid() {
        return 433;
    }

    private static int getFormulaSize(Ptg[] ptgs) {
        if (ptgs == null) {
            return 0;
        }
        return Ptg.getEncodedSize(ptgs);
    }

    public int serialize(int pOffset, byte[] data) {
        int formula1Len = CFRuleRecord.getFormulaSize(this.field_17_formula1);
        int formula2Len = CFRuleRecord.getFormulaSize(this.field_18_formula2);
        int offset = pOffset;
        int recordsize = this.getRecordSize();
        LittleEndian.putShort(data, 0 + offset, (short)433);
        LittleEndian.putShort(data, 2 + offset, (short)(recordsize - 4));
        data[4 + offset] = this.field_1_condition_type;
        data[5 + offset] = this.field_2_comparison_operator;
        LittleEndian.putUShort(data, 6 + offset, formula1Len);
        LittleEndian.putUShort(data, 8 + offset, formula2Len);
        LittleEndian.putInt(data, 10 + offset, this.field_5_options);
        LittleEndian.putShort(data, 14 + offset, this.field_6_not_used);
        offset += 16;
        if (this.containsFontFormattingBlock()) {
            byte[] fontFormattingRawRecord = this.fontFormatting.getRawRecord();
            System.arraycopy(fontFormattingRawRecord, 0, data, offset, fontFormattingRawRecord.length);
            offset += fontFormattingRawRecord.length;
        }
        if (this.containsBorderFormattingBlock()) {
            offset += this.borderFormatting.serialize(offset, data);
        }
        if (this.containsPatternFormattingBlock()) {
            offset += this.patternFormatting.serialize(offset, data);
        }
        if (this.field_17_formula1 != null) {
            offset += Ptg.serializePtgs(this.field_17_formula1, data, offset);
        }
        if (this.field_18_formula2 != null) {
            offset += Ptg.serializePtgs(this.field_18_formula2, data, offset);
        }
        if (offset - pOffset != recordsize) {
            throw new IllegalStateException("write mismatch (" + (offset - pOffset) + "!=" + recordsize + ")");
        }
        return recordsize;
    }

    public int getRecordSize() {
        int retval = 16 + (this.containsFontFormattingBlock() ? this.fontFormatting.getRawRecord().length : 0) + (this.containsBorderFormattingBlock() ? 8 : 0) + (this.containsPatternFormattingBlock() ? 4 : 0) + CFRuleRecord.getFormulaSize(this.field_17_formula1) + CFRuleRecord.getFormulaSize(this.field_18_formula2);
        return retval;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CFRULE]\n");
        buffer.append("    OPTION FLAGS=0x" + Integer.toHexString(this.getOptions()));
        return buffer.toString();
    }

    public Object clone() {
        CFRuleRecord rec = new CFRuleRecord(this.field_1_condition_type, this.field_2_comparison_operator);
        rec.field_5_options = this.field_5_options;
        rec.field_6_not_used = this.field_6_not_used;
        if (this.containsFontFormattingBlock()) {
            rec.fontFormatting = (FontFormatting)this.fontFormatting.clone();
        }
        if (this.containsBorderFormattingBlock()) {
            rec.borderFormatting = (BorderFormatting)this.borderFormatting.clone();
        }
        if (this.containsPatternFormattingBlock()) {
            rec.patternFormatting = (PatternFormatting)this.patternFormatting.clone();
        }
        if (this.field_17_formula1 != null) {
            rec.field_17_formula1 = (Ptg[])this.field_17_formula1.clone();
        }
        if (this.field_18_formula2 != null) {
            rec.field_18_formula2 = (Ptg[])this.field_18_formula2.clone();
        }
        return rec;
    }

    private static Ptg[] parseFormula(String formula, HSSFWorkbook workbook) {
        if (formula == null) {
            return null;
        }
        return FormulaParser.parse(formula, workbook);
    }

    public static final class ComparisonOperator {
        public static final byte NO_COMPARISON = 0;
        public static final byte BETWEEN = 1;
        public static final byte NOT_BETWEEN = 2;
        public static final byte EQUAL = 3;
        public static final byte NOT_EQUAL = 4;
        public static final byte GT = 5;
        public static final byte LT = 6;
        public static final byte GE = 7;
        public static final byte LE = 8;
    }
}

