/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.ScalarConstantPtg;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.util.LittleEndian;

public final class NumberPtg
extends ScalarConstantPtg {
    public static final int SIZE = 9;
    public static final byte sid = 31;
    private final double field_1_value;

    public NumberPtg(RecordInputStream in) {
        this.field_1_value = in.readDouble();
    }

    public NumberPtg(String value) {
        this.field_1_value = Double.parseDouble(value);
    }

    public double getValue() {
        return this.field_1_value;
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = 31;
        LittleEndian.putDouble(array, offset + 1, this.getValue());
    }

    public int getSize() {
        return 9;
    }

    public String toFormulaString(HSSFWorkbook book) {
        return "" + this.getValue();
    }
}

