/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.hapi;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.hapi.Connection;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.HttpUtil;

public class HttpConnection
extends Connection {
    static final Logger loggerUrl = LoggerManager.getLogger((String)"das2.url");
    final HttpURLConnection fhttpConnect;

    public HttpConnection(URL url) throws IOException {
        super(url);
        loggerUrl.log(Level.FINE, "GET {0}", new Object[]{url});
        HttpURLConnection httpConnect = (HttpURLConnection)url.openConnection();
        loggerUrl.log(Level.FINE, "--> {0} {1}", new Object[]{httpConnect.getResponseCode(), httpConnect.getResponseMessage()});
        httpConnect.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
        httpConnect.setReadTimeout(FileSystem.settings().getReadTimeoutMs());
        this.fhttpConnect = httpConnect = (HttpURLConnection)HttpUtil.checkRedirect((URLConnection)httpConnect);
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.fhttpConnect.getInputStream();
    }

    @Override
    public InputStream getErrorStream() throws IOException {
        return this.fhttpConnect.getErrorStream();
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.fhttpConnect.getResponseMessage();
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.fhttpConnect.getResponseCode();
    }

    @Override
    public void disconnect() {
        this.fhttpConnect.disconnect();
    }
}

