/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.hapi;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.autoplot.hapi.AbstractBinaryRecordReader;

public class InputStreamBinaryRecordReader
implements AbstractBinaryRecordReader {
    ReadableByteChannel ch;

    InputStreamBinaryRecordReader(InputStream ins) {
        this.ch = Channels.newChannel(ins);
    }

    @Override
    public int readRecord(ByteBuffer buf) throws IOException {
        int bytesRead = this.ch.read(buf);
        if (bytesRead == -1) {
            return -1;
        }
        while (bytesRead < buf.limit()) {
            int c = this.ch.read(buf);
            if (c == -1) {
                return -1;
            }
            bytesRead += c;
        }
        return bytesRead;
    }

    @Override
    public void close() throws IOException {
        this.ch.close();
    }
}

