/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.netCDF;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.metatree.IstpMetadataModel;
import org.autoplot.metatree.MetadataUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.LoggerManager;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;

public class NetCdfVarDataSet
extends AbstractDataSet {
    Variable v;
    double[] data;
    int[] shape;
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.netcdf");

    public static NetCdfVarDataSet create(Variable variable, String constraint, NetcdfDataset ncfile, ProgressMonitor mon) throws IOException {
        NetCdfVarDataSet result = new NetCdfVarDataSet();
        result.read(variable, ncfile, constraint, null, false, mon);
        return result;
    }

    private NetCdfVarDataSet() {
        this.putProperty("QUBE", Boolean.TRUE);
    }

    private static String sliceConstraints(String constraints, int i) {
        String[] cc;
        if (constraints == null) {
            return null;
        }
        if (constraints.startsWith("[") && constraints.endsWith("]")) {
            constraints = constraints.substring(1, constraints.length() - 1);
        }
        if (i >= (cc = constraints.split(",")).length) {
            return null;
        }
        if (cc[i].equals(":")) {
            return null;
        }
        return cc[i];
    }

    public static long[] parseConstraint(String constraint, long recCount) throws ParseException {
        long[] result = new long[]{0L, recCount, 1L};
        if (constraint == null) {
            return result;
        }
        if (constraint.startsWith("[") && constraint.endsWith("]")) {
            constraint = constraint.substring(1, constraint.length() - 1);
        }
        try {
            String[] ss = constraint.split(":", -2);
            if (ss.length > 0 && ss[0].length() > 0) {
                result[0] = Integer.parseInt(ss[0]);
                if (result[0] < 0L) {
                    result[0] = recCount + result[0];
                }
            }
            if (ss.length > 1 && ss[1].length() > 0) {
                result[1] = Integer.parseInt(ss[1]);
                if (result[1] < 0L) {
                    result[1] = recCount + result[1];
                }
            }
            if (ss.length > 2 && ss[2].length() > 0) {
                result[2] = Integer.parseInt(ss[2]);
            }
            if (ss.length == 1) {
                result[1] = -1L;
                result[2] = -1L;
            }
        }
        catch (NumberFormatException ex) {
            throw new ParseException("expected integer: " + ex.toString(), 0);
        }
        return result;
    }

    private int sliceCount(boolean[] slice, int idim) {
        int result = 0;
        for (int i = 0; i < idim; ++i) {
            if (!slice[i]) continue;
            ++result;
        }
        return result;
    }

    private double[] unsigned(double[] data, long limit) {
        for (int i = 0; i < data.length; ++i) {
            double b = data[i];
            if (!(b < 0.0)) continue;
            data[i] = b + (double)limit;
        }
        return data;
    }

    private TimeParser guessTimeParser(String s) {
        TimeParser tp = null;
        int digitCount = -1;
        for (int ich = 0; ich < s.length(); ++ich) {
            if (!Character.isDigit(s.charAt(ich))) {
                if (digitCount != -1) continue;
                digitCount = ich;
                continue;
            }
            if (digitCount <= -1) continue;
            digitCount = -1;
            break;
        }
        switch (digitCount) {
            case 16: {
                tp = TimeParser.create((String)"$Y$j$H$M$S$(subsec,places=3)");
                break;
            }
            case 17: {
                tp = TimeParser.create((String)"$Y$m$d$H$M$S$(subsec,places=3)");
                break;
            }
            case -1: {
                s = s.trim();
                try {
                    String t = TimeParser.iso8601String((String)s);
                    tp = TimeParser.create((String)t);
                    break;
                }
                catch (IllegalArgumentException ex) {
                    return null;
                }
            }
        }
        return tp;
    }

    private void read(Variable variable, NetcdfDataset ncfile, String constraints, MetadataModel mm, boolean isDepend, ProgressMonitor mon) throws IOException {
        Object o;
        int i;
        Array a;
        this.v = variable;
        if (!mon.isStarted()) {
            mon.started();
        }
        mon.setProgressMessage("reading " + this.v.getNameAndDimensions());
        if (mm == null) {
            long t0 = System.currentTimeMillis();
            ImmutableList vvs = ncfile.getVariables();
            for (Variable vv : vvs) {
                if (vv.findAttribute("DEPEND_0") == null) continue;
                mm = new IstpMetadataModel();
                break;
            }
            logger.log(Level.FINER, "look for DEPEND_0 (ms):{0}", System.currentTimeMillis() - t0);
        }
        logger.finer("v.getShape()");
        this.shape = this.v.getShape();
        boolean[] slice = new boolean[this.shape.length];
        if (constraints != null) {
            if (constraints.startsWith("[") && constraints.endsWith("]")) {
                constraints = constraints.substring(1, constraints.length() - 1);
            }
            try {
                String[] cc = constraints.split(",");
                ArrayList<Range> ranges = new ArrayList<Range>((Collection<Range>)this.v.getRanges());
                for (int i2 = 0; i2 < Math.min(ranges.size(), cc.length); ++i2) {
                    long[] ir = NetCdfVarDataSet.parseConstraint(cc[i2], ((Range)ranges.get(i2)).last() + 1);
                    if (ir[1] == -1L) {
                        ranges.set(i2, new Range((int)ir[0], (int)ir[0]));
                        this.shape[i2] = 1;
                        slice[i2] = true;
                        continue;
                    }
                    ranges.set(i2, new Range((int)ir[0], (int)ir[1] - 1, (int)ir[2]));
                    this.shape[i2] = (int)((ir[1] - ir[0]) / ir[2]);
                }
                logger.finer("v.read()");
                a = this.v.read(ranges);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvalidRangeException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            logger.finer("v.read()");
            a = this.v.read();
        }
        char[] cdata = null;
        try {
            if (a.getElementType() == Character.TYPE) {
                cdata = (char[])a.get1DJavaArray(Character.TYPE);
            } else if (a.isUnsigned() && (a.getElementType() == Byte.TYPE || a.getElementType() == Short.TYPE || a.getElementType() == Integer.TYPE)) {
                this.data = (double[])a.get1DJavaArray(Double.class);
                if (a.getElementType() == Byte.TYPE) {
                    this.data = this.unsigned(this.data, 256L);
                } else if (a.getElementType() == Short.TYPE) {
                    this.data = this.unsigned(this.data, 65536L);
                } else if (a.getElementType() == Integer.TYPE) {
                    this.data = this.unsigned(this.data, 0x100000000L);
                }
            } else {
                this.data = (double[])a.get1DJavaArray(Double.class);
            }
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("data cannot be converted to numbers", ex);
        }
        this.properties.put("NAME", Ops.safeName((String)variable.getName()));
        if (this.shape.length > 1) {
            this.properties.put("QUBE", Boolean.TRUE);
        }
        if (this.v.getParentStructure() != null) {
            this.shape = new int[]{this.data.length};
            slice = new boolean[a.getRank()];
        }
        boolean isCoordinateVariable = false;
        for (int ir = 0; ir < a.getRank(); ++ir) {
            NetCdfVarDataSet dependi;
            if (slice[ir]) continue;
            logger.log(Level.FINER, "v.getDimension({0})", ir);
            Dimension d = this.v.getDimension(ir);
            if (d == null) continue;
            logger.log(Level.FINER, "ncfile.findVariable({0})", d.getName());
            Variable cv = ncfile.findVariable(d.getName());
            if (cv == null || !cv.isCoordinateVariable()) continue;
            logger.log(Level.FINE, "dimension '{0}' is coordinate variable, adding DEPEND", cv.getName());
            Variable dv = cv;
            if (dv != variable && dv.getRank() == 1) {
                mon.setProgressMessage("reading " + dv.getNameAndDimensions());
                dependi = NetCdfVarDataSet.create(dv, NetCdfVarDataSet.sliceConstraints(constraints, ir), ncfile, (ProgressMonitor)new NullProgressMonitor());
                if (dependi.length() == 3 && dependi.value(0) == dependi.value(1) && dependi.value(0) == dependi.value(2)) {
                    this.properties.put("DEPEND_" + (ir - this.sliceCount(slice, ir)), Ops.labelsDataset((String[])new String[]{"X", "Y", "Z"}));
                    continue;
                }
                this.properties.put("DEPEND_" + (ir - this.sliceCount(slice, ir)), dependi);
                continue;
            }
            if (dv != variable && dv.getRank() == 2 && dv.getDataType() == DataType.CHAR) {
                mon.setProgressMessage("reading " + dv.getNameAndDimensions());
                dependi = NetCdfVarDataSet.create(dv, NetCdfVarDataSet.sliceConstraints(constraints, ir), ncfile, (ProgressMonitor)new NullProgressMonitor());
                this.properties.put("DEPEND_" + (ir - this.sliceCount(slice, ir)), dependi);
                continue;
            }
            isCoordinateVariable = true;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        mon.setProgressMessage("reading attributes");
        logger.finer("v.getAttributes()");
        AttributeContainer attrs = this.v.attributes();
        for (Attribute attr : attrs) {
            if (attr.isArray()) continue;
            if (attr.isString()) {
                attributes.put(attr.getName(), attr.getStringValue());
                continue;
            }
            attributes.put(attr.getName(), String.valueOf(attr.getNumericValue()));
        }
        Object lablPtr = attributes.get("LABL_PTR_1");
        if (lablPtr != null && lablPtr instanceof String) {
            Variable vv = ncfile.findVariable((String)lablPtr);
            if (vv == null) {
                logger.log(Level.WARNING, "unable to find variable: {0}", lablPtr);
            } else if (vv.getDataType() == DataType.CHAR && vv.getDimensions().size() == 2 && this.shape[1] == vv.getDimension(0).getLength()) {
                String[] ss = new String[vv.getDimension(0).getLength()];
                char[][] arr = (char[][])vv.read().copyToNDJavaArray();
                for (i = 0; i < ss.length; ++i) {
                    ss[i] = String.copyValueOf(arr[i]);
                }
                this.properties.put("DEPEND_1", Ops.labelsDataset((String[])ss));
            }
        }
        if (attributes.containsKey("units")) {
            String tb;
            Object otb;
            String unitsString = (String)attributes.get("units");
            if ("milliseconds".equalsIgnoreCase(unitsString)) {
                unitsString = Units.milliseconds.toString();
            }
            if ((otb = attributes.get("TIME_BASE")) == null) {
                otb = attributes.get("Time_Base");
            }
            String string = tb = otb == null ? null : otb.toString();
            if (unitsString.contains(" since ")) {
                Units u;
                try {
                    u = Units.lookupTimeUnits((String)unitsString);
                }
                catch (ParseException ex) {
                    throw new RuntimeException(ex);
                }
                this.properties.put("UNITS", u);
                this.properties.put("MONOTONIC", Boolean.TRUE);
            } else if (Units.lookupUnits((String)unitsString).isConvertibleTo(Units.seconds) && tb != null) {
                if (tb.equals("FIXED: 1970 (POSIX)")) {
                    try {
                        this.properties.put("UNITS", Units.lookupTimeUnits((String)(unitsString + " since 1970")));
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                } else if (tb.equals("1970-01-01 00:00:00.000 UTC")) {
                    try {
                        this.properties.put("UNITS", Units.lookupTimeUnits((String)(unitsString + " since 1970-01-01T00:00Z")));
                    }
                    catch (ParseException ex) {
                        Logger.getLogger(NetCdfVarDataSet.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    Logger.getLogger(NetCdfVarDataSet.class.getName()).log(Level.SEVERE, null, "missing support for this time type: " + tb);
                }
            } else {
                this.properties.put("UNITS", Units.lookupUnits((String)unitsString));
            }
        }
        if ((o = attributes.get("description")) != null && o instanceof String) {
            this.properties.put("DESCRIPTION", (String)o);
        }
        if ((o = attributes.get("comments")) != null && o instanceof String) {
            this.properties.put("TITLE", (String)o);
        }
        if ((o = attributes.get("long_label")) != null && o instanceof String) {
            this.properties.put("TITLE", (String)o);
        }
        if ((o = attributes.get("short_label")) != null && o instanceof String) {
            this.properties.put("LABEL", (String)o);
        }
        if ((o = attributes.get("long_name")) != null && o instanceof String) {
            Units u;
            if (this.properties.get("NAME") == null) {
                this.properties.put("NAME", Ops.safeName((String)((String)o)));
            }
            if (!(this.properties.get("LABEL") != null || (u = (Units)this.properties.get("UNITS")) != null && UnitsUtil.isTimeLocation((Units)u))) {
                this.properties.put("LABEL", o);
            }
        }
        if ((o = attributes.get("lin_log")) != null && (o.equals("lin") || o.equals("log"))) {
            this.properties.put("SCALE_TYPE", o.equals("lin") ? "linear" : (String)o);
        }
        if ((o = attributes.get("nominal_min")) != null && o instanceof String) {
            this.properties.put("TYPICAL_MIN", Double.parseDouble((String)o));
        }
        if ((o = attributes.get("nominal_max")) != null && o instanceof String) {
            this.properties.put("TYPICAL_MAX", Double.parseDouble((String)o));
        }
        if ((o = attributes.get("format")) != null && o instanceof String) {
            this.properties.put("FORMAT", MetadataUtil.normalizeFormatSpecifier((String)((String)o)));
        }
        EnumerationUnits eu = null;
        if (this.data == null) {
            if (cdata == null) {
                throw new RuntimeException("Either data or cdata should be defined at this point");
            }
            logger.fine("parsing times formatted in char arrays");
            this.data = new double[this.shape[0]];
            String ss = new String(cdata);
            TimeParser tp = null;
            boolean tryGuessTimeParser = true;
            for (int i3 = 0; i3 < this.shape[0]; ++i3) {
                int n = i3 * this.shape[1];
                String s = ss.substring(n, n + this.shape[1]);
                try {
                    if (tp != null) {
                        this.data[i3] = tp.parse(s).getTime((Units)Units.us2000);
                        continue;
                    }
                    if (tryGuessTimeParser) {
                        tryGuessTimeParser = false;
                        tp = this.guessTimeParser(s);
                        if (tp == null) {
                            eu = Units.nominal((String)"netcdf");
                        }
                    }
                    if (tp != null) {
                        this.data[i3] = tp.parse(s).getTime((Units)Units.us2000);
                        continue;
                    }
                    assert (eu != null);
                    this.data[i3] = eu.createDatum((Object)s).doubleValue((Units)eu);
                    continue;
                }
                catch (ParseException ex) {
                    this.data[i3] = Double.NaN;
                }
            }
            if (eu != null) {
                this.properties.put("UNITS", eu);
            } else {
                this.properties.put("UNITS", Units.us2000);
            }
            this.shape = new int[]{this.shape[0]};
        }
        if (attributes.containsKey("_FillValue")) {
            String sfill = (String)attributes.get("_FillValue");
            if (eu != null) {
                this.properties.put("FILL_VALUE", eu.createDatum((Object)sfill).doubleValue(eu));
            } else {
                double fill = Double.parseDouble(sfill);
                this.properties.put("FILL_VALUE", fill);
            }
        }
        if ((o = attributes.get("missing_value")) != null) {
            if (a.getElementType() == Float.TYPE) {
                this.properties.put("FILL_VALUE", Float.valueOf(Float.parseFloat((String)o)));
            } else if (a.getElementType() == Double.TYPE) {
                this.properties.put("FILL_VALUE", Double.parseDouble((String)o));
            } else {
                this.properties.put("FILL_VALUE", Long.parseLong((String)o));
            }
        }
        if (mm != null && mm instanceof IstpMetadataModel || attributes.containsKey("VAR_TYPE") || attributes.containsKey("DEPEND_0")) {
            String[] vvs;
            String s;
            logger.log(Level.FINE, "variable '{0}' has VAR_TYPE or DEPEND_0 attribute, use ISTP metadata", this.v.getName());
            this.properties.put("METADATA_MODEL", "ISTP-CDF");
            mm = new IstpMetadataModel();
            Map istpProps = mm.properties(attributes);
            if (this.properties.get("UNITS") == Units.us2000) {
                UnitsConverter uc = UnitsConverter.getConverter((Units)Units.cdfEpoch, (Units)Units.us2000);
                if (istpProps.containsKey("VALID_MIN")) {
                    istpProps.put("VALID_MIN", uc.convert((Number)istpProps.get("VALID_MIN")));
                }
                if (istpProps.containsKey("VALID_MAX")) {
                    istpProps.put("VALID_MAX", uc.convert((Number)istpProps.get("VALID_MAX")));
                }
                if (istpProps.containsKey("TYPICAL_MIN")) {
                    istpProps.put("TYPICAL_MIN", uc.convert((Number)istpProps.get("TYPICAL_MIN")));
                }
                if (istpProps.containsKey("TYPICAL_MAX")) {
                    istpProps.put("TYPICAL_MAX", uc.convert((Number)istpProps.get("TYPICAL_MAX")));
                }
                istpProps.put("UNITS", Units.us2000);
            }
            if (istpProps.containsKey("RENDER_TYPE") && (s = (String)istpProps.get("RENDER_TYPE")).equals("image")) {
                logger.fine("removing DISPLAY_TYPE=image because it's incorrect");
                istpProps.remove("RENDER_TYPE");
            }
            if (this.properties.containsKey("UNITS")) {
                istpProps.remove("UNITS");
            }
            this.properties.putAll(istpProps);
            for (int ir = 0; ir < a.getRank(); ++ir) {
                String s2 = (String)attributes.get("DEPEND_" + ir);
                if (s2 == null) continue;
                logger.log(Level.FINER, "ncfile.findVariable({0})", s2);
                Variable dv = ncfile.findVariable(s2);
                if (dv == null || dv == variable) continue;
                NetCdfVarDataSet result1 = new NetCdfVarDataSet();
                result1.read(dv, ncfile, NetCdfVarDataSet.sliceConstraints(constraints, ir), mm, true, (ProgressMonitor)new NullProgressMonitor());
                NetCdfVarDataSet dependi = result1;
                if (dependi.rank() == 0) continue;
                int dim = ir - this.sliceCount(slice, ir);
                if (dependi.length() != this.shape[dim]) {
                    logger.info("wrong length for dimension");
                    continue;
                }
                this.properties.put("DEPEND_" + dim, dependi);
            }
            for (String vv : vvs = new String[]{"DELTA_PLUS_VAR", "DELTA_MINUS_VAR"}) {
                if (!attributes.containsKey(vv)) continue;
                String s3 = (String)attributes.get(vv);
                logger.log(Level.FINER, "{0} ({1})", new Object[]{vv, s3});
                Variable dv = ncfile.findVariable(s3);
                if (dv == null || dv == variable) continue;
                String[] ss = vv.split("_");
                NetCdfVarDataSet result1 = new NetCdfVarDataSet();
                result1.read(dv, ncfile, NetCdfVarDataSet.sliceConstraints(constraints, 0), mm, true, (ProgressMonitor)new NullProgressMonitor());
                NetCdfVarDataSet dependi = result1;
                String qdatasetPropName = isDepend ? "BIN_" + ss[1] : "DELTA_" + ss[1];
                this.properties.put(qdatasetPropName, dependi);
            }
        }
        this.properties.put("USER_PROPERTIES", attributes);
        ArrayList<Integer> newShape = new ArrayList<Integer>(this.shape.length);
        for (i = 0; i < this.shape.length; ++i) {
            if (slice[i]) continue;
            newShape.add(this.shape[i]);
        }
        this.shape = new int[newShape.size()];
        for (i = 0; i < newShape.size(); ++i) {
            this.shape[i] = (Integer)newShape.get(i);
        }
        if (this.properties.get("FILL_VALUE") == null && this.properties.get("VALID_MIN") == null) {
            this.properties.put("VALID_MIN", -1.0E90);
        }
        if (isCoordinateVariable) {
            this.properties.put("CADENCE", DataSetUtil.guessCadenceNew((QDataSet)this, null));
        }
        mon.finished();
    }

    public int rank() {
        return this.shape.length;
    }

    public double value(int i) {
        return this.data[i];
    }

    public double value(int i, int j) {
        int index = j + this.shape[1] * i;
        if (index >= this.data.length) {
            throw new IllegalArgumentException("index out of bounds");
        }
        return this.data[index];
    }

    public double value(int i, int j, int k) {
        int index = k + this.shape[2] * j + this.shape[2] * this.shape[1] * i;
        if (index >= this.data.length) {
            throw new IllegalArgumentException("index out of bounds");
        }
        return this.data[index];
    }

    public double value(int i, int j, int k, int l) {
        int index = l + this.shape[3] * k + this.shape[3] * this.shape[2] * j + this.shape[3] * this.shape[2] * this.shape[1] * i;
        if (index >= this.data.length) {
            throw new IllegalArgumentException("index out of bounds");
        }
        return this.data[index];
    }

    public int length() {
        return this.shape[0];
    }

    public int length(int dim) {
        return this.shape[1];
    }

    public int length(int dim0, int dim1) {
        return this.shape[2];
    }

    public int length(int dim0, int dim1, int dim2) {
        return this.shape[3];
    }

    public QDataSet trim(int start, int end) {
        return super.trim(start, end);
    }

    public QDataSet slice(int i) {
        return super.slice(i);
    }
}

