/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.state;

import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUtil;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.dom.Application;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Diff;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.state.StatePersistence;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.system.RequestProcessor;
import org.das2.util.LoggerManager;

public class UndoRedoSupport {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.dom.vap");
    ApplicationModel applicationModel;
    private final LinkedList<StateStackElement> stateStack = new LinkedList();
    private final LinkedList<StateStackElement> redoStack = new LinkedList();
    private String redoLabel = null;
    public static final String PROP_REDOLABEL = "redoLabel";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String PROP_SIZE_LIMIT = "sizeLimit";
    private int sizeLimit = 50;
    private boolean ignoringUpdates;
    public static final String PROP_DEPTH = "depth";
    public static final String PROP_SAVE_STATE_DEPTH = "saveStateDepth";
    private int saveStateDepth = 0;

    public UndoRedoSupport(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        applicationModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                if (ev.getPropertyName().equals("vapFile")) {
                    UndoRedoSupport.this.resetHistory();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUndoMultipleMenu(JMenu undoMultipleMenu) {
        ArrayList<StateStackElement> lstateStack;
        undoMultipleMenu.removeAll();
        UndoRedoSupport undoRedoSupport = this;
        synchronized (undoRedoSupport) {
            lstateStack = new ArrayList<StateStackElement>(this.stateStack);
        }
        int lstateStackPos = lstateStack.size();
        for (int i = lstateStackPos - 1; i > Math.max(0, lstateStackPos - 10); --i) {
            StateStackElement prevState = (StateStackElement)lstateStack.get(i);
            String label = prevState.deltaDesc;
            final int ii = lstateStackPos - i;
            JMenuItem item = new JMenuItem(new AbstractAction(label){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    Runnable run = () -> UndoRedoSupport.this.undo(ii);
                    new Thread(run, "undoLaterThread").start();
                }
            });
            item.setToolTipText(prevState.docString);
            if (((StateStackElement)lstateStack.get((int)(i - 1))).thumb != null) {
                item.setIcon(new ImageIcon(((StateStackElement)lstateStack.get((int)(i - 1))).thumb));
            }
            undoMultipleMenu.add(item);
        }
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public Action getUndoAction() {
        return new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Runnable run = () -> UndoRedoSupport.this.undo();
                new Thread(run, "undoLaterThread").start();
            }
        };
    }

    public void undo() {
        this.undo(1);
    }

    public void undo(int level) {
        int oldDepth;
        logger.log(Level.FINE, "undo {0}", level);
        String oldRedoLabel = this.getRedoLabel();
        if (SwingUtilities.isEventDispatchThread()) {
            logger.warning("undo called from event thread");
        }
        if (level > (oldDepth = this.stateStack.size()) - 1) {
            level = oldDepth - 1;
        }
        if (level == 0) {
            return;
        }
        if (oldDepth > 0) {
            StateStackElement elephant;
            while (level > 0) {
                elephant = this.stateStack.removeLast();
                this.redoStack.add(0, elephant);
                --level;
            }
            elephant = this.stateStack.peekLast();
            assert (elephant != null);
            this.ignoringUpdates = true;
            this.applicationModel.setRestoringState(true);
            this.applicationModel.restoreState(elephant.state);
            this.applicationModel.setRestoringState(false);
            this.ignoringUpdates = false;
            RequestProcessor.invokeLater(() -> AutoplotUtil.reloadAll(this.applicationModel.getDom()));
        }
        this.redoLabel = this.getRedoLabel();
        this.propertyChangeSupport.firePropertyChange(PROP_REDOLABEL, oldRedoLabel, this.redoLabel);
        this.propertyChangeSupport.firePropertyChange(PROP_DEPTH, oldDepth, oldDepth + 1);
    }

    public Action getRedoAction() {
        return new AbstractAction("redo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Runnable run = () -> UndoRedoSupport.this.redo();
                new Thread(run, "redoLaterThread").start();
            }
        };
    }

    public void redo() {
        logger.fine("redo");
        String oldRedoLabel = this.getRedoLabel();
        int oldDepth = this.stateStack.size();
        if (!this.redoStack.isEmpty()) {
            StateStackElement elephant = this.redoStack.pop();
            this.ignoringUpdates = true;
            this.applicationModel.setRestoringState(true);
            this.applicationModel.restoreState(elephant.state);
            this.applicationModel.setRestoringState(false);
            this.ignoringUpdates = false;
            this.stateStack.add(elephant);
        }
        this.redoLabel = this.getRedoLabel();
        this.propertyChangeSupport.firePropertyChange(PROP_REDOLABEL, oldRedoLabel, this.redoLabel);
        this.propertyChangeSupport.firePropertyChange(PROP_DEPTH, oldDepth, this.stateStack.size());
    }

    public void pushState(PropertyChangeEvent ev) {
        this.pushState(ev, null);
    }

    private static List<Diff> removeTimeRangeBindings(Application dom, List<Diff> diffs) {
        dom = (Application)dom.copy();
        diffs = new ArrayList<Diff>(diffs);
        ArrayList<Diff> timeRangeBound = new ArrayList<Diff>();
        for (Diff s : diffs) {
            BindingModel bm;
            Plot p;
            Pattern pattern = Pattern.compile("plots\\[(\\d+)\\].xaxis.range");
            Matcher m = pattern.matcher(s.propertyName());
            if (m.matches()) {
                try {
                    p = dom.getPlots(Integer.parseInt(m.group(1)));
                    bm = DomUtil.findBinding(dom, p.getXaxis(), "range", dom, "timeRange");
                    if (bm != null) {
                        timeRangeBound.add(s);
                    }
                }
                catch (IndexOutOfBoundsException ex) {
                    logger.severe("IndexOutOfBounds error that needs to be fixed because needs synchronization");
                }
            }
            if (!(m = (pattern = Pattern.compile("plots\\[(\\d+)\\].xaxis.scale")).matcher(s.propertyName())).matches()) continue;
            try {
                p = dom.getPlots(Integer.parseInt(m.group(1)));
                bm = DomUtil.findBinding(dom, p.getXaxis(), "range", dom, "timeRange");
                if (bm == null) continue;
                timeRangeBound.add(s);
            }
            catch (IndexOutOfBoundsException ex) {
                logger.severe("IndexOutOfBounds error that needs to be fixed because needs synchronization");
            }
        }
        diffs.removeAll(timeRangeBound);
        return diffs;
    }

    private static List<Diff> removeRedundantDiffs(Application dom, List<Diff> diffs) {
        diffs = new ArrayList<Diff>(diffs);
        ArrayList<Diff> removeUs = new ArrayList<Diff>();
        for (Diff s : diffs) {
            Pattern pattern = Pattern.compile("plots\\[(\\d+)\\].([xyz])axis.range");
            Matcher m = pattern.matcher(s.propertyName());
            if (!m.matches()) continue;
            for (Diff s2 : diffs) {
                if (!s2.propertyName().equals("plots[" + m.group(1) + "]." + m.group(2) + "axis.scale")) continue;
                removeUs.add(s);
            }
        }
        diffs.removeAll(removeUs);
        return diffs;
    }

    private StateStackElement describeChanges(List<Diff> diffs, StateStackElement element) {
        String labelStr;
        StringBuilder docBuf = new StringBuilder();
        int count = 0;
        boolean axisRangeOnly = true;
        boolean zaxisRangeOnly = true;
        boolean axisAuto = false;
        boolean timeRange = false;
        String focus = null;
        diffs = UndoRedoSupport.removeTimeRangeBindings(this.applicationModel.getDocumentModel(), diffs);
        diffs = UndoRedoSupport.removeRedundantDiffs(this.applicationModel.getDocumentModel(), diffs);
        for (Diff diff : diffs) {
            if (diff.getDescription().contains("plotDefaults")) continue;
            String thisDiffFocus = null;
            int i = diff.propertyName().indexOf(46);
            if (i > -1) {
                thisDiffFocus = diff.propertyName().substring(0, i);
            }
            if (focus == null) {
                focus = thisDiffFocus;
            } else if (!focus.equals(thisDiffFocus) && !diff.propertyName().equals("timeRange")) {
                focus = "";
            } else if (diff.propertyName().equals("timeRange")) {
                timeRange = true;
            }
            ++count;
            docBuf.append("<br>");
            docBuf.append(diff.getDescription());
            if (diff.propertyName().endsWith("axis.range") || diff.propertyName().equals("timeRange")) {
                if (diff.propertyName().endsWith("zaxis.range")) {
                    axisRangeOnly = false;
                    continue;
                }
                zaxisRangeOnly = false;
                continue;
            }
            if (diff.propertyName().endsWith("autoRange")) {
                axisAuto = true;
                continue;
            }
            axisRangeOnly = false;
            zaxisRangeOnly = false;
        }
        if (focus == null) {
            focus = "";
        }
        String docString = docBuf.length() > 4 ? docBuf.substring(4) : "";
        docString = "<html>" + docString + "</html>";
        if (diffs.isEmpty()) {
            element.deltaDesc = "unidentified change";
            element.docString = "change was detected but could not be identified.";
            return element;
        }
        if (zaxisRangeOnly && focus.length() > 0 && count > 1) {
            labelStr = axisAuto ? focus + " first Z range change" : focus + " Z range change";
        } else if (axisRangeOnly && focus.length() > 0 && count > 1) {
            labelStr = axisAuto ? focus + " first range change" : focus + " range changes";
        } else if (count > 3) {
            labelStr = "" + count + " changes";
        } else {
            StringBuilder buf = new StringBuilder();
            for (Diff s : diffs) {
                if (s.getDescription().contains("plotDefaults")) continue;
                buf.append(", ").append(s.getLabel());
            }
            String string = labelStr = buf.length() > 2 ? buf.substring(2) : "";
        }
        if (labelStr.length() > 30) {
            StringTokenizer tok = new StringTokenizer(labelStr, ".,[", true);
            StringBuilder stringBuilder = new StringBuilder();
            while (tok.hasMoreTokens()) {
                String ss = tok.nextToken();
                stringBuilder.append(ss.substring(0, Math.min(ss.length(), 12)));
            }
            labelStr = stringBuilder.toString();
        }
        element.deltaDesc = labelStr;
        element.docString = docString;
        return element;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int size) {
        int oldSize = this.sizeLimit;
        this.sizeLimit = size;
        this.removeOldStates();
        this.propertyChangeSupport.firePropertyChange(PROP_SIZE_LIMIT, oldSize, size);
    }

    private void removeOldStates() {
        int len = this.sizeLimit;
        while (this.stateStack.size() > len) {
            this.stateStack.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushState(PropertyChangeEvent ev, String label) {
        logger.log(Level.FINE, "pushState: {0}", label);
        UndoRedoSupport undoRedoSupport = this;
        synchronized (undoRedoSupport) {
            if (this.ignoringUpdates) {
                logger.info("ignoring updates in undo stack");
                return;
            }
        }
        Application state = this.applicationModel.createState(false);
        BufferedImage thumb = this.applicationModel.getThumbnail(50);
        StateStackElement elephant = this.stateStack.peekLast();
        if (elephant != null && state.equals(elephant.state)) {
            return;
        }
        int oldDepth = this.stateStack.size();
        String labelStr = "initial";
        String docString = "initial state of application";
        StateStackElement element = new StateStackElement(state, labelStr, docString);
        if (elephant != null) {
            List<Diff> diffss = elephant.state.diffs(state);
            if (diffss.isEmpty()) {
                return;
            }
            element = this.describeChanges(diffss, element);
            if (label != null && element.deltaDesc.endsWith(" changes")) {
                element.deltaDesc = label;
            }
        }
        element.thumb = thumb;
        this.stateStack.add(element);
        int newDepth = this.stateStack.size();
        if (label != null) {
            this.redoStack.clear();
        }
        this.removeOldStates();
        if (this.saveStateDepth > 0) {
            boolean ok;
            long t0 = System.currentTimeMillis();
            File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "state/");
            if (!f2.exists() && !(ok = f2.mkdirs())) {
                throw new RuntimeException("unable to create folder " + f2);
            }
            File f3 = new File(f2, TimeParser.create((String)"state_$Y$m$d_$H$M$S.vap.gz").format(TimeUtil.now(), null));
            try (GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(f3));){
                StatePersistence.saveState(out, (Object)state, "");
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            logger.fine(String.format("saved state file in %d ms", System.currentTimeMillis() - t0));
        }
        this.propertyChangeSupport.firePropertyChange(PROP_DEPTH, oldDepth, newDepth);
    }

    public String getUndoDescription() {
        if (this.stateStack.size() < 2) {
            return null;
        }
        StateStackElement undo = this.stateStack.peekLast();
        if (undo != null) {
            if (undo.equals(this.stateStack.peekFirst())) {
                return null;
            }
            return "Undo " + undo.docString;
        }
        return null;
    }

    public String getUndoLabel() {
        if (this.stateStack.size() < 2) {
            return null;
        }
        StateStackElement undo = this.stateStack.peekLast();
        if (undo != null) {
            if (undo.equals(this.stateStack.peekFirst())) {
                return null;
            }
            return "Undo " + undo.deltaDesc;
        }
        return null;
    }

    public String getRedoDescription() {
        StateStackElement redo = this.redoStack.peekFirst();
        if (redo != null) {
            return "Redo " + redo.docString;
        }
        return null;
    }

    public String getRedoLabel() {
        StateStackElement redo = this.redoStack.peekFirst();
        if (redo != null) {
            return "Redo " + redo.deltaDesc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetHistory() {
        int oldDepth;
        UndoRedoSupport undoRedoSupport = this;
        synchronized (undoRedoSupport) {
            oldDepth = this.stateStack.size();
            this.stateStack.clear();
            this.redoStack.clear();
        }
        this.propertyChangeSupport.firePropertyChange(PROP_DEPTH, oldDepth, 0);
    }

    public synchronized boolean isIgnoringUpdates() {
        return this.ignoringUpdates;
    }

    public synchronized void setIgnoringUpdates(boolean ignoringUpdates) {
        this.ignoringUpdates = ignoringUpdates;
    }

    public synchronized int getDepth() {
        return this.stateStack.size();
    }

    public int getSaveStateDepth() {
        return this.saveStateDepth;
    }

    public void setSaveStateDepth(int depth) {
        this.saveStateDepth = depth;
    }

    public synchronized StateStackElement peekAt(int pos) {
        return this.stateStack.get(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLongUndoDescription(int i) {
        StateStackElement e0;
        StateStackElement e1;
        UndoRedoSupport undoRedoSupport = this;
        synchronized (undoRedoSupport) {
            e1 = this.stateStack.get(i);
            e0 = this.stateStack.get(i - 1);
        }
        List<Diff> diffss = e1.state.diffs(e0.state);
        diffss = UndoRedoSupport.removeTimeRangeBindings(e0.state, diffss);
        StringBuilder docBuf = new StringBuilder();
        for (int j = 0; j < diffss.size(); ++j) {
            Diff s = diffss.get(j);
            if (s.getDescription().contains("plotDefaults")) continue;
            if (j > 0) {
                docBuf.append(";\n");
            }
            docBuf.append(s.getDescription());
        }
        return docBuf.toString();
    }

    public static class StateStackElement {
        private final Application state;
        String deltaDesc;
        String docString;
        BufferedImage thumb;

        public StateStackElement(Application state, String deltaDesc, String docString) {
            this.state = state;
            this.deltaDesc = deltaDesc;
            this.docString = docString;
        }

        public String toString() {
            return this.deltaDesc;
        }

        public String getDocString() {
            return this.docString;
        }

        public String getDeltaDesc() {
            return this.deltaDesc;
        }
    }
}

