/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.autoplot.pngwalk.ImageResize;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasPlot;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.graph.SelectionUtil;
import org.das2.util.ClassMap;
import org.das2.util.LoggerManager;

public class CanvasLayoutPanel
extends JLabel {
    private JComponent target;
    private ClassMap<Color> types;
    private Timer timer;
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.layout.panel");
    private Rectangle cursor = null;
    private transient BufferedImage canvasImage = null;
    private boolean itsme = false;
    private Timer getCanvasImageTimer;
    private transient boolean handlingEvent = false;
    private final transient MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            boolean shiftClick;
            int mwidth;
            double scale;
            int km = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            long t0 = System.currentTimeMillis();
            logger.log(Level.FINE, "mouseClicked: {0} getMenuShortcutKeyMask={1}", new Object[]{e.getModifiers(), km});
            if ((e.getModifiers() & km) == 0 && (e.getModifiers() & 1) == 0 && e.getModifiers() > 16) {
                return;
            }
            if (CanvasLayoutPanel.this.target == null) {
                return;
            }
            int twidth = CanvasLayoutPanel.this.target.getWidth();
            int theight = CanvasLayoutPanel.this.target.getHeight();
            if ((double)theight * (scale = (double)(mwidth = CanvasLayoutPanel.this.getWidth()) / (double)twidth) > (double)CanvasLayoutPanel.this.getHeight()) {
                scale = (double)CanvasLayoutPanel.this.getHeight() / (double)theight;
            }
            boolean bl = shiftClick = (e.getModifiers() & 1) == 1;
            if (!shiftClick) {
                for (int i = CanvasLayoutPanel.this.target.getComponentCount() - 1; i >= 0; --i) {
                    boolean invisibleEdgeClick;
                    Component c = CanvasLayoutPanel.this.target.getComponent(i);
                    Color color = (Color)CanvasLayoutPanel.this.types.get(c.getClass());
                    if (color == null) continue;
                    Rectangle bounds = ((JComponent)c).getBounds();
                    Rectangle mbounds = new Rectangle((int)((double)bounds.x * scale), (int)((double)bounds.y * scale), (int)((double)bounds.width * scale), (int)((double)bounds.height * scale));
                    boolean bl2 = invisibleEdgeClick = !c.isVisible() && CanvasLayoutPanel.this.rectEdgeClicked(mbounds, e.getX(), e.getY());
                    if (!c.isVisible() && !invisibleEdgeClick || !mbounds.contains(e.getX(), e.getY()) && !invisibleEdgeClick) continue;
                    if ((e.getModifiers() & km) == km) {
                        if (CanvasLayoutPanel.this.selectedComponents.contains(c)) {
                            CanvasLayoutPanel.this.selectedComponents.remove(c);
                            CanvasLayoutPanel.this.component = null;
                        } else {
                            CanvasLayoutPanel.this.selectedComponents.add(c);
                            CanvasLayoutPanel.this.component = c;
                        }
                    } else {
                        CanvasLayoutPanel.this.component = c;
                        CanvasLayoutPanel.this.selectedComponents.clear();
                        CanvasLayoutPanel.this.selectedComponents.add(c);
                        CanvasLayoutPanel.this.cursor = new Rectangle((int)((double)e.getX() / scale), (int)((double)e.getY() / scale), 1, 1);
                    }
                    CanvasLayoutPanel.this.repaint();
                    CanvasLayoutPanel.this.handlingEvent = true;
                    CanvasLayoutPanel.this.firePropertyChange(CanvasLayoutPanel.PROP_COMPONENT, null, c);
                    if ((e.getModifiers() & km) == km) {
                        CanvasLayoutPanel.this.firePropertyChange(CanvasLayoutPanel.PROP_SELECTEDCOMPONENTS, null, CanvasLayoutPanel.this.selectedComponents);
                    }
                    CanvasLayoutPanel.this.handlingEvent = false;
                }
            } else {
                Rectangle select;
                Rectangle m = new Rectangle((int)((double)e.getX() / scale), (int)((double)e.getY() / scale), 1, 1);
                if (CanvasLayoutPanel.this.cursor == null) {
                    select = m;
                } else {
                    select = m;
                    Rectangle.union(CanvasLayoutPanel.this.cursor, m, select);
                }
                ArrayList<Component> newSelect = new ArrayList<Component>();
                for (int i = CanvasLayoutPanel.this.target.getComponentCount() - 1; i >= 0; --i) {
                    Component c = CanvasLayoutPanel.this.target.getComponent(i);
                    Color color = (Color)CanvasLayoutPanel.this.types.get(c.getClass());
                    if (color == null || !select.intersects(c.getBounds())) continue;
                    newSelect.add(c);
                }
                if (!CanvasLayoutPanel.this.selectedComponents.equals(newSelect)) {
                    CanvasLayoutPanel.this.selectedComponents.clear();
                    CanvasLayoutPanel.this.selectedComponents.addAll(newSelect);
                    CanvasLayoutPanel.this.handlingEvent = true;
                    CanvasLayoutPanel.this.firePropertyChange(CanvasLayoutPanel.PROP_SELECTEDCOMPONENTS, null, CanvasLayoutPanel.this.selectedComponents);
                    CanvasLayoutPanel.this.handlingEvent = false;
                    CanvasLayoutPanel.this.repaint();
                }
            }
            long ms = System.currentTimeMillis() - t0;
            logger.log(Level.FINE, "done in {0}ms mouseClicked: {1} getMenuShortcutKeyMask={2}", new Object[]{ms, e.getModifiers(), km});
        }
    };
    protected Object component = null;
    public static final String PROP_COMPONENT = "component";
    private Rectangle rectangleSelect = null;
    protected List<Object> selectedComponents = new ArrayList<Object>();
    public static final String PROP_SELECTEDCOMPONENTS = "selectedComponents";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final transient ComponentListener componentListener = new ComponentListener(){

        @Override
        public void componentResized(ComponentEvent e) {
            CanvasLayoutPanel.this.timer.restart();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            CanvasLayoutPanel.this.timer.restart();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            CanvasLayoutPanel.this.timer.restart();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            CanvasLayoutPanel.this.timer.restart();
        }
    };
    private final transient PropertyChangeListener repaintListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            logger.finer("canvas was painted, get a screenshot.");
            if (CanvasLayoutPanel.this.itsme) {
                logger.finer("its me...");
            } else {
                CanvasLayoutPanel.this.getCanvasImageTimer.restart();
            }
        }
    };

    public CanvasLayoutPanel() {
        this.types = new ClassMap();
        this.timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CanvasLayoutPanel.this.repaint();
            }
        });
        this.timer.setRepeats(false);
        this.getCanvasImageTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CanvasLayoutPanel.this.itsme = true;
                BufferedImage img = new BufferedImage(CanvasLayoutPanel.this.target.getWidth(), CanvasLayoutPanel.this.target.getHeight(), 2);
                ((DasCanvas)CanvasLayoutPanel.this.target).writeToImageImmediatelyNoCount((Image)img);
                CanvasLayoutPanel.this.canvasImage = img;
                CanvasLayoutPanel.this.itsme = false;
                CanvasLayoutPanel.this.repaint();
            }
        });
        this.getCanvasImageTimer.setRepeats(false);
        this.addMouseListener(this.mouseListener);
    }

    private boolean rectEdgeClicked(Rectangle r, int x, int y) {
        boolean e0 = Math.abs(r.getX() - (double)x) < 10.0;
        boolean e1 = Math.abs(r.getY() - (double)y) < 10.0;
        boolean e2 = Math.abs(r.getX() + r.getWidth() - (double)x) < 10.0;
        boolean e3 = Math.abs(r.getY() + r.getHeight() - (double)y) < 10.0;
        return (e0 || e1 || e2 || e3) && r.intersects(x - 10, y - 10, x + 20, y + 20);
    }

    public Object getComponent() {
        return this.component;
    }

    public Object getCanvasComponentAt(int x, int y) {
        Rectangle m;
        int mwidth;
        double scale;
        int twidth = this.target.getWidth();
        int theight = this.target.getHeight();
        if ((double)theight * (scale = (double)(mwidth = this.getWidth()) / (double)twidth) > (double)this.getHeight()) {
            scale = (double)this.getHeight() / (double)theight;
        }
        Rectangle select = m = new Rectangle((int)((double)x / scale), (int)((double)y / scale), 1, 1);
        ArrayList<Component> newSelect = new ArrayList<Component>();
        for (int i = this.target.getComponentCount() - 1; i >= 0; --i) {
            Component c = this.target.getComponent(i);
            Color color = (Color)this.types.get(c.getClass());
            if (color == null || !select.intersects(c.getBounds())) continue;
            newSelect.add(c);
        }
        if (newSelect.isEmpty()) {
            return null;
        }
        return newSelect.get(0);
    }

    public List<Object> getCanvasComponentsWithin(Rectangle r) {
        int mwidth;
        double scale;
        int twidth = this.target.getWidth();
        int theight = this.target.getHeight();
        if ((double)theight * (scale = (double)(mwidth = this.getWidth()) / (double)twidth) > (double)this.getHeight()) {
            scale = (double)this.getHeight() / (double)theight;
        }
        r = new Rectangle((int)((double)r.x / scale), (int)((double)r.y / scale), (int)((double)r.width / scale), (int)((double)r.height / scale));
        ArrayList<Object> newSelect = new ArrayList<Object>();
        for (int i = this.target.getComponentCount() - 1; i >= 0; --i) {
            Rectangle b;
            Component c = this.target.getComponent(i);
            Color color = (Color)this.types.get(c.getClass());
            if (color == null || !r.contains(b = GraphUtil.shrinkRectangle((Rectangle)c.getBounds(), (int)30))) continue;
            newSelect.add(c);
        }
        return newSelect;
    }

    public void setRectangleSelect(Rectangle r) {
        this.rectangleSelect = r;
    }

    public void setComponent(Object component) {
        if (this.handlingEvent) {
            return;
        }
        logger.log(Level.FINER, "setComponent({0})", component);
        Object oldComponent = this.component;
        this.component = component;
        this.handlingEvent = true;
        this.firePropertyChange(PROP_COMPONENT, oldComponent, component);
        this.handlingEvent = false;
        this.repaint();
    }

    public List<Object> getSelectedComponents() {
        return new ArrayList<Object>(this.selectedComponents);
    }

    public void setSelectedComponents(List<Object> selectedComponents) {
        if (this.handlingEvent) {
            return;
        }
        logger.log(Level.FINER, "setSelectedComponents({0})", selectedComponents);
        List<Object> oldSelectedComponents = this.selectedComponents;
        this.selectedComponents = new ArrayList<Object>(selectedComponents);
        this.handlingEvent = true;
        this.propertyChangeSupport.firePropertyChange(PROP_SELECTEDCOMPONENTS, oldSelectedComponents, selectedComponents);
        this.handlingEvent = false;
        this.repaint();
    }

    public void setSelectedComponents(Rectangle r) {
        this.setSelectedComponents(this.getCanvasComponentsWithin(r));
    }

    private Color getTranslucentColor(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    @Override
    protected void paintComponent(Graphics g1) {
        Component c;
        int i;
        logger.log(Level.FINER, "paintComponent target={0}", this.target);
        if (this.target == null) {
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getBackground());
        int theight = this.target.getHeight();
        int twidth = this.target.getWidth();
        int mwidth = this.getWidth();
        double scale = (double)mwidth / (double)twidth;
        if ((double)theight * scale > (double)this.getHeight()) {
            scale = (double)this.getHeight() / (double)theight;
        }
        g.fillRect(0, 0, (int)((double)twidth * scale), (int)((double)theight * scale));
        BasicStroke selectedStroke = new BasicStroke(3.0f);
        BasicStroke normalStroke = new BasicStroke(1.0f);
        BufferedImage img = this.canvasImage;
        if (img != null) {
            img = ImageResize.getScaledInstance(img, (int)((double)this.target.getWidth() * scale), (int)((double)this.target.getHeight() * scale), RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
            g.drawImage((Image)img, 0, 0, this);
            Color back = this.target.getBackground();
            g.setColor(new Color(back.getRed(), back.getGreen(), back.getBlue(), 100));
            g.fillRect(0, 0, img.getWidth(), img.getHeight());
        }
        Graphics2D gs = (Graphics2D)g.create();
        AffineTransform at = g.getTransform();
        at.scale(scale, scale);
        gs.setTransform(at);
        gs.setColor(new Color(255, 255, 0, 180));
        for (i = 0; i < this.target.getComponentCount(); ++i) {
            c = this.target.getComponent(i);
            if (!(c instanceof DasPlot)) continue;
            DasPlot plot = (DasPlot)c;
            gs.setClip(plot.getBounds());
            for (Renderer r : plot.getRenderers()) {
                if (!this.selectedComponents.contains(r)) continue;
                Shape s = SelectionUtil.getSelectionArea((Renderer)r);
                gs.fill(s);
            }
        }
        for (i = 0; i < this.target.getComponentCount(); ++i) {
            c = this.target.getComponent(i);
            Color color = (Color)this.types.get(c.getClass());
            if (color == null) continue;
            Rectangle bounds = ((JComponent)c).getBounds();
            Rectangle mbounds = new Rectangle((int)((double)bounds.x * scale), (int)((double)bounds.y * scale), (int)((double)bounds.width * scale), (int)((double)bounds.height * scale));
            if (!c.isVisible()) {
                g.setColor(this.getTranslucentColor(color, 160));
                Graphics2D g2 = g;
                if (this.selectedComponents.contains(c)) {
                    g2.setStroke(selectedStroke);
                } else {
                    g2.setStroke(normalStroke);
                }
                mbounds = new Rectangle(mbounds.x + 5, mbounds.y + 5, mbounds.width - 10, mbounds.height - 10);
                g2.drawRoundRect(mbounds.x, mbounds.y, mbounds.width, mbounds.height, 10, 10);
                g2.setStroke(normalStroke);
                continue;
            }
            if (c == this.component) {
                g.setColor(this.getTranslucentColor(color, 160));
                g.fillRoundRect(mbounds.x, mbounds.y, mbounds.width, mbounds.height, 10, 10);
                g.setColor(this.getTranslucentColor(color, 220));
                g.setStroke(selectedStroke);
                g.drawRoundRect(mbounds.x, mbounds.y, mbounds.width, mbounds.height, 10, 10);
                g.setStroke(normalStroke);
                continue;
            }
            if (this.selectedComponents.contains(c)) {
                g.setColor(this.getTranslucentColor(color, 130));
                g.fillRoundRect(mbounds.x, mbounds.y, mbounds.width, mbounds.height, 10, 10);
                g.setColor(this.getTranslucentColor(color, 220));
                g.drawRoundRect(mbounds.x, mbounds.y, mbounds.width, mbounds.height, 10, 10);
                continue;
            }
            g.setColor(this.getTranslucentColor(color, 60));
            g.fillRoundRect(mbounds.x, mbounds.y, mbounds.width, mbounds.height, 10, 10);
            g.setColor(this.getTranslucentColor(color, 160));
            g.drawRoundRect(mbounds.x, mbounds.y, mbounds.width, mbounds.height, 10, 10);
        }
        if (this.rectangleSelect != null) {
            g.setColor(Color.GRAY);
            g.draw(this.rectangleSelect);
        }
    }

    public void setContainer(DasCanvas c) {
        if (this.target != null) {
            this.target.removePropertyChangeListener("paintCount", this.repaintListener);
        }
        this.target = c;
        c.addPropertyChangeListener("paintCount", this.repaintListener);
        c.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                e.getChild().addComponentListener(CanvasLayoutPanel.this.componentListener);
                CanvasLayoutPanel.this.timer.restart();
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                e.getChild().removeComponentListener(CanvasLayoutPanel.this.componentListener);
                CanvasLayoutPanel.this.timer.restart();
            }
        });
    }

    public void addComponentType(Class c, Color color) {
        this.types.put(c, (Object)color);
    }
}

