/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.ascii;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.AbstractDataSourceFormat;
import org.das2.datum.Datum;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DefaultDatumFormatter;
import org.das2.datum.format.FormatStringFormatter;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.datum.format.TimeDatumFormatterFactory;
import org.das2.qds.BundleDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.LongReadAccess;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.AsciiParser;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONException;
import org.json.JSONObject;

public class AsciiTableDataSourceFormat
extends AbstractDataSourceFormat {
    private static final Logger logger = Logger.getLogger("apdss.ascii");
    private final Map<QDataSet, String> namesFor = new HashMap<QDataSet, String>();

    private DatumFormatter getTimeFormatter(QDataSet ttag) {
        Object timeFormatter;
        String ff;
        String tformat = this.getParam("tformat", "ISO8601");
        if (tformat.equals("ISO8601") && ttag != null && (ff = (String)ttag.property("FORMAT")) != null) {
            tformat = ff;
        }
        String ft = tformat.toLowerCase();
        String depend0Units = this.getParam("depend0Units", "");
        Units dep0units = null;
        if (depend0Units.length() > 0) {
            try {
                dep0units = Units.lookupTimeUnits((String)depend0Units);
            }
            catch (ParseException ex) {
                Logger.getLogger(AsciiTableDataSourceFormat.class.getName()).log(Level.SEVERE, null, ex);
            }
            final Units tu = dep0units;
            if (ft.equals("iso8601")) {
                ft = null;
            }
            final String sformat = ft;
            timeFormatter = new DefaultDatumFormatter(){

                public String format(Datum datum) {
                    return this.format(datum, tu);
                }

                public String format(Datum datum, Units units) {
                    if (datum.isFill()) {
                        return "fill";
                    }
                    if (sformat != null && sformat.startsWith("%")) {
                        return String.format(sformat, datum.doubleValue(tu));
                    }
                    return String.valueOf(datum.doubleValue(tu));
                }
            };
        } else if (ft.equals("iso8601")) {
            timeFormatter = TimeDatumFormatterFactory.getInstance().defaultFormatter();
        } else if (tformat.startsWith("%") || ft.startsWith("$")) {
            if (tformat.startsWith("$")) {
                tformat = tformat.replaceAll("\\$", "%");
            }
            tformat = tformat.replaceAll("\\+", this.getDelim());
            try {
                timeFormatter = new TimeDatumFormatter(tformat);
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                timeFormatter = new FormatStringFormatter(tformat, false);
            }
        } else {
            try {
                if (ft.equals("day")) {
                    timeFormatter = new TimeDatumFormatter("%Y-%m-%d");
                } else if (ft.equals("hour")) {
                    timeFormatter = new TimeDatumFormatter("%Y-%m-%dT%H:%MZ");
                } else if (ft.startsWith("min")) {
                    timeFormatter = new TimeDatumFormatter("%Y-%m-%dT%H:%MZ");
                } else if (ft.startsWith("sec")) {
                    timeFormatter = new TimeDatumFormatter("%Y-%m-%dT%H:%M:%SZ");
                } else if (ft.startsWith("millisec")) {
                    final TimeParser tp = TimeParser.create((String)"$Y-$m-$dT$H:$M:$S.$(subsec,places=3)");
                    timeFormatter = new DatumFormatter(){

                        public String format(Datum datum) {
                            return tp.format(datum);
                        }
                    };
                } else if (ft.startsWith("microsec")) {
                    final TimeParser tp = TimeParser.create((String)"$Y-$m-$dT$H:$M:$S.$(subsec,places=6)");
                    timeFormatter = new DatumFormatter(){

                        public String format(Datum datum) {
                            return tp.format(datum);
                        }
                    };
                } else if (ft.startsWith("nanosec")) {
                    final TimeParser tp = TimeParser.create((String)"$Y-$m-$dT$H:$M:$S.$(subsec,places=9)");
                    timeFormatter = new DatumFormatter(){

                        public String format(Datum datum) {
                            return tp.format(datum);
                        }
                    };
                } else {
                    logger.log(Level.FINE, "not implemented: {0}", ft);
                    timeFormatter = new TimeDatumFormatter("%Y-%m-%dT%H:%M:%S");
                }
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                timeFormatter = TimeDatumFormatterFactory.getInstance().defaultFormatter();
            }
        }
        return timeFormatter;
    }

    private DatumFormatter getDataFormatter(String df, Units u) {
        try {
            if (!df.contains("%")) {
                df = "%" + df;
            }
            return new FormatStringFormatter(df, false);
        }
        catch (RuntimeException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return u.getDatumFormatterFactory().defaultFormatter();
        }
    }

    private void maybeOutputProperty(PrintWriter out, QDataSet data, String property) {
        if (this.getParam("header", "").equals("none")) {
            return;
        }
        if (!this.getParam("comment", "_").equals("_")) {
            return;
        }
        Object v = data.property(property);
        if (v != null) {
            out.println("# " + property + ": " + v);
        }
    }

    private boolean jsonProp(JSONObject jo1, QDataSet ds, String prop, int i) throws JSONException {
        boolean isTime;
        Units u;
        Object o;
        if (i > -1) {
            o = ds.property(prop, i);
            u = (Units)ds.property("UNITS", i);
            if (u == null) {
                u = Units.dimensionless;
            }
        } else {
            o = ds.property(prop);
            u = (Units)ds.property("UNITS");
            if (u == null) {
                u = Units.dimensionless;
            }
        }
        if ((isTime = UnitsUtil.isTimeLocation((Units)u)) && (prop.equals("VALID_MIN") || prop.equals("VALID_MAX") || prop.equals("TYPICAL_MIN") || prop.equals("TYPICAL_MAX") || prop.equals("FILL_VALUE"))) {
            return false;
        }
        if (prop.equals("START_INDEX")) {
            prop = "START_COLUMN";
        }
        if (o != null) {
            if (o instanceof QDataSet) {
                jo1.put(prop, (Object)o.toString());
            } else if (o instanceof Number) {
                jo1.put(prop, (Object)((Number)o));
            } else if (o instanceof Units) {
                if (UnitsUtil.isTimeLocation((Units)((Units)o))) {
                    jo1.put(prop, (Object)"UTC");
                } else {
                    jo1.put(prop, (Object)String.valueOf(o));
                }
            } else {
                jo1.put(prop, (Object)String.valueOf(o));
            }
            return true;
        }
        return false;
    }

    private JSONObject formatDataSetInline(QDataSet ds) throws JSONException {
        JSONObject jo1 = new JSONObject();
        this.jsonProp(jo1, ds, "LABEL", -1);
        this.jsonProp(jo1, ds, "UNITS", -1);
        this.jsonProp(jo1, ds, "VALID_MIN", -1);
        this.jsonProp(jo1, ds, "VALID_MAX", -1);
        this.jsonProp(jo1, ds, "FILL_VALUE", -1);
        this.jsonProp(jo1, ds, "TITLE", -1);
        jo1.put("VALUES", (Object)DataSetUtil.asArrayOfDoubles((QDataSet)ds));
        jo1.put("DIMENSION", (Object)new int[]{ds.length()});
        return jo1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNameFor(QDataSet ds) {
        String s;
        Map<QDataSet, String> map = this.namesFor;
        synchronized (map) {
            s = this.namesFor.get(ds);
            if (s != null) {
                return s;
            }
            s = Ops.guessName((QDataSet)ds, (String)("data" + this.namesFor.size()));
            this.namesFor.put(ds, s);
        }
        return s;
    }

    private void formatBundleDescRichAscii(PrintWriter out, QDataSet data, QDataSet bundleDesc) throws JSONException {
        int i;
        int dep0inc;
        String name;
        assert (data != null);
        assert (bundleDesc.length() == data.length(1));
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        JSONObject jo = new JSONObject();
        JSONObject jo1 = new JSONObject();
        int startColumn = dep0 == null ? 0 : 1;
        String dep1Name = null;
        QDataSet dep = (QDataSet)data.property("DEPEND_1");
        if (dep != null && UnitsUtil.isRatioMeasurement((Units)SemanticOps.getUnits((QDataSet)dep)) && data.property("BUNDLE_1") == null) {
            dep1Name = Ops.guessName((QDataSet)dep);
            if (dep1Name == null) {
                dep1Name = "dep1";
            }
            jo.put(dep1Name, (Object)this.formatDataSetInline(dep));
        }
        String dep2Name = null;
        dep = (QDataSet)data.property("DEPEND_2");
        if (dep != null && UnitsUtil.isRatioMeasurement((Units)SemanticOps.getUnits((QDataSet)dep)) && data.property("BUNDLE_1") == null) {
            dep2Name = Ops.guessName((QDataSet)dep);
            if (dep2Name == null) {
                dep2Name = "dep2";
            }
            jo.put(dep2Name, (Object)this.formatDataSetInline(dep));
        }
        if (dep0 != null) {
            JSONObject dep0jo = new JSONObject();
            name = this.getNameFor(dep0);
            this.jsonProp(dep0jo, dep0, "LABEL", -1);
            if (UnitsUtil.isTimeLocation((Units)SemanticOps.getUnits((QDataSet)dep0))) {
                dep0jo.put("UNITS", (Object)this.getTimeUnitLabel());
            } else {
                this.jsonProp(dep0jo, dep0, "UNITS", -1);
            }
            dep0jo.put("START_COLUMN", 0);
            if (data.rank() > 1) {
                jo.put(name, (Object)dep0jo);
                dep0inc = 1;
            } else {
                dep0inc = 0;
            }
        } else {
            dep0inc = 0;
        }
        String[] elementNames = new String[bundleDesc.length()];
        String[] elementLabels = new String[bundleDesc.length()];
        if (bundleDesc.length() == 1 && bundleDesc.length(0) == 1) {
            int n = DataSetUtil.product((int[])DataSetUtil.qubeDims((QDataSet)data.slice(0)));
            elementNames = new String[n];
            for (int i2 = 0; i2 < n; ++i2) {
                elementNames[i2] = "ch_" + i2;
            }
            QDataSet theOne = Ops.unbundle((QDataSet)bundleDesc, (int)0);
            this.jsonProp(jo1, theOne, "LABEL", -1);
            this.jsonProp(jo1, theOne, "TITLE", -1);
            this.jsonProp(jo1, theOne, "VALID_MIN", -1);
            this.jsonProp(jo1, theOne, "VALID_MAX", -1);
            this.jsonProp(jo1, theOne, "FILL_VALUE", -1);
            this.jsonProp(jo1, theOne, "DEPEND_0", -1);
            this.jsonProp(jo1, theOne, "SCALE_TYPE", -1);
            this.jsonProp(jo1, theOne, "TYPICAL_MIN", -1);
            this.jsonProp(jo1, theOne, "TYPICAL_MAX", -1);
            this.jsonProp(jo1, theOne, "START_INDEX", -1);
            elementLabels = null;
        } else {
            for (i = 0; i < bundleDesc.length(); ++i) {
                name = (String)bundleDesc.property("NAME", i);
                if (name == null) {
                    logger.info("unnamed dataset!");
                    name = "field" + i;
                }
                JSONObject jo2 = new JSONObject();
                this.jsonProp(jo2, bundleDesc, "LABEL", i);
                if (!this.jsonProp(jo2, bundleDesc, "UNITS", i)) {
                    this.jsonProp(jo2, data, "UNITS", -1);
                }
                this.jsonProp(jo2, bundleDesc, "VALID_MIN", i);
                this.jsonProp(jo2, bundleDesc, "VALID_MAX", i);
                this.jsonProp(jo2, bundleDesc, "FILL_VALUE", i);
                this.jsonProp(jo2, bundleDesc, "DEPEND_0", i);
                this.jsonProp(jo2, bundleDesc, "START_INDEX", i);
                jo2.put("START_COLUMN", i + dep0inc);
                if (data.rank() == 1) {
                    jo.put(name, (Object)jo2);
                }
                elementNames[i] = name;
                elementLabels[i] = (String)bundleDesc.property("LABEL", i);
            }
        }
        for (i = dep0inc; elementLabels != null && i < bundleDesc.length(); ++i) {
            if (elementLabels[i] != null) continue;
            elementLabels = null;
        }
        jo1.put("START_COLUMN", startColumn);
        if (data.rank() > 1) {
            if (bundleDesc.length() == 1) {
                if (data.rank() > 2) {
                    int[] dims = DataSetUtil.qubeDims((QDataSet)data.slice(0));
                    jo1.put("DIMENSION", (Object)dims);
                } else {
                    jo1.put("DIMENSION", (Object)new int[]{(int)bundleDesc.value(0, 0)});
                }
            } else {
                jo1.put("DIMENSION", (Object)new int[]{bundleDesc.length()});
            }
            jo1.put("ELEMENT_NAMES", (Object)elementNames);
            if (elementLabels != null) {
                jo1.put("ELEMENT_LABELS", (Object)elementLabels);
            }
            if (dep1Name != null) {
                jo1.put("DEPEND_1", (Object)dep1Name);
                jo1.put("RENDER_TYPE", (Object)"spectrogram");
            }
            if (dep2Name != null) {
                jo1.put("DEPEND_2", (Object)dep2Name);
            }
            jo.put(Ops.guessName((QDataSet)data, (String)"data"), (Object)jo1);
        }
        String json = jo.toString(3);
        String[] lines = json.split("\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append("# ").append(line).append("\n");
        }
        out.print(sb.toString());
    }

    private String getTimeUnitLabel() {
        String depend0Units = this.getParam("depend0Units", "");
        if (depend0Units.equals("")) {
            return "UTC";
        }
        try {
            Units u = Units.lookupTimeUnits((String)depend0Units);
            return u.toString();
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String getDelim() {
        String head = this.getParam("header", "");
        String delim = "rich".equals(head) ? " " : ", ";
        String x = this.getParam("delim", ",").toUpperCase();
        if (!x.equals(",")) {
            delim = x.equals("NONE") ? "" : (x.equals("WHITESPACE") || x.equals("SPACE") ? " " : (x.equals("COMMA") ? "," : (x.equals("SEMICOLON") ? ";" : (x.equals("COLON") ? ":" : (x.equals("TAB") ? "\t" : x)))));
        }
        return delim;
    }

    private void formatRank2Bundle(PrintWriter out, QDataSet data, ProgressMonitor mon) {
        int i;
        QDataSet bundleDesc = (QDataSet)data.property("BUNDLE_1");
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        if (dep0 != null && dep0.length() > 0 && Ops.equivalent((QDataSet)dep0, (QDataSet)Ops.unbundle((QDataSet)data, (int)0))) {
            logger.fine("depend0 is also found in the first column, ignoring");
            dep0 = null;
        }
        String head = this.getParam("header", "");
        boolean haveRich = false;
        if (bundleDesc != null && "rich".equals(head)) {
            try {
                this.formatBundleDescRichAscii(out, data, bundleDesc);
                haveRich = true;
            }
            catch (JSONException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        } else {
            this.maybeOutputProperty(out, data, "TITLE");
        }
        DatumFormatter tf = this.getTimeFormatter(dep0);
        String delim = this.getDelim();
        String df = this.getParam("format", "");
        DatumFormatter[] formats = new DatumFormatter[data.length(0)];
        Units[] uu = new Units[data.length(0)];
        if (bundleDesc == null) {
            throw new IllegalArgumentException("expected to find bundleDesc in dataset!");
        }
        int jj = 0;
        for (i = 0; i < bundleDesc.length(); ++i) {
            jj = i;
            uu[jj] = (Units)bundleDesc.property("UNITS", i);
            if (uu[jj] == null) {
                uu[jj] = Units.dimensionless;
            }
            if (!(uu[jj] instanceof EnumerationUnits)) {
                String ff = (String)bundleDesc.property("FORMAT", jj);
                formats[jj] = df.equals("") ? (ff == null ? uu[jj].createDatum(data.value(0, jj)).getFormatter() : this.getDataFormatter(ff, uu[jj])) : (UnitsUtil.isTimeLocation((Units)uu[jj]) ? tf : (ff == null ? this.getDataFormatter(df, uu[jj]) : this.getDataFormatter(ff, uu[jj])));
            } else {
                formats[jj] = uu[jj].createDatum(data.value(0, jj)).getFormatter();
            }
            ++jj;
        }
        if (dep0 != null) {
            String l = Ops.guessName((QDataSet)dep0);
            if (l == null) {
                l = Units.t2000.isConvertibleTo(SemanticOps.getUnits((QDataSet)dep0)) ? "time(" + this.getTimeUnitLabel() + ")" : "dep0";
            } else if (Units.t2000.isConvertibleTo(SemanticOps.getUnits((QDataSet)dep0))) {
                l = l + "(" + this.getTimeUnitLabel() + ")";
            }
            if (!"none".equals(head)) {
                if ("rich".equals(head)) {
                    out.print("# ");
                }
                out.print(l + delim);
            }
        }
        boolean startStopTime = false;
        for (i = 0; i < bundleDesc.length(); ++i) {
            int k;
            String l1 = haveRich ? (String)bundleDesc.property("NAME", i) : (String)bundleDesc.property("LABEL", i);
            if (l1 == null && (l1 = (String)bundleDesc.property("NAME", i)) == null) {
                l1 = "";
            }
            if (l1.trim().length() == 0) {
                Units u1 = (Units)bundleDesc.property("UNITS", i);
                if (u1 == null) {
                    u1 = Units.dimensionless;
                }
                if (i == 0 && UnitsUtil.isTimeLocation((Units)u1) && bundleDesc.length() > 1) {
                    Units u2 = (Units)bundleDesc.property("UNITS", 1);
                    if (u2 == null) {
                        u2 = Units.dimensionless;
                    }
                    if (UnitsUtil.isTimeLocation((Units)u2)) {
                        startStopTime = true;
                    }
                }
                l1 = Units.t2000.isConvertibleTo(u1) ? (startStopTime ? "time" + i : "time") : "field" + i;
            }
            if (uu[i] != null && uu[i] != Units.dimensionless && !(uu[i] instanceof EnumerationUnits)) {
                l1 = UnitsUtil.isTimeLocation((Units)uu[i]) ? l1 + "(" + this.getTimeUnitLabel() + ")" : l1 + "(" + uu[i] + ")";
            }
            int nelements = 1;
            for (k = 0; k < bundleDesc.length(i); ++k) {
                nelements = (int)((double)nelements * bundleDesc.value(i, k));
            }
            if ("none".equals(head)) continue;
            if (dep0 == null && "rich".equals(head)) {
                out.print("# ");
            }
            for (k = 0; k < nelements; ++k) {
                if (delim.length() > 0) {
                    out.print(l1);
                    if (i == bundleDesc.length() - 1 && k == nelements - 1) {
                        out.print("\n");
                        continue;
                    }
                    out.print(delim);
                    continue;
                }
                String f = (String)bundleDesc.property("FORMAT", i);
                if (f == null) {
                    out.print(l1);
                    continue;
                }
                int len = AsciiParser.guessLengthForFormat((String)f);
                if (len == -1) {
                    out.print(l1);
                } else {
                    StringBuilder b = new StringBuilder();
                    int extra = len - l1.length();
                    for (int ii = 0; ii < extra; ++ii) {
                        b.append(" ");
                    }
                    b.append(l1);
                    out.print(b.toString());
                }
                if (i != bundleDesc.length() - 1 || k != nelements - 1) continue;
                out.print("\n");
            }
        }
        LongReadAccess lra = dep0 == null ? null : (LongReadAccess)dep0.capability(LongReadAccess.class);
        DatumFormatter cf0 = tf;
        Units u0 = null;
        if (dep0 != null) {
            u0 = (Units)dep0.property("UNITS");
            if (u0 == null) {
                u0 = Units.dimensionless;
            }
            if (!UnitsUtil.isTimeLocation((Units)u0) && dep0.length() > 0) {
                cf0 = df.equals("") ? u0.createDatum(dep0.value(0)).getFormatter() : this.getDataFormatter(df, uu[jj]);
            }
        }
        mon.setTaskSize((long)data.length());
        mon.started();
        for (i = 0; i < data.length(); ++i) {
            int j;
            mon.setTaskProgress((long)i);
            if (mon.isCancelled()) break;
            if (dep0 != null) {
                assert (u0 != null);
                Datum t = lra == null ? u0.createDatum(dep0.value(i)) : u0.createDatum(lra.lvalue(i));
                out.print("" + cf0.format(t, u0) + delim);
            }
            for (j = 0; j < data.length(i) - 1; ++j) {
                out.print(formats[j].format(uu[j].createDatum(data.value(i, j)), uu[j]) + delim);
            }
            out.println(formats[j].format(uu[j].createDatum(data.value(i, j)), uu[j]));
        }
        mon.finished();
    }

    private void formatRank2(PrintWriter out, QDataSet data, ProgressMonitor mon) {
        LongReadAccess lra;
        String dfs;
        QDataSet dep1 = (QDataSet)data.property("DEPEND_1");
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        String delim = this.getDelim();
        boolean okay = DataSetUtil.checkQube((QDataSet)data);
        if (!okay) {
            throw new IllegalArgumentException("Data is not a qube.  Each record must have the same DEPEND_1.");
        }
        if (dep1 != null && dep1.rank() == 2) {
            throw new IllegalArgumentException("dep1 rank is 2, which is not supported.");
        }
        String head = this.getParam("header", "");
        if ("rich".equals(head)) {
            try {
                BundleDataSet bds = BundleDataSet.createRank1Bundle();
                DDataSet ds = DDataSet.createRank1((int)1);
                ds.putProperty("TITLE", data.property("TITLE"));
                ds.putProperty("LABEL", data.property("LABEL"));
                ds.putProperty("NAME", data.property("NAME"));
                ds.putProperty("UNITS", data.property("UNITS"));
                ds.putProperty("VALID_MAX", data.property("VALID_MAX"));
                ds.putProperty("VALID_MIN", data.property("VALID_MIN"));
                ds.putProperty("FILL_VALUE", data.property("FILL_VALUE"));
                ds.putValue(0, (double)data.length(0));
                bds.bundle((QDataSet)ds);
                this.formatBundleDescRichAscii(out, data, (QDataSet)bds);
            }
            catch (JSONException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        } else {
            this.maybeOutputProperty(out, data, "TITLE");
        }
        Units u = (Units)data.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        if (u != Units.dimensionless && !"rich".equals(head)) {
            this.maybeOutputProperty(out, data, "UNITS");
        }
        if (dep1 != null && !"none".equals(head)) {
            String s;
            Datum d;
            int i;
            Units dep1units;
            if ("rich".equals(head)) {
                out.print("#");
            }
            if (dep0 != null) {
                String l = (String)dep0.property("LABEL");
                if (l == null) {
                    l = Units.t2000.isConvertibleTo(SemanticOps.getUnits((QDataSet)dep0)) ? "time(" + this.getTimeUnitLabel() + ")" : "dep0";
                }
                out.print(l + delim);
            }
            if ((dep1units = (Units)dep1.property("UNITS")) == null) {
                dep1units = Units.dimensionless;
            }
            if (dep1.rank() > 1) {
                // empty if block
            }
            for (i = 0; i < dep1.length() - 1; ++i) {
                d = dep1units.createDatum(dep1.value(i));
                s = d.toString().replaceAll("\\s+", "");
                out.print(s + delim);
            }
            d = dep1units.createDatum(dep1.value(i));
            s = d.toString().replaceAll("\\s+", "");
            out.println(s);
        }
        Units u0 = null;
        if (dep0 != null && (u0 = (Units)dep0.property("UNITS")) == null) {
            u0 = Units.dimensionless;
        }
        mon.setTaskSize((long)data.length());
        mon.started();
        DatumFormatter tf = this.getTimeFormatter(dep0);
        String format = this.getParam("format", "");
        DatumFormatter df = format.equals("") ? ((dfs = (String)data.property("FORMAT")) != null && dfs.trim().length() > 0 ? this.getDataFormatter(dfs, u) : u.getDatumFormatterFactory().defaultFormatter()) : this.getDataFormatter(format, u);
        LongReadAccess longReadAccess = lra = dep0 == null ? null : (LongReadAccess)dep0.capability(LongReadAccess.class);
        DatumFormatter cf0 = dep0 == null ? null : (UnitsUtil.isTimeLocation((Units)u0) ? tf : df);
        DatumFormatter cf1 = UnitsUtil.isTimeLocation((Units)u) ? tf : df;
        block7: for (int i = 0; i < data.length(); ++i) {
            mon.setTaskProgress((long)i);
            if (mon.isCancelled()) break;
            if (dep0 != null) {
                assert (dep0 != null);
                assert (cf0 != null);
                assert (u0 != null);
                Datum t = lra == null ? u0.createDatum(dep0.value(i)) : u0.createDatum(lra.lvalue(i));
                out.print("" + cf0.format(t, u0) + delim);
            }
            switch (data.rank()) {
                case 2: {
                    int j;
                    for (j = 0; j < data.length(i) - 1; ++j) {
                        out.print(cf1.format(u.createDatum(data.value(i, j)), u) + delim);
                    }
                    out.println(cf1.format(u.createDatum(data.value(i, j)), u));
                    continue block7;
                }
                case 3: {
                    int j;
                    int m = data.length(i);
                    int n = data.length(i, 0);
                    for (j = 0; j < m; ++j) {
                        for (int k = 0; k < n; ++k) {
                            out.print(cf1.format(u.createDatum(data.value(i, j, k)), u));
                            if (j < m - 1 || k < n - 1) {
                                out.print(delim);
                                continue;
                            }
                            out.print("\n");
                        }
                    }
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("rank error, expected 2 or 3");
                }
            }
        }
        mon.finished();
    }

    private String dataSetLabel(QDataSet ds, String deft) {
        String name;
        String head = this.getParam("header", "");
        String delim = this.getDelim();
        if ("rich".equals(head)) {
            name = (String)ds.property("NAME");
        } else {
            name = (String)ds.property("LABEL");
            if (name != null && name.contains("(")) {
                int i = name.indexOf("(");
                name = name.substring(0, i).trim();
            }
        }
        if (name == null || !Ops.safeName((String)name).equals(name)) {
            name = (String)ds.property("NAME");
        }
        if (name == null || name.equals("")) {
            name = deft;
        }
        String label = name;
        Units units = (Units)ds.property("UNITS");
        if (units != null && units != Units.dimensionless) {
            label = UnitsUtil.isTimeLocation((Units)units) ? label + "(" + this.getTimeUnitLabel() + ")" : label + "(" + units + ")";
        }
        if (delim.length() == 0) {
            String f = (String)ds.property("FORMAT");
            label = f == null ? " " + label : " " + label;
        }
        return label;
    }

    private void formatRank1(PrintWriter out, QDataSet data, ProgressMonitor mon) {
        LongReadAccess lra;
        String dfs;
        String format;
        QDataSet plane;
        String l;
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        Units u0 = null;
        String delim = this.getDelim();
        ArrayList<QDataSet> planes = new ArrayList<QDataSet>();
        ArrayList<Units> planeUnits = new ArrayList<Units>();
        String head = this.getParam("header", "");
        if ("rich".equals(head)) {
            try {
                DDataSet ids = DDataSet.createRank1((int)1);
                ids.putProperty("TITLE", dep0.property("TITLE"));
                ids.putProperty("LABEL", dep0.property("LABEL"));
                ids.putProperty("NAME", dep0.property("NAME"));
                ids.putProperty("UNITS", dep0.property("UNITS"));
                ids.putProperty("VALID_MAX", dep0.property("VALID_MAX"));
                ids.putProperty("VALID_MIN", dep0.property("VALID_MIN"));
                ids.putProperty("FILL_VALUE", dep0.property("FILL_VALUE"));
                DDataSet ds = DDataSet.createRank1((int)1);
                ds.putProperty("TITLE", data.property("TITLE"));
                ds.putProperty("LABEL", data.property("LABEL"));
                String name = (String)data.property("NAME");
                if (name == null) {
                    name = "data";
                }
                ds.putProperty("NAME", (Object)name);
                ds.putProperty("UNITS", data.property("UNITS"));
                ds.putProperty("VALID_MAX", data.property("VALID_MAX"));
                ds.putProperty("VALID_MIN", data.property("VALID_MIN"));
                ds.putProperty("FILL_VALUE", data.property("FILL_VALUE"));
                QDataSet bds = Ops.join((QDataSet)ids, (QDataSet)ds);
                this.formatBundleDescRichAscii(out, data, bds);
            }
            catch (JSONException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        } else {
            this.maybeOutputProperty(out, data, "TITLE");
        }
        StringBuilder buf = new StringBuilder();
        if (dep0 != null) {
            l = this.dataSetLabel(dep0, "dep0");
            buf.append(delim).append(l);
            u0 = (Units)dep0.property("UNITS");
            if (u0 == null) {
                u0 = Units.dimensionless;
            }
        }
        l = this.dataSetLabel(data, "data");
        buf.append(delim).append(l);
        Units u = (Units)data.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        if (!"rich".equals(head) && u != Units.dimensionless) {
            this.maybeOutputProperty(out, data, "UNITS");
        }
        for (int i = 0; i < 50 && (plane = (QDataSet)data.property("PLANE_" + i)) != null; ++i) {
            planes.add(plane);
            planeUnits.add((Units)plane.property("UNITS"));
            if (planeUnits.get(i) == null) {
                planeUnits.add(i, Units.dimensionless);
            }
            l = this.dataSetLabel(plane, "data" + i);
            buf.append(delim).append(l);
        }
        if (!"none".equals(head)) {
            if ("rich".equals(head)) {
                out.println("# " + buf.substring(1));
            } else {
                out.println(buf.substring(1));
            }
        }
        mon.setTaskSize((long)data.length());
        mon.started();
        DatumFormatter tf = this.getTimeFormatter(dep0);
        Units dep0units = u0;
        String depend0Units = this.getParam("depend0Units", "");
        if (depend0Units.length() > 0) {
            tf = Units.dimensionless.getDatumFormatterFactory().defaultFormatter();
            try {
                dep0units = Units.lookupTimeUnits((String)depend0Units);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("unable to parse depend0Units");
            }
        }
        DatumFormatter df = (format = this.getParam("format", "")).equals("") ? ((dfs = (String)data.property("FORMAT")) != null && dfs.trim().length() > 0 ? this.getDataFormatter(dfs, u) : u.getDatumFormatterFactory().defaultFormatter()) : this.getDataFormatter(format, u);
        LongReadAccess longReadAccess = lra = dep0 == null ? null : (LongReadAccess)dep0.capability(LongReadAccess.class);
        DatumFormatter cf0 = dep0 == null ? null : (UnitsUtil.isTimeLocation((Units)u0) ? tf : df);
        DatumFormatter cf1 = UnitsUtil.isTimeLocation((Units)u) ? tf : df;
        for (int i = 0; i < data.length(); ++i) {
            mon.setTaskProgress((long)i);
            if (mon.isCancelled()) break;
            if (dep0 != null) {
                assert (cf0 != null);
                assert (u0 != null);
                Datum t = lra == null ? u0.createDatum(dep0.value(i)) : u0.createDatum(lra.lvalue(i));
                out.print("" + cf0.format(t, dep0units) + delim);
            }
            out.print(cf1.format(u.createDatum(data.value(i)), u));
            for (int j = 0; j < planes.size(); ++j) {
                out.print(delim + cf1.format(((Units)planeUnits.get(j)).createDatum(((QDataSet)planes.get(j)).value(i)), (Units)planeUnits.get(j)));
            }
            out.println();
        }
        mon.finished();
    }

    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws IOException {
        block22: {
            this.setUri(uri);
            this.maybeMkdirs();
            String doDep = this.getParam("doDep", "");
            if (doDep.length() > 0 && doDep.toUpperCase().charAt(0) == 'F') {
                MutablePropertyDataSet mpds = DataSetOps.makePropertiesMutable((QDataSet)data);
                mpds.putProperty("DEPEND_0", null);
                mpds.putProperty("DEPEND_1", null);
                mpds.putProperty("BUNDLE_1", null);
                data = mpds;
            }
            File f = new File(this.getResourceURI());
            try (PrintWriter out = new PrintWriter(f);){
                String head = this.getParam("header", "");
                if (!"rich".equals(head) && !"none".equals(head)) {
                    String comment = this.getParam("comment", "_");
                    if (comment.equals("_")) {
                        out.println("# Generated by Autoplot on " + new Date());
                    } else if (!comment.equals("")) {
                        out.println("# " + comment);
                    }
                }
                if (data.rank() == 2) {
                    if (SemanticOps.isBundle((QDataSet)data)) {
                        this.formatRank2Bundle(out, data, mon);
                    } else {
                        this.formatRank2(out, data, mon);
                    }
                    break block22;
                }
                if (data.rank() == 1) {
                    this.formatRank1(out, data, mon);
                    break block22;
                }
                if (data.rank() == 3 && "rich".equals(head)) {
                    this.formatRank2(out, data, mon);
                    break block22;
                }
                throw new IllegalArgumentException("only rank 1 and rank 2 data are supported");
            }
        }
    }

    public boolean canFormat(QDataSet ds) {
        return ds.rank() > 0 && ds.rank() < 3;
    }

    public String getDescription() {
        return "ASCII Table";
    }
}

