/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource.jython;

import java.beans.ExceptionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.ReferenceCache;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.Caching;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.datasource.jython.JythonDataSourceFactory;
import org.autoplot.datasource.jython.JythonDataSourceTimeSeriesBrowse;
import org.autoplot.jythonsupport.JythonOps;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.PyQDataSet;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.CacheTag;
import org.das2.datum.DatumRangeUtil;
import org.das2.qds.DataSetOps;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.util.PythonInterpreter;

public final class JythonDataSource
extends AbstractDataSource
implements Caching {
    ExceptionListener listener;
    private Map<String, Object> metadata;
    public static final String PARAM_SCRIPT = "script";
    protected static final String PARAM_TIMERANGE = "timerange";
    protected static final String PARAM_RESOURCE_URI = "resourceURI";
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.jyds");
    private boolean notCheckedTsb = true;
    PythonInterpreter interp = null;
    TimeSeriesBrowse tsb = null;
    Date cacheDate = null;
    String cacheUrl = null;

    public JythonDataSource(URI uri, JythonDataSourceFactory factory) {
        super(uri);
        this.addCapability(Caching.class, (Object)this);
        this.listener = factory.listener;
        try {
            File jythonScript = this.getScript();
            JythonDataSourceTimeSeriesBrowse tsb1 = JythonDataSourceTimeSeriesBrowse.checkForTimeSeriesBrowse(uri.toString(), jythonScript);
            if (tsb1 != null) {
                tsb1.setJythonDataSource(this);
                this.addCapability(TimeSeriesBrowse.class, tsb1);
                this.tsb = tsb1;
                this.notCheckedTsb = false;
            }
        }
        catch (IOException | ParseException ex) {
            logger.severe(ex.toString());
        }
    }

    private File getScript() throws IOException {
        File jythonScript = this.params.get(PARAM_SCRIPT) != null ? this.getFile(new URL((String)this.params.get(PARAM_SCRIPT)), (ProgressMonitor)new NullProgressMonitor()) : this.getFile((ProgressMonitor)new NullProgressMonitor());
        return jythonScript;
    }

    private String nextExec(LineNumberReader reader, String[] nextLine) throws IOException {
        StringBuilder s;
        if (nextLine[0] != null) {
            s = new StringBuilder(nextLine[0]);
            nextLine[0] = null;
        } else {
            String ss = reader.readLine();
            if (ss == null) {
                ss = "";
            }
            s = new StringBuilder(ss);
        }
        String stest = s.toString();
        if (stest.startsWith("def ") || stest.startsWith("if") || stest.startsWith("else")) {
            String s1 = reader.readLine();
            while (s1 != null && (s1.length() == 0 || Character.isWhitespace(s1.charAt(0)))) {
                s.append("\n").append(s1);
                s1 = reader.readLine();
            }
            while (s1 != null && s1.startsWith("else")) {
                s.append("\n").append(s1);
                s1 = reader.readLine();
                while (s1 != null && (s1.length() == 0 || Character.isWhitespace(s1.charAt(0)))) {
                    s.append("\n").append(s1);
                    s1 = reader.readLine();
                }
            }
            nextLine[0] = s1;
        }
        return s.toString();
    }

    private synchronized QDataSet getInlineDataSet(URI uri) throws Exception {
        this.interp = JythonUtil.createInterpreter((boolean)false);
        PyObject result = this.interp.eval(uri.getRawSchemeSpecificPart());
        QDataSet res = result instanceof PyList ? JythonOps.dataset((PyObject)((PyList)result)) : (QDataSet)result.__tojava__(QDataSet.class);
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        boolean allowCaching;
        mon.started();
        String suri = DataSetURI.fromUri((URI)this.uri);
        if (this.tsb != null) {
            suri = this.tsb.getURI();
        }
        URISplit split = URISplit.parse((String)suri);
        LinkedHashMap paramsl = URISplit.parseParams((String)split.params);
        if (split.scheme.equals("inline")) {
            return this.getInlineDataSet(new URI(this.uri.getRawSchemeSpecificPart()));
        }
        boolean useReferenceCache = "true".equals(System.getProperty("enableReferenceCache", "false"));
        suri = URISplit.makeCanonical((String)suri);
        URISplit split1 = URISplit.parse((String)suri);
        LinkedHashMap params1 = URISplit.parseParams((String)split1.params);
        split1.params = URISplit.formatParams((Map)params1);
        suri = URISplit.format((URISplit)split1);
        params1.remove("arg_0");
        split1.params = URISplit.formatParams((Map)params1);
        String lockUri = URISplit.format((URISplit)split1);
        ReferenceCache.ReferenceCacheEntry rcent = null;
        if (useReferenceCache) {
            rcent = ReferenceCache.getInstance().getDataSetOrLock(lockUri, mon);
            if (!rcent.shouldILoad(Thread.currentThread())) {
                rcent.park(mon);
                ReferenceCache.ReferenceCacheEntry entry = ReferenceCache.getInstance().getReferenceCacheEntry(suri);
                if (entry != null) {
                    QDataSet result = ReferenceCache.getInstance().getDataSet(suri);
                    if (result != null) {
                        if (result != ReferenceCache.NULL) return result;
                        return null;
                    }
                    logger.fine("garbage collector got the data before a non-weak reference could be made");
                    logger.log(Level.FINE, "miss {0}", suri);
                    rcent = null;
                    mon = new NullProgressMonitor();
                } else {
                    logger.log(Level.FINE, "referenceCache doesn''t know the URI: {0}", suri);
                    rcent = null;
                    mon = new NullProgressMonitor();
                }
            } else {
                logger.log(Level.FINE, "reference cache in use, {0} is loading {1}", new Object[]{Thread.currentThread().toString(), this.resourceURI});
            }
        }
        boolean bl = allowCaching = !"F".equals(this.params.get("allowCaching"));
        if (!allowCaching) {
            this.interp = null;
        }
        PyException causedBy = null;
        try {
            QDataSet dep0;
            QDataSet res;
            String lresourceURI;
            File jythonScript;
            if (this.params.get(PARAM_SCRIPT) != null) {
                jythonScript = this.getFile(new URL((String)this.params.get(PARAM_SCRIPT)), (ProgressMonitor)new NullProgressMonitor());
                mon.setProgressMessage("loading " + this.uri);
                split.params = null;
                lresourceURI = DataSetURI.fromUri((URI)DataSetURI.getResourceURI((String)URISplit.format((URISplit)split)));
            } else {
                lresourceURI = null;
                jythonScript = this.getFile((ProgressMonitor)new NullProgressMonitor());
            }
            if (this.interp == null) {
                Object sval;
                logger.log(Level.FINE, "running script {0} {1}", new Object[]{jythonScript, paramsl});
                mon.setProgressMessage("initialize Jython interpreter...");
                this.interp = JythonUtil.createInterpreter((boolean)false);
                mon.setProgressMessage("done initializing Jython interpreter");
                try {
                    this.interp.set("monitor", (Object)mon);
                }
                catch (ConcurrentModificationException ex) {
                    logger.warning("avoiding strange concurrent modification bug that occurs within Jython on the server...");
                    Thread.yield();
                    this.interp.set("monitor", (Object)mon);
                    logger.warning("done.");
                }
                this.interp.set("PWD", (Object)URISplit.parse((URI)jythonScript.toURI()).path);
                this.interp.exec("import autoplot2025 as autoplot");
                this.interp.exec("autoplot.params=dict()");
                for (Map.Entry e : paramsl.entrySet()) {
                    String s = (String)e.getKey();
                    if (s.equals("arg_0") || s.equals(PARAM_SCRIPT) || ((String)(sval = (String)e.getValue())).length() <= 0) continue;
                    int iq = ((String)sval).indexOf(63);
                    int ie = ((String)sval).indexOf(61);
                    if (iq > -1 && ie > -1 && iq < ie) {
                        logger.log(Level.INFO, "double question mark detected in URI: {0}", suri);
                    }
                    sval = JythonUtil.maybeQuoteString((String)sval);
                    logger.log(Level.FINE, "autoplot.params[''{0}'']={1}", new Object[]{s, sval});
                    this.interp.exec("autoplot.params['" + s + "']=" + (String)sval);
                }
                if (lresourceURI != null) {
                    this.interp.set(PARAM_RESOURCE_URI, (Object)lresourceURI);
                    this.interp.exec("autoplot.params['resourceURI']=" + JythonUtil.maybeQuoteString((String)lresourceURI));
                }
                mon.setProgressMessage("executing script");
                LineNumberReader reader = null;
                try {
                    boolean debug = false;
                    if (debug) {
                        InputStreamReader fr = new InputStreamReader(JythonRefactory.fixImports((InputStream)new FileInputStream(jythonScript), (String)jythonScript.getName()));
                        sval = null;
                        try {
                            reader = new LineNumberReader(fr);
                            String[] nextLine = new String[1];
                            String s = this.nextExec(reader, nextLine);
                            long t0 = System.currentTimeMillis();
                            while (s != null) {
                                logger.log(Level.FINEST, "{0}: {1}", new Object[]{reader.getLineNumber(), s});
                                this.interp.exec(s);
                                logger.finest(String.format("line=%d time=%dms  %s\n", reader.getLineNumber(), System.currentTimeMillis() - t0, s));
                                if (mon.isCancelled()) break;
                                mon.setProgressMessage("exec line " + reader.getLineNumber());
                                s = this.nextExec(reader, nextLine);
                                t0 = System.currentTimeMillis();
                            }
                        }
                        catch (Throwable nextLine) {
                            sval = nextLine;
                            throw nextLine;
                        }
                        finally {
                            if (fr != null) {
                                if (sval != null) {
                                    try {
                                        ((Reader)fr).close();
                                    }
                                    catch (Throwable nextLine) {
                                        ((Throwable)sval).addSuppressed(nextLine);
                                    }
                                } else {
                                    ((Reader)fr).close();
                                }
                            }
                        }
                    } else {
                        InputStream in = new FileInputStream(jythonScript);
                        try {
                            in = JythonRefactory.fixImports((InputStream)in, (String)jythonScript.getName());
                            logger.log(Level.FINE, "executing script {0}", jythonScript.getName());
                            this.interp.execfile(in, jythonScript.getName());
                            logger.log(Level.FINE, "done executing script {0}", jythonScript.getName());
                        }
                        catch (PyException ex) {
                            if (!ex.toString().contains("checkForComodification")) throw ex;
                            in.close();
                            in = new FileInputStream(jythonScript);
                            logger.warning("avoiding second strange concurrent modification bug that occurs within Jython on the server.  Run the whole thing again.");
                            Thread.sleep(200L);
                            in = JythonRefactory.fixImports((InputStream)in, (String)jythonScript.getName());
                            this.interp.execfile(in, jythonScript.getName());
                        }
                        in.close();
                    }
                    mon.setProgressMessage("done executing script");
                }
                catch (PyException ex) {
                    if (reader != null) {
                        logger.log(Level.FINE, "debugging line number={0}", reader.getLineNumber());
                    }
                    causedBy = ex;
                    Object javaClass = ex.value.__tojava__(Exception.class);
                    if (javaClass instanceof FileNotFoundException) {
                        throw (Exception)javaClass;
                    }
                    if (javaClass instanceof NoDataInIntervalException) {
                        throw (Exception)javaClass;
                    }
                    if (javaClass instanceof org.das2.CancelledOperationException) {
                        throw (Exception)javaClass;
                    }
                    if (javaClass instanceof CancelledOperationException) {
                        throw (Exception)javaClass;
                    }
                    logger.warning(ex.toString());
                    if (this.listener != null) {
                        this.listener.exceptionThrown((Exception)((Object)ex));
                    }
                }
                catch (Exception ex) {
                    throw ex;
                }
                if (causedBy == null && allowCaching) {
                    this.cacheDate = this.resourceDate(this.uri);
                    this.cacheUrl = this.cacheUrl(this.uri);
                }
            } else {
                logger.fine("using existing interpreter to provide caching");
            }
            String expr = (String)this.params.get("arg_0");
            PyObject result = null;
            String label = null;
            if (expr == null) {
                try {
                    result = this.interp.eval("result");
                }
                catch (PyException ex) {
                    try {
                        result = this.interp.eval("data");
                    }
                    catch (PyException ex2) {
                        if (causedBy == null) throw new IllegalArgumentException("neither \"data\" nor \"result\" is defined");
                        throw ex2;
                    }
                }
            } else {
                PyObject o = this.interp.get("outputParams");
                if (o != null && o instanceof PyDictionary) {
                    PyDictionary dict = (PyDictionary)o;
                    result = dict.get((PyObject)Py.newString((String)expr));
                }
                if (result == null || result == Py.None) {
                    result = this.interp.eval(expr);
                }
                label = expr;
            }
            this.metadata = new LinkedHashMap<String, Object>();
            try {
                PyObject pymeta = this.interp.eval("metadata");
                if (pymeta instanceof PyDictionary) {
                    PyDictionary dict = (PyDictionary)pymeta;
                    PyList keys = dict.keys();
                    for (Object key : keys) {
                        String name = key.toString();
                        PyObject o = dict.get(Py.java2py(key));
                        if (o instanceof PyList) {
                            String[] arr = new String[((PyList)o).__len__()];
                            for (int i2 = 0; i2 < arr.length; ++i2) {
                                arr[i2] = ((PyList)o).__getitem__(i2).toString();
                            }
                            this.metadata.put(name, arr);
                            continue;
                        }
                        String val = o.toString();
                        this.metadata.put(name, val);
                    }
                }
            }
            catch (PyException dict) {
                // empty catch block
            }
            if (result instanceof PyList) {
                res = JythonOps.dataset((PyObject)((PyList)result));
            } else if (result instanceof PyArray) {
                res = JythonOps.dataset((PyObject)((PyArray)result));
            } else if (result instanceof PyInteger) {
                res = JythonOps.dataset((PyObject)((PyInteger)result));
            } else if (result instanceof PyFloat) {
                res = JythonOps.dataset((PyObject)((PyFloat)result));
            } else {
                try {
                    res = (QDataSet)result.__tojava__(QDataSet.class);
                }
                catch (ClassCastException ex) {
                    Object os = result.__tojava__(Object.class);
                    throw new IllegalArgumentException("variable is not a dataset: " + expr + " (" + os.toString() + ")");
                }
            }
            if (label != null && res instanceof MutablePropertyDataSet && !((MutablePropertyDataSet)res).isImmutable() && res.property("LABEL") == null) {
                ((MutablePropertyDataSet)res).putProperty("LABEL", (Object)label);
            }
            if (this.notCheckedTsb) {
                PyObject tr = this.interp.eval("getParam('timerange','x')");
                JythonDataSourceTimeSeriesBrowse tsb1 = JythonDataSourceTimeSeriesBrowse.checkForTimeSeriesBrowse(this.uri.toString(), jythonScript);
                if (tsb1 != null) {
                    tsb1.setJythonDataSource(this);
                    if (!tr.toString().equals("x")) {
                        tsb1.setTimeRange(DatumRangeUtil.parseTimeRange((String)tr.toString()));
                    }
                    this.addCapability(TimeSeriesBrowse.class, tsb1);
                    this.tsb = tsb1;
                }
                this.notCheckedTsb = false;
            }
            if (this.tsb != null && res != null && (dep0 = (QDataSet)res.property("DEPEND_0")) != null) {
                CacheTag tag = (CacheTag)dep0.property("CACHE_TAG");
                if (tag == null) {
                    tag = new CacheTag(this.tsb.getTimeRange(), null);
                    MutablePropertyDataSet mdep0 = DataSetOps.makePropertiesMutable((QDataSet)dep0);
                    mdep0.putProperty("CACHE_TAG", (Object)tag);
                    MutablePropertyDataSet mres = DataSetOps.makePropertiesMutable((QDataSet)res);
                    mres.putProperty("DEPEND_0", (Object)mdep0);
                    res = mres;
                } else {
                    logger.log(Level.FINE, "result reports cache tag: {0}", tag);
                }
            }
            if (rcent != null) {
                URISplit t = URISplit.parse((String)suri);
                LinkedHashMap m = URISplit.parseParams((String)t.params);
                String s = (String)m.remove("arg_0");
                PyStringMap locals = (PyStringMap)this.interp.getLocals();
                PyList keys = locals.keys();
                PyList values = locals.values();
                boolean useOutputParams = false;
                PyObject o = this.interp.get("outputParams");
                if (o != null && o instanceof PyDictionary && ((PyDictionary)o).__len__() > 0) {
                    useOutputParams = true;
                }
                if (!useOutputParams) {
                    logger.fine("loading local datasets to cache");
                    for (int i = 0; i < keys.size(); ++i) {
                        String key = (String)keys.get(i);
                        Object value = values.get(i);
                        if (value instanceof PyQDataSet) {
                            value = ((PyQDataSet)value).getQDataSet();
                        }
                        if (!(value instanceof QDataSet) && value != null) continue;
                        m.put("arg_0", String.valueOf(key));
                        t.params = URISplit.formatParams((Map)m);
                        String uri1 = URISplit.makeCanonical((String)URISplit.format((URISplit)t));
                        ReferenceCache.getInstance().offerDataSet(uri1, (QDataSet)value);
                        logger.log(Level.FINE, "Also adding to reference cache: {0}->{1}", new Object[]{uri1, value});
                    }
                } else {
                    logger.fine("loading output params to cache");
                    PyDictionary dict = (PyDictionary)o;
                    assert (dict != null);
                    keys = dict.keys();
                    for (int i = 0; i < keys.size(); ++i) {
                        String key = (String)keys.get(i);
                        PyObject value = dict.get((PyObject)Py.newString((String)key));
                        if (value instanceof PyQDataSet) {
                            value = ((PyQDataSet)value).getQDataSet();
                        }
                        if (!(value instanceof QDataSet) && value != null) continue;
                        m.put("arg_0", String.valueOf(key));
                        t.params = URISplit.formatParams((Map)m);
                        String uri1 = URISplit.makeCanonical((String)URISplit.format((URISplit)t));
                        ReferenceCache.getInstance().offerDataSet(uri1, (QDataSet)value);
                        logger.log(Level.FINE, "Also adding to reference cache: {0}->{1}", new Object[]{uri1, value});
                    }
                }
                if (s == null) {
                    rcent.finished(res);
                } else {
                    rcent.finished(Ops.dataset((Object)"1971-01-01T00:00"));
                }
            }
            if (causedBy != null) {
                this.interp = null;
                this.cacheUrl = null;
                this.cacheDate = null;
                logger.log(Level.WARNING, "exception in processing: {0}", causedBy);
                throw causedBy;
            }
            if (!allowCaching) {
                logger.log(Level.FINE, "reset caching because allowCaching is false");
                this.interp = null;
            }
            QDataSet qDataSet = res;
            return qDataSet;
        }
        catch (PyException ex) {
            if (rcent != null) {
                rcent.exception((Exception)((Object)ex));
            }
            if (causedBy != null) {
                logger.log(Level.FINE, "rethrow causedBy");
                throw causedBy;
            }
            logger.log(Level.FINE, "resetting caching because of PyException");
            this.interp = null;
            this.cacheUrl = null;
            this.cacheDate = null;
            throw ex;
        }
        catch (Exception ex) {
            if (rcent == null) throw ex;
            rcent.exception(ex);
            throw ex;
        }
        finally {
            if (!mon.isFinished()) {
                mon.finished();
            }
        }
    }

    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        return this.metadata;
    }

    private String cacheUrl(URI uri) {
        URISplit split = URISplit.parse((URI)uri);
        LinkedHashMap params2 = URISplit.parseParams((String)split.params);
        params2.remove("arg_0");
        split.params = URISplit.formatParams((Map)params2);
        return URISplit.format((URISplit)split);
    }

    private Date resourceDate(URI uri) throws IOException {
        File src = DataSetURI.getFile((String)DataSetURI.fromUri((URI)uri), (boolean)true, (ProgressMonitor)new NullProgressMonitor());
        return new Date(src.lastModified());
    }

    private synchronized boolean useCache(URI uri) {
        try {
            if (this.cacheDate != null && !this.resourceDate(uri).after(this.cacheDate) && this.cacheUrl != null && this.cacheUrl.equals(this.cacheUrl(uri))) {
                return !uri.toString().contains("allowCaching=F");
            }
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean satisfies(String surl) {
        URISplit split = URISplit.parse((String)surl);
        if (!"vap+jyds".equals(split.vapScheme)) {
            return false;
        }
        try {
            return this.useCache(DataSetURI.getURI((String)surl));
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }

    public void resetURI(String surl) {
        try {
            this.uri = DataSetURI.getURI((String)surl);
            URISplit split = URISplit.parse((URI)this.uri);
            this.params = URISplit.parseParams((String)split.params);
            this.resourceURI = DataSetURI.toUri((String)split.file);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void reset() {
        logger.fine("JythonDataSource.reset() clears cache");
        this.interp = null;
    }
}

