/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

public class CDFHuffman {
    Bit_File bit_file = new Bit_File();
    long[] counts;
    Tree_Node[] tnodes;
    Code[] codes;
    byte[] input;
    byte[] output;
    int iSize;
    int iByteN;
    int oByteN;
    protected static final int END_OF_STREAM = 256;
    protected static final int ESCAPE = 257;
    protected static final int SYMBOL_COUNT = 258;
    protected static final int NODE_TABLE_COUNT = 515;
    protected static final int ROOT_NODE = 0;
    protected static final int MAX_WEIGHT = 32768;
    protected static final int UBYTE_MAX = 256;
    protected static final int USHORT_MAX = 65535;
    protected static final long UINT_MAX = 0xFFFFFFFFL;

    public CDFHuffman() {
        this.bit_file.startBit();
        this.counts = new long[256];
        this.tnodes = new Tree_Node[514];
        for (int i = 0; i < this.tnodes.length; ++i) {
            this.tnodes[i] = new Tree_Node();
        }
        this.codes = new Code[257];
    }

    public byte[] compress(byte[] input, int iSize) {
        boolean oSize = false;
        this.input = input;
        this.iSize = iSize;
        this.oByteN = 0;
        this.iByteN = 0;
        this.count_bytes(input, this.counts, iSize);
        byte[] output = new byte[10 * iSize];
        this.scale_counts();
        this.output_counts();
        int root_node = this.build_tree();
        this.convert_tree_to_code(0, 0, root_node);
        this.compress_data();
        this.endOutputBit();
        byte[] noutput = new byte[this.oByteN];
        System.arraycopy(output, 0, noutput, 0, this.oByteN);
        return noutput;
    }

    public byte[] decompress(byte[] input, int oSize) {
        this.output = new byte[oSize];
        this.iByteN = 0;
        this.oByteN = 0;
        this.input = input;
        this.iSize = input.length;
        this.input_counts();
        int root_node = this.build_tree();
        this.expand_data(root_node);
        return this.output;
    }

    void output_counts() {
        int first;
        int last = 0;
        for (first = 0; first < 255 && this.tnodes[first].count == 0; ++first) {
        }
        while (first < 256) {
            int next;
            last = first + 1;
            while (true) {
                if (last < 256 && this.tnodes[last].count != 0) {
                    ++last;
                    continue;
                }
                for (next = --last + 1; next < 256 && this.tnodes[next].count == 0; ++next) {
                }
                if (next > 255 || next - last > 3) break;
                last = next;
            }
            this.output[this.oByteN] = (byte)first;
            ++this.oByteN;
            this.output[this.oByteN] = (byte)last;
            ++this.oByteN;
            for (int i = first; i <= last; ++i) {
                this.output[this.oByteN] = (byte)this.tnodes[i].count;
                ++this.oByteN;
            }
            first = next;
        }
        this.output[this.oByteN] = 0;
        ++this.oByteN;
    }

    void count_bytes(byte[] input, long[] counts, long iSize) {
        int i = 0;
        while ((long)i < iSize) {
            byte c;
            byte by = c = input[i];
            counts[by] = counts[by] + 1L;
            ++i;
        }
    }

    void scale_counts() {
        int i;
        long max_count = 0L;
        for (i = 0; i < 256; ++i) {
            if (this.counts[i] <= max_count) continue;
            max_count = this.counts[i];
        }
        if (max_count == 0L) {
            this.counts[0] = 1L;
            max_count = 1L;
        }
        max_count /= 255L;
        ++max_count;
        for (i = 0; i < 256; ++i) {
            this.tnodes[i].count = (int)(this.counts[i] / max_count);
            if (this.tnodes[i].count != 0 || this.counts[i] == 0L) continue;
            this.tnodes[i].count = 1;
        }
        this.tnodes[256].count = 1;
    }

    int build_tree() {
        this.tnodes[513].count = 65535;
        int next_free = 257;
        while (true) {
            int min_1 = 513;
            int min_2 = 513;
            for (int i = 0; i < next_free; ++i) {
                if (this.tnodes[i].count == 0) continue;
                if (this.tnodes[i].count < this.tnodes[min_1].count) {
                    min_2 = min_1;
                    min_1 = i;
                    continue;
                }
                if (this.tnodes[i].count >= this.tnodes[min_2].count) continue;
                min_2 = i;
            }
            if (min_2 == 513) break;
            this.tnodes[next_free].count = this.tnodes[min_1].count + this.tnodes[min_2].count;
            this.tnodes[min_1].saved_count = this.tnodes[min_1].count;
            this.tnodes[min_1].count = 0;
            this.tnodes[min_2].saved_count = this.tnodes[min_2].count;
            this.tnodes[min_2].count = 0;
            this.tnodes[next_free].child_0 = min_1;
            this.tnodes[next_free].child_1 = min_2;
            ++next_free;
        }
        this.tnodes[--next_free].saved_count = this.tnodes[next_free].count;
        return next_free;
    }

    void convert_tree_to_code(int code_so_far, int bits, int node) {
        if (node <= 256) {
            this.codes[node].code = (short)code_so_far;
            this.codes[node].code_bits = bits;
            return;
        }
        this.convert_tree_to_code(code_so_far <<= 1, ++bits, this.tnodes[node].child_0);
        this.convert_tree_to_code(code_so_far | 1, bits, this.tnodes[node].child_1);
    }

    int compress_data() {
        for (long i = 0L; i < (long)this.iSize; ++i) {
            byte c = this.input[this.iByteN];
            ++this.iByteN;
            this.outputBits(this.codes[c].code, this.codes[c].code_bits);
        }
        this.outputBits(this.codes[256].code, this.codes[256].code_bits);
        return 0;
    }

    void endOutputBit() {
        if (this.bit_file.mask != 128) {
            this.output[this.oByteN] = (byte)this.bit_file.rack;
            ++this.oByteN;
        }
    }

    void outputBits(long code, int count) {
        for (long mask = (long)(1 << count - 1); mask != 0L; mask >>= 1) {
            if ((mask & code) != 0L) {
                this.bit_file.rack |= this.bit_file.mask;
            }
            this.bit_file.mask = (short)(this.bit_file.mask >> 1);
            if (this.bit_file.mask != 0) continue;
            this.output[this.oByteN] = (byte)this.bit_file.rack;
            ++this.oByteN;
            this.bit_file.rack = 0;
            this.bit_file.mask = (short)128;
        }
    }

    int inputBit() {
        if (this.bit_file.mask == 128) {
            this.bit_file.rack = this.input[this.iByteN] >= 0 ? this.input[this.iByteN] : 256 + this.input[this.iByteN];
            ++this.iByteN;
            if (this.bit_file.rack == -1) {
                return -1;
            }
        }
        int value = this.bit_file.rack & this.bit_file.mask;
        this.bit_file.mask = (short)(this.bit_file.mask >> 1);
        if (this.bit_file.mask == 0) {
            this.bit_file.mask = (short)128;
        }
        return value != 0 ? 1 : 0;
    }

    void input_counts() {
        int i;
        for (i = 0; i < 256; ++i) {
            this.tnodes[i].count = 0;
        }
        int first = this.input[this.iByteN];
        ++this.iByteN;
        first = first >= 0 ? first : 256 + first;
        int last = this.input[this.iByteN];
        ++this.iByteN;
        last = last >= 0 ? last : 256 + last;
        while (true) {
            for (i = first; i <= last; ++i) {
                int c = this.input[this.iByteN];
                ++this.iByteN;
                this.tnodes[i].count = c >= 0 ? c : 256 + c;
            }
            first = this.input[this.iByteN];
            ++this.iByteN;
            if (first == 0) break;
            first = first > 0 ? first : 256 + first;
            last = this.input[this.iByteN];
            ++this.iByteN;
            last = last >= 0 ? last : 256 + last;
        }
        this.tnodes[256].count = 1;
    }

    void expand_data(int root_node) {
        while (true) {
            int bit;
            int node1 = root_node;
            while ((node1 = (bit = this.inputBit()) != 0 ? this.tnodes[node1].child_1 : this.tnodes[node1].child_0) > 256) {
            }
            if (node1 == 256) break;
            this.output[this.oByteN] = (byte)node1;
            ++this.oByteN;
        }
    }

    class Node {
        int weight;
        int parent;
        boolean child_is_leaf;
        int child;

        Node() {
        }
    }

    class Bit_File {
        short mask;
        int rack;

        private Bit_File() {
        }

        void startBit() {
            this.rack = 0;
            this.mask = (short)128;
        }
    }

    class Code {
        int code;
        int code_bits;

        Code() {
        }
    }

    class Tree_Node {
        int count;
        int saved_count;
        int child_0;
        int child_1;

        Tree_Node() {
        }
    }
}

