/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.GenericReader;
import gov.nasa.gsfc.spdf.cdfj.MetaData;
import gov.nasa.gsfc.spdf.cdfj.TSExtractor;
import gov.nasa.gsfc.spdf.cdfj.TimeInstantModel;
import gov.nasa.gsfc.spdf.cdfj.TimePrecision;
import gov.nasa.gsfc.spdf.cdfj.TimeSeries;
import gov.nasa.gsfc.spdf.cdfj.TimeSeriesOneD;
import gov.nasa.gsfc.spdf.cdfj.TimeSeriesX;
import gov.nasa.gsfc.spdf.cdfj.TimeUtil;
import gov.nasa.gsfc.spdf.cdfj.TimeVariableFactory;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public class CDFReader
extends GenericReader {
    Scalar scalar;
    CDFVector vector;

    public CDFReader() {
    }

    public CDFReader(String cdfFile) throws CDFException.ReaderError {
        super(cdfFile);
        this.scalar = new Scalar();
        this.scalar.rdr = this;
        this.vector = new CDFVector();
        this.vector.rdr = this;
    }

    public CDFReader(URL url) throws CDFException.ReaderError {
        super(url);
        this.scalar = new Scalar();
        this.scalar.rdr = this;
        this.vector = new CDFVector();
        this.vector.rdr = this;
    }

    public TimeSeries getTimeSeries(String varName) throws CDFException.ReaderError {
        return this.getTimeSeries(varName, null, CDFReader.timeModelInstance());
    }

    public TimeSeries getTimeSeries(String varName, TimeInstantModel tspec) throws CDFException.ReaderError {
        TimeInstantModel _tspec = tspec == null ? CDFReader.timeModelInstance() : tspec;
        return this.getTimeSeries(varName, null, _tspec);
    }

    public TimeSeries getTimeSeries(String varName, int[] startTime, int[] stopTime) throws CDFException.ReaderError {
        return this.getTimeSeries(varName, startTime, stopTime, null);
    }

    private TimeSeries getTimeSeries(String varName, double[] timeRange, TimeInstantModel tspec) throws CDFException.ReaderError {
        Variable var = this.thisCDF.getVariable(varName);
        TSExtractor.GeneralTimeSeriesX ts = null;
        try {
            ts = new TSExtractor.GeneralTimeSeriesX(this, var, false, timeRange, tspec, false, true);
            return new TimeSeriesImpl(ts);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public TimeSeries getTimeSeries(String varName, int[] startTime, int[] stopTime, TimeInstantModel tspec) throws CDFException.ReaderError {
        TimeVariableFactory.CDFTimeVariable tv = null;
        try {
            tv = TimeVariableFactory.getTimeVariable(this, varName);
            TimeInstantModel _tspec = tspec;
            if (_tspec == null) {
                _tspec = CDFReader.timeModelInstance();
            }
            if (!tv.canSupportPrecision(_tspec.getOffsetUnits())) {
                throw new CDFException.ReaderError(varName + " has lower time precision than requested.");
            }
            double[] trange = this.getAvailableTimeRange(varName);
            double[] tr = TSExtractor.getOverlap(this, trange, varName, startTime, stopTime);
            return this.getTimeSeries(varName, tr, tspec);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    private TimeSeriesOneD getTimeSeries(String varName, double[] timeRange, TimeInstantModel tspec, boolean columnMajor) throws CDFException.ReaderError {
        Variable var = this.thisCDF.getVariable(varName);
        TSExtractor.GeneralTimeSeriesX ts = null;
        try {
            ts = new TSExtractor.GeneralTimeSeriesX(this, var, false, timeRange, tspec, true, columnMajor);
            return new TimeSeriesOneDImpl(ts);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public TimeSeriesOneD getTimeSeriesOneD(String varName, int[] startTime, int[] stopTime, TimeInstantModel tspec, boolean columnMajor) throws CDFException.ReaderError {
        try {
            TimeVariableFactory.CDFTimeVariable tv = TimeVariableFactory.getTimeVariable(this, varName);
            TimeInstantModel _tspec = tspec;
            if (_tspec == null) {
                _tspec = CDFReader.timeModelInstance();
            }
            if (!tv.canSupportPrecision(_tspec.getOffsetUnits())) {
                System.out.println("cannot support");
                throw new Throwable(varName + " has lower time precision than requested.");
            }
            double[] trange = this.getAvailableTimeRange(varName);
            double[] tr = TSExtractor.getOverlap(this, trange, varName, startTime, stopTime);
            return this.getTimeSeries(varName, tr, _tspec, columnMajor);
        }
        catch (Throwable th) {
            System.out.println(th.getMessage());
            th.printStackTrace();
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public double[] getAvailableTimeRange(String varName) throws CDFException.ReaderError {
        try {
            TimeVariableFactory.CDFTimeVariable tv = TimeVariableFactory.getTimeVariable(this, varName);
            double[] times = tv.getTimes();
            return new double[]{times[0], times[times.length - 1]};
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    boolean overlaps(double[] t) {
        if (t[0] == Double.MIN_VALUE) {
            return false;
        }
        return t[0] != Double.MAX_VALUE;
    }

    public int[] firstAvailableTime(String varName) throws CDFException.ReaderError {
        return this.firstAvailableTime(varName, null);
    }

    public int[] firstAvailableTime(String varName, int[] start) throws CDFException.ReaderError {
        try {
            double[] tr;
            TimeVariableFactory.CDFTimeVariable tv = TimeVariableFactory.getTimeVariable(this, varName);
            double[] times = tv.getTimes();
            double[] trange = new double[]{times[0], times[times.length - 1]};
            try {
                tr = TSExtractor.getOverlap(this, trange, varName, start, null);
            }
            catch (Exception ex) {
                return null;
            }
            if (tr[0] != Double.MIN_VALUE) {
                GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                c.setTimeInMillis((long)tr[0]);
                if (tv.isTT2000()) {
                    long l0 = c.getTime().getTime();
                    long l = (long)TimeUtil.getOffset(l0);
                    c.setTimeInMillis((long)tr[0] - l + l0);
                }
                return this.GMT(c);
            }
            return null;
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public int[] lastAvailableTime(String varName) throws CDFException.ReaderError {
        return this.lastAvailableTime(varName, null);
    }

    public int[] lastAvailableTime(String varName, int[] stop) throws CDFException.ReaderError {
        try {
            double[] tr;
            TimeVariableFactory.CDFTimeVariable tv = TimeVariableFactory.getTimeVariable(this, varName);
            double[] times = tv.getTimes();
            double[] trange = new double[]{times[0], times[times.length - 1]};
            try {
                tr = TSExtractor.getOverlap(this, trange, varName, null, stop);
            }
            catch (Exception ex) {
                return null;
            }
            if (tr[1] != Double.MAX_VALUE) {
                GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                c.setTimeInMillis((long)tr[1]);
                if (tv.isTT2000()) {
                    long l0 = c.getTime().getTime();
                    long l = (long)TimeUtil.getOffset(l0);
                    c.setTimeInMillis((long)tr[1] - l + l0);
                }
                return this.GMT(c);
            }
            return null;
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    int[] GMT(Calendar c) {
        return new int[]{c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14)};
    }

    public TimeInstantModel timeModelInstance(String varName, int[] baseTime) throws CDFException.ReaderError {
        if (baseTime.length < 3) {
            throw new CDFException.ReaderError("incomplete base time definition.");
        }
        try {
            boolean isTT2000 = TimeVariableFactory.getTimeVariable(this, varName).isTT2000();
            long l = TSExtractor.getTime(baseTime);
            double msec = !isTT2000 ? (double)l : TimeUtil.milliSecondSince1970(l);
            return this.getTimeInstantModel(msec += (double)TimeVariableFactory.JANUARY_1_1970_LONG);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public TimeInstantModel timeModelInstance(String varName, int[] baseTime, TimePrecision offsetUnits) throws CDFException.ReaderError {
        TimeInstantModel model = this.timeModelInstance(varName, baseTime);
        model.setOffsetUnits(offsetUnits);
        return model;
    }

    private TimeInstantModel getTimeInstantModel(double msec) {
        TimeInstantModel tspec = TimeVariableFactory.getDefaultTimeInstantModel(msec);
        return tspec;
    }

    private double getTime(String varName, int[] time) throws CDFException.ReaderError {
        try {
            return TSExtractor.getTime(this, varName, time);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public static TimeInstantModel timeModelInstance() {
        return TimeVariableFactory.getDefaultTimeInstantModel();
    }

    public static TimeInstantModel timeModelInstance(String offsetUnits) {
        TimeInstantModel tim = TimeVariableFactory.getDefaultTimeInstantModel();
        tim.setOffsetUnits(TimePrecision.getPrecision(offsetUnits));
        return tim;
    }

    public String[] getDependent(String varName) {
        String[] anames = this.thisCDF.variableAttributeNames(varName);
        if (anames == null) {
            return new String[0];
        }
        Vector dependent = new Vector();
        for (String aname : anames) {
            if (!aname.startsWith("DEPEND_")) continue;
            dependent.add(((Vector)this.thisCDF.getAttribute(varName, aname)).get(0));
        }
        String[] sa = new String[dependent.size()];
        dependent.toArray(sa);
        return sa;
    }

    public String getIndexName(String varName, int index) throws CDFException.ReaderError {
        try {
            int[] dim = this.getDimensions(varName);
            if (dim.length == 0) {
                return null;
            }
            if (index >= dim.length) {
                return null;
            }
            Vector attr = (Vector)this.getAttribute(varName, "DEPEND_" + (1 + index));
            return (String)attr.get(0);
        }
        catch (CDFException.ReaderError th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public double[][] getScalarTimeSeries(String varName) throws CDFException.ReaderError {
        try {
            return this.scalar.getTimeSeries(varName);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public double[][] getScalarTimeSeries(String varName, int[] startTime, int[] stopTime) throws CDFException.ReaderError {
        try {
            return this.scalar.getTimeSeries(varName, startTime, stopTime);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public TimeSeries getScalarTimeSeries(String varName, int[] startTime, int[] stopTime, TimeInstantModel tspec) throws CDFException.ReaderError {
        try {
            return this.scalar.getTimeSeries(varName, startTime, stopTime, tspec);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public double[][] getScalarTimeSeries(String varName, boolean ignoreFill) throws CDFException.ReaderError {
        try {
            return this.scalar.getTimeSeries(varName, ignoreFill);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public double[][] getScalarTimeSeries(String varName, boolean ignoreFill, int[] startTime, int[] stopTime) throws CDFException.ReaderError {
        try {
            return this.scalar.getTimeSeries(varName, ignoreFill, startTime, stopTime);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public TimeSeries getScalarTimeSeries(String varName, boolean ignoreFill, int[] startTime, int[] stopTime, TimeInstantModel tspec) throws CDFException.ReaderError {
        try {
            return this.scalar.getTimeSeries(varName, ignoreFill, startTime, stopTime, tspec);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public double[][] getVectorTimeSeries(String varName, int component) throws CDFException.ReaderError {
        try {
            return this.vector.getTimeSeries(varName, component);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public double[][] getVectorTimeSeries(String varName, int component, int[] startTime, int[] stopTime) throws CDFException.ReaderError {
        try {
            return this.vector.getTimeSeries(varName, component, startTime, stopTime);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public TimeSeries getVectorTimeSeries(String varName, int component, int[] startTime, int[] stopTime, TimeInstantModel tspec) throws CDFException.ReaderError {
        try {
            return this.vector.getTimeSeries(varName, component, startTime, stopTime, tspec);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public double[][] getVectorTimeSeries(String varName, int component, boolean ignoreFill) throws CDFException.ReaderError {
        try {
            return this.vector.getTimeSeries(varName, component, ignoreFill);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public double[][] getVectorTimeSeries(String varName, int component, boolean ignoreFill, int[] startTime, int[] stopTime) throws CDFException.ReaderError {
        try {
            return this.vector.getTimeSeries(varName, component, ignoreFill, startTime, stopTime);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public TimeSeries getVectorTimeSeries(String varName, int component, boolean ignoreFill, int[] startTime, int[] stopTime, TimeInstantModel tspec) throws CDFException.ReaderError {
        try {
            return this.vector.getTimeSeries(varName, component, ignoreFill, startTime, stopTime, tspec);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    class CDFVector {
        MetaData rdr;

        CDFVector() {
        }

        private double[][] _getTimeSeries(String varName, int component, boolean ignoreFill, double[] timeRange) throws Throwable {
            CDFReader.this.checkType(varName);
            Variable var = CDFReader.this.thisCDF.getVariable(varName);
            Method method = TSExtractor.getMethod(var, "TimeSeries", 1);
            return (double[][])method.invoke(null, this.rdr, var, component, ignoreFill, timeRange);
        }

        private TimeSeries _getTimeSeries(String varName, int component, boolean ignoreFill, double[] timeRange, TimeInstantModel tspec) throws Throwable {
            CDFReader.this.checkType(varName);
            Variable var = CDFReader.this.thisCDF.getVariable(varName);
            Method method = TSExtractor.getMethod(var, "TimeSeriesObject", 1);
            TimeSeries ts = (TimeSeries)method.invoke(null, this.rdr, var, component, ignoreFill, timeRange, tspec);
            return new TimeSeriesImpl(ts);
        }

        public double[][] getTimeSeries(String varName, int component) throws Throwable {
            Variable var = CDFReader.this.thisCDF.getVariable(varName);
            if (var.getEffectiveRank() != 1) {
                throw new Throwable(varName + " is not a vector.");
            }
            int dim = var.getEffectiveDimensions()[0];
            if (component < 0 || component > dim) {
                throw new Throwable("component exceeds dimension of " + varName + " (" + dim + ")");
            }
            return this._getTimeSeries(varName, component, true, null);
        }

        public double[][] getTimeSeries(String varName, int component, int[] startTime, int[] stopTime) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(varName).getEffectiveRank() != 1) {
                throw new Throwable(varName + " is not a vector.");
            }
            Integer dim = (Integer)CDFReader.this.thisCDF.getVariable(varName).getElementCount().get(0);
            if (component < 0 || component > dim) {
                throw new Throwable("Invalid component " + component + " for " + varName);
            }
            double[] trange = CDFReader.this.getAvailableTimeRange(varName);
            double[] tr = TSExtractor.getOverlap(this.rdr, trange, varName, startTime, stopTime);
            return this._getTimeSeries(varName, component, true, tr);
        }

        public TimeSeries getTimeSeries(String varName, int component, int[] startTime, int[] stopTime, TimeInstantModel tspec) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(varName).getEffectiveRank() != 1) {
                throw new Throwable(varName + " is not a vector.");
            }
            Integer dim = (Integer)CDFReader.this.thisCDF.getVariable(varName).getElementCount().get(0);
            if (component < 0 || component > dim) {
                throw new Throwable("Invalid component " + component + " for " + varName);
            }
            double[] trange = CDFReader.this.getAvailableTimeRange(varName);
            double[] tr = TSExtractor.getOverlap(this.rdr, trange, varName, startTime, stopTime);
            return this._getTimeSeries(varName, component, true, tr, tspec);
        }

        public double[][] getTimeSeries(String varName, int component, boolean ignoreFill) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(varName).getEffectiveRank() != 1) {
                throw new Throwable(varName + " is not a vector.");
            }
            Integer dim = (Integer)CDFReader.this.thisCDF.getVariable(varName).getElementCount().get(0);
            if (component < 0 || component > dim) {
                throw new Throwable("Invalid component " + component + " for " + varName);
            }
            return this._getTimeSeries(varName, component, ignoreFill, null);
        }

        public double[][] getTimeSeries(String varName, int component, boolean ignoreFill, int[] startTime, int[] stopTime) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(varName).getEffectiveRank() != 1) {
                throw new Throwable(varName + " is not a vector.");
            }
            Integer dim = (Integer)CDFReader.this.thisCDF.getVariable(varName).getElementCount().get(0);
            if (component < 0 || component > dim) {
                throw new Throwable("Invalid component " + component + " for " + varName);
            }
            double[] trange = CDFReader.this.getAvailableTimeRange(varName);
            double[] tr = TSExtractor.getOverlap(this.rdr, trange, varName, startTime, stopTime);
            return this._getTimeSeries(varName, component, ignoreFill, tr);
        }

        public TimeSeries getTimeSeries(String varName, int component, boolean ignoreFill, int[] startTime, int[] stopTime, TimeInstantModel tspec) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(varName).getEffectiveRank() != 1) {
                throw new Throwable(varName + " is not a vector.");
            }
            Integer dim = (Integer)CDFReader.this.thisCDF.getVariable(varName).getElementCount().get(0);
            if (component < 0 || component > dim) {
                throw new Throwable("Invalid component " + component + " for " + varName);
            }
            double[] trange = CDFReader.this.getAvailableTimeRange(varName);
            double[] tr = TSExtractor.getOverlap(this.rdr, trange, varName, startTime, stopTime);
            return this._getTimeSeries(varName, component, ignoreFill, tr, tspec);
        }
    }

    class Scalar {
        MetaData rdr;

        Scalar() {
        }

        double[][] _getTimeSeries(String varName, boolean ignoreFill, double[] timeRange) throws Throwable {
            CDFReader.this.checkType(varName);
            Variable var = CDFReader.this.thisCDF.getVariable(varName);
            Method method = TSExtractor.getMethod(var, "TimeSeries", 0);
            return (double[][])method.invoke(null, this.rdr, var, ignoreFill, timeRange);
        }

        TimeSeries _getTimeSeries(String varName, boolean ignoreFill, double[] timeRange, TimeInstantModel tspec) throws Throwable {
            CDFReader.this.checkType(varName);
            Variable var = CDFReader.this.thisCDF.getVariable(varName);
            Method method = TSExtractor.getMethod(var, "TimeSeriesObject", 0);
            TimeSeries ts = (TimeSeries)method.invoke(null, this.rdr, var, ignoreFill, timeRange, tspec);
            return new TimeSeriesImpl(ts);
        }

        public double[][] getTimeSeries(String varName) throws Throwable {
            Variable var = CDFReader.this.thisCDF.getVariable(varName);
            if (var.getEffectiveRank() != 0) {
                throw new Throwable(varName + " is not a scalar.");
            }
            return this._getTimeSeries(varName, true, null);
        }

        public double[][] getTimeSeries(String varName, int[] startTime, int[] stopTime) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(varName).getEffectiveRank() != 0) {
                throw new Throwable(varName + " is not a scalar.");
            }
            double[] trange = CDFReader.this.getAvailableTimeRange(varName);
            double[] tr = TSExtractor.getOverlap(this.rdr, trange, varName, startTime, stopTime);
            return this._getTimeSeries(varName, true, tr);
        }

        public TimeSeries getTimeSeries(String varName, int[] startTime, int[] stopTime, TimeInstantModel tspec) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(varName).getEffectiveRank() != 0) {
                throw new Throwable(varName + " is not a scalar.");
            }
            double[] trange = CDFReader.this.getAvailableTimeRange(varName);
            double[] tr = TSExtractor.getOverlap(this.rdr, trange, varName, startTime, stopTime);
            return this._getTimeSeries(varName, true, tr, tspec);
        }

        public double[][] getTimeSeries(String varName, boolean ignoreFill) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(varName).getEffectiveRank() != 0) {
                throw new Throwable(varName + " is not a scalar.");
            }
            return this._getTimeSeries(varName, ignoreFill, null);
        }

        public double[][] getTimeSeries(String varName, boolean ignoreFill, int[] startTime, int[] stopTime) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(varName).getEffectiveRank() != 0) {
                throw new Throwable(varName + " is not a scalar.");
            }
            double[] trange = CDFReader.this.getAvailableTimeRange(varName);
            double[] tr = TSExtractor.getOverlap(this.rdr, trange, varName, startTime, stopTime);
            return this._getTimeSeries(varName, ignoreFill, tr);
        }

        public TimeSeries getTimeSeries(String varName, boolean ignoreFill, int[] startTime, int[] stopTime, TimeInstantModel tspec) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(varName).getEffectiveRank() != 0) {
                throw new Throwable(varName + " is not a scalar.");
            }
            double[] trange = CDFReader.this.getAvailableTimeRange(varName);
            double[] tr = TSExtractor.getOverlap(this.rdr, trange, varName, startTime, stopTime);
            return this._getTimeSeries(varName, ignoreFill, tr, tspec);
        }
    }

    class TimeSeriesImpl
    implements TimeSeries {
        double[] times;
        Object values;
        TimeInstantModel tspec;

        public TimeSeriesImpl(TimeSeries ts) throws CDFException.ReaderError {
            this.times = ts.getTimes();
            this.values = ts.getValues();
            this.tspec = ts.getTimeInstantModel();
        }

        @Override
        public TimeInstantModel getTimeInstantModel() {
            return this.tspec;
        }

        @Override
        public double[] getTimes() throws CDFException.ReaderError {
            return this.times;
        }

        @Override
        public Object getValues() throws CDFException.ReaderError {
            return this.values;
        }
    }

    class TimeSeriesOneDImpl
    extends TimeSeriesImpl
    implements TimeSeriesOneD {
        boolean columnMajor;

        TimeSeriesOneDImpl(TimeSeriesX ts) throws CDFException.ReaderError {
            super(ts);
            if (!ts.isOneD()) {
                throw new CDFException.ReaderError("Not 1D timeseries.");
            }
            this.columnMajor = ts.isColumnMajor();
        }

        @Override
        public double[] getValues() throws CDFException.ReaderError {
            return (double[])this.values;
        }

        public double[] getValuesOneD() throws CDFException.ReaderError {
            return (double[])this.values;
        }

        @Override
        public boolean isColumnMajor() {
            return this.columnMajor;
        }
    }
}

