/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.ArrayAttribute;
import gov.nasa.gsfc.spdf.cdfj.BaseVarContainer;
import gov.nasa.gsfc.spdf.cdfj.ByteVarContainer;
import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFFactory;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.DoubleVarContainer;
import gov.nasa.gsfc.spdf.cdfj.Extractor;
import gov.nasa.gsfc.spdf.cdfj.FloatVarContainer;
import gov.nasa.gsfc.spdf.cdfj.IntVarContainer;
import gov.nasa.gsfc.spdf.cdfj.LongVarContainer;
import gov.nasa.gsfc.spdf.cdfj.MetaData;
import gov.nasa.gsfc.spdf.cdfj.ShortVarContainer;
import gov.nasa.gsfc.spdf.cdfj.Stride;
import gov.nasa.gsfc.spdf.cdfj.VDataContainer;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Hashtable;
import java.util.logging.Logger;

public class GenericReader
extends MetaData {
    private ThreadGroup tgroup;
    private Hashtable threadMap = new Hashtable();
    static final Hashtable classMap = new Hashtable();
    private static final Logger LOGGER;

    GenericReader() {
    }

    void setImpl(CDFImpl impl) {
        this.thisCDF = impl;
    }

    public GenericReader(String cdfFile) throws CDFException.ReaderError {
        LOGGER.entering("GenericReader", "constructor", cdfFile);
        File _file = new File(cdfFile);
        if (!_file.exists()) {
            throw new CDFException.ReaderError(cdfFile + " does not exist.");
        }
        if (_file.length() > Integer.MAX_VALUE) {
            throw new CDFException.ReaderError("Size of file " + cdfFile + " exceeds Integer.MAX_VALUE. If data for individual variables is less than this limit, you can use ReaderFactory.getReader(fileName) to get a GenericReader instance for this file.");
        }
        try {
            this.thisCDF = CDFFactory.getCDF(cdfFile);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
        LOGGER.exiting("GenericReader", "constructor");
    }

    void setup() {
        this.tgroup = new ThreadGroup(Integer.toHexString(this.hashCode()));
    }

    public GenericReader(URL url) throws CDFException.ReaderError {
        try {
            this.thisCDF = CDFFactory.getCDF(url);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final Object get(String varName) throws CDFException.ReaderError {
        Variable var = this.thisCDF.getVariable(varName);
        if (var == null) {
            throw new CDFException.ReaderError("No such variable " + varName);
        }
        try {
            Method method = Extractor.getMethod(var, "Series");
            if (method == null || GenericReader.coreNeeded(var)) {
                return this.thisCDF.get(varName);
            }
            return method.invoke(null, this.thisCDF, var);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final Object getLong(String varName) throws CDFException.ReaderError {
        Variable var = this.thisCDF.getVariable(varName);
        if (var == null) {
            throw new CDFException.ReaderError("No such variable " + varName);
        }
        try {
            return this.thisCDF.getLong(varName);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final double[] asDouble0(String varName) throws CDFException.ReaderError {
        try {
            double[] da;
            int ndim = this.getEffectiveDimensions(varName).length;
            if (ndim != 0) {
                throw new CDFException.ReaderError("Use asDouble" + ndim + "(" + varName + ") for " + ndim + "-dimensional variable " + varName);
            }
            Object o = this.get(varName);
            ArrayAttribute aa = new ArrayAttribute(o);
            if (aa.getType() == Long.TYPE) {
                long[] la = (long[])o;
                da = new double[la.length];
                for (int i = 0; i < la.length; ++i) {
                    da[i] = la[i];
                }
            } else {
                da = (double[])o;
            }
            return da;
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final double[][] asDouble1(String varName) throws CDFException.ReaderError {
        try {
            int ndim = this.getEffectiveDimensions(varName).length;
            if (ndim != 1) {
                throw new CDFException.ReaderError("Use asDouble" + ndim + "(" + varName + ") for " + ndim + "-dimensional variable " + varName);
            }
            return (double[][])this.get(varName);
        }
        catch (CDFException.ReaderError th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final double[][][] asDouble2(String varName) throws CDFException.ReaderError {
        try {
            int ndim = this.getEffectiveDimensions(varName).length;
            if (ndim != 2) {
                throw new CDFException.ReaderError("Use asDouble" + ndim + "(" + varName + ") for " + ndim + "-dimensional variable " + varName);
            }
            return (double[][][])this.get(varName);
        }
        catch (CDFException.ReaderError th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final double[][][][] asDouble3(String varName) throws CDFException.ReaderError {
        try {
            int ndim = this.getEffectiveDimensions(varName).length;
            if (ndim != 3) {
                throw new CDFException.ReaderError("Use asDouble" + ndim + "(" + varName + ") for " + ndim + "-dimensional variable " + varName);
            }
            return (double[][][][])this.get(varName);
        }
        catch (CDFException.ReaderError th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final double[] getOneD(String varName, boolean columnMajor) throws CDFException.ReaderError {
        Variable var = this.thisCDF.getVariable(varName);
        if (var == null) {
            throw new CDFException.ReaderError("No such variable " + varName);
        }
        if (this.getNumberOfValues(varName) == 0) {
            return new double[0];
        }
        try {
            return this.thisCDF.getOneD(varName, columnMajor);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final Object getRange(String varName, int first, int last) throws CDFException.ReaderError {
        Variable var = this.thisCDF.getVariable(varName);
        if (var == null) {
            throw new CDFException.ReaderError("No such variable " + varName);
        }
        try {
            Method method = Extractor.getMethod(var, "Range");
            if (method == null || GenericReader.coreNeeded(var)) {
                return this.thisCDF.getRange(varName, first, last);
            }
            return method.invoke(null, this.thisCDF, var, first, last);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final double[] getRangeOneD(String varName, int first, int last, boolean columnMajor) throws CDFException.ReaderError {
        Variable var = this.thisCDF.getVariable(varName);
        if (var == null) {
            throw new CDFException.ReaderError("No such variable " + varName);
        }
        try {
            return (double[])this.thisCDF.getRangeOneD(varName, first, last, columnMajor);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final double[] getVectorComponent(String varName, int component) throws CDFException.ReaderError {
        this.checkType(varName);
        if (this.getEffectiveRank(varName) != 1) {
            throw new CDFException.ReaderError(varName + " is not a vector.");
        }
        try {
            Variable var = this.thisCDF.getVariable(varName);
            Method method = Extractor.getMethod(var, "Element");
            if (method == null || GenericReader.coreNeeded(var)) {
                return (double[])this.thisCDF.get(varName, component);
            }
            return (double[])method.invoke(null, this.thisCDF, var, component);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final double[][] getVectorComponents(String varName, int[] components) throws Throwable {
        this.checkType(varName);
        if (this.getEffectiveRank(varName) != 1) {
            throw new CDFException.ReaderError(varName + " is not a vector.");
        }
        try {
            Variable var = this.thisCDF.getVariable(varName);
            Method method = Extractor.getMethod(var, "Elements");
            if (method == null || GenericReader.coreNeeded(var)) {
                return (double[][])this.thisCDF.get(varName, components);
            }
            return (double[][])method.invoke(null, this.thisCDF, var, components);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final double[] getRangeForComponent(String varName, int first, int last, int component) throws CDFException.ReaderError {
        this.checkType(varName);
        if (this.getEffectiveRank(varName) != 1) {
            throw new CDFException.ReaderError(varName + " is not a vector.");
        }
        try {
            Variable var = this.thisCDF.getVariable(varName);
            Method method = Extractor.getMethod(var, "RangeForElement");
            if (method == null || GenericReader.coreNeeded(var, new int[]{first, last})) {
                return (double[])this.thisCDF.getRange(varName, first, last, component);
            }
            return (double[])method.invoke(null, this.thisCDF, var, first, last, component);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final double[][] getRangeForComponents(String varName, int first, int last, int[] components) throws CDFException.ReaderError {
        this.checkType(varName);
        if (this.getEffectiveRank(varName) != 1) {
            throw new CDFException.ReaderError(varName + " is not a vector.");
        }
        try {
            Variable var = this.thisCDF.getVariable(varName);
            Method method = Extractor.getMethod(var, "RangeForElements");
            if (method == null || GenericReader.coreNeeded(var)) {
                return (double[][])this.thisCDF.get(varName, first, last, components);
            }
            return (double[][])method.invoke(null, this.thisCDF, var, first, last, components);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final String startContainerThread(String varName, String targetType, int[] recordRange, boolean preserve) throws CDFException.ReaderError {
        try {
            return this.startContainerThread(varName, targetType, recordRange, preserve, ByteOrder.nativeOrder());
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    String startContainerThread(String varName, String targetType, int[] recordRange, boolean preserve, ByteOrder bo) throws Throwable {
        String tname = this.threadName(varName, targetType, recordRange, preserve, bo);
        Class type = this.getContainerClass(targetType);
        VDataContainer container = this.getContainer(varName, type, recordRange, preserve, bo);
        if (this.tgroup == null) {
            this.setup();
        }
        Thread thread = new Thread(this.tgroup, container, tname);
        thread.start();
        this.threadMap.put(tname, new ThreadMapEntry(container, thread));
        return tname;
    }

    public final boolean threadFinished(String threadName) throws CDFException.ReaderError {
        Thread thread = ((ThreadMapEntry)this.threadMap.get(threadName)).getThread();
        if (thread == null) {
            throw new CDFException.ReaderError("Invalid thread name " + threadName);
        }
        return thread.getState() == Thread.State.TERMINATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ByteBuffer getBuffer(String threadName) throws Throwable {
        if (this.threadFinished(threadName)) {
            Hashtable hashtable = this.threadMap;
            synchronized (hashtable) {
                VDataContainer container = ((ThreadMapEntry)this.threadMap.get(threadName)).getContainer();
                ByteBuffer buffer = null;
                try {
                    buffer = container.getBuffer();
                }
                catch (Throwable th) {
                    throw new CDFException.ReaderError(th.getMessage());
                }
                this.threadMap.remove(threadName);
                return buffer;
            }
        }
        throw new CDFException.ReaderError("Thread " + threadName + " is working");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getOneDArray(String threadName, boolean columnMajor) throws CDFException.ReaderError {
        if (this.threadFinished(threadName)) {
            Hashtable hashtable = this.threadMap;
            synchronized (hashtable) {
                VDataContainer container = ((ThreadMapEntry)this.threadMap.get(threadName)).getContainer();
                Object array = null;
                try {
                    array = container.asOneDArray(columnMajor);
                }
                catch (Throwable th) {
                    throw new CDFException.ReaderError(th.getMessage());
                }
                this.threadMap.remove(threadName);
                return array;
            }
        }
        throw new CDFException.ReaderError("Thread " + threadName + " is working");
    }

    public final ByteBuffer getBuffer(String varName, String targetType, int[] recordRange, boolean preserve) throws CDFException.ReaderError {
        return this.getBuffer(varName, targetType, recordRange, preserve, true);
    }

    public final ByteBuffer getBuffer(String varName, String targetType, int[] recordRange, boolean preserve, boolean useDirect) throws CDFException.ReaderError {
        Class type;
        try {
            type = this.getContainerClass(targetType);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
        if (!this.isCompatible(varName, type, preserve)) {
            throw new CDFException.ReaderError("Requested type " + targetType + " not compatible with preserve = " + preserve);
        }
        VDataContainer container = null;
        try {
            container = this.getContainer(varName, type, recordRange, preserve, ByteOrder.nativeOrder());
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
        container.setDirect(useDirect);
        container.run();
        return container.getBuffer();
    }

    public final Object getOneDArray(String varName, String targetType, int[] recordRange, boolean preserve, boolean columnMajor) throws CDFException.ReaderError {
        VDataContainer container = null;
        try {
            Class type = this.getContainerClass(targetType);
            container = this.getContainer(varName, type, recordRange, preserve, ByteOrder.nativeOrder());
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
        container.run();
        return container.asOneDArray(columnMajor);
    }

    String threadName(String varName, String type, int[] recordRange, boolean preserve, ByteOrder bo) {
        StringBuffer sb = new StringBuffer(varName + "_" + type + "_");
        if (recordRange == null) {
            sb.append("null_");
        } else {
            sb.append(recordRange[0]).append("_").append(recordRange[1]);
            sb.append("_");
        }
        sb.append(preserve).append("_" + Math.random() + "_" + bo);
        return sb.toString();
    }

    Class getContainerClass(String stype) throws Throwable {
        Class cl = (Class)classMap.get(stype.toLowerCase());
        if (cl == null) {
            throw new Throwable("Unrecognized type " + stype);
        }
        return cl;
    }

    void checkType(String varName) throws CDFException.ReaderError {
        Variable var = this.thisCDF.getVariable(varName);
        if (var == null) {
            throw new CDFException.ReaderError("No such variable " + varName);
        }
        int type = var.getType();
        if (DataTypes.typeCategory[type] == 5) {
            throw new CDFException.ReaderError("This method cannot be used for variables of type long. Use the get methods for the variable and the associated time variable. ");
        }
    }

    public final boolean sourceIsFile() {
        return this.thisCDF.getSource().isFile();
    }

    public final String getSource() {
        return this.thisCDF.getSource().getName();
    }

    public final boolean isScalar(String varName) throws CDFException.ReaderError {
        return this.getEffectiveRank(varName) == 0;
    }

    public final boolean isVector(String varName) throws CDFException.ReaderError {
        return this.getEffectiveRank(varName) == 1;
    }

    @Override
    public String userTimeVariableName(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return null;
    }

    BaseVarContainer getRangeContainer(String varName, int[] range, String type, boolean preserve) throws Throwable {
        if (!this.existsVariable(varName)) {
            throw new Throwable("CDF does not hava a variable named " + varName);
        }
        if (DataTypes.isStringType(this.getType(varName))) {
            throw new Throwable("Function not supported for string variables");
        }
        Class cl = (Class)classMap.get(type);
        if (cl == null) {
            throw new Throwable("Invalid type " + type);
        }
        BaseVarContainer container = null;
        Variable var = this.thisCDF.getVariable(varName);
        if ("float".equals(type)) {
            container = new FloatVarContainer(this.thisCDF, var, range, preserve);
        }
        if ("double".equals(type)) {
            container = new DoubleVarContainer(this.thisCDF, var, range, preserve);
        }
        if ("int".equals(type)) {
            container = new IntVarContainer(this.thisCDF, var, range, preserve);
        }
        if ("short".equals(type)) {
            container = new ShortVarContainer(this.thisCDF, var, range, preserve);
        }
        if ("byte".equals(type)) {
            container = new ByteVarContainer(this.thisCDF, var, range);
        }
        if ("long".equals(type)) {
            container = new LongVarContainer(this.thisCDF, var, range);
        }
        container.run();
        return container;
    }

    public Object getSampled(String varName, int[] range, int stride, String type, boolean preserve, boolean columnMajor) throws CDFException.ReaderError {
        try {
            int[] nArray;
            BaseVarContainer container = this.getRangeContainer(varName, range, type, preserve);
            if (stride > 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = stride;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = -1;
                nArray = nArray3;
                nArray3[1] = -stride;
            }
            int[] _stride = nArray;
            return container.asOneDArray(columnMajor, new Stride(_stride));
        }
        catch (Throwable t) {
            throw new CDFException.ReaderError(t.getMessage());
        }
    }

    public Object getSampled(String varName, int first, int last, int stride, String type, boolean preserve) throws CDFException.ReaderError {
        try {
            int[] nArray;
            BaseVarContainer container = this.getRangeContainer(varName, new int[]{first, last}, type, preserve);
            if (stride > 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = stride;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = -1;
                nArray = nArray3;
                nArray3[1] = -stride;
            }
            int[] _stride = nArray;
            return container.asSampledArray(new Stride(_stride));
        }
        catch (Throwable t) {
            throw new CDFException.ReaderError(t.getMessage());
        }
    }

    private static boolean coreNeeded(Variable var) {
        return var.isMissingRecords();
    }

    private static boolean coreNeeded(Variable var, int[] range) {
        int[] available = var.getRecordRange();
        if (range.length == 1) {
            if (range[0] >= available[0]) {
                return var.isMissingRecords();
            }
            return true;
        }
        if (range[0] >= available[0] && range[1] <= available[1]) {
            return var.isMissingRecords();
        }
        return true;
    }

    VDataContainer getContainer(String varName, Class type, int[] recordRange, boolean preserve, ByteOrder bo) throws Throwable {
        Variable var = this.thisCDF.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        if (type == Double.TYPE) {
            return var.getDoubleContainer(recordRange, preserve, bo);
        }
        if (type == Float.TYPE) {
            return var.getFloatContainer(recordRange, preserve, bo);
        }
        if (type == Long.TYPE) {
            return var.getLongContainer(recordRange, bo);
        }
        if (type == Integer.TYPE) {
            return var.getIntContainer(recordRange, preserve, bo);
        }
        if (type == Short.TYPE) {
            return var.getShortContainer(recordRange, preserve, bo);
        }
        if (type == Byte.TYPE) {
            return var.getByteContainer(recordRange);
        }
        if (type == String.class) {
            return var.getStringContainer(recordRange);
        }
        throw new Throwable("Invalid type ");
    }

    public final int getBufferCapacity(String varName, String targetType, int[] recordRange) throws CDFException.ReaderError {
        VDataContainer container = null;
        try {
            Class type = this.getContainerClass(targetType);
            container = this.getContainer(varName, type, recordRange, false, ByteOrder.nativeOrder());
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
        return container.getCapacity();
    }

    public final ByteBuffer getBuffer(String varName, String targetType, int[] recordRange, boolean preserve, ByteBuffer buffer) throws CDFException.ReaderError {
        VDataContainer container = null;
        try {
            Class type = this.getContainerClass(targetType);
            container = this.getContainer(varName, type, recordRange, preserve, ByteOrder.nativeOrder());
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
        container.setUserBuffer(buffer);
        container.run();
        return container.getBuffer();
    }

    static {
        classMap.put("long", Long.TYPE);
        classMap.put("double", Double.TYPE);
        classMap.put("float", Float.TYPE);
        classMap.put("int", Integer.TYPE);
        classMap.put("short", Short.TYPE);
        classMap.put("byte", Byte.TYPE);
        classMap.put("string", String.class);
        LOGGER = Logger.getLogger("cdfj.genericreader");
    }

    class ThreadMapEntry {
        VDataContainer container;
        Thread thread;

        ThreadMapEntry(VDataContainer container, Thread thread) {
            this.container = container;
            this.thread = thread;
        }

        VDataContainer getContainer() {
            return this.container;
        }

        Thread getThread() {
            return this.thread;
        }
    }
}

