/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pdsppi;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.pdsppi.PDSPPIDB;
import org.autoplot.spase.VOTableReader;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DataSetOps;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class PDSPPIDataSource
extends AbstractDataSource {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.pdsppi");
    public static final int MAX_BUNDLE_COUNT = 12;

    PDSPPIDataSource(URI uri) {
        super(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        try {
            String luri;
            TimeSeriesBrowse tsb = this.getCapability(TimeSeriesBrowse.class);
            if (tsb != null && (luri = tsb.getURI()) != null) {
                URISplit split = URISplit.parse((String)luri);
                this.params = URISplit.parseParams((String)split.params);
            }
            String id = (String)this.getParams().get("id");
            String param = (String)this.getParams().get("param");
            if (param == null) {
                param = (String)this.getParams().get("ds");
            }
            if (id == null) {
                throw new IllegalArgumentException("id not specified");
            }
            if (param == null) {
                throw new IllegalArgumentException("ds not specified");
            }
            param = param.replaceAll("\\+", " ");
            String url = "https://pds-ppi.igpp.ucla.edu/ditdos/write?f=vo&id=pds://" + id;
            VOTableReader read = new VOTableReader();
            mon.setProgressMessage("downloading data");
            logger.log(Level.FINE, "getDataSet {0}", url);
            File f = DataSetURI.downloadResourceAsTempFile((URL)new URL(url), (int)3600, (ProgressMonitor)mon.getSubtaskMonitor("download file"));
            mon.setProgressMessage("reading data");
            String error = PDSPPIDB.getInstance().checkXML(f);
            if (error != null) {
                throw new NoDataInIntervalException(error);
            }
            QDataSet ds = read.readTable(f.toString(), mon.getSubtaskMonitor("read table"));
            if (ds.length() == 0) {
                throw new NoDataInIntervalException("result contains no records");
            }
            QDataSet result = DataSetOps.unbundle((QDataSet)ds, (String)param);
            if (result.property("DEPEND_0") == null) {
                QDataSet dep0check;
                Units tu;
                int i;
                QDataSet bds = (QDataSet)ds.property("BUNDLE_1");
                String n = (String)bds.property("DEPENDNAME_0", i = DataSetOps.indexOfBundledDataSet((QDataSet)ds, (String)param));
                if (n != null) {
                    result = Ops.link((QDataSet)DataSetOps.unbundle((QDataSet)ds, (String)n), (QDataSet)result);
                } else if (i > 0 && UnitsUtil.isTimeLocation((Units)(tu = SemanticOps.getUnits((QDataSet)(dep0check = DataSetOps.unbundle((QDataSet)ds, (int)(i - 1))))))) {
                    result = Ops.putProperty((QDataSet)result, (String)"DEPEND_0", (Object)dep0check);
                }
            }
            if (result.rank() > 1 && result.length(0) > 12) {
                result = Ops.putProperty((QDataSet)result, (String)"BUNDLE_1", null);
            }
            QDataSet ah = Ops.autoHistogram((QDataSet)result);
            Map up = (Map)ah.property("USER_PROPERTIES");
            Map outl = (Map)up.get("outliers");
            Integer outlierCount = (Integer)up.get("outlierCount");
            if (outlierCount > 10) {
                for (Map.Entry entry : outl.entrySet()) {
                    if ((Integer)entry.getValue() <= outlierCount * 8 / 10) continue;
                    logger.log(Level.FINE, "identified fill: {0}", entry.getKey());
                    ((MutablePropertyDataSet)result).putProperty("FILL_VALUE", entry.getKey());
                    break;
                }
            }
            QDataSet qDataSet = result;
            return qDataSet;
        }
        finally {
            mon.finished();
        }
    }

    public <T> T getCapability(Class<T> clazz) {
        return (T)super.getCapability(clazz);
    }
}

