/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.text.ParseException;
import org.autoplot.jythonsupport.JythonOps;
import org.autoplot.jythonsupport.PyQDataSet;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;

public class BinaryInfixOps {
    private static QDataSet enumerationUnitsCheck(QDataSet ds1, PyObject o2, QDataSet ds2) {
        if (ds1 == null) {
            return ds2;
        }
        Units u = SemanticOps.getUnits((QDataSet)ds1);
        if (u instanceof EnumerationUnits) {
            return JythonOps.dataset(o2, u);
        }
        return ds2;
    }

    private static QDataSet[] datasetCoerce(PyObject arg1, PyObject arg2) {
        QDataSet jarg2;
        QDataSet jarg1 = JythonOps.dataset(arg1);
        if (arg2 instanceof PyString) {
            try {
                jarg2 = Ops.dataset((Object)arg2);
            }
            catch (IllegalArgumentException ex) {
                Units u = SemanticOps.getUnits((QDataSet)jarg1);
                try {
                    if (u instanceof EnumerationUnits) {
                        jarg2 = Ops.dataset((Object)((EnumerationUnits)u).createDatum((Object)arg2.toString()));
                    }
                    jarg2 = Ops.dataset((Object)u.parse(arg2.toString()));
                }
                catch (ParseException ex1) {
                    throw new IllegalArgumentException("unable to interpret argument: " + arg2);
                }
            }
        } else {
            jarg2 = JythonOps.dataset(arg2);
        }
        jarg2 = BinaryInfixOps.enumerationUnitsCheck(jarg1, arg2, jarg2);
        jarg1 = BinaryInfixOps.enumerationUnitsCheck(jarg2, arg1, jarg1);
        return new QDataSet[]{jarg1, jarg2};
    }

    public static PyObject eq(PyObject arg1, PyObject arg2) {
        QDataSet[] jargs2 = BinaryInfixOps.datasetCoerce(arg1, arg2);
        QDataSet jarg1 = jargs2[0];
        QDataSet jarg2 = jargs2[1];
        if (jarg1 == null || jarg2 == null) {
            return new PyInteger(jarg1 == jarg2 ? 1 : 0);
        }
        QDataSet r = Ops.eq((QDataSet)jarg1, (QDataSet)jarg2);
        return BinaryInfixOps.mycast(r);
    }

    public static PyObject ne(PyObject arg1, PyObject arg2) {
        QDataSet[] jargs2 = BinaryInfixOps.datasetCoerce(arg1, arg2);
        QDataSet jarg1 = jargs2[0];
        QDataSet jarg2 = jargs2[1];
        if (jarg1 == null || jarg2 == null) {
            return new PyInteger(jarg1 != jarg2 ? 1 : 0);
        }
        QDataSet r = Ops.ne((QDataSet)jarg1, (QDataSet)jarg2);
        return BinaryInfixOps.mycast(r);
    }

    public static PyObject gt(PyObject arg1, PyObject arg2) {
        QDataSet r = Ops.gt((QDataSet)JythonOps.dataset(arg1), (QDataSet)JythonOps.dataset(arg2));
        return BinaryInfixOps.mycast(r);
    }

    public static PyObject ge(PyObject arg1, PyObject arg2) {
        QDataSet r = Ops.ge((QDataSet)JythonOps.dataset(arg1), (QDataSet)JythonOps.dataset(arg2));
        return BinaryInfixOps.mycast(r);
    }

    public static PyObject lt(PyObject arg1, PyObject arg2) {
        QDataSet r = Ops.lt((QDataSet)JythonOps.dataset(arg1), (QDataSet)JythonOps.dataset(arg2));
        return BinaryInfixOps.mycast(r);
    }

    public static PyObject le(PyObject arg1, PyObject arg2) {
        QDataSet r = Ops.le((QDataSet)JythonOps.dataset(arg1), (QDataSet)JythonOps.dataset(arg2));
        return BinaryInfixOps.mycast(r);
    }

    public static PyObject and(PyObject arg1, PyObject arg2) {
        QDataSet r = Ops.and((QDataSet)JythonOps.dataset(arg1), (QDataSet)JythonOps.dataset(arg2));
        return BinaryInfixOps.mycast(r);
    }

    public static PyObject or(PyObject arg1, PyObject arg2) {
        QDataSet r = Ops.or((QDataSet)JythonOps.dataset(arg1), (QDataSet)JythonOps.dataset(arg2));
        return BinaryInfixOps.mycast(r);
    }

    private static PyObject mycast(QDataSet r) {
        if (r.rank() == 0) {
            return new PyInteger(r.value() == 0.0 ? 0 : 1);
        }
        return new PyQDataSet(r);
    }
}

