/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.lang.reflect.Array;
import org.autoplot.jythonsupport.JythonOps;
import org.autoplot.jythonsupport.PyQDataSet;
import org.das2.datum.Units;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.SparseDataSet;
import org.das2.qds.ops.Ops;
import org.python.core.PyArray;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.adapter.PyObjectAdapter;

public class PyQDataSetAdapter
implements PyObjectAdapter {
    public boolean canAdapt(Object arg0) {
        return arg0 instanceof QDataSet;
    }

    public PyObject adapt(Object arg0) {
        return new PyQDataSet((QDataSet)arg0);
    }

    public static QDataSet adaptList(PyList p) {
        double[] j = new double[p.size()];
        JoinDataSet jds = null;
        Units u = null;
        Units[] us = new Units[p.size()];
        boolean isBundle = false;
        for (int i = 0; i < p.size(); ++i) {
            Units ud1;
            Object n = p.get(i);
            QDataSet d1 = n instanceof PyObject ? JythonOps.dataset((PyObject)n) : Ops.dataset((Object)n);
            if (u == null) {
                u = SemanticOps.getUnits((QDataSet)d1);
            }
            us[i] = ud1 = SemanticOps.getUnits((QDataSet)d1);
            if (ud1 != u) {
                if (u.isConvertibleTo(ud1)) {
                    d1 = Ops.convertUnitsTo((QDataSet)d1, (Units)u);
                } else {
                    isBundle = true;
                }
            }
            if (d1.rank() == 0) {
                j[i] = d1.value();
                continue;
            }
            if (jds == null) {
                jds = new JoinDataSet(d1);
                continue;
            }
            jds.join(d1);
        }
        if (jds == null) {
            DDataSet q = DDataSet.wrap((double[])j);
            if (isBundle) {
                SparseDataSet bds = SparseDataSet.createRankLen((int)2, (int)p.size());
                for (int i = 0; i < p.size(); ++i) {
                    bds.putProperty("UNITS", i, (Object)us[i]);
                    bds.putProperty("NAME", i, (Object)("ch" + i));
                }
                q.putProperty("BUNDLE_0", (Object)bds);
            } else {
                q.putProperty("UNITS", u);
            }
            return q;
        }
        jds.putProperty("UNITS", u);
        return jds;
    }

    protected static QDataSet adaptArray(PyArray pyArray) {
        Object arr = pyArray.getArray();
        double[] j = new double[pyArray.__len__()];
        JoinDataSet jds = null;
        Units u = null;
        for (int i = 0; i < pyArray.__len__(); ++i) {
            QDataSet d1;
            Object n = Array.get(arr, i);
            if (n instanceof PyObject) {
                d1 = JythonOps.dataset((PyObject)n);
            } else if (n.getClass().isArray()) {
                d1 = Ops.dataset((Object)n);
                if (jds == null) {
                    jds = new JoinDataSet(d1);
                } else {
                    jds.join(d1);
                }
            } else {
                d1 = Ops.dataset((Object)n);
            }
            if (u == null) {
                u = SemanticOps.getUnits((QDataSet)d1);
            }
            if (SemanticOps.getUnits((QDataSet)d1) != u) {
                d1 = Ops.convertUnitsTo((QDataSet)d1, (Units)u);
            }
            if (d1.rank() != 0) continue;
            j[i] = d1.value();
        }
        if (jds != null) {
            jds.putProperty("UNITS", u);
            jds.putProperty("JOIN_0", null);
            return ArrayDataSet.copy(jds);
        }
        DDataSet q = DDataSet.wrap((double[])j);
        q.putProperty("UNITS", u);
        return q;
    }

    public static QDataSet adaptTuple(PyTuple p) {
        double[] j = new double[p.size()];
        JoinDataSet jds = null;
        Units u = null;
        Units[] us = new Units[p.size()];
        boolean isBundle = false;
        for (int i = 0; i < p.size(); ++i) {
            Units ud1;
            Object n = p.get(i);
            QDataSet d1 = n instanceof PyObject ? JythonOps.dataset((PyObject)n) : Ops.dataset((Object)n);
            if (u == null) {
                u = SemanticOps.getUnits((QDataSet)d1);
            }
            us[i] = ud1 = SemanticOps.getUnits((QDataSet)d1);
            if (ud1 != u) {
                if (u.isConvertibleTo(ud1)) {
                    d1 = Ops.convertUnitsTo((QDataSet)d1, (Units)u);
                } else {
                    isBundle = true;
                }
            }
            if (d1.rank() == 0) {
                j[i] = d1.value();
                continue;
            }
            if (jds == null) {
                jds = new JoinDataSet(d1);
                continue;
            }
            jds.join(d1);
        }
        if (jds == null) {
            DDataSet q = DDataSet.wrap((double[])j);
            if (isBundle) {
                SparseDataSet bds = SparseDataSet.createRankLen((int)2, (int)p.size());
                for (int i = 0; i < p.size(); ++i) {
                    bds.putProperty("UNITS", i, (Object)us[i]);
                    bds.putProperty("NAME", i, (Object)("ch" + i));
                }
                q.putProperty("BUNDLE_0", (Object)bds);
            } else {
                q.putProperty("UNITS", u);
            }
            return q;
        }
        jds.putProperty("UNITS", u);
        return jds;
    }

    public static QDataSet adaptList(PyList p, Units u) {
        double[] j = new double[p.size()];
        JoinDataSet jds = null;
        for (int i = 0; i < p.size(); ++i) {
            Object n = p.get(i);
            QDataSet d1 = n instanceof PyObject ? JythonOps.dataset((PyObject)n, u) : Ops.dataset((Object)n, (Units)u);
            if (d1.rank() == 0) {
                j[i] = d1.value();
                continue;
            }
            if (jds == null) {
                jds = new JoinDataSet(d1);
                continue;
            }
            jds.join(d1);
        }
        if (jds == null) {
            DDataSet q = DDataSet.wrap((double[])j);
            q.putProperty("UNITS", (Object)u);
            return q;
        }
        jds.putProperty("UNITS", (Object)u);
        return jds;
    }

    public static QDataSet adaptTuple(PyTuple p, Units u) {
        double[] j = new double[p.size()];
        JoinDataSet jds = null;
        for (int i = 0; i < p.size(); ++i) {
            Object n = p.get(i);
            QDataSet d1 = n instanceof PyObject ? JythonOps.dataset((PyObject)n, u) : Ops.dataset((Object)n, (Units)u);
            if (d1.rank() == 0) {
                j[i] = d1.value();
                continue;
            }
            if (jds == null) {
                jds = new JoinDataSet(d1);
                continue;
            }
            jds.join(d1);
        }
        if (jds == null) {
            DDataSet q = DDataSet.wrap((double[])j);
            q.putProperty("UNITS", (Object)u);
            return q;
        }
        jds.putProperty("UNITS", (Object)u);
        return jds;
    }

    protected static QDataSet adaptArray(PyArray pyArray, Units u) {
        Object arr = pyArray.getArray();
        double[] j = new double[pyArray.__len__()];
        JoinDataSet jds = null;
        for (int i = 0; i < pyArray.__len__(); ++i) {
            QDataSet d1;
            Object n = Array.get(arr, i);
            if (n instanceof PyObject) {
                d1 = JythonOps.dataset((PyObject)n, u);
            } else if (n.getClass().isArray()) {
                d1 = Ops.dataset((Object)n, (Units)u);
                if (jds == null) {
                    jds = new JoinDataSet(d1);
                } else {
                    jds.join(d1);
                }
            } else {
                d1 = Ops.dataset((Object)n, (Units)u);
            }
            if (u == null) {
                u = SemanticOps.getUnits((QDataSet)d1);
            }
            if (d1.rank() != 0) continue;
            j[i] = d1.value();
        }
        if (jds != null) {
            jds.putProperty("UNITS", (Object)u);
            jds.putProperty("JOIN_0", null);
            return ArrayDataSet.copy(jds);
        }
        DDataSet q = DDataSet.wrap((double[])j);
        q.putProperty("UNITS", (Object)u);
        return q;
    }
}

