/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.DataSourceEditorPanelUtil;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.WindowManager;
import org.autoplot.jythonsupport.ui.DataMashUp;
import org.das2.datum.DatumRange;
import org.das2.qds.filters.FiltersChainPanel;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;

public class NamedURIListTool
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.mashup");
    private static final String CLASS_NAME = NamedURIListTool.class.getName();
    protected static final String PROP_URIS = "uris";
    protected static final String PROP_ID = "id";
    JScrollPane scrollPane = new JScrollPane();
    List<String> uris = null;
    List<String> ids = Collections.emptyList();
    List<Boolean> isAuto = null;
    DataMashUp dataMashUp;
    private DatumRange timeRange;
    public static final String PROP_TIMERANGE = "timeRange";
    private boolean showIds = true;
    public static final String PROP_SHOWIDS = "showIds";
    private String expression = "";

    public NamedURIListTool() {
        this.uris = Collections.emptyList();
        this.isAuto = Collections.emptyList();
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.scrollPane);
        this.refresh();
    }

    public final void refresh() {
        JPanel content = new JPanel();
        BoxLayout lo = new BoxLayout(content, 1);
        content.setLayout(lo);
        for (int i = 0; i < this.uris.size(); ++i) {
            content.add(this.onePanel(i));
        }
        content.add(this.onePanel(-1));
        this.scrollPane.setViewportView(content);
    }

    public String[] getUris() {
        assert (this.ids.size() == this.uris.size());
        return this.uris.toArray(new String[this.uris.size()]);
    }

    public String[] getIds() {
        assert (this.ids.size() == this.uris.size());
        return this.ids.toArray(new String[this.ids.size()]);
    }

    public String getUriForId(String name) {
        String suri = null;
        for (int i = 0; i < this.ids.size(); ++i) {
            if (!this.ids.get(i).equals(name)) continue;
            suri = this.uris.get(i);
        }
        if (suri != null) {
            if (this.timeRange != null) {
                String stimeRange = this.timeRange.toString().replaceAll("\\ ", "+");
                suri = "vap+inline:getDataSet('" + suri + "','" + stimeRange + "')";
            }
            return suri;
        }
        return null;
    }

    public void setDataMashUp(DataMashUp dmu) {
        this.dataMashUp = dmu;
    }

    public String makeupName(List<String> names) {
        int max = 0;
        for (String n : names) {
            if (!n.startsWith("ds")) continue;
            try {
                int j = Integer.parseInt(n.substring(2));
                max = Math.max(max, j);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return "ds" + (max + 1);
    }

    private void bindTimeRange(DataSetSelector dss) {
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)BeanProperty.create((String)PROP_TIMERANGE), (Object)dss, (Property)BeanProperty.create((String)PROP_TIMERANGE));
        binding.bind();
    }

    public DatumRange getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(DatumRange timeRange) {
        DatumRange oldTimeRange = this.timeRange;
        this.timeRange = timeRange;
        this.firePropertyChange(PROP_TIMERANGE, oldTimeRange, timeRange);
    }

    public boolean isShowIds() {
        return this.showIds;
    }

    public void setShowIds(boolean showIds) {
        boolean oldShowIds = this.showIds;
        this.showIds = showIds;
        this.firePropertyChange(PROP_SHOWIDS, oldShowIds, showIds);
    }

    private JPanel onePanel(final int fi) {
        JButton subAdd;
        logger.entering(CLASS_NAME, "onePanel", fi);
        final JPanel sub = new JPanel(new BorderLayout());
        sub.setName("sub" + fi);
        Dimension limit = new Dimension(100, 24);
        if (!this.showIds) {
            limit = new Dimension(24, 24);
        }
        Dimension dim = new Dimension(24, 24);
        if (fi >= 0) {
            if (this.showIds) {
                JButton name = new JButton(this.ids.get(fi) + "=");
                name.setMaximumSize(limit);
                name.setPreferredSize(limit);
                name.setToolTipText("press to rename ");
                name.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent((ActionEvent)e);
                        String oldName = NamedURIListTool.this.ids.get(fi);
                        NamedURIListTool.this.renameAndEdit(fi);
                        String newName = NamedURIListTool.this.ids.get(fi);
                        NamedURIListTool.this.firePropertyChange("idName_" + fi, oldName, newName);
                    }
                });
                sub.add((Component)name, "West");
            } else {
                subAdd = new JButton(new ImageIcon(FiltersChainPanel.class.getResource("/resources/add.png")));
                subAdd.setMaximumSize(limit);
                subAdd.setPreferredSize(limit);
                subAdd.setToolTipText("add new URI");
                subAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent((ActionEvent)e);
                        ArrayList<String> ids = new ArrayList<String>(NamedURIListTool.this.ids);
                        ArrayList<String> uris = new ArrayList<String>(NamedURIListTool.this.uris);
                        String newName = NamedURIListTool.this.makeupName(ids);
                        ids.add(fi, newName);
                        uris.add(fi, "");
                        NamedURIListTool.this.setIds(ids);
                        NamedURIListTool.this.setUris(uris);
                    }
                });
                sub.add((Component)subAdd, "West");
            }
        } else {
            subAdd = new JButton(new ImageIcon(FiltersChainPanel.class.getResource("/resources/add.png")));
            subAdd.setMaximumSize(limit);
            subAdd.setPreferredSize(limit);
            subAdd.setToolTipText("add new URI");
            subAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    ArrayList<String> ids = new ArrayList<String>(NamedURIListTool.this.ids);
                    ArrayList<String> uris = new ArrayList<String>(NamedURIListTool.this.uris);
                    ArrayList<Boolean> isAuto = new ArrayList<Boolean>(NamedURIListTool.this.isAuto);
                    String newName = NamedURIListTool.this.makeupName(ids);
                    ids.add(newName);
                    uris.add("");
                    isAuto.add(true);
                    NamedURIListTool.this.setIds(ids);
                    NamedURIListTool.this.setUris(uris);
                    NamedURIListTool.this.setIsAuto(isAuto);
                }
            });
            sub.add((Component)subAdd, "West");
        }
        if (fi >= 0) {
            JButton subDelete = new JButton(new ImageIcon(FiltersChainPanel.class.getResource("/resources/subtract.png")));
            subDelete.setMaximumSize(limit);
            subDelete.setPreferredSize(dim);
            subDelete.setToolTipText("remove uri ");
            final int ffi = fi;
            subDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Container parent = sub.getParent();
                    parent.remove(sub);
                    parent.validate();
                    NamedURIListTool.this.uris.remove(ffi);
                    NamedURIListTool.this.ids.remove(ffi);
                    NamedURIListTool.this.isAuto.remove(ffi);
                    NamedURIListTool.this.refresh();
                }
            });
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            p.add(Box.createHorizontalStrut(11));
            p.add(subDelete);
            sub.add((Component)p, "East");
        }
        if (fi >= 0) {
            final DataSetSelector dss = new DataSetSelector();
            dss.setPlotItButtonVisible(false);
            dss.setPlayButton(false);
            dss.setValue(this.uris.get(fi));
            this.bindTimeRange(dss);
            try {
                List recent = DataSetSelector.getDefaultRecent();
                ArrayList<String> recentSansInline = new ArrayList<String>();
                for (String s : recent) {
                    if (s.startsWith("vap+inline:") && s.contains("getDataSet")) {
                        logger.log(Level.FINEST, "skipping {0}", s);
                        continue;
                    }
                    URISplit split = URISplit.parse((String)s);
                    if (".jy".equals(split.ext)) {
                        logger.log(Level.FINEST, "skipping {0}", s);
                        continue;
                    }
                    if (".vap".equals(split.ext)) continue;
                    recentSansInline.add(s);
                }
                recentSansInline.addAll(this.uris);
                LinkedHashSet<String> nuris = new LinkedHashSet<String>();
                nuris.addAll(recentSansInline);
                dss.setRecent(new ArrayList(nuris));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            dss.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newName = null;
                    String currentName = null;
                    if (NamedURIListTool.this.isAuto.get(fi).booleanValue() || NamedURIListTool.this.uris.get(fi).trim().length() == 0) {
                        ArrayList<String> nids = new ArrayList<String>(NamedURIListTool.this.ids);
                        ArrayList<String> nuris = new ArrayList<String>(NamedURIListTool.this.uris);
                        nids.remove(fi);
                        nuris.remove(fi);
                        newName = DataSourceUtil.guessNameFor((String)dss.getValue(), nuris, nids);
                        if (NamedURIListTool.this.isValidIdentifier(newName)) {
                            currentName = NamedURIListTool.this.ids.get(fi);
                        }
                    }
                    String uri = dss.getValue();
                    String uri2 = DataSetURI.blurTsbUri((String)uri);
                    NamedURIListTool.this.uris.set(fi, uri2);
                    if (!uri.equals(uri2)) {
                        dss.setValue(uri2);
                    }
                    if (NamedURIListTool.this.dataMashUp != null) {
                        NamedURIListTool.this.dataMashUp.refresh();
                    }
                    if (currentName != null && newName != null) {
                        NamedURIListTool.this.doVariableRename(fi, currentName, newName);
                    }
                }
            });
            dss.getEditor().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    NamedURIListTool.this.uris.set(fi, dss.getValue());
                    if (NamedURIListTool.this.dataMashUp != null) {
                        NamedURIListTool.this.dataMashUp.refresh();
                    }
                }
            });
            sub.add((Component)dss, "Center");
        } else {
            JLabel tf = new JLabel();
            tf.setText("<html><i>&nbsp;(click to add)</i></html>");
            sub.add((Component)tf, "Center");
        }
        Dimension maximumSize = sub.getPreferredSize();
        maximumSize.width = Integer.MAX_VALUE;
        sub.setMaximumSize(maximumSize);
        return sub;
    }

    private void doVariableRename(int fi, String oldName, String newName) {
        this.ids.set(fi, newName);
        this.refresh();
        if (this.dataMashUp != null) {
            this.dataMashUp.rename(oldName, newName);
        }
    }

    private boolean isValidIdentifier(String n) {
        boolean s = n.length() > 0 && Character.isJavaIdentifierStart(n.charAt(0));
        for (int i = 1; s && i < n.length(); ++i) {
            s = s && Character.isJavaIdentifierPart(n.charAt(i));
        }
        return s;
    }

    private void renameAndEdit(int fi) {
        String title;
        String currentName = this.ids.get(fi);
        boolean autoName = this.isAuto.get(fi);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        final JCheckBox cb = new JCheckBox("Manually set parameter name (a name with no spaces, made of letters, numbers and underscores):");
        cb.setToolTipText("checked indicates variable name will be picked automatically");
        cb.setSelected(!autoName);
        p.add(cb);
        int em = p.getFont().getSize();
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        final JTextField tf = new JTextField(currentName);
        tf.setMaximumSize(new Dimension(em * 50, em * 2));
        tf.setPreferredSize(new Dimension(em * 50, em * 2));
        tf.setEnabled(cb.isSelected());
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tf.setEnabled(cb.isSelected());
            }
        });
        p1.add(tf);
        p1.add(Box.createGlue());
        p1.setAlignmentX(0.0f);
        p.add(p1);
        p.add(Box.createVerticalStrut(em));
        p.add(Box.createGlue());
        DataSourceEditorPanel edit = null;
        try {
            String uri = this.uris.get(fi);
            edit = DataSourceEditorPanelUtil.getDataSourceEditorPanel((JPanel)p, (String)uri);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.SEVERE, "can't get editor for #{0}", fi);
        }
        String string = title = edit != null ? "Rename parameter and dataset editor" : "Rename parameter";
        while (0 == WindowManager.showConfirmDialog((Component)this.scrollPane, (Object)p, (String)title, (int)2)) {
            String newName = tf.getText();
            if (!cb.isSelected() && edit != null) {
                ArrayList<String> nids = new ArrayList<String>(this.ids);
                ArrayList<String> nuris = new ArrayList<String>(this.uris);
                nids.remove(fi);
                nuris.remove(fi);
                newName = DataSourceUtil.guessNameFor((String)edit.getURI(), nuris, nids);
            }
            if (!this.isValidIdentifier(newName)) continue;
            if (!currentName.equals(newName)) {
                this.doVariableRename(fi, currentName, newName);
            }
            this.isAuto.set(fi, !cb.isSelected());
            if (edit != null) {
                String uri = edit.getURI();
                uri = DataSetURI.blurTsbUri((String)uri);
                this.uris.set(fi, uri);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NamedURIListTool.this.refresh();
                }
            });
            break;
        }
    }

    public void setIds(List<String> ids) {
        this.ids = new ArrayList<String>(ids);
        if (this.uris.size() == ids.size()) {
            this.refresh();
        }
    }

    public void setUris(List<String> uris) {
        this.uris = new ArrayList<String>(uris);
        if (uris.size() == this.ids.size()) {
            this.refresh();
        }
    }

    public void setIsAuto(List<Boolean> isAuto) {
        this.isAuto = new ArrayList<Boolean>(isAuto);
        if (isAuto.size() == this.ids.size()) {
            this.refresh();
        }
    }

    protected String getAsJython() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.uris.size(); ++i) {
            b.append(this.ids.get(i)).append("=").append("getDataSet('").append(this.uris.get(i)).append("')\n");
        }
        return b.toString();
    }

    protected String getAsJythonInline() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.uris.size(); ++i) {
            String uri = this.uris.get(i);
            if (uri.trim().length() <= 0) continue;
            String s = this.uris.get(i);
            if (s.contains("'")) {
                logger.info("removing single quotes from URI, hope that doesn't break anything.");
                b.append(this.ids.get(i)).append("=").append("getDataSet('").append(s.replaceAll("'", "")).append("')&");
                continue;
            }
            b.append(this.ids.get(i)).append("=").append("getDataSet('").append(s).append("')&");
        }
        return b.toString();
    }

    public String selectDataId(String id) {
        JCheckBox cb;
        int i;
        JPanel dsSelector1 = new JPanel();
        JPanel dsSelector = new JPanel();
        dsSelector1.add(new JScrollPane(dsSelector, 22, 32));
        dsSelector1.setPreferredSize(new Dimension(600, 500));
        dsSelector1.setMaximumSize(new Dimension(600, 500));
        dsSelector.setLayout(new BoxLayout(dsSelector, 1));
        ButtonGroup bg = new ButtonGroup();
        JCheckBox[] butts = new JCheckBox[this.uris.size() + 2];
        GridBagLayout layout = new GridBagLayout();
        dsSelector.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weighty = 0.0;
        for (i = 0; i < this.uris.size(); ++i) {
            cb = new JCheckBox(this.ids.get(i));
            if (this.ids.get(i).equals(id)) {
                cb.setSelected(true);
            }
            butts[i] = cb;
            c.gridy = i;
            c.gridx = 1;
            c.weightx = 0.0;
            dsSelector.add((Component)cb, c);
            JLabel label = new JLabel(this.uris.get(i));
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    cb.setSelected(true);
                }
            });
            c.gridx = 2;
            c.weightx = 1.0;
            dsSelector.add((Component)label, c);
            bg.add(cb);
        }
        cb = new JCheckBox("Literal: ");
        int ilit = i++;
        butts[ilit] = cb;
        cb.setToolTipText("enter a literal like 0.0");
        c.gridy = this.uris.size();
        c.gridx = 1;
        c.weightx = 0.0;
        dsSelector.add((Component)cb, c);
        bg.add(cb);
        final JTextField literalTF = new JTextField("0.0");
        literalTF.setMinimumSize(new Dimension(120, literalTF.getFont().getSize() * 2));
        literalTF.setPreferredSize(new Dimension(120, literalTF.getFont().getSize() * 2));
        c.gridx = 2;
        c.weightx = 1.0;
        literalTF.addFocusListener(new FocusListener(){
            String orig = null;

            @Override
            public void focusGained(FocusEvent e) {
                this.orig = literalTF.getText();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!literalTF.getText().equals(this.orig)) {
                    cb.setSelected(true);
                }
            }
        });
        literalTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                cb.setSelected(true);
            }
        });
        dsSelector.add((Component)literalTF, c);
        final JCheckBox cb2 = new JCheckBox("Expression: ");
        int iexpr = i++;
        butts[iexpr] = cb2;
        cb2.setToolTipText("enter an expression");
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 0.0;
        dsSelector.add((Component)cb2, c);
        bg.add(cb2);
        final JTextField exprTF = new JTextField(this.expression);
        exprTF.setMinimumSize(new Dimension(600, exprTF.getFont().getSize() * 2));
        exprTF.setMaximumSize(new Dimension(600, exprTF.getFont().getSize() * 2));
        exprTF.setPreferredSize(new Dimension(600, exprTF.getFont().getSize() * 2));
        c.gridx = 2;
        c.weightx = 1.0;
        exprTF.addFocusListener(new FocusListener(){
            String orig = null;

            @Override
            public void focusGained(FocusEvent e) {
                this.orig = exprTF.getText();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!exprTF.getText().equals(this.orig)) {
                    cb2.setSelected(true);
                }
            }
        });
        if (!this.isValidIdentifier(id)) {
            if (id.startsWith("'") || id.startsWith("\"")) {
                literalTF.setText(id);
                butts[ilit].setSelected(true);
            } else {
                try {
                    Double.parseDouble(id);
                    if (id.length() < 20) {
                        id = String.format("%s", id);
                    }
                    literalTF.setText(id);
                    butts[ilit].setSelected(true);
                }
                catch (NumberFormatException ex) {
                    exprTF.setText(id);
                    butts[iexpr].setSelected(true);
                }
            }
        } else if (id.equals("None")) {
            literalTF.setText(id);
            butts[ilit].setSelected(true);
        }
        dsSelector.add((Component)exprTF, c);
        JPanel p = new JPanel();
        ++c.gridy;
        c.weighty = 1.0;
        dsSelector.add((Component)p, c);
        bg.add(cb);
        if (0 == WindowManager.showConfirmDialog((Component)this, (Object)dsSelector, (String)"Select Variable", (int)2)) {
            for (i = 0; i < this.uris.size(); ++i) {
                if (!butts[i].isSelected()) continue;
                return this.ids.get(i);
            }
            if (butts[this.uris.size()].isSelected()) {
                return literalTF.getText().trim();
            }
            if (butts[this.uris.size() + 1].isSelected()) {
                return exprTF.getText().trim();
            }
            return null;
        }
        return null;
    }

    void setExpression(String expr) {
        this.expression = expr;
    }
}

