/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.NonWritableChannelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteWiseFileAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByteWiseFileAccessor.class);
    private int recordLength;
    private ByteBuffer buffer = null;
    private long fileContentSize;
    private static final int MAPPING_SIZE = 0x40000000;
    private final List<ByteBuffer> mappings = new ArrayList<ByteBuffer>();
    private long curPosition = 0L;
    private long curListIndex = 0L;
    private long totalBytesRead = 0L;

    public ByteWiseFileAccessor(File file, long offset, int length, int records) throws FileNotFoundException, IOException {
        this(file.toURI().toURL(), offset, length, records);
    }

    public ByteWiseFileAccessor(URL url, long offset, int length, int records) throws FileNotFoundException, IOException {
        this(url, offset, length, records, true);
    }

    public ByteWiseFileAccessor(URL url, long offset, int length, int records, boolean checkSize) throws FileNotFoundException, IOException {
        this.recordLength = length;
        long lsize = (long)length * (long)records;
        this.totalBytesRead = 0L;
        int bytesRead = 0;
        try {
            File dataFile = new File(url.toURI());
            RandomAccessFile raf = new RandomAccessFile(dataFile, "r");
            FileChannel inChannel = raf.getChannel();
            long fileSize = this.fileContentSize = inChannel.size();
            long sizeToRead = lsize;
            if (sizeToRead > fileSize - offset) {
                sizeToRead = fileSize - offset;
            }
            long tmpSize = sizeToRead;
            for (long offset2 = 0L; offset2 < sizeToRead; offset2 += 0x40000000L) {
                long size2 = Math.min(tmpSize, 0x40000000L);
                this.mappings.add(inChannel.map(FileChannel.MapMode.READ_ONLY, offset2 + offset, size2));
                tmpSize -= size2;
                LOGGER.debug("ByteWiseFileAccessor: mappings.add: offset2,offset {},{}", (Object)offset2, (Object)offset);
                LOGGER.debug("ByteWiseFileAccessor: mappings.add: size2,mappings.size {},{}", (Object)size2, (Object)this.mappings.size());
            }
            raf.close();
            for (int i = 0; i < this.mappings.size(); ++i) {
                bytesRead = this.mappings.get(i).capacity();
                this.totalBytesRead += (long)bytesRead;
                LOGGER.debug("ByteWiseFileAccessor: i,bytesRead,totalBytesRead " + Integer.toString(i) + "," + Long.toString(bytesRead) + "," + Long.toString(this.totalBytesRead));
            }
            this.curPosition = 0L;
            if (checkSize && this.totalBytesRead < lsize) {
                throw new IllegalArgumentException("Expected to read in " + lsize + " bytes but only " + this.totalBytesRead + " bytes were read for " + url.toString());
            }
            LOGGER.debug("ByteWiseFileAccessor: url {}", (Object)url);
            LOGGER.debug("ByteWiseFileAccessor: fileSize,sizeToRead {},{}", (Object)url, (Object)sizeToRead);
            LOGGER.debug("ByteWiseFileAccessor: totalBytesRead {}", (Object)this.totalBytesRead);
            LOGGER.debug("ByteWiseFileAccessor: mappings.size() {}", (Object)this.mappings.size());
        }
        catch (NonWritableChannelException dataFile) {
        }
        catch (FileNotFoundException ex) {
            LOGGER.error("The file '" + url.toString() + "' is not found. ", (Throwable)ex);
            throw ex;
        }
        catch (IOException ex) {
            LOGGER.error("I/O error.", (Throwable)ex);
            throw ex;
        }
        catch (URISyntaxException ex) {
            LOGGER.error("URI Syntax Error.", (Throwable)ex);
        }
    }

    public ByteWiseFileAccessor(URL url, long offset, int length) throws IOException {
        this.recordLength = length;
        int bytesRead = 0;
        this.totalBytesRead = 0L;
        try {
            long size;
            File dataFile = new File(url.toURI());
            RandomAccessFile raf = new RandomAccessFile(dataFile, "r");
            FileChannel inChannel = raf.getChannel();
            long fileSize = this.fileContentSize = inChannel.size();
            long tmpSize = size = fileSize - offset;
            for (long offset2 = 0L; offset2 < size; offset2 += 0x40000000L) {
                long size2 = Math.min(tmpSize, 0x40000000L);
                this.mappings.add(inChannel.map(FileChannel.MapMode.READ_ONLY, offset2 + offset, size2));
                tmpSize -= size2;
            }
            raf.close();
            for (int i = 0; i < this.mappings.size(); ++i) {
                bytesRead = this.mappings.get(i).capacity();
                this.totalBytesRead += (long)bytesRead;
            }
            this.curPosition = 0L;
        }
        catch (NonWritableChannelException dataFile) {
        }
        catch (IOException ex) {
            LOGGER.error("I/O error.", (Throwable)ex);
            throw ex;
        }
        catch (URISyntaxException ex) {
            LOGGER.error("URI Syntax Error.", (Throwable)ex);
        }
    }

    private byte[] handleTooSmallMapping(int recordNum, int offset, int length, ByteBuffer aBuf, int mapN, int offN, long fileOffset, byte[] buf) {
        LOGGER.debug("handleTooSmallBuffer:recordNum,buf.length {},{}", (Object)recordNum, (Object)buf.length);
        LOGGER.debug("handleTooSmallBuffer: aBuf.remaining(),aBuf.hasRemaining() {},{}", (Object)aBuf.remaining(), (Object)aBuf.hasRemaining());
        LOGGER.debug("handleTooSmallBuffer: aBuf.isDirect() {}", (Object)aBuf.isDirect());
        LOGGER.debug("handleTooSmallBuffer: length,fileOffset {},{}", (Object)length, (Object)fileOffset);
        LOGGER.debug("handleTooSmallBuffer: mapN,offN {},{}", (Object)mapN, (Object)offN);
        LOGGER.debug("handleTooSmallBuffer: this.recordLength {}", (Object)this.recordLength);
        LOGGER.debug("handleTooSmallBuffer:Record number " + Integer.toString(recordNum) + " spanning over two mappings.  Will perform an extra read.");
        LOGGER.info("Record number " + Integer.toString(recordNum) + " spanning over two mappings.  Will perform an extra read.");
        if (mapN + 1 >= this.mappings.size()) {
            LOGGER.error("Expecting another mapping of file content while reading record " + Integer.toString(recordNum));
            return buf;
        }
        byte[] bufPortion1 = new byte[aBuf.remaining()];
        aBuf.get(bufPortion1);
        aBuf = this.mappings.get(mapN + 1);
        aBuf.position(0);
        byte[] bufPortion2 = new byte[this.recordLength - bufPortion1.length];
        aBuf.get(bufPortion2);
        LOGGER.debug("handleTooSmallBuffer:bufPortion1 {}", (Object)bufPortion1);
        LOGGER.debug("handleTooSmallBuffer:bufPortion2 {}", (Object)bufPortion2);
        LOGGER.debug("handleTooSmallBuffer:bufPortion1 + bufPortion2 {}{}", (Object)new String(bufPortion1), (Object)new String(bufPortion2));
        LOGGER.debug("handleTooSmallBuffer: bufPortion1.length,bufPortion2.length {},{}", (Object)bufPortion1.length, (Object)bufPortion2.length);
        LOGGER.debug("handleTooSmallBuffer: this.recordLength {}", (Object)this.recordLength);
        System.arraycopy(bufPortion1, 0, buf, 0, bufPortion1.length);
        System.arraycopy(bufPortion2, 0, buf, bufPortion1.length, bufPortion2.length);
        LOGGER.debug("handleTooSmallBuffer: buf [{}]", (Object)new String(buf));
        LOGGER.debug("handleTooSmallBuffer: buf.length [{}]", (Object)buf.length);
        return buf;
    }

    public byte[] readRecordBytes(int recordNum, int offset, int length) {
        assert (recordNum > 0);
        long fileOffset = (long)(recordNum - 1) * (long)this.recordLength;
        byte[] buf = new byte[this.recordLength];
        int mapN = (int)(fileOffset / 0x40000000L);
        int offN = (int)(fileOffset % 0x40000000L);
        if (fileOffset < 0L || mapN < 0) {
            LOGGER.error("Negative fileOffset or index of mappings list.");
            return null;
        }
        ByteBuffer aBuf = this.mappings.get(mapN);
        aBuf.position(offN);
        LOGGER.debug("readRecordBytes:recordNum,offset {},{}", (Object)recordNum, (Object)offset);
        LOGGER.debug("readRecordBytes:recordNum,length {},{}", (Object)recordNum, (Object)length);
        LOGGER.debug("readRecordBytes:aBuf.remaining(),buf.length {},{}", (Object)aBuf.remaining(), (Object)buf.length);
        if (aBuf.remaining() >= buf.length) {
            aBuf.get(buf);
        } else {
            buf = this.handleTooSmallMapping(recordNum, offset, length, aBuf, mapN, offN, fileOffset, buf);
        }
        byte[] bytesToReturn = Arrays.copyOfRange(buf, offset, offset + length);
        LOGGER.debug("readRecordBytes:recordNum,buf.length {},{}", (Object)recordNum, (Object)buf.length);
        LOGGER.debug("readRecordBytes: aBuf.remaining(),aBuf.hasRemaining() {},{}", (Object)aBuf.remaining(), (Object)aBuf.hasRemaining());
        LOGGER.debug("readRecordBytes: aBuf.isDirect() {}", (Object)aBuf.isDirect());
        LOGGER.debug("readRecordBytes: length,fileOffset {},{}", (Object)length, (Object)fileOffset);
        LOGGER.debug("readRecordBytes: mapN,offN {},{}", (Object)mapN, (Object)offN);
        LOGGER.debug("readRecordBytes: this.recordLength {}", (Object)this.recordLength);
        LOGGER.debug("readRecordBytes: bytesToReturn.length {}", (Object)bytesToReturn.length);
        LOGGER.debug("readRecordBytes: bytesToReturn {}", (Object)new String(bytesToReturn));
        return bytesToReturn;
    }

    public byte readByte() {
        int mapN = (int)(this.curPosition / 0x40000000L);
        int offN = (int)(this.curPosition % 0x40000000L);
        ++this.curPosition;
        return this.mappings.get(mapN).get(offN);
    }

    public void mark() {
        int mapN = (int)(this.curPosition / 0x40000000L);
        this.mappings.get(mapN).mark();
    }

    public void reset() {
        for (int i = 0; i < this.mappings.size(); ++i) {
            this.mappings.get(i).reset();
        }
    }

    public boolean hasRemaining() {
        return this.totalBytesRead - this.curPosition != 0L;
    }

    public long getCurrentPosition() {
        return this.curPosition;
    }

    public long getFileContentSize() {
        return this.fileContentSize;
    }
}

