/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess;

import com.google.common.primitives.UnsignedLong;
import com.sun.media.jai.codec.MemoryCacheSeekableStream;
import gov.nasa.arc.pds.xml.generated.Array3DImage;
import gov.nasa.arc.pds.xml.generated.AxisArray;
import gov.nasa.arc.pds.xml.generated.DisplaySettings;
import gov.nasa.arc.pds.xml.generated.FileAreaObservational;
import gov.nasa.pds.label.DisplayDirection;
import gov.nasa.pds.objectAccess.DataType;
import gov.nasa.pds.objectAccess.Exporter;
import gov.nasa.pds.objectAccess.ImageExporter;
import gov.nasa.pds.objectAccess.ObjectProvider;
import gov.nasa.pds.objectAccess.VicarSystemLabelGenerator;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import jpl.mipl.io.plugins.DOMtoPDSlabel;
import jpl.mipl.io.plugins.ImageToPDS_DOM;
import jpl.mipl.io.vicar.AlreadyOpenException;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.ImageHDU;
import nom.tam.util.BufferedDataOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreeDImageExporter
extends ImageExporter
implements Exporter<Array3DImage> {
    Logger logger = LoggerFactory.getLogger(ThreeDImageExporter.class);
    private DataType.NumericDataType rawDataType;
    private int targetPixelBitDepth = 8;
    private int targetLevels = (int)Math.pow(2.0, this.targetPixelBitDepth);
    private IndexColorModel colorModel;
    private BufferedImage bufferedImage;
    private int imageType = 13;
    private boolean maximizeDynamicRange = true;
    private String exportType = "PNG";
    private Array3DImage pdsImage;
    private boolean lineDirectionDown = true;
    private boolean sampleDirectionRight = true;
    private boolean firstIndexFastest = false;
    private double scalingFactor = 1.0;
    private double valueOffset = 0.0;
    private double dataMin = Double.NEGATIVE_INFINITY;
    private double dataMax = Double.POSITIVE_INFINITY;
    WritableRaster fitRaster_R;
    WritableRaster fitRaster_G;
    WritableRaster fitRaster_B;

    ThreeDImageExporter(FileAreaObservational fileArea, ObjectProvider provider) throws IOException {
        super(fileArea, provider);
    }

    ThreeDImageExporter(File label, int fileAreaIndex) throws Exception {
        this(label.toURI().toURL(), fileAreaIndex);
    }

    ThreeDImageExporter(URL label, int fileAreaIndex) throws Exception {
        super(label, fileAreaIndex);
    }

    private void setImageType() {
        switch (this.targetPixelBitDepth) {
            case 8: {
                this.imageType = 13;
                break;
            }
            case 16: {
                this.imageType = 11;
            }
        }
    }

    @Override
    public void convert(OutputStream outputStream, int objectIndex) throws IOException {
        List<Array3DImage> imageList = this.getObjectProvider().getArray3DImages(this.getObservationalFileArea());
        this.setArray3DImage(imageList.get(objectIndex));
        this.convert(this.getArray3DImage(), outputStream);
    }

    @Override
    public void convert(Array3DImage array3DImage, OutputStream outputStream) throws IOException {
        this.setArray3DImage(array3DImage);
        int lines = 0;
        int samples = 0;
        int bands = 1;
        if (array3DImage.getAxes() == 3) {
            for (AxisArray axis : array3DImage.getAxisArraies()) {
                if (axis.getSequenceNumber() == 3) {
                    samples = axis.getElements().intValueExact();
                    continue;
                }
                if (axis.getSequenceNumber() == 2) {
                    lines = axis.getElements().intValueExact();
                    continue;
                }
                bands = axis.getElements().intValueExact();
            }
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new URL(this.getObjectProvider().getRoot(), this.getObservationalFileArea().getFile().getFileName()).openStream());
        bufferedInputStream.skip(array3DImage.getOffset().getValue().longValueExact());
        int scanline_stride = samples;
        int[] band_offsets = new int[bands];
        int[] bank_indices = new int[bands];
        for (int i = 0; i < bands; ++i) {
            band_offsets[i] = 0;
            bank_indices[i] = i;
        }
        int dataBufferType = 4;
        BandedSampleModel sampleModel = new BandedSampleModel(dataBufferType, samples, lines, scanline_stride, bank_indices, band_offsets);
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)sampleModel);
        ImageTypeSpecifier imageType = new ImageTypeSpecifier(colorModel, sampleModel);
        this.bufferedImage = imageType.createBufferedImage(samples, lines);
        this.flexReadToRaster(bufferedInputStream, this.bufferedImage, lines, samples, bands);
        this.bufferedImage = this.scaleImage(this.bufferedImage);
        this.bufferedImage = this.toDisplayableImage(this.bufferedImage);
        if (this.exportType.equals("VICAR") || this.exportType.equalsIgnoreCase("PDS3")) {
            try {
                this.writeLabel(outputStream, this.getExportType());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.writeRasterImage(outputStream, this.bufferedImage);
        outputStream.close();
    }

    private BufferedImage scaleImage(BufferedImage bufferedImage) {
        double minValue = this.dataMin;
        double maxValue = this.dataMax;
        if (minValue == Double.NEGATIVE_INFINITY || maxValue == Double.POSITIVE_INFINITY) {
            ParameterBlock pbMaxMin = new ParameterBlock();
            pbMaxMin.addSource(bufferedImage);
            RenderedOp extrema = JAI.create((String)"extrema", (ParameterBlock)pbMaxMin);
            double[] allMins = (double[])extrema.getProperty("minimum");
            double[] allMaxs = (double[])extrema.getProperty("maximum");
            if (minValue == Double.NEGATIVE_INFINITY) {
                minValue = allMins[0];
            }
            if (maxValue == Double.POSITIVE_INFINITY) {
                maxValue = allMaxs[0];
            }
            for (int v = 1; v < allMins.length; ++v) {
                if (allMins[v] < minValue) {
                    minValue = allMins[v];
                }
                if (!(allMaxs[v] > maxValue)) continue;
                maxValue = allMaxs[v];
            }
        }
        double[] subtractThis = new double[]{minValue};
        double[] multiplyBy = new double[]{255.0 / (maxValue - minValue)};
        PlanarImage planarImage = PlanarImage.wrapRenderedImage((RenderedImage)bufferedImage);
        ParameterBlock pbSub = new ParameterBlock();
        pbSub.addSource(planarImage);
        pbSub.add(subtractThis);
        planarImage = JAI.create((String)"subtractconst", (ParameterBlock)pbSub, null);
        ParameterBlock pbMult = new ParameterBlock();
        pbMult.addSource(planarImage);
        pbMult.add(multiplyBy);
        planarImage = JAI.create((String)"multiplyconst", (ParameterBlock)pbMult, null);
        return planarImage.getAsBufferedImage();
    }

    private BufferedImage toDisplayableImage(BufferedImage bufferedImage) {
        ParameterBlock pbConvert = new ParameterBlock();
        pbConvert.addSource(bufferedImage);
        pbConvert.add(0);
        RenderedOp planarImage = JAI.create((String)"format", (ParameterBlock)pbConvert);
        return planarImage.getAsBufferedImage();
    }

    private void setImageElementsDataType(Array3DImage array3dImage) {
        try {
            this.rawDataType = Enum.valueOf(DataType.NumericDataType.class, array3dImage.getElementArray().getDataType());
        }
        catch (Exception e) {
            this.logger.error("Array data type is not valid, null, or unsupported", (Throwable)e);
            throw new IllegalArgumentException("Array data type is not valid, null, or unsupported");
        }
    }

    private void setImageStatistics(Array3DImage array3dImage) {
        if (array3dImage.getLocalIdentifier() != null) {
            DisplaySettings ds = this.getDisplaySettings(array3dImage.getLocalIdentifier());
            if (ds != null) {
                DisplayDirection lineDir = null;
                try {
                    lineDir = DisplayDirection.getDirectionFromValue(ds.getDisplayDirection().getVerticalDisplayDirection());
                    if (lineDir.equals((Object)DisplayDirection.BOTTOM_TO_TOP)) {
                        this.lineDirectionDown = false;
                    } else if (lineDir.equals((Object)DisplayDirection.TOP_TO_BOTTOM)) {
                        this.lineDirectionDown = true;
                    }
                }
                catch (NullPointerException ignore) {
                    this.logger.error("Cannot find vertical_display_direction element in the Display_Direction area with identifier '" + array3dImage.getLocalIdentifier() + "'.");
                }
                DisplayDirection sampleDir = null;
                try {
                    sampleDir = DisplayDirection.getDirectionFromValue(ds.getDisplayDirection().getHorizontalDisplayDirection());
                    if (sampleDir.equals((Object)DisplayDirection.RIGHT_TO_LEFT)) {
                        this.setSampleDirectionRight(false);
                    } else if (sampleDir.equals((Object)DisplayDirection.LEFT_TO_RIGHT)) {
                        this.setSampleDirectionRight(true);
                    }
                }
                catch (NullPointerException ignore) {
                    this.logger.error("Cannot find horizontal_display_direction element in the Display_Direction area with identifier '" + array3dImage.getLocalIdentifier() + "'.");
                }
            } else {
                this.logger.info("No display settings found for identifier '" + array3dImage.getLocalIdentifier() + "'.");
            }
        } else {
            this.logger.info("No display settings found. Missing local_identifier element in the Array_3D_Image area.");
        }
        if (array3dImage.getElementArray().getScalingFactor() != null) {
            this.scalingFactor = array3dImage.getElementArray().getScalingFactor();
        }
        if (array3dImage.getElementArray().getValueOffset() != null) {
            this.valueOffset = array3dImage.getElementArray().getValueOffset();
        }
        if (array3dImage.getObjectStatistics() != null) {
            if (array3dImage.getObjectStatistics().getMinimum() != null) {
                this.dataMin = array3dImage.getObjectStatistics().getMinimum();
                this.dataMin = this.dataMin * this.scalingFactor + this.valueOffset;
            }
            if (array3dImage.getObjectStatistics().getMaximum() != null) {
                this.dataMax = array3dImage.getObjectStatistics().getMaximum();
                this.dataMax = this.dataMax * this.scalingFactor + this.valueOffset;
            }
        }
    }

    private void flexReadToRaster(BufferedInputStream inputStream, BufferedImage bufferedImage, int lines, int samples, int bands) throws IOException {
        WritableRaster raster = bufferedImage.getRaster();
        int countBytes = -1;
        MemoryCacheSeekableStream si = null;
        try {
            si = new MemoryCacheSeekableStream((InputStream)inputStream);
            int xWrite = 0;
            int yWrite = 0;
            if (this.exportType.equalsIgnoreCase("fits")) {
                for (int y = 0; y < lines; ++y) {
                    yWrite = this.lineDirectionDown ? y : lines - y - 1;
                    for (int x = 0; x < samples; ++x) {
                        for (int b = 0; b < bands; ++b) {
                            countBytes += 2;
                            double value = 0.0;
                            switch (this.rawDataType) {
                                case SignedByte: {
                                    value = si.readByte();
                                    break;
                                }
                                case UnsignedByte: {
                                    value = si.readUnsignedByte();
                                    break;
                                }
                                case UnsignedLSB2: {
                                    value = si.readUnsignedShortLE();
                                    break;
                                }
                                case SignedLSB2: {
                                    value = si.readShortLE();
                                    break;
                                }
                                case UnsignedMSB2: {
                                    value = si.readUnsignedShort();
                                    break;
                                }
                                case SignedMSB2: {
                                    value = si.readShort();
                                    break;
                                }
                                case UnsignedMSB4: {
                                    value = si.readUnsignedInt();
                                    break;
                                }
                                case UnsignedMSB8: {
                                    value = UnsignedLong.valueOf((long)si.readLong()).doubleValue();
                                    break;
                                }
                                case IEEE754MSBSingle: {
                                    value = si.readFloat();
                                    break;
                                }
                                case IEEE754MSBDouble: {
                                    value = si.readDouble();
                                }
                            }
                            xWrite = this.sampleDirectionRight ? x : samples - x - 1;
                            value = value * this.scalingFactor + this.valueOffset;
                            if (value < this.dataMin) {
                                value = this.dataMin;
                            }
                            if (value > this.dataMax) {
                                value = this.dataMax;
                            }
                            raster.setSample(xWrite, yWrite, b, value);
                        }
                    }
                }
            } else {
                for (int b = 0; b < bands; ++b) {
                    for (int y = 0; y < lines; ++y) {
                        yWrite = this.lineDirectionDown ? y : lines - y - 1;
                        for (int x = 0; x < samples; ++x) {
                            countBytes += 2;
                            double value = 0.0;
                            switch (this.rawDataType) {
                                case SignedByte: {
                                    value = si.readByte();
                                    break;
                                }
                                case UnsignedByte: {
                                    value = si.readUnsignedByte();
                                    break;
                                }
                                case UnsignedLSB2: {
                                    value = si.readUnsignedShortLE();
                                    break;
                                }
                                case SignedLSB2: {
                                    value = si.readShortLE();
                                    break;
                                }
                                case UnsignedMSB2: {
                                    value = si.readUnsignedShort();
                                    break;
                                }
                                case SignedMSB2: {
                                    value = si.readShort();
                                    break;
                                }
                                case UnsignedMSB4: {
                                    value = si.readUnsignedInt();
                                    break;
                                }
                                case UnsignedMSB8: {
                                    value = UnsignedLong.valueOf((long)si.readLong()).doubleValue();
                                    break;
                                }
                                case IEEE754MSBSingle: {
                                    value = si.readFloat();
                                    break;
                                }
                                case IEEE754MSBDouble: {
                                    value = si.readDouble();
                                }
                            }
                            xWrite = this.sampleDirectionRight ? x : samples - x - 1;
                            value = value * this.scalingFactor + this.valueOffset;
                            if (value < this.dataMin) {
                                value = this.dataMin;
                            }
                            if (value > this.dataMax) {
                                value = this.dataMax;
                            }
                            raster.setSample(xWrite, yWrite, b, value);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            String m = "EOF at byte number: " + countBytes + "inputFile: " + inputStream;
            this.logger.error(m, (Throwable)e);
            e.printStackTrace();
            throw new IOException(m);
        }
        finally {
            if (si != null) {
                try {
                    si.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeRasterImage(OutputStream outputStream, BufferedImage bi) {
        try {
            if (this.exportType.equals("VICAR") || this.exportType.equals("PDS3")) {
                ImageIO.write((RenderedImage)bi, "raw", outputStream);
            } else if (this.exportType.equalsIgnoreCase("fits")) {
                this.writeFitsFile(outputStream, bi);
            } else {
                ImageIO.write((RenderedImage)bi, this.exportType, outputStream);
            }
        }
        catch (IOException e) {
            String message = "Error writing to output stream";
            this.logger.error(message, (Throwable)e);
        }
    }

    public void flip(BufferedImage image) {
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight() / 2; ++j) {
                int tmp = image.getRGB(i, j);
                image.setRGB(i, j, image.getRGB(i, image.getHeight() - j - 1));
                image.setRGB(i, image.getHeight() - j - 1, tmp);
            }
        }
    }

    private void writeFitsFile(OutputStream outputStream, BufferedImage bi) {
        Fits f = new Fits();
        try {
            ImageHDU hdu = (ImageHDU)FitsFactory.HDUFactory((Object)bi.getData().getDataElements(0, 0, bi.getWidth(), bi.getHeight(), null));
            hdu.addValue("NAXIS", 3, "NUMBER OF AXES");
            hdu.addValue("NAXIS1", bi.getWidth(), "NUMBER OF COLUMNS");
            hdu.addValue("NAXIS2", bi.getHeight(), "NUMBER OF ROWS");
            hdu.addValue("NAXIS3", 3, "NUMBER OF BANDS");
            f.addHDU((BasicHDU)hdu);
            BufferedDataOutputStream bdos = new BufferedDataOutputStream(outputStream);
            f.write((DataOutput)bdos);
            bdos.close();
        }
        catch (FitsException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeLabel(OutputStream outputStream, String type) throws AlreadyOpenException, IOException, Exception {
        if (type.equalsIgnoreCase("VICAR")) {
            VicarSystemLabelGenerator labelGenerator = new VicarSystemLabelGenerator();
            int cols = 0;
            int rows = 0;
            int bands = 1;
            if (this.pdsImage.getAxes() == 3) {
                for (AxisArray axis : this.pdsImage.getAxisArraies()) {
                    if (axis.getSequenceNumber() == 3) {
                        cols = axis.getElements().intValueExact();
                        continue;
                    }
                    if (axis.getSequenceNumber() == 2) {
                        rows = axis.getElements().intValueExact();
                        continue;
                    }
                    bands = axis.getElements().intValueExact();
                }
            }
            labelGenerator.set_org("BSQ");
            labelGenerator.set_nb(bands);
            labelGenerator.set_nl(cols);
            labelGenerator.set_ns(rows);
            labelGenerator.set_binc(1.0);
            labelGenerator.set_linc(1.0);
            labelGenerator.set_sinc(1.0);
            labelGenerator.set_datatype(this.getRawDataType().getVicarAlias());
            labelGenerator.set_tileHeight(rows);
            labelGenerator.set_tileWidth(cols);
            labelGenerator.set_pixelStride(1);
            labelGenerator.generateFile(outputStream);
        } else if (type.equalsIgnoreCase("PDS3")) {
            ImageToPDS_DOM imageToPdsDom = new ImageToPDS_DOM((RenderedImage)this.bufferedImage);
            outputStream.write(new DOMtoPDSlabel(imageToPdsDom.getDocument()).toString().getBytes("ASCII"));
        } else {
            String message = "Unsupported label type: " + type;
            this.logger.error(message);
            throw new Exception(message);
        }
    }

    private IndexColorModel getColorModel() {
        return this.colorModel;
    }

    private void setColorModel(IndexColorModel colorModel) {
        this.colorModel = colorModel;
    }

    public int getTargetPixelDepth() {
        return this.targetPixelBitDepth;
    }

    public void setTargetPixelDepth(int targetPixelDepth) {
        if (targetPixelDepth != 8 && targetPixelDepth != 16 && targetPixelDepth != 24) {
            String message = "Supported pixel bit depths are 8 and 16 and 24";
            this.logger.error(message);
            throw new IllegalArgumentException(message);
        }
        this.targetPixelBitDepth = targetPixelDepth;
        this.targetLevels = (int)Math.pow(2.0, this.targetPixelBitDepth);
        switch (this.targetPixelBitDepth) {
            case 8: {
                this.imageType = 13;
                break;
            }
            case 16: {
                this.imageType = 11;
                break;
            }
            case 24: {
                this.imageType = 5;
            }
        }
    }

    private DataType.NumericDataType getRawDataType() {
        return this.rawDataType;
    }

    private void setRawDataType(DataType.NumericDataType rawDataType) {
        this.rawDataType = rawDataType;
    }

    public boolean maximizeDynamicRange() {
        return this.maximizeDynamicRange;
    }

    public void maximizeDynamicRange(boolean dynamicRangeScaling) {
        this.maximizeDynamicRange = dynamicRangeScaling;
    }

    public String getExportType() {
        return this.exportType;
    }

    @Override
    public void setExportType(String exportType) {
        Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByFormatName(exportType);
        if (!(imageWriters.hasNext() || exportType.equalsIgnoreCase("VICAR") || exportType.equalsIgnoreCase("PDS3") || exportType.equalsIgnoreCase("fits"))) {
            String message = "The export image type " + exportType + " is not currently supported.";
            this.logger.error(message);
            throw new IllegalArgumentException(message);
        }
        this.exportType = exportType;
    }

    public boolean isSampleDirectionRight() {
        return this.sampleDirectionRight;
    }

    public void setSampleDirectionRight(boolean sampleDirectionRight) {
        this.sampleDirectionRight = sampleDirectionRight;
    }

    public boolean isFirstIndexFastest() {
        return this.firstIndexFastest;
    }

    public void setFirstIndexFastest(boolean firstIndexFastest) {
        this.firstIndexFastest = firstIndexFastest;
    }

    public Array3DImage getArray3DImage() {
        return this.pdsImage;
    }

    public void setArray3DImage(Array3DImage img) {
        this.pdsImage = img;
        this.setImageElementsDataType(this.pdsImage);
        this.setImageStatistics(this.pdsImage);
        this.setImageType();
    }
}

