/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess.utility;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.xml.sax.InputSource;

public class Utility {
    public static InputStream openConnection(URLConnection conn) throws IOException {
        boolean redir;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).setInstanceFollowRedirects(false);
            }
            if (conn instanceof HttpsURLConnection) {
                try {
                    SSLContext context = SSLContext.getInstance("TLSv1.2");
                    context.init(null, null, new SecureRandom());
                    HttpsURLConnection test = (HttpsURLConnection)conn;
                    SSLSocketFactory sf = test.getSSLSocketFactory();
                    SSLSocketFactory d = HttpsURLConnection.getDefaultSSLSocketFactory();
                    ((HttpsURLConnection)conn).setSSLSocketFactory(context.getSocketFactory());
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            }
            in = conn.getInputStream();
            redir = false;
            if (!(conn instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)conn).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https") || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            conn = target.openConnection();
            ++redirects;
        } while (redir);
        return in;
    }

    public static InputSource openConnection(URL url) throws IOException {
        InputSource inputSource = new InputSource(Utility.openConnection(url.openConnection()));
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        inputSource.setSystemId(uri.toString());
        return inputSource;
    }

    static {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                return hostname.equals("pds.nasa.gov") && hostname.equals(sslSession.getPeerHost());
            }
        });
    }
}

