/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.datum.DomainDivider;
import org.das2.datum.DomainDividerUtil;
import org.das2.datum.LoggerManager;
import org.das2.datum.MonthDatumRange;
import org.das2.datum.OrbitDatumRange;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.TimeDatumFormatter;

public class DatumRangeUtil {
    private static final Logger logger = LoggerManager.getLogger("das2.datum");
    private static final boolean DEBUG = false;
    private static final Datum MIN_TIME = TimeUtil.createTimeDatum(1000, 1, 1, 0, 0, 0, 0);
    private static final Datum MAX_TIME = TimeUtil.createTimeDatum(3000, 1, 1, 0, 0, 0, 0);
    private static Pattern time1;
    private static Pattern time2;
    private static Pattern time3;
    private static Pattern time4;
    private static Pattern time5;
    private static Pattern time6;
    private static final String simpleFloat = "\\d*?\\.?\\d+";
    public static final String iso8601duration = "P(\\d+Y)?(\\d+M)?(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d*?\\.?\\d+S)?)?";
    public static final Pattern iso8601DurationPattern;
    private static boolean useDoy;

    private static boolean isYear(String string) {
        return string.length() == 4 && Pattern.matches("\\d{4}", string);
    }

    private static boolean isDayOfYear(String string) {
        return string.length() == 3 && Pattern.matches("\\d{3}", string);
    }

    private static int monthNumber(String string) throws ParseException {
        if (Pattern.matches("\\d+", string)) {
            return DatumRangeUtil.parseInt(string);
        }
        int month = DatumRangeUtil.monthNameNumber(string);
        if (month == -1) {
            throw new ParseException("hoping for month at, got " + string, 0);
        }
        return month;
    }

    private static int monthNameNumber(String string) {
        if (string.length() < 3) {
            return -1;
        }
        String[] monthNames = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
        string = string.substring(0, 3).toLowerCase();
        int r = -1;
        for (int i = 0; i < monthNames.length; ++i) {
            if (!string.equals(monthNames[i])) continue;
            r = i;
        }
        if (r == -1) {
            return -1;
        }
        return r + 1;
    }

    private static int y2k(String syear) throws ParseException {
        int year = DatumRangeUtil.parseInt(syear);
        if (year > 100) {
            return year;
        }
        if (year < 70) {
            return 2000 + year;
        }
        return 1900 + year;
    }

    public static boolean isAcceptable(DatumRange dr, boolean log) {
        if (Double.isInfinite(dr.min().doubleValue(dr.getUnits())) || Double.isInfinite(dr.max().doubleValue(dr.getUnits()))) {
            return false;
        }
        if (UnitsUtil.isTimeLocation(dr.getUnits()) && (dr.min().lt(MIN_TIME) || dr.max().gt(MAX_TIME))) {
            return false;
        }
        if (log) {
            if (!UnitsUtil.isRatioMeasurement(dr.getUnits())) {
                return false;
            }
            return !(dr.max().divide(dr.min()).doubleValue(Units.dimensionless) > 1.0E100);
        }
        return true;
    }

    public static String toStringInclusive(DatumRange datumRange) {
        String s = datumRange.toString();
        return s;
    }

    private static void caldat(int julday, DateDescriptor dateDescriptor) {
        int jalpha = (int)(((double)(julday - 1867216) - 0.25) / 36524.25);
        int j1 = julday + 1 + jalpha - jalpha / 4;
        int j2 = j1 + 1524;
        int j3 = 6680 + (int)(((double)(j2 - 2439870) - 122.1) / 365.25);
        int j4 = 365 * j3 + j3 / 4;
        int j5 = (int)((double)(j2 - j4) / 30.6001);
        int day = j2 - j4 - (int)(30.6001 * (double)j5);
        int month = j5 - 1;
        month = (month - 1) % 12 + 1;
        int year = j3 - 4715;
        dateDescriptor.day = "" + day;
        dateDescriptor.month = "" + month;
        dateDescriptor.year = "" + (year -= (year -= month > 2 ? 1 : 0) <= 0 ? 1 : 0);
    }

    private static int julday(int month, int day, int year) {
        int jd = 367 * year - 7 * (year + (month + 9) / 12) / 4 - 3 * ((year + (month - 9) / 7) / 100 + 1) / 4 + 275 * month / 9 + day + 1721029;
        return jd;
    }

    private static void printGroups(Matcher matcher) {
        for (int i = 0; i <= matcher.groupCount(); ++i) {
            System.out.println(" " + i + ": " + matcher.group(i));
        }
        System.out.println(" ");
    }

    private static int parseInt(String s) throws ParseException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new ParseException("failed attempt to parse int in \"" + s + "\"", 0);
        }
    }

    private static int getInt(String val, int deft) {
        if (val == null) {
            if (deft != -99) {
                return deft;
            }
            throw new IllegalArgumentException("bad digit");
        }
        int n = val.length() - 1;
        if (Character.isLetter(val.charAt(n))) {
            return Integer.parseInt(val.substring(0, n));
        }
        return Integer.parseInt(val);
    }

    private static double getDouble(String val, double deft) {
        if (val == null) {
            if (deft != -99.0) {
                return deft;
            }
            throw new IllegalArgumentException("bad digit");
        }
        int n = val.length() - 1;
        if (Character.isLetter(val.charAt(n))) {
            return Double.parseDouble(val.substring(0, n));
        }
        return Double.parseDouble(val);
    }

    public static String formatISO8601Datum(int[] result) {
        return String.format("%04d-%02d-%02dT%02d:%02d:%02d.%09dZ", result[0], result[1], result[2], result[3], result[4], result[5], result[6]);
    }

    public static int parseISO8601Datum(String str, int[] result, int lsd) {
        StringTokenizer st = new StringTokenizer(str, "-T:.Z+ ", true);
        String dir = null;
        String DIR_FORWARD = "f";
        String DIR_REVERSE = "r";
        int want = 0;
        boolean haveDelim = false;
        boolean afterT = false;
        while (st.hasMoreTokens()) {
            int n;
            int i;
            char delim = ' ';
            if (haveDelim) {
                delim = st.nextToken().charAt(0);
                if (delim == 'T') {
                    afterT = true;
                }
                if (afterT && (delim == '-' || delim == '+' || delim == ' ')) {
                    StringBuilder toff = new StringBuilder(String.valueOf(delim));
                    while (st.hasMoreElements()) {
                        toff.append(st.nextToken());
                    }
                    int deltaHours = delim == ' ' ? Integer.parseInt(toff.substring(1, 3)) : Integer.parseInt(toff.substring(0, 3));
                    switch (toff.length()) {
                        case 6: {
                            result[3] = result[3] - deltaHours;
                            result[4] = (int)((float)result[4] - Math.signum(deltaHours) * (float)Integer.parseInt(toff.substring(4)));
                            break;
                        }
                        case 5: {
                            result[3] = result[3] - deltaHours;
                            result[4] = (int)((float)result[4] - Math.signum(deltaHours) * (float)Integer.parseInt(toff.substring(3)));
                            break;
                        }
                        case 3: {
                            result[3] = result[3] - deltaHours;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("malformed time zone designator: " + str);
                        }
                    }
                    DatumRangeUtil.normalizeTimeComponents(result);
                    break;
                }
                if (!st.hasMoreElements()) {
                    break;
                }
            } else {
                haveDelim = true;
            }
            String tok = st.nextToken();
            if (dir == null) {
                switch (tok.length()) {
                    case 4: {
                        int iyear;
                        result[0] = iyear = Integer.parseInt(tok);
                        want = 1;
                        dir = DIR_FORWARD;
                        break;
                    }
                    case 6: {
                        want = lsd;
                        if (want != 6) {
                            throw new IllegalArgumentException("lsd must be 6");
                        }
                        result[want] = Integer.parseInt(tok.substring(0, 2));
                        result[--want] = Integer.parseInt(tok.substring(2, 4));
                        result[--want] = Integer.parseInt(tok.substring(4, 6));
                        --want;
                        dir = DIR_REVERSE;
                        break;
                    }
                    case 7: {
                        result[0] = Integer.parseInt(tok.substring(0, 4));
                        result[1] = 1;
                        result[2] = Integer.parseInt(tok.substring(4, 7));
                        want = 3;
                        dir = DIR_FORWARD;
                        break;
                    }
                    case 8: {
                        result[0] = Integer.parseInt(tok.substring(0, 4));
                        result[1] = Integer.parseInt(tok.substring(4, 6));
                        result[2] = Integer.parseInt(tok.substring(6, 8));
                        want = 3;
                        dir = DIR_FORWARD;
                        break;
                    }
                    default: {
                        dir = DIR_REVERSE;
                        want = lsd;
                        int i2 = Integer.parseInt(tok);
                        if (want < 0) {
                            throw new IllegalArgumentException("str does not appear to be an ISO8601 time: " + str);
                        }
                        result[want] = i2;
                        --want;
                        break;
                    }
                }
                continue;
            }
            if (dir == DIR_FORWARD) {
                if (want == 1 && tok.length() == 3) {
                    result[1] = 1;
                    result[2] = Integer.parseInt(tok);
                    want = 3;
                    continue;
                }
                if (want == 3 && tok.length() == 6) {
                    result[want] = Integer.parseInt(tok.substring(0, 2));
                    result[++want] = Integer.parseInt(tok.substring(2, 4));
                    result[++want] = Integer.parseInt(tok.substring(4, 6));
                    ++want;
                    continue;
                }
                if (want == 3 && tok.length() == 4) {
                    result[want] = Integer.parseInt(tok.substring(0, 2));
                    result[++want] = Integer.parseInt(tok.substring(2, 4));
                    ++want;
                    continue;
                }
                if (delim == '.' && want == 6) {
                    if (tok.length() > 9) {
                        tok = tok.substring(0, 9);
                    }
                    i = Integer.parseInt(tok);
                    n = 9 - tok.length();
                    result[want] = i * (int)Math.pow(10.0, n);
                } else {
                    result[want] = i = Integer.parseInt(tok);
                }
                ++want;
                continue;
            }
            if (dir != DIR_REVERSE) continue;
            i = Integer.parseInt(tok);
            if (delim == '.') {
                n = 9 - tok.length();
                result[want] = i * (int)Math.pow(10.0, n);
            } else {
                result[want] = i;
            }
            --want;
        }
        if (dir == DIR_REVERSE) {
            int iu = want + 1;
            for (int id = lsd; iu < id; ++iu, --id) {
                int t = result[iu];
                result[iu] = result[id];
                result[id] = t;
            }
        } else {
            lsd = want - 1;
        }
        return lsd;
    }

    public static int[] normalizeTimeComponents(int[] components) {
        int daysInMonth;
        while (components[6] >= 1000000000) {
            components[5] = components[5] + 1;
            components[6] = components[6] - 1000000000;
        }
        while (components[5] >= 60) {
            components[4] = components[4] + 1;
            components[5] = components[5] - 60;
        }
        while (components[5] < 0) {
            components[4] = components[4] - 1;
            components[5] = components[5] + 60;
        }
        while (components[4] >= 60) {
            components[3] = components[3] + 1;
            components[4] = components[4] - 60;
        }
        while (components[4] < 0) {
            components[3] = components[3] - 1;
            components[4] = components[4] + 60;
        }
        while (components[3] >= 23) {
            components[2] = components[2] + 1;
            components[3] = components[3] - 24;
        }
        while (components[3] < 0) {
            components[2] = components[2] - 1;
            components[3] = components[3] + 24;
        }
        if (components[2] > 28) {
            daysInMonth = TimeUtil.daysInMonth(components[1], components[0]);
            while (components[2] > daysInMonth) {
                components[2] = components[2] - daysInMonth;
                components[1] = components[1] + 1;
                if (components[1] > 12) break;
                daysInMonth = TimeUtil.daysInMonth(components[1], components[0]);
            }
        }
        if (components[2] == 0) {
            components[1] = -1;
            if (components[1] == 0) {
                components[1] = 12;
                components[0] = components[0] - 1;
            }
            components[2] = daysInMonth = TimeUtil.daysInMonth(components[1], components[0]);
        }
        while (components[1] > 12) {
            components[0] = components[0] + 1;
            components[1] = components[1] - 12;
        }
        if (components[1] < 0) {
            components[0] = components[0] + 1;
            components[1] = components[1] + 12;
        }
        return components;
    }

    public static int[] parseISO8601(String str) {
        try {
            int[] result = new int[7];
            DatumRangeUtil.parseISO8601Datum(str, result, -1);
            return result;
        }
        catch (RuntimeException result) {
            Matcher m = time1.matcher(str);
            if (m.matches()) {
                String sf = m.group(10);
                if (sf != null && sf.length() > 9) {
                    throw new IllegalArgumentException("too many digits in nanoseconds part");
                }
                int nanos = sf == null ? 0 : Integer.parseInt(sf) * (int)Math.pow(10.0, 9 - sf.length());
                return new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)), DatumRangeUtil.getInt(m.group(4), 0), DatumRangeUtil.getInt(m.group(5), 0), DatumRangeUtil.getInt(m.group(8), 0), nanos};
            }
            m = time2.matcher(str);
            if (m.matches()) {
                return new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)), DatumRangeUtil.getInt(m.group(4), 0), DatumRangeUtil.getInt(m.group(5), 0), DatumRangeUtil.getInt(m.group(7), 0), 0};
            }
            m = time3.matcher(str);
            if (m.matches()) {
                return new int[]{Integer.parseInt(m.group(1)), 1, Integer.parseInt(m.group(2)), DatumRangeUtil.getInt(m.group(3), 0), DatumRangeUtil.getInt(m.group(4), 0), DatumRangeUtil.getInt(m.group(5), 0), 0};
            }
            m = time4.matcher(str);
            if (m.matches()) {
                return new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), DatumRangeUtil.getInt(m.group(3), 0), 0, 0, 0, 0};
            }
            m = time5.matcher(str);
            if (m.matches()) {
                return new int[]{Integer.parseInt(m.group(1)), 1, Integer.parseInt(m.group(2)), 0, 0, 0, 0};
            }
            m = time6.matcher(str);
            if (m.matches()) {
                String sf = m.group(10);
                if (sf != null && sf.length() > 9) {
                    throw new IllegalArgumentException("too many digits in nanoseconds part");
                }
                int nanos = sf == null ? 0 : Integer.parseInt(sf) * (int)Math.pow(10.0, 9 - sf.length());
                String plusMinus = m.group(12);
                String tzHours = m.group(13);
                String tzMinutes = m.group(15);
                int[] result2 = plusMinus.charAt(0) == '+' ? new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)), DatumRangeUtil.getInt(m.group(4), 0) - DatumRangeUtil.getInt(tzHours, 0), DatumRangeUtil.getInt(m.group(5), 0) - DatumRangeUtil.getInt(tzMinutes, 0), DatumRangeUtil.getInt(m.group(8), 0), nanos} : new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)), DatumRangeUtil.getInt(m.group(4), 0) + DatumRangeUtil.getInt(tzHours, 0), DatumRangeUtil.getInt(m.group(5), 0) + DatumRangeUtil.getInt(tzMinutes, 0), DatumRangeUtil.getInt(m.group(8), 0), nanos};
                return DatumRangeUtil.normalizeTimeComponents(result2);
            }
            return null;
        }
    }

    public static int[] parseISO8601Duration(String stringIn) throws ParseException {
        Matcher m = iso8601DurationPattern.matcher(stringIn);
        if (m.matches()) {
            double dsec = DatumRangeUtil.getDouble(m.group(7), 0.0);
            int sec = (int)dsec;
            int nanosec = (int)((dsec - (double)sec) * 1.0E9);
            return new int[]{DatumRangeUtil.getInt(m.group(1), 0), DatumRangeUtil.getInt(m.group(2), 0), DatumRangeUtil.getInt(m.group(3), 0), DatumRangeUtil.getInt(m.group(5), 0), DatumRangeUtil.getInt(m.group(6), 0), sec, nanosec};
        }
        if (stringIn.contains("P") && stringIn.contains("S") && !stringIn.contains("T")) {
            throw new ParseException("ISO8601 duration expected but not found.  Was the T missing before S?", 0);
        }
        throw new ParseException("ISO8601 duration expected but not found.", 0);
    }

    public static String formatISO8601Duration(int[] t) {
        StringBuilder result = new StringBuilder(24);
        result.append('P');
        if (t[0] != 0) {
            result.append(t[0]).append('Y');
        }
        if (t[1] != 0) {
            result.append(t[1]).append('M');
        }
        if (t[2] != 0) {
            result.append(t[2]).append('D');
        }
        if (t[3] != 0 || t[4] != 0 || t[5] != 0 || t.length == 7 && t[6] != 0) {
            result.append('T');
            if (t[3] != 0) {
                result.append(t[3]).append('H');
            }
            if (t[4] != 0) {
                result.append(t[4]).append('M');
            }
            if (t[5] != 0 || t.length == 7 && t[6] != 0) {
                if (t.length < 7 || t[6] == 0) {
                    result.append(t[5]).append('S');
                } else {
                    double sec = (double)t[5] + (double)t[6] / 1.0E9;
                    result.append(sec).append('S');
                }
            }
        }
        return result.toString();
    }

    private static boolean isISO8601RangeDuration(String string) {
        if (string.length() < 3) {
            return false;
        }
        if (string.charAt(0) != 'P') {
            return false;
        }
        try {
            DatumRangeUtil.parseISO8601Duration(string);
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    public static boolean isISO8601Range(String stringIn) {
        int i = stringIn.indexOf(47);
        if (i == -1) {
            return false;
        }
        String s1 = stringIn.substring(0, i);
        String s2 = stringIn.substring(i + 1);
        if (TimeParser.isIso8601String(s1)) {
            return TimeParser.isIso8601String(s2) || DatumRangeUtil.isISO8601RangeDuration(s2);
        }
        if (TimeParser.isIso8601String(s2)) {
            return DatumRangeUtil.isISO8601RangeDuration(s1);
        }
        return false;
    }

    public static DatumRange parseISO8601Range(String stringIn) throws ParseException {
        int i;
        int[] digits1;
        int j;
        int[] digits0;
        String[] parts = stringIn.split("/", -2);
        if (parts.length != 2) {
            return null;
        }
        boolean isDuration1 = parts[0].charAt(0) == 'P';
        boolean isDuration2 = parts[1].charAt(0) == 'P';
        int lsd = -1;
        if (isDuration1) {
            digits0 = DatumRangeUtil.parseISO8601Duration(parts[0]);
        } else {
            digits0 = new int[7];
            try {
                lsd = DatumRangeUtil.parseISO8601Datum(parts[0], digits0, lsd);
                for (j = lsd + 1; j < 3; ++j) {
                    digits0[j] = 1;
                }
            }
            catch (IllegalArgumentException ex) {
                throw new ParseException("string does not appear to be an iso8601 time range", 0);
            }
        }
        if (isDuration2) {
            digits1 = DatumRangeUtil.parseISO8601Duration(parts[1]);
        } else {
            digits1 = isDuration1 ? new int[7] : Arrays.copyOf(digits0, digits0.length);
            if (parts[1].contains("T") || isDuration1) {
                lsd = DatumRangeUtil.parseISO8601Datum(parts[1], digits1, lsd);
            } else {
                String hms0;
                int tindex;
                int i0 = parts[0].lastIndexOf(".");
                if (i0 > -1) {
                    int i1 = parts[1].lastIndexOf(".");
                    String fractionalPart0 = parts[0].substring(i0);
                    if (i1 > -1) {
                        String fractionalPart1 = parts[1].substring(i1);
                        if (fractionalPart0.length() < fractionalPart1.length()) {
                            parts[0] = parts[0] + "000000000".substring(fractionalPart1.length() - fractionalPart0.length());
                        } else if (fractionalPart0.length() > fractionalPart1.length()) {
                            parts[1] = parts[1] + "000000000".substring(0, fractionalPart0.length() - fractionalPart1.length());
                        }
                    }
                }
                if ((tindex = parts[0].indexOf("T")) > -1 && (hms0 = parts[0].substring(tindex + 1)).length() < parts[1].length()) {
                    parts[0] = parts[0] + ":00.000000000".substring(0, parts[1].length() - hms0.length());
                }
                String t = parts[0].substring(0, parts[0].length() - parts[1].length()) + parts[1];
                lsd = DatumRangeUtil.parseISO8601Datum(t, digits1, lsd);
            }
            for (j = lsd + 1; j < 3; ++j) {
                digits1[j] = 1;
            }
        }
        if (digits0 == null || digits1 == null) {
            return null;
        }
        if (isDuration1) {
            for (i = 0; i < 7; ++i) {
                digits0[i] = digits1[i] - digits0[i];
            }
            if (digits0[1] < 1) {
                digits0[1] = digits0[1] + 12;
                digits0[0] = digits0[0] - 1;
            }
        }
        if (isDuration2) {
            for (i = 0; i < 7; ++i) {
                digits1[i] = digits0[i] + digits1[i];
            }
            if (digits1[1] > 12) {
                digits1[1] = digits1[1] - 12;
                digits1[0] = digits1[0] + 1;
            }
        }
        Datum t1 = TimeUtil.toDatum(digits0);
        Datum t2 = TimeUtil.toDatum(digits1);
        return new DatumRange(t1, t2);
    }

    public static DatumRange parseValidISO8601Range(String stringIn) {
        try {
            return DatumRangeUtil.parseISO8601Range(stringIn);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("string was not ISO8601 range", ex);
        }
    }

    public static void main(String[] ss) throws ParseException {
        System.err.println(DatumRangeUtil.parseTimeRange("now-P1D/now+P1D"));
        System.err.println(DatumRangeUtil.parseTimeRange("1972/now-P1D"));
        System.err.println(DatumRangeUtil.parseTimeRange("now-P10D/now-P1D"));
        System.err.println(DatumRangeUtil.parseISO8601Range("20000101T1300Z/PT1H"));
    }

    public static DatumRange parseTimeRange(String string) throws ParseException {
        if (string.startsWith("orbit:")) {
            String[] ss = string.split(":");
            if (ss.length == 4) {
                ss[1] = ss[1] + ":" + ss[2];
                ss[2] = ss[3];
            }
            if (ss.length < 3) {
                throw new ParseException("orbit misformatted, should be orbit:<sc>:<num> or orbit:<sc>:<num>-<num>", 0);
            }
            Pattern p = Pattern.compile("(\\d+)\\-(\\d+)");
            Matcher m = p.matcher(ss[2]);
            if (m.matches()) {
                OrbitDatumRange o0 = new OrbitDatumRange(ss[1], m.group(1));
                OrbitDatumRange o1 = new OrbitDatumRange(ss[1], m.group(2));
                return DatumRangeUtil.union((DatumRange)o0, o1);
            }
            return new OrbitDatumRange(ss[1], ss[2]);
        }
        if (string.startsWith("P") && iso8601DurationPattern.matcher(string).matches()) {
            Datum now = TimeUtil.now();
            DatumRange result = DatumRangeUtil.parseISO8601Range(string + "/" + TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(now, null));
            if (result == null) {
                throw new ParseException(string, 0);
            }
            return result;
        }
        if (string.contains("now") || string.contains("last") && (string.contains("lastminute") || string.contains("lasthour") || string.contains("lastday") || string.contains("lastmonth") || string.contains("lastyear"))) {
            String[] ss = string.split("/");
            String delim = "/";
            if (ss.length != 2) {
                logger.fine("expected to find '/' along with now");
            }
            StringBuilder snew = new StringBuilder();
            Datum now = TimeUtil.now();
            for (int iss = 0; iss < ss.length; ++iss) {
                Datum lastDay;
                int[] d;
                int[] dt;
                int[] tt;
                Datum time;
                int[] tt2;
                int[] dt2;
                String s = ss[iss];
                if (iss > 0) {
                    snew.append(delim);
                }
                if (s.startsWith("now-")) {
                    dt2 = DatumRangeUtil.parseISO8601Duration(s.substring(4));
                    tt2 = TimeUtil.fromDatum(now);
                    for (int i = 0; i < tt2.length; ++i) {
                        tt2[i] = tt2[i] - dt2[i];
                    }
                    time = TimeUtil.toDatum(tt2);
                    snew.append(TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(time, null));
                    continue;
                }
                if (s.startsWith("now+") || s.startsWith("now ")) {
                    dt2 = DatumRangeUtil.parseISO8601Duration(s.substring(4));
                    tt2 = TimeUtil.fromDatum(now);
                    for (int i = 0; i < tt2.length; ++i) {
                        tt2[i] = tt2[i] + dt2[i];
                    }
                    time = TimeUtil.toDatum(tt2);
                    snew.append(TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(time, null));
                    continue;
                }
                if (s.equals("now")) {
                    snew.append(TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(now, null));
                    continue;
                }
                if (s.contains("now")) {
                    String nowString = TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(now, null);
                    snew.append(s.replace("now", nowString));
                    continue;
                }
                if (s.contains("lastyear-")) {
                    tt = TimeUtil.fromDatum(now);
                    tt[1] = 1;
                    tt[2] = 1;
                    tt[3] = 0;
                    tt[4] = 0;
                    tt[5] = 0;
                    tt[6] = 0;
                    dt = DatumRangeUtil.parseISO8601Duration(s.substring(8));
                    for (int i = 0; i < tt.length; ++i) {
                        tt[i] = tt[i] - dt[i];
                    }
                    time = TimeUtil.toDatum(tt);
                    snew.append(TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(time, null));
                    continue;
                }
                if (s.contains("lastyear")) {
                    d = TimeUtil.fromDatum(now);
                    d[1] = 1;
                    d[2] = 1;
                    d[3] = 0;
                    d[4] = 0;
                    d[5] = 0;
                    d[6] = 0;
                    lastDay = TimeUtil.toDatum(d);
                    String lastDayString = TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(lastDay, null);
                    snew.append(s.replace("lastyear", lastDayString));
                    continue;
                }
                if (s.contains("lastmonth-")) {
                    tt = TimeUtil.fromDatum(now);
                    tt[2] = 1;
                    tt[3] = 0;
                    tt[4] = 0;
                    tt[5] = 0;
                    tt[6] = 0;
                    dt = DatumRangeUtil.parseISO8601Duration(s.substring(8));
                    for (int i = 0; i < tt.length; ++i) {
                        tt[i] = tt[i] - dt[i];
                    }
                    time = TimeUtil.toDatum(tt);
                    snew.append(TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(time, null));
                    continue;
                }
                if (s.contains("lastmonth+")) {
                    tt = TimeUtil.fromDatum(now);
                    tt[2] = 1;
                    tt[3] = 0;
                    tt[4] = 0;
                    tt[5] = 0;
                    tt[6] = 0;
                    dt = DatumRangeUtil.parseISO8601Duration(s.substring(8));
                    for (int i = 0; i < tt.length; ++i) {
                        tt[i] = tt[i] + dt[i];
                    }
                    time = TimeUtil.toDatum(tt);
                    snew.append(TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(time, null));
                    continue;
                }
                if (s.contains("lastmonth")) {
                    d = TimeUtil.fromDatum(now);
                    d[2] = 1;
                    d[3] = 0;
                    d[4] = 0;
                    d[5] = 0;
                    d[6] = 0;
                    lastDay = TimeUtil.toDatum(d);
                    String lastDayString = TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(lastDay, null);
                    snew.append(s.replace("lastmonth", lastDayString));
                    continue;
                }
                if (s.contains("lastday-")) {
                    tt = TimeUtil.fromDatum(now);
                    tt[3] = 0;
                    tt[4] = 0;
                    tt[5] = 0;
                    tt[6] = 0;
                    dt = DatumRangeUtil.parseISO8601Duration(s.substring(8));
                    for (int i = 0; i < tt.length; ++i) {
                        tt[i] = tt[i] - dt[i];
                    }
                    time = TimeUtil.toDatum(tt);
                    snew.append(TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(time, null));
                    continue;
                }
                if (s.contains("lastday+")) {
                    tt = TimeUtil.fromDatum(now);
                    tt[3] = 0;
                    tt[4] = 0;
                    tt[5] = 0;
                    tt[6] = 0;
                    dt = DatumRangeUtil.parseISO8601Duration(s.substring(8));
                    for (int i = 0; i < tt.length; ++i) {
                        tt[i] = tt[i] + dt[i];
                    }
                    time = TimeUtil.toDatum(tt);
                    snew.append(TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(time, null));
                    continue;
                }
                if (s.contains("lastday")) {
                    d = TimeUtil.fromDatum(now);
                    d[3] = 0;
                    d[4] = 0;
                    d[5] = 0;
                    d[6] = 0;
                    lastDay = TimeUtil.toDatum(d);
                    String lastDayString = TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(lastDay, null);
                    snew.append(s.replace("lastday", lastDayString));
                    continue;
                }
                if (s.contains("lasthour-")) {
                    tt = TimeUtil.fromDatum(now);
                    tt[4] = 0;
                    tt[5] = 0;
                    tt[6] = 0;
                    dt = DatumRangeUtil.parseISO8601Duration(s.substring(8));
                    for (int i = 0; i < tt.length; ++i) {
                        tt[i] = tt[i] - dt[i];
                    }
                    time = TimeUtil.toDatum(tt);
                    snew.append(TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(time, null));
                    continue;
                }
                if (s.contains("lasthour+")) {
                    tt = TimeUtil.fromDatum(now);
                    tt[4] = 0;
                    tt[5] = 0;
                    tt[6] = 0;
                    dt = DatumRangeUtil.parseISO8601Duration(s.substring(8));
                    for (int i = 0; i < tt.length; ++i) {
                        tt[i] = tt[i] + dt[i];
                    }
                    time = TimeUtil.toDatum(tt);
                    snew.append(TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(time, null));
                    continue;
                }
                if (s.contains("lasthour")) {
                    d = TimeUtil.fromDatum(now);
                    d[4] = 0;
                    d[5] = 0;
                    d[6] = 0;
                    lastDay = TimeUtil.toDatum(d);
                    String lastDayString = TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(lastDay, null);
                    snew.append(s.replace("lasthour", lastDayString));
                    continue;
                }
                if (s.contains("lastminute-")) {
                    tt = TimeUtil.fromDatum(now);
                    tt[5] = 0;
                    tt[6] = 0;
                    dt = DatumRangeUtil.parseISO8601Duration(s.substring(11));
                    for (int i = 0; i < tt.length; ++i) {
                        tt[i] = tt[i] - dt[i];
                    }
                    time = TimeUtil.toDatum(tt);
                    snew.append(TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(time, null));
                    continue;
                }
                if (s.contains("lastminute+")) {
                    tt = TimeUtil.fromDatum(now);
                    tt[5] = 0;
                    tt[6] = 0;
                    dt = DatumRangeUtil.parseISO8601Duration(s.substring(11));
                    for (int i = 0; i < tt.length; ++i) {
                        tt[i] = tt[i] + dt[i];
                    }
                    time = TimeUtil.toDatum(tt);
                    snew.append(TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(time, null));
                    continue;
                }
                if (s.contains("lastminute")) {
                    d = TimeUtil.fromDatum(now);
                    d[5] = 0;
                    d[6] = 0;
                    lastDay = TimeUtil.toDatum(d);
                    String lastDayString = TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z").format(lastDay, null);
                    snew.append(s.replace("lastminute", lastDayString));
                    continue;
                }
                snew.append(s);
            }
            string = snew.toString();
        }
        string = string.replaceAll("\\+", " ");
        return new TimeRangeParser().parse(string);
    }

    public static DatumRange parseTimeRangeValid(String s) {
        try {
            return DatumRangeUtil.parseTimeRange(s);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String efficientTime(Datum time, Datum time2, DatumRange context) {
        Datum[] times;
        TimeUtil.TimeStruct ts = TimeUtil.toTimeStruct(time);
        int stopRes = 4;
        if (TimeUtil.getSecondsSinceMidnight(time) == 0.0 && time.equals(context.max())) {
            ts.hour = 24;
            --ts.day;
        }
        String timeString = "" + ts.hour + ":";
        for (Datum t : times = new Datum[]{time, time2}) {
            int idigit;
            int[] arr = TimeUtil.toTimeArray(t);
            for (idigit = 7; idigit > 3 && arr[idigit] <= 0; --idigit) {
            }
            stopRes = Math.max(stopRes, idigit);
        }
        if (Math.abs(time2.subtract(time).doubleValue(Units.seconds)) > 3600.0) {
            stopRes = Math.min(stopRes, 4);
        }
        int[] arr = TimeUtil.toTimeArray(time);
        if (stopRes > 3) {
            timeString = timeString + (arr[4] < 10 ? "0" : "") + arr[4];
            if (stopRes > 4) {
                int second = arr[5];
                timeString = timeString + ":" + (second < 10 ? "0" : "") + second;
                if (stopRes > 5) {
                    int millis = arr[6];
                    DecimalFormat nf = new DecimalFormat("000");
                    timeString = timeString + "." + nf.format(millis);
                    if (stopRes > 6) {
                        int micros = arr[7];
                        timeString = timeString + nf.format(micros);
                    }
                }
            }
        }
        return timeString;
    }

    public static void setUseDoy(boolean v) {
        useDoy = v;
    }

    public static String formatTimeRange(DatumRange self) {
        return DatumRangeUtil.formatTimeRange(self, false);
    }

    public static String formatTimeRange(DatumRange self, boolean bothDoyYMD) {
        String[] monthStr = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "June", "July", "Aug", "Sep", "Oct", "Nov", "Dec"};
        double seconds = self.width().doubleValue(Units.seconds);
        TimeUtil.TimeStruct ts1 = TimeUtil.toTimeStruct(self.min());
        TimeUtil.TimeStruct ts2 = TimeUtil.toTimeStruct(self.max());
        boolean isMidnight1 = TimeUtil.getSecondsSinceMidnight(self.min()) == 0.0;
        boolean isMidnight2 = TimeUtil.getSecondsSinceMidnight(self.max()) == 0.0;
        boolean isMonthBoundry1 = isMidnight1 && ts1.day == 1;
        boolean isMonthBoundry2 = isMidnight2 && ts2.day == 1;
        boolean isYearBoundry1 = isMonthBoundry1 && ts1.month == 1;
        boolean isYearBoundry2 = isMonthBoundry2 && ts2.month == 1;
        String toDelim = " through ";
        if (isYearBoundry1 && isYearBoundry2) {
            if (ts2.year - ts1.year == 1) {
                return "" + ts1.year;
            }
            return "" + ts1.year + toDelim + (ts2.year - 1);
        }
        if (isMonthBoundry1 && isMonthBoundry2) {
            if (ts2.month == 1) {
                ts2.month = 13;
                --ts2.year;
            }
            if (ts2.year == ts1.year) {
                if (ts2.month - ts1.month == 1) {
                    return monthStr[ts1.month - 1] + " " + ts1.year;
                }
                return monthStr[ts1.month - 1] + toDelim + monthStr[ts2.month - 1 - 1] + " " + ts1.year;
            }
            return monthStr[ts1.month - 1] + " " + ts1.year + toDelim + monthStr[ts2.month - 1 - 1] + " " + ts2.year;
        }
        TimeDatumFormatter daysFormat = bothDoyYMD ? TimeDatumFormatter.DOY_DAYS : (useDoy ? TimeDatumFormatter.DAY_OF_YEAR : TimeDatumFormatter.DAYS);
        if (isMidnight1 && isMidnight2) {
            if (TimeUtil.getJulianDay(self.max()) - TimeUtil.getJulianDay(self.min()) == 1) {
                return ((DatumFormatter)daysFormat).format(self.min());
            }
            Datum endtime = self.max().subtract(Datum.create(1, Units.days));
            return ((DatumFormatter)daysFormat).format(self.min()) + toDelim + ((DatumFormatter)daysFormat).format(endtime);
        }
        TimeDatumFormatter timeOfDayFormatter = seconds < 1.0 ? TimeDatumFormatter.MILLISECONDS : (seconds < 60.0 ? TimeDatumFormatter.MILLISECONDS : (seconds < 3600.0 ? TimeDatumFormatter.SECONDS : TimeDatumFormatter.MINUTES));
        int minDay = TimeUtil.getJulianDay(self.min());
        int maxDay = TimeUtil.getJulianDay(self.max());
        if (TimeUtil.getSecondsSinceMidnight(self.max()) == 0.0) {
            --maxDay;
        }
        if (maxDay == minDay) {
            return ((DatumFormatter)daysFormat).format(self.min()) + " " + DatumRangeUtil.efficientTime(self.min(), self.max(), self) + " to " + DatumRangeUtil.efficientTime(self.max(), self.min(), self);
        }
        ((DatumFormatter)timeOfDayFormatter).format(self.min());
        String sminDay = ((DatumFormatter)daysFormat).format(TimeUtil.prevMidnight(self.min()));
        String smaxDay = ((DatumFormatter)daysFormat).format(self.max());
        if (sminDay.compareTo(smaxDay) > 0) {
            return self.min() + " to " + self.max();
        }
        return sminDay + " " + ((DatumFormatter)timeOfDayFormatter).format(self.min()) + " to " + smaxDay + " " + ((DatumFormatter)timeOfDayFormatter).format(self.max());
    }

    public static List<DatumRange> generateList(DatumRange bounds, DatumRange element) {
        DatumRange dr1;
        DatumRange dr12;
        ArrayList<DatumRange> result = new ArrayList<DatumRange>();
        DatumRange dr = element;
        while (dr.max().le(bounds.min()) && !(dr12 = dr.next()).equals(dr)) {
            dr = dr12;
        }
        while (dr.min().ge(bounds.max()) && !(dr12 = dr.previous()).equals(dr)) {
            dr = dr12;
        }
        boolean stepOutside = true;
        while (dr.max().gt(bounds.min())) {
            dr1 = dr.previous();
            if (dr1.equals(dr)) {
                stepOutside = false;
                break;
            }
            dr = dr1;
        }
        if (stepOutside) {
            dr = dr.next();
        }
        while (dr.min().lt(bounds.max())) {
            result.add(dr);
            dr1 = dr.next();
            if (dr1.equals(dr)) break;
            dr = dr1;
        }
        return result;
    }

    public static DatumRange newDimensionless(double lower, double upper) {
        return new DatumRange(Datum.create(lower), Datum.create(upper));
    }

    public static DatumRange parseDatumRange(String str, Units units) throws ParseException {
        Datum d1;
        Datum d2;
        if (units instanceof TimeLocationUnits) {
            return DatumRangeUtil.parseTimeRange(str);
        }
        String[] ss = str.split("to", 2);
        if (ss.length == 1) {
            ss = str.split("\u2013");
        }
        if (ss.length != 2) {
            throw new ParseException("failed to parse: " + str, 0);
        }
        try {
            d2 = DatumUtil.parse(ss[1]);
            if (d2.getUnits() == Units.dimensionless && units != Units.dimensionless) {
                d2 = units.parse(ss[1]);
            }
        }
        catch (ParseException e) {
            d2 = units.parse(ss[1]);
        }
        if (ss[0].endsWith("+")) {
            ss[0] = ss[0].substring(0, ss[0].length() - 1);
        }
        if ((d1 = d2.getUnits().parse(ss[0])).getUnits().isConvertibleTo(units)) {
            return new DatumRange(d1, d2);
        }
        throw new ParseException("Can't convert parsed unit (" + d1.getUnits() + ") to " + units, 0);
    }

    public static DatumRange parseDatumRange(String str, DatumRange orig) throws ParseException {
        return DatumRangeUtil.parseDatumRange(str, orig.getUnits());
    }

    public static DatumRange parseDatumRange(String str) throws ParseException {
        if ((str = str.trim()).endsWith("UTC")) {
            return DatumRangeUtil.parseTimeRange(str.substring(0, str.length() - 3));
        }
        if (DatumRangeUtil.isISO8601Range(str)) {
            return DatumRangeUtil.parseISO8601Range(str);
        }
        String[] ss = str.split("to", 2);
        if (ss.length == 1) {
            ss = str.split("\u2013");
        }
        if (ss.length == 1) {
            return DatumRangeUtil.parseTimeRange(ss[0]);
        }
        if (ss.length != 2) {
            throw new ParseException("failed to parse: " + str, 0);
        }
        try {
            Datum d2 = DatumUtil.parse(ss[1]);
            Datum d1 = d2.getUnits().parse(ss[0]);
            return new DatumRange(d1, d2);
        }
        catch (ParseException ex) {
            try {
                return DatumRangeUtil.parseTimeRange(str);
            }
            catch (ParseException ex2) {
                if (TimeUtil.isValidTime(ss[0])) {
                    throw ex2;
                }
                throw ex;
            }
        }
    }

    public static Datum[] parseRescaleStr(String s, Datum[] result) throws ParseException {
        String[] ss = s.split("%", -2);
        if (ss.length == 1) {
            result[1] = result[1].getUnits().parse(ss[1]);
        } else {
            result[0] = Units.percent.parse(ss[0]);
            if (ss[1].trim().length() > 0) {
                result[1] = result[1].getUnits().parse(ss[1]);
            }
        }
        return result;
    }

    public static DatumRange rescale(DatumRange dr, String rescale) throws ParseException {
        String[] ss = rescale.split(",");
        Datum[] rrmin = new Datum[]{Units.percent.createDatum(0), dr.getUnits().getOffsetUnits().createDatum(0.0)};
        Datum[] rrmax = new Datum[]{Units.percent.createDatum(100), dr.getUnits().getOffsetUnits().createDatum(0.0)};
        if (ss[0].trim().length() > 0) {
            rrmin = DatumRangeUtil.parseRescaleStr(ss[0], rrmin);
        }
        if (ss[1].trim().length() > 0) {
            rrmax = DatumRangeUtil.parseRescaleStr(ss[1], rrmax);
        }
        DatumRange result = rrmin[0].doubleValue(Units.percent) == 0.0 && rrmax[0].doubleValue(Units.percent) == 100.0 ? dr : DatumRangeUtil.rescale(dr, rrmin[0].doubleValue(Units.percent) / 100.0, rrmax[0].doubleValue(Units.percent) / 100.0);
        result = new DatumRange(result.min().add(rrmin[1]), result.max().add(rrmax[1]));
        return result;
    }

    public static DatumRange rescaleInverse(DatumRange dr, String rescale) throws ParseException {
        String[] ss = rescale.split(",");
        Datum[] rrmin = new Datum[]{Units.percent.createDatum(0), dr.getUnits().getOffsetUnits().createDatum(0.0)};
        Datum[] rrmax = new Datum[]{Units.percent.createDatum(100), dr.getUnits().getOffsetUnits().createDatum(0.0)};
        if (ss[0].trim().length() > 0) {
            rrmin = DatumRangeUtil.parseRescaleStr(ss[0], rrmin);
        }
        if (ss[1].trim().length() > 0) {
            rrmax = DatumRangeUtil.parseRescaleStr(ss[1], rrmax);
        }
        DatumRange result = new DatumRange(dr.min().subtract(rrmin[1]), dr.max().subtract(rrmax[1]));
        double min = rrmin[0].doubleValue(Units.percent) / 100.0;
        double max = rrmax[0].doubleValue(Units.percent) / 100.0;
        result = DatumRangeUtil.rescaleInverse(result, min, max);
        return result;
    }

    public static DatumRange rescale(DatumRange dr, double min, double max) {
        Datum w = dr.width();
        if (!w.isFinite()) {
            throw new RuntimeException("width is not finite (containing fill) in rescale");
        }
        if (w.doubleValue(w.getUnits()) == 0.0) {
            throw new RuntimeException("width is zero in rescale!");
        }
        return new DatumRange(dr.min().add(w.multiply(min)), dr.min().add(w.multiply(max)));
    }

    public static Datum rescale(DatumRange dr, double n) {
        Datum w = dr.width();
        if (!w.isFinite()) {
            throw new RuntimeException("width is not finite (containing fill) in rescale");
        }
        if (w.doubleValue(w.getUnits()) == 0.0) {
            throw new RuntimeException("width is zero in rescale!");
        }
        return dr.min().add(w.multiply(n));
    }

    public static DatumRange rescaleInverse(DatumRange dr, double min, double max) {
        Datum w = dr.width().divide(max - min);
        return new DatumRange(dr.min().add(w.multiply(-min)), dr.min().add(w.multiply(max)));
    }

    public static DatumRange rescaleLog(DatumRange dr, double min, double max) {
        Units u = dr.getUnits();
        double s1 = Math.log10(dr.min().doubleValue(u));
        double s2 = Math.log10(dr.max().doubleValue(u));
        double w = s2 - s1;
        if (w == 0.0) {
            throw new RuntimeException("width is zero!");
        }
        s2 = Math.pow(10.0, s1 + max * w);
        s1 = Math.pow(10.0, s1 + min * w);
        return new DatumRange(s1, s2, u);
    }

    public static DatumRange createCentered(Datum middle, Datum width) {
        Units u = middle.getUnits();
        double m = middle.doubleValue(u);
        double dm = width.doubleValue(u.getOffsetUnits());
        return DatumRange.newDatumRange(m - dm / 2.0, m + dm / 2.0, u);
    }

    public static double normalize(DatumRange dr, Datum d) {
        Units u = dr.getUnits();
        double d0 = dr.min().doubleValue(u);
        double d1 = dr.max().doubleValue(u);
        double dd = d.doubleValue(u);
        return (dd - d0) / (d1 - d0);
    }

    public static double normalize(DatumRange dr, Datum d, boolean log) {
        if (log) {
            return DatumRangeUtil.normalizeLog(dr, d);
        }
        return DatumRangeUtil.normalize(dr, d);
    }

    public static double normalizeLog(DatumRange dr, Datum d) {
        Units u = dr.getUnits();
        double d0 = Math.log(dr.min().doubleValue(u));
        double d1 = Math.log(dr.max().doubleValue(u));
        double dd = Math.log(d.doubleValue(u));
        return (dd - d0) / (d1 - d0);
    }

    public static DatumRange sloppyIntersection(DatumRange range, DatumRange include) {
        Units units = range.getUnits();
        double s11 = range.min().doubleValue(units);
        double s12 = include.min().doubleValue(units);
        double s21 = range.max().doubleValue(units);
        if (range.intersects(include)) {
            double s1 = Math.max(s11, s12);
            double s22 = include.max().doubleValue(units);
            double s2 = Math.min(s21, s22);
            return new DatumRange(s1, s2, units);
        }
        if (s11 < s12) {
            return new DatumRange(s21, s21, units);
        }
        return new DatumRange(s11, s11, units);
    }

    public static List<DatumRange> intersection(List<DatumRange> bounds, List<DatumRange> elements, boolean remove) {
        int is = 0;
        int ns = bounds.size();
        int cs = elements.size();
        ArrayList<DatumRange> result = new ArrayList<DatumRange>();
        ArrayList<DatumRange> contained = new ArrayList<DatumRange>();
        DatumRange lastAdded = null;
        int i = 0;
        while (i < elements.size()) {
            while (is < ns && bounds.get(is).max().le(elements.get(i).min())) {
                ++is;
            }
            if (is == ns) break;
            while (i < cs && elements.get(i).max().le(bounds.get(is).min())) {
                ++i;
            }
            if (i == cs) break;
            DatumRange bounds1 = bounds.get(is);
            if (i >= cs || !bounds1.intersects(elements.get(i))) continue;
            while (i < cs && bounds1.intersects(elements.get(i))) {
                if (remove) {
                    contained.add(elements.get(i));
                }
                ++i;
                if (bounds1 == lastAdded) continue;
                result.add(bounds1);
                lastAdded = bounds1;
            }
            if (lastAdded == bounds.get(is)) {
                ++is;
            }
            if (i <= 0) continue;
            --i;
        }
        if (remove) {
            elements.removeAll(contained);
        }
        return result;
    }

    public static boolean sloppyContains(DatumRange context, Datum datum) {
        return context.contains(datum) || context.max().equals(datum);
    }

    public static DatumRange union(Datum d1, Datum d2) {
        Units units = d1.getUnits();
        if (d1.isFill()) {
            return new DatumRange(d2, d2);
        }
        if (d2.isFill()) {
            return new DatumRange(d1, d1);
        }
        double s1 = d1.doubleValue(units);
        double s2 = d2.doubleValue(units);
        return new DatumRange(Math.min(s1, s2), Math.max(s1, s2), units);
    }

    public static DatumRange union(DatumRange range, Datum include) {
        if (range == null) {
            return new DatumRange(include, include);
        }
        if (include.isFill()) {
            return range;
        }
        Units units = range.getUnits();
        double s11 = range.min().doubleValue(units);
        double s12 = include.doubleValue(units);
        double s21 = range.max().doubleValue(units);
        double s22 = include.doubleValue(units);
        return new DatumRange(Math.min(s11, s12), Math.max(s21, s22), units);
    }

    public static DatumRange union(DatumRange range, DatumRange include) {
        if (include == null) {
            throw new NullPointerException("include argument is null");
        }
        if (range == null) {
            return include;
        }
        Units units = range.getUnits();
        double s11 = range.min().doubleValue(units);
        double s12 = include.min().doubleValue(units);
        double s21 = range.max().doubleValue(units);
        double s22 = include.max().doubleValue(units);
        return new DatumRange(Math.min(s11, s12), Math.max(s21, s22), units);
    }

    public static boolean fuzzyEqual(DatumRange timeRange1, DatumRange timeRange2, double percent) {
        if (timeRange1.width().value() == 0.0) {
            return timeRange1.equals(timeRange2);
        }
        double n0 = DatumRangeUtil.normalize(timeRange1, timeRange2.min());
        double n1 = DatumRangeUtil.normalize(timeRange1, timeRange2.max());
        double p = percent / 100.0;
        return Math.abs(n0) < p && Math.abs(n1 - 1.0) < p;
    }

    public static DatumRange roundSections(DatumRange dr, int n) {
        if (dr.width().value() == 0.0) {
            return dr;
        }
        DomainDivider dd = DomainDividerUtil.getDomainDivider(dr.min(), dr.max());
        while (dd.boundaryCount(dr.min(), dr.max()) > (long)n) {
            dd = dd.coarserDivider(false);
        }
        while (dd.boundaryCount(dr.min(), dr.max()) < (long)n) {
            dd = dd.finerDivider(false);
        }
        DatumRange min = dd.rangeContaining(dr.min());
        DatumRange max = dd.rangeContaining(dr.max());
        if (DatumRangeUtil.normalize(min, dr.min()) > 0.99) {
            min = min.next();
        }
        if (DatumRangeUtil.normalize(max, dr.max()) < 0.01) {
            max = max.previous();
        }
        return DatumRangeUtil.union(min, max);
    }

    static {
        String d = "[-:]";
        String i4 = "(\\d\\d\\d\\d)";
        String i3 = "(\\d+)";
        String i2 = "(\\d\\d)";
        String tz = "((\\+|\\-)(\\d\\d)(:?(\\d\\d))?)";
        String iso8601time = i4 + d + i2 + d + i2 + "T" + i2 + d + i2 + "((" + d + i2 + "(\\." + i3 + ")?)?)Z?";
        String iso8601time2 = i4 + i2 + i2 + "T" + i2 + i2 + "(" + i2 + ")?Z?";
        String iso8601time3 = i4 + d + i3 + "T" + i2 + d + i2 + "(" + i2 + ")?Z?";
        String iso8601time4 = i4 + d + i2 + d + i2 + "Z?";
        String iso8601time5 = i4 + d + i3 + "Z?";
        String iso8601time6 = i4 + d + i2 + d + i2 + "T" + i2 + d + i2 + "((" + d + i2 + "(\\." + i3 + ")?)?)" + tz + "?";
        time1 = Pattern.compile(iso8601time);
        time2 = Pattern.compile(iso8601time2);
        time3 = Pattern.compile(iso8601time3);
        time4 = Pattern.compile(iso8601time4);
        time5 = Pattern.compile(iso8601time5);
        time6 = Pattern.compile(iso8601time6);
        iso8601DurationPattern = Pattern.compile(iso8601duration);
        useDoy = false;
    }

    static class TimeRangeParser {
        String token;
        String delim = "";
        String string;
        int ipos;
        static final int YEAR = 0;
        static final int MONTH = 1;
        static final int DAY = 2;
        static final int HOUR = 3;
        static final int MINUTE = 4;
        static final int SECOND = 5;
        static final int NANO = 6;
        String delimRegEx = "\\s|-|/|\\.|:|to|through|span|UTC|T|Z|\u2013|,";
        Pattern delimPattern = Pattern.compile(this.delimRegEx);
        int[] ts1 = new int[]{-1, -1, -1, -1, -1, -1, -1};
        int[] ts2 = new int[]{-1, -1, -1, -1, -1, -1, -1};
        int[] ts = null;
        boolean beforeTo;
        private final Pattern yyyymmddPattern = Pattern.compile("((\\d{4})(\\d{2})(\\d{2}))( |to|t|-|$)");

        TimeRangeParser() {
        }

        private boolean tryPattern(Pattern regex, String string, int[] groups, DateDescriptor dateDescriptor) throws ParseException {
            Matcher matcher = regex.matcher(string.toLowerCase());
            if (matcher.find() && matcher.start() == 0) {
                String remaining = string.substring(matcher.end());
                try {
                    Integer.parseInt(remaining.trim());
                    logger.fine("number following date prevents use of digits as date.");
                    return false;
                }
                catch (NumberFormatException e) {
                    logger.finer("no number following string which appears to be a date.");
                    dateDescriptor.delim = matcher.group(groups[3]);
                    dateDescriptor.date = string.substring(matcher.start(), matcher.end() - dateDescriptor.delim.length());
                    dateDescriptor.day = matcher.group(groups[2]);
                    dateDescriptor.month = matcher.group(groups[1]);
                    dateDescriptor.year = matcher.group(groups[0]);
                    return true;
                }
            }
            return false;
        }

        public boolean isDate(String string, DateDescriptor dateDescriptor) throws ParseException {
            int[] groups;
            String euroDateRegex;
            if (string.length() < 6) {
                return false;
            }
            String dateDelimRegex = "( |to|t|-)";
            String yearRegex = "(\\d{2}(\\d{2})?)";
            if (this.tryPattern(this.yyyymmddPattern, string, new int[]{2, 3, 4, 5}, dateDescriptor)) {
                dateDescriptor.format = "$Y" + dateDescriptor.delim + "$m" + dateDescriptor.delim + "$d";
                return true;
            }
            String delims = "(/|\\.|-| )";
            Matcher matcher = Pattern.compile(delims).matcher(string);
            if (!matcher.find()) {
                return false;
            }
            String delim1 = string.substring(matcher.start(), matcher.end());
            if (delim1.equals(".")) {
                delim1 = "\\.";
            }
            String monthNameRegex = "(jan[a-z]*|feb[a-z]*|mar[a-z]*|apr[a-z]*|may|june?|july?|aug[a-z]*|sep[a-z]*|oct[a-z]*|nov[a-z]*|dec[a-z]*)";
            String monthRegex = "((\\d?\\d)|" + monthNameRegex + ")";
            String dayRegex = "(\\d?\\d)";
            if (delim1.equals("\\.")) {
                euroDateRegex = "(" + dayRegex + delim1 + monthRegex + delim1 + yearRegex + dateDelimRegex + ")";
                groups = new int[]{6, 3, 2, 8};
            } else {
                euroDateRegex = "(" + dayRegex + delim1 + monthNameRegex + delim1 + yearRegex + dateDelimRegex + ")";
                groups = new int[]{4, 3, 2, 6};
            }
            if (this.tryPattern(Pattern.compile(euroDateRegex), string, groups, dateDescriptor)) {
                dateDescriptor.format = "$d" + delim1 + "$m" + delim1 + "$Y";
                return true;
            }
            String usaDateRegex = monthRegex + delim1 + dayRegex + delim1 + yearRegex + dateDelimRegex;
            if (this.tryPattern(Pattern.compile(usaDateRegex), string, new int[]{5, 1, 4, 7}, dateDescriptor)) {
                dateDescriptor.format = "$m" + delim1 + "$d" + delim1 + "$Y";
                return true;
            }
            String lastDateRegex = "(\\d{4})" + delim1 + monthRegex + delim1 + dayRegex + dateDelimRegex;
            if (this.tryPattern(Pattern.compile(lastDateRegex), string, new int[]{1, 2, 5, 6}, dateDescriptor)) {
                dateDescriptor.format = "$Y" + delim1 + "$m" + delim1 + "$d";
                return true;
            }
            String doyRegex = "(\\d{3})";
            String dateRegex = doyRegex + "(-|/)" + yearRegex + dateDelimRegex;
            if (this.tryPattern(Pattern.compile(dateRegex), string, new int[]{3, 1, 1, 5}, dateDescriptor)) {
                int doy = DatumRangeUtil.parseInt(dateDescriptor.day);
                if (doy > 366) {
                    return false;
                }
                int year = DatumRangeUtil.parseInt(dateDescriptor.year);
                DatumRangeUtil.caldat(DatumRangeUtil.julday(12, 31, year - 1) + doy, dateDescriptor);
                dateDescriptor.format = "$j" + delim1 + "$Y";
                return true;
            }
            dateRegex = yearRegex + "(-|/)" + doyRegex + dateDelimRegex;
            if (this.tryPattern(Pattern.compile(dateRegex), string, new int[]{1, 4, 4, 5}, dateDescriptor)) {
                int doy = DatumRangeUtil.parseInt(dateDescriptor.day);
                if (doy > 366) {
                    return false;
                }
                int year = DatumRangeUtil.parseInt(dateDescriptor.year);
                DatumRangeUtil.caldat(DatumRangeUtil.julday(12, 31, year - 1) + doy, dateDescriptor);
                dateDescriptor.format = "$Y" + delim1 + "$j";
                return true;
            }
            return false;
        }

        private void nextToken() {
            Matcher matcher = this.delimPattern.matcher(this.string.substring(this.ipos));
            if (matcher.find()) {
                int r = matcher.start();
                int length = matcher.end() - matcher.start();
                this.token = this.string.substring(this.ipos, this.ipos + r);
                this.delim = this.string.substring(this.ipos + r, this.ipos + r + length);
                if (this.delim.equals("to") && this.token.length() == 2 && Character.toLowerCase(this.token.charAt(0)) == 'o' && Character.toLowerCase(this.token.charAt(1)) == 'c') {
                    this.token = this.token + this.delim;
                    this.ipos += r + length;
                    matcher = this.delimPattern.matcher(this.string.substring(this.ipos));
                    if (matcher.find()) {
                        r = matcher.start();
                        length = matcher.end() - matcher.start();
                        this.token = this.token + this.string.substring(this.ipos, this.ipos + r);
                        this.delim = this.string.substring(this.ipos + r, this.ipos + r + length);
                    }
                }
                this.ipos = this.ipos + r + length;
            } else {
                this.token = this.string.substring(this.ipos);
                this.delim = "";
                this.ipos = this.string.length();
            }
        }

        private void setBeforeTo(boolean v) {
            this.beforeTo = v;
            this.ts = this.beforeTo ? this.ts1 : this.ts2;
        }

        private String normalizeTo(String s) throws ParseException {
            int minusCount = 0;
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) != '-') continue;
                ++minusCount;
            }
            if (minusCount == 0) {
                return s;
            }
            DateDescriptor dateDescriptor = new DateDescriptor();
            this.ipos = 0;
            StringBuilder newString = new StringBuilder();
            while (this.ipos < s.length()) {
                if (this.isDate(s.substring(this.ipos), dateDescriptor)) {
                    this.ipos = this.ipos + dateDescriptor.date.length() + dateDescriptor.delim.length();
                    this.token = dateDescriptor.date;
                    this.delim = dateDescriptor.delim;
                } else {
                    this.nextToken();
                }
                newString.append(this.token);
                if (this.delim.equals("-")) {
                    newString.append("to");
                    continue;
                }
                newString.append(this.delim);
            }
            String result = newString.toString();
            String[] ss = result.split("to");
            if (ss.length > 2) {
                StringBuilder sb = new StringBuilder(ss[0]);
                for (int i = 1; i < ss.length; ++i) {
                    sb.append("-").append(ss[i]);
                }
                result = sb.toString();
            } else if (ss.length == 2) {
                String s0 = ss[0].trim();
                String s1 = ss[1].trim();
                if (!DatumRangeUtil.isYear(s0) || !DatumRangeUtil.isYear(s1)) {
                    result = s0 + " " + s1;
                }
            }
            return result;
        }

        public DatumRange parse(String stringIn) throws ParseException {
            Datum time2;
            int i;
            int i2;
            int i3;
            DatumRange check = DatumRangeUtil.parseISO8601Range(stringIn);
            if (check != null) {
                return check;
            }
            if (stringIn.contains("/PT")) {
                throw new ParseException("appears to be malformed ISO8601 string: " + stringIn, 0);
            }
            this.string = stringIn + " ";
            this.ipos = 0;
            if (stringIn.length() == 0) {
                throw new ParseException("Unable to parse timerange: empty string", 0);
            }
            ArrayList<String> beforeToUnresolved = new ArrayList<String>();
            ArrayList<String> afterToUnresolved = new ArrayList<String>();
            String[] formatCodes = new String[]{"$y", "$m", "$d", "$H", "$M", "$S", "$N"};
            String[] digitIdentifiers = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "NANO"};
            boolean isThroughNotTo = false;
            boolean YEAR = false;
            boolean MONTH = true;
            int DAY = 2;
            int HOUR = 3;
            int MINUTE = 4;
            int SECOND = 5;
            int NANO = 6;
            int STATE_OPEN = 89;
            int STATE_TS1TIME = 90;
            int STATE_TS2TIME = 91;
            int state = 89;
            String format = "";
            this.setBeforeTo(true);
            DateDescriptor dateDescriptor = new DateDescriptor();
            String newString = this.normalizeTo(this.string);
            if (newString.endsWith("UTC")) {
                newString = newString.substring(0, newString.length() - 3);
            }
            this.string = newString;
            this.ipos = 0;
            while (this.ipos < this.string.length()) {
                boolean isWithinTime;
                String lastdelim = this.delim;
                format = format + lastdelim;
                if (lastdelim.equals("to")) {
                    this.setBeforeTo(false);
                }
                if (lastdelim.equals("through")) {
                    this.setBeforeTo(false);
                    isThroughNotTo = true;
                }
                if (lastdelim.equals("\u2013")) {
                    this.setBeforeTo(false);
                }
                if (lastdelim.equals("span")) {
                    this.setBeforeTo(false);
                    if (this.ts1[2] > -1) {
                        for (int ii = 3; ii <= 6; ++ii) {
                            if (this.ts1[ii] != -1) continue;
                            this.ts1[ii] = 0;
                        }
                    } else {
                        throw new IllegalArgumentException("span needs start date to have day specified");
                    }
                    Datum start = TimeUtil.toDatum(this.ts1);
                    String swidth = newString.substring(this.ipos);
                    swidth = this.makeCanonicalTimeWidthString(swidth);
                    Datum width = DatumUtil.parse(swidth);
                    Datum stop = start.add(width);
                    TimeUtil.TimeStruct tt = TimeUtil.toTimeStruct(stop);
                    this.ts2[2] = tt.day;
                    this.ts2[1] = tt.month;
                    this.ts2[0] = tt.year;
                    this.ts2[3] = tt.hour;
                    this.ts2[4] = tt.minute;
                    this.ts2[5] = (int)tt.seconds;
                    this.ts2[6] = (int)((tt.seconds - (double)this.ts2[5]) * 1.0E9) + tt.millis * 1000000 + tt.micros * 1000;
                    this.ipos = newString.length();
                }
                if (this.isDate(this.string.substring(this.ipos), dateDescriptor)) {
                    int day;
                    format = format + dateDescriptor.format;
                    if (this.ts1[2] != -1 || this.ts1[1] != -1 || this.ts1[0] != -1) {
                        this.setBeforeTo(false);
                    }
                    int month = DatumRangeUtil.monthNumber(dateDescriptor.month);
                    int year = DatumRangeUtil.y2k(dateDescriptor.year);
                    this.ts[2] = day = DatumRangeUtil.parseInt(dateDescriptor.day);
                    this.ts[1] = month;
                    this.ts[0] = year;
                    this.delim = dateDescriptor.delim;
                    this.ipos = this.ipos + dateDescriptor.date.length() + dateDescriptor.delim.length();
                    continue;
                }
                this.nextToken();
                if (this.token.equals("")) continue;
                if (DatumRangeUtil.isYear(this.token)) {
                    format = format + "$Y";
                    if (this.ts1[0] == -1 && this.beforeTo) {
                        this.ts1[0] = DatumRangeUtil.parseInt(this.token);
                        this.ts2[0] = this.ts1[0];
                        continue;
                    }
                    this.setBeforeTo(false);
                    this.ts2[0] = DatumRangeUtil.parseInt(this.token);
                    if (this.ts1[0] != -1) continue;
                    this.ts1[0] = this.ts2[0];
                    continue;
                }
                if (DatumRangeUtil.isDayOfYear(this.token)) {
                    format = format + "$j";
                    if (this.ts1[0] == -1) {
                        throw new ParseException("day of year before year: " + stringIn + " (" + format + ")", this.ipos);
                    }
                    int doy = DatumRangeUtil.parseInt(this.token);
                    DatumRangeUtil.caldat(DatumRangeUtil.julday(12, 31, this.ts1[0] - 1) + doy, dateDescriptor);
                    int day = DatumRangeUtil.parseInt(dateDescriptor.day);
                    int month = DatumRangeUtil.parseInt(dateDescriptor.month);
                    if (this.ts1[2] == -1 && this.beforeTo) {
                        this.ts1[2] = day;
                        this.ts1[1] = month;
                        this.ts2[2] = day;
                        this.ts2[1] = month;
                        continue;
                    }
                    this.setBeforeTo(false);
                    this.ts2[2] = day;
                    this.ts2[1] = month;
                    if (this.ts1[2] != -1) continue;
                    this.ts1[2] = day;
                    this.ts1[1] = month;
                    continue;
                }
                if (DatumRangeUtil.monthNameNumber(this.token) != -1) {
                    format = format + "$b";
                    int month = DatumRangeUtil.monthNameNumber(this.token);
                    if (this.ts1[1] == -1) {
                        this.ts1[1] = month;
                        this.ts2[1] = month;
                        continue;
                    }
                    this.setBeforeTo(false);
                    this.ts2[1] = month;
                    if (this.ts1[1] != -1) continue;
                    this.ts1[1] = month;
                    continue;
                }
                boolean bl = isWithinTime = this.delim.equals(":") || lastdelim.equals(":");
                if (isWithinTime) {
                    if (this.delim.equals(":") && !lastdelim.equals(":") && state == 89) {
                        format = format + "$H";
                        if (this.beforeTo && this.ts1[3] == -1) {
                            state = 90;
                        } else {
                            this.setBeforeTo(false);
                            state = 91;
                        }
                        this.ts[3] = DatumRangeUtil.parseInt(this.token);
                    } else {
                        int i4;
                        for (i4 = 3; i4 <= 6 && this.ts[i4] != -1; ++i4) {
                        }
                        if (i4 == 5 && this.delim.equals(".")) {
                            this.ts[i4] = DatumRangeUtil.parseInt(this.token);
                            format = format + formatCodes[i4];
                            this.nextToken();
                            i4 = 6;
                        }
                        if (i4 == 6) {
                            int tokenDigits = this.token.length();
                            this.ts[i4] = DatumRangeUtil.parseInt(this.token) * (int)Math.pow(10.0, 9 - tokenDigits);
                            switch (tokenDigits) {
                                case 3: {
                                    format = format + "$(subsec,places=3)";
                                    break;
                                }
                                case 6: {
                                    format = format + "$(subsec,places=6)";
                                    break;
                                }
                                default: {
                                    format = format + "$N";
                                    break;
                                }
                            }
                        } else {
                            this.ts[i4] = DatumRangeUtil.parseInt(this.token);
                            format = format + formatCodes[i4];
                        }
                    }
                    if (this.delim.equals(":") || this.delim.equals(".")) continue;
                    state = 89;
                    continue;
                }
                if (this.beforeTo) {
                    beforeToUnresolved.add(this.token);
                    format = format + "UNRSV1" + beforeToUnresolved.size();
                    continue;
                }
                afterToUnresolved.add(this.token);
                format = format + "UNRSV2" + afterToUnresolved.size();
            }
            format = format + " ";
            StringBuilder stringBuffer = new StringBuilder("ts1: ");
            for (i3 = 0; i3 < 7; ++i3) {
                stringBuffer.append("").append(this.ts1[i3]).append(" ");
            }
            logger.fine(stringBuffer.toString());
            stringBuffer = new StringBuilder("ts2: ");
            for (i3 = 0; i3 < 7; ++i3) {
                stringBuffer.append("").append(this.ts2[i3]).append(" ");
            }
            logger.fine(stringBuffer.toString());
            logger.fine(format);
            if (this.beforeTo) {
                int idx = 0;
                for (i3 = 0; i3 < beforeToUnresolved.size(); ++i3) {
                    while (idx < 7 && this.ts1[idx] != -1) {
                        ++idx;
                    }
                    if (idx == 7) {
                        throw new ParseException("can't resolve token in \"" + stringIn + "\": " + beforeToUnresolved.get(i3) + " (" + format + ")", 0);
                    }
                    this.ts1[idx] = DatumRangeUtil.parseInt((String)beforeToUnresolved.get(i3));
                    String[] s = format.split("UNRSV1" + (i3 + 1), -2);
                    format = s[0] + formatCodes[idx] + s[1];
                }
                beforeToUnresolved.clear();
            }
            if (beforeToUnresolved.size() + afterToUnresolved.size() > 0) {
                String formatUn;
                ArrayList<String> unload;
                String[] s;
                int idx;
                if (beforeToUnresolved.size() < afterToUnresolved.size()) {
                    if (beforeToUnresolved.size() > 0) {
                        for (int i5 = 0; i5 < afterToUnresolved.size(); ++i5) {
                            while (idx < 7 && this.ts2[idx] != -1) {
                                ++idx;
                            }
                            if (idx == 7) {
                                throw new ParseException("can't resolve token in \"" + stringIn + "\": " + afterToUnresolved.get(i5) + " (" + format + ")", 0);
                            }
                            this.ts2[idx] = DatumRangeUtil.parseInt((String)afterToUnresolved.get(i5));
                            s = format.split("UNRSV2" + (i5 + 1));
                            format = s[0] + formatCodes[idx] + s[1];
                        }
                        unload = beforeToUnresolved;
                        formatUn = "UNRSV1";
                        this.ts = this.ts1;
                    } else {
                        for (idx = 0; idx < 7 && this.ts1[idx] != -1; ++idx) {
                        }
                        if (idx > 0) {
                            --idx;
                        }
                        unload = afterToUnresolved;
                        formatUn = "UNRSV2";
                        this.ts = this.ts2;
                    }
                } else if (afterToUnresolved.size() > 0) {
                    for (int i6 = 0; i6 < beforeToUnresolved.size(); ++i6) {
                        while (idx < 7 && this.ts1[idx] != -1) {
                            ++idx;
                        }
                        if (idx == 7) {
                            throw new ParseException("can't resolve token in \"" + stringIn + "\": " + beforeToUnresolved.get(i6) + " (" + format + ")", 0);
                        }
                        this.ts1[idx] = DatumRangeUtil.parseInt((String)beforeToUnresolved.get(i6));
                        if (idx == 0 && this.ts[idx] < 1000) {
                            throw new ParseException("Years must be four digit years: " + (String)beforeToUnresolved.get(i6), 0);
                        }
                        s = format.split("UNRSV1" + (i6 + 1));
                        format = s[0] + formatCodes[idx] + s[1];
                    }
                    unload = afterToUnresolved;
                    formatUn = "UNRSV2";
                    this.ts = this.ts2;
                } else {
                    while (idx < 7 && this.ts2[idx] != -1) {
                        ++idx;
                    }
                    if (idx > 0) {
                        --idx;
                    }
                    unload = beforeToUnresolved;
                    formatUn = "UNRSV1";
                    this.ts = this.ts1;
                }
                int lsd = idx;
                for (int i7 = unload.size() - 1; i7 >= 0; --i7) {
                    while (this.ts[lsd] != -1 && lsd > 0) {
                        --lsd;
                    }
                    if (this.ts[lsd] != -1) {
                        throw new ParseException("can't resolve these tokens in \"" + stringIn + "\": " + unload + " (" + format + ")", 0);
                    }
                    this.ts[lsd] = DatumRangeUtil.parseInt((String)unload.get(i7));
                    String[] s2 = format.split(formatUn + (i7 + 1));
                    format = s2[0] + formatCodes[lsd] + s2[1];
                }
            }
            stringBuffer = new StringBuilder("ts1: ");
            for (i2 = 0; i2 < 7; ++i2) {
                stringBuffer.append("").append(this.ts1[i2]).append(" ");
            }
            logger.fine(stringBuffer.toString());
            stringBuffer = new StringBuilder("ts2: ");
            for (i2 = 0; i2 < 7; ++i2) {
                stringBuffer.append("").append(this.ts2[i2]).append(" ");
            }
            logger.fine(stringBuffer.toString());
            logger.fine(format);
            for (i = 0; i <= 2; ++i) {
                if (this.ts2[i] == -1 && this.ts1[i] != -1) {
                    this.ts2[i] = this.ts1[i];
                }
                if (this.ts1[i] != -1 || this.ts2[i] == -1) continue;
                this.ts1[i] = this.ts2[i];
            }
            int[] implicit_timearr = new int[]{-1, 1, 1, 0, 0, 0, 0};
            int ts1lsd = -1;
            int ts2lsd = -1;
            for (i = 6; i >= 0; --i) {
                if (this.ts2[i] != -1 && ts2lsd == -1) {
                    ts2lsd = i;
                }
                if (ts2lsd == -1) {
                    this.ts2[i] = implicit_timearr[i];
                }
                if (this.ts2[i] == -1 && ts2lsd != -1) {
                    throw new ParseException("not specified in stop time: " + digitIdentifiers[i] + " in " + stringIn + " (" + format + ")", this.ipos);
                }
                if (this.ts1[i] != -1 && ts1lsd == -1) {
                    ts1lsd = i;
                }
                if (ts1lsd == -1) {
                    this.ts1[i] = implicit_timearr[i];
                }
                if (this.ts1[i] != -1 || ts1lsd == -1) continue;
                throw new ParseException("not specified in start time:" + digitIdentifiers[i] + " in " + stringIn + " (" + format + ")", this.ipos);
            }
            if (ts1lsd != ts2lsd && this.beforeTo) {
                throw new ParseException("expected to find \"to\" when hours are specified", 0);
            }
            if (ts1lsd != ts2lsd && (ts1lsd < 3 || ts2lsd < 3)) {
                throw new ParseException("resolution mismatch: " + digitIdentifiers[ts1lsd] + " specified for start, but " + digitIdentifiers[ts2lsd] + " specified for end, must be same in \"" + stringIn + "\" (" + format + ")", this.ipos);
            }
            if (this.beforeTo) {
                isThroughNotTo = true;
            }
            if (isThroughNotTo) {
                if (ts2lsd < 0) {
                    throw new ParseException("cannot interpret as time", this.ipos);
                }
                int n = ts2lsd;
                this.ts2[n] = this.ts2[n] + 1;
            }
            if (this.ts1[0] < 1900) {
                this.ts1[0] = DatumRangeUtil.y2k("" + this.ts1[0]);
            }
            if (this.ts2[0] < 1900) {
                this.ts2[0] = DatumRangeUtil.y2k("" + this.ts2[0]);
            }
            if (this.ts1[0] > 9000) {
                throw new ParseException("Year cannot be greater than 9000: " + this.ts1[0], 0);
            }
            if (this.ts2[0] > 9001) {
                throw new ParseException("Year cannot be greater than 9000: " + this.ts2[0], 0);
            }
            if (ts1lsd < 2) {
                try {
                    return new MonthDatumRange(this.ts1, this.ts2);
                }
                catch (IllegalArgumentException e) {
                    ParseException eNew = new ParseException("fails to parse due to MonthDatumRange: " + stringIn + " (" + format + ") " + e.getMessage(), 0);
                    eNew.initCause(e);
                    throw eNew;
                }
            }
            Datum time1 = TimeUtil.createTimeDatum(this.ts1[0], this.ts1[1], this.ts1[2], this.ts1[3], this.ts1[4], this.ts1[5], this.ts1[6]);
            if (time1.le(time2 = TimeUtil.createTimeDatum(this.ts2[0], this.ts2[1], this.ts2[2], this.ts2[3], this.ts2[4], this.ts2[5], this.ts2[6]))) {
                return new DatumRange(time1, time2);
            }
            throw new ParseException(String.format("First time is after second time: %s after %s", time1, time2), 0);
        }

        private String makeCanonicalTimeWidthString(String swidth) {
            if (swidth.contains("day") && !swidth.contains("days")) {
                swidth = swidth.replaceAll("day ", "days");
            }
            swidth = swidth.replaceAll("hrs", "hr");
            swidth = swidth.replaceAll("mins", "min");
            swidth = swidth.replaceAll("secs", "s");
            swidth = swidth.replaceAll("sec", "s");
            swidth = swidth.replaceAll("msec", "ms");
            return swidth;
        }
    }

    public static class DateDescriptor {
        String date;
        String year;
        String month;
        String day;
        String delim;
        String format;
    }
}

