/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatterFactory;
import org.das2.datum.format.DefaultDatumFormatterFactory;

public class NumberUnits
extends Units {
    private static Pattern expressionPattern = Pattern.compile("(.+)(\\*)(.+)");

    public NumberUnits(String id) {
        this(id, "");
    }

    public NumberUnits(String id, String description) {
        super(id, description);
    }

    @Override
    public Datum createDatum(double value) {
        return new Datum.Double(value, (Units)this, 0.0);
    }

    @Override
    public Datum createDatum(double value, double resolution) {
        return new Datum.Double(value, (Units)this, resolution);
    }

    @Override
    public Datum createDatum(int value) {
        return new Datum.Double(value, (Units)this);
    }

    @Override
    public Datum createDatum(long value) {
        return new Datum.Long(value, this);
    }

    @Override
    public Datum createDatum(Number value) {
        return new Datum.Double(value, (Units)this);
    }

    @Override
    public Datum createDatum(Datum value) {
        if (value.getUnits() == this) {
            return value;
        }
        return value.convertTo(this);
    }

    @Override
    public DatumFormatterFactory getDatumFormatterFactory() {
        return DefaultDatumFormatterFactory.getInstance();
    }

    private static double[] parseDecimal(String s) {
        if ((s = s.trim()).startsWith("x")) {
            return new double[]{Integer.parseInt(s.substring(1), 16), 0.0};
        }
        if (s.startsWith("0x")) {
            return new double[]{Integer.parseInt(s.substring(2), 16), 0.0};
        }
        if (s.equalsIgnoreCase("nan")) {
            return new double[]{Double.NaN, 0.0};
        }
        BigDecimal bd = new BigDecimal(s);
        if (bd.scale() > 0) {
            double resolution = Math.pow(10.0, -1 * bd.scale());
            return new double[]{Double.parseDouble(s), resolution};
        }
        int ie = s.indexOf(69);
        if (ie == -1) {
            ie = s.indexOf(101);
        }
        if (ie == -1) {
            int id = s.indexOf(46);
            double[] dd = new double[2];
            dd[0] = Double.parseDouble(s);
            if (id == -1) {
                dd[1] = 1.0;
            } else {
                int scale = s.length() - id - 1;
                dd[1] = Math.pow(10.0, -1 * scale);
            }
            return dd;
        }
        String mant = s.substring(0, ie);
        double[] dd = NumberUnits.parseDecimal(mant);
        double exp = Math.pow(10.0, Double.parseDouble(s.substring(ie + 1)));
        dd[0] = dd[0] * exp;
        dd[1] = dd[1] * exp;
        return dd;
    }

    private Datum parseExpression(String s) throws ParseException {
        Datum result;
        Datum operand2;
        Datum operand1;
        Matcher m = expressionPattern.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException("not an expression");
        }
        String operator = m.group(2);
        try {
            operand1 = Units.dimensionless.parse(m.group(1));
        }
        catch (IllegalArgumentException e) {
            operand1 = this.parse(m.group(1));
        }
        try {
            operand2 = Units.dimensionless.parse(m.group(3));
        }
        catch (IllegalArgumentException e) {
            operand2 = this.parse(m.group(3));
        }
        switch (operator) {
            case "*": {
                result = operand1.multiply(operand2);
                break;
            }
            case "/": {
                result = operand1.divide(operand2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad operator: " + operator + " of expression " + s);
            }
        }
        return result;
    }

    @Override
    public Datum parse(String s) throws ParseException {
        try {
            Units u;
            s = s.trim();
            if (this != Units.dimensionless && s.endsWith(this.getId())) {
                char cbefore = '\u0000';
                if (s.length() > this.getId().length() + 1) {
                    cbefore = s.charAt(s.length() - 2);
                }
                if (!Character.isLetter(cbefore)) {
                    s = s.substring(0, s.length() - this.getId().length());
                }
            }
            if (s.length() == 0) {
                throw new ParseException("String contains no numeric part to parse into Datum", 0);
            }
            String[] ss = s.split("\\s+");
            if (!(ss.length != 1 || !Character.isLetter(s.charAt(s.length() - 1)) || s.startsWith("N") || s.startsWith("n") || s.startsWith("x") || s.startsWith("0x"))) {
                for (int i = s.length() - 1; i >= 0; --i) {
                    if (!Character.isDigit(s.charAt(i))) continue;
                    String[] ss2 = new String[]{ss[0].substring(0, i + 1), ss[0].substring(i + 1)};
                    ss = ss2;
                    break;
                }
            }
            double[] dd = NumberUnits.parseDecimal(ss[0]);
            if (ss.length == 1) {
                return Datum.create(dd[0], (Units)this, 0.0);
            }
            StringBuilder unitsString = new StringBuilder(ss[1]);
            for (int i = 2; i < ss.length; ++i) {
                unitsString.append(" ").append(ss[i]);
            }
            try {
                u = Units.getByName(unitsString.toString());
            }
            catch (IllegalArgumentException e) {
                ParseException t = new ParseException(s, ss[0].length() + 1);
                t.initCause(e);
                throw t;
            }
            UnitsConverter uc = u.getConverter(this);
            return Datum.create(uc.convert(dd[0]), (Units)this, 0.0);
        }
        catch (NumberFormatException nfe) {
            if (s.equalsIgnoreCase("fill")) {
                return this.getFillDatum();
            }
            ParseException pe = new ParseException("Unable to parse Datum in string: " + s, 0);
            pe.initCause(nfe);
            throw pe;
        }
    }

    protected static Number add(Number a, Number value) {
        if (a instanceof Integer && value instanceof Integer) {
            return a.intValue() + value.intValue();
        }
        return a.doubleValue() + value.doubleValue();
    }

    protected static Number subtract(Number from, Number value) {
        if (from instanceof Integer && value instanceof Integer) {
            return from.intValue() - value.intValue();
        }
        return from.doubleValue() - value.doubleValue();
    }

    protected static Number divide(Number a, Number value) {
        if (a instanceof Integer && value instanceof Integer) {
            return a.intValue() / value.intValue();
        }
        return a.doubleValue() / value.doubleValue();
    }

    protected static Number multiply(Number a, Number value) {
        if (a instanceof Integer && value instanceof Integer) {
            return a.intValue() * value.intValue();
        }
        return a.doubleValue() * value.doubleValue();
    }

    @Override
    public Datum add(Number a, Number b, Units bUnits) {
        if (bUnits != this) {
            UnitsConverter uc = Units.getConverter(bUnits, this);
            b = uc.convert(b);
        }
        return this.createDatum(NumberUnits.add(a, b));
    }

    @Override
    public Datum subtract(Number a, Number b, Units bUnits) {
        if (bUnits != this) {
            UnitsConverter uc = Units.getConverter(bUnits, this);
            b = uc.convert(b);
        }
        return this.createDatum(NumberUnits.subtract(a, b));
    }

    @Override
    public Datum multiply(Number a, Number b, Units bUnits) {
        if (bUnits == Units.dimensionless) {
            return this.createDatum(NumberUnits.multiply(a, b));
        }
        if (this == Units.dimensionless) {
            return bUnits.createDatum(NumberUnits.multiply(a, b));
        }
        Units inv = UnitsUtil.getInverseUnit(bUnits);
        UnitsConverter uc = this.getConverter(inv);
        if (uc == null) {
            throw new IllegalArgumentException("Multiplication of two non-dimensionless numbers is not supported");
        }
        return Units.dimensionless.createDatum(NumberUnits.multiply(uc.convert(a), b));
    }

    @Override
    public Datum divide(Number a, Number b, Units bUnits) {
        if (bUnits == Units.dimensionless) {
            return this.createDatum(NumberUnits.divide(a, b));
        }
        if (this == Units.dimensionless) {
            try {
                Units inv = UnitsUtil.getInverseUnit(bUnits);
                return inv.createDatum(NumberUnits.divide(a, b));
            }
            catch (IllegalArgumentException ex) {
                if (bUnits.isConvertibleTo(Units.seconds)) {
                    double factor = bUnits.convertDoubleTo(Units.seconds, 1.0);
                    return Units.hertz.createDatum(NumberUnits.divide(a, b).doubleValue() / factor);
                }
                throw new IllegalArgumentException("No inversion found for " + bUnits);
            }
        }
        UnitsConverter uc = bUnits.getConverter(this);
        if (uc == null) {
            throw new IllegalArgumentException("Only division by dimensionless or convertable Datums is supported");
        }
        return Units.dimensionless.createDatum(NumberUnits.divide(a, uc.convert(b)));
    }
}

