/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

public class Ratio {
    int numerator;
    int denominator;
    public static final Ratio one = new Ratio(1);
    public static final Ratio zero = new Ratio(0);

    public Ratio(int i) {
        this.numerator = i;
        this.denominator = 1;
    }

    public Ratio(int n, int d) {
        if (n % d == 0) {
            n /= d;
            d = 1;
        }
        this.numerator = n;
        this.denominator = d;
    }

    public static long gcd(long a, long d) {
        if (a < d) {
            long t = a;
            a = d;
            d = t;
        }
        if (d == 0L) {
            return a;
        }
        long r = a % d;
        while (r > 0L) {
            d = r;
            r = a % d;
        }
        return d;
    }

    public static Ratio create(String s) {
        s = s.toLowerCase();
        int ipt = s.indexOf(".");
        int ien = s.length();
        int ie = s.lastIndexOf("e");
        int exp = 0;
        if (ie > -1) {
            exp = Integer.parseInt(s.substring(ie + 1));
            if (ipt == -1) {
                ipt = ie;
            }
        } else if (ipt == -1) {
            ipt = s.length();
        }
        int n = ipt > 0 ? Integer.parseInt(s.substring(0, ipt)) : 0;
        if (ipt == ie) {
            if (exp > 0) {
                n *= (int)Math.pow(10.0, exp);
            } else if (exp < 0) {
                throw new IllegalArgumentException("exponent must be positive, use rational Number");
            }
            return new Ratio(n);
        }
        int d = ipt + 1 < ien ? Integer.parseInt(s.substring(ipt + 1, ien)) : 0;
        int np = d == 0 ? 0 : (int)Math.log10(d) + 1;
        n = n * (int)Math.pow(10.0, np) + d;
        d = (int)Math.pow(10.0, np);
        if (exp > 0) {
            n = n * 10 ^ exp;
            return new Ratio(n, d);
        }
        return new Ratio(n, d);
    }

    public static Ratio create(double number) {
        long gcd;
        if (number == 0.0) {
            return zero;
        }
        if (Double.isNaN(number)) {
            throw new IllegalArgumentException("NaN is not supported");
        }
        long bits = Double.doubleToLongBits(number);
        long sign = bits >>> 63;
        long exponent = (bits >>> 52 ^ sign << 11) - 1023L;
        long fraction = bits << 12;
        long a = 1L;
        long b = 1L;
        for (int i = 63; i >= 33; --i) {
            a = a * 2L + (fraction >>> i & 1L);
            b *= 2L;
        }
        if (exponent > 0L) {
            a *= (long)(1 << (int)exponent);
        } else {
            b *= (long)(1 << (int)(-exponent));
        }
        if (sign == 1L) {
            a *= -1L;
        }
        if ((gcd = Ratio.gcd(a, b)) > 1L) {
            a /= gcd;
            b /= gcd;
        }
        if (a < Integer.MIN_VALUE || a > Integer.MAX_VALUE) {
            return Ratio.create(Math.round(number / 1000.0) * 1000L);
        }
        if (b < Integer.MIN_VALUE || b > Integer.MAX_VALUE) {
            return Ratio.create(Math.round(number / 1000.0) * 1000L);
        }
        return new Ratio((int)a, (int)b);
    }

    public Ratio pow(Ratio r) {
        if (r.denominator == 1) {
            return new Ratio((int)Math.pow(this.numerator, r.numerator), (int)Math.pow(this.denominator, r.numerator));
        }
        return Ratio.create(Math.pow(this.numerator, r.doubleValue()) / Math.pow(this.denominator, r.doubleValue()));
    }

    public Ratio sqrt() {
        return Ratio.create(Math.sqrt(this.numerator) / Math.sqrt(this.denominator));
    }

    public Ratio multiply(Ratio r) {
        return new Ratio(this.numerator * r.numerator, this.denominator * r.denominator);
    }

    public Ratio divide(Ratio r) {
        return new Ratio(this.numerator / r.numerator, this.denominator / r.denominator);
    }

    public Ratio add(Ratio r) {
        return new Ratio(this.numerator * r.denominator + r.numerator * this.denominator, this.denominator * r.denominator);
    }

    public Ratio subtract(Ratio r) {
        return new Ratio(this.numerator * r.denominator - r.numerator * this.denominator, this.denominator * r.denominator);
    }

    public boolean isZero() {
        return this.numerator == 0;
    }

    public boolean isOne() {
        return this.numerator == this.denominator;
    }

    public int hashCode() {
        return Double.valueOf((double)this.numerator / (double)this.denominator).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Ratio) {
            Ratio r = (Ratio)o;
            return r.numerator * this.denominator == r.denominator * this.numerator;
        }
        return super.equals(o);
    }

    public String toString() {
        if (this.denominator == 1) {
            return String.format("%d", this.numerator);
        }
        if (this.denominator < 100) {
            return String.format("%d/%d", this.numerator, this.denominator);
        }
        return String.valueOf((double)this.numerator / (double)this.denominator);
    }

    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public static void main(String[] args) {
        System.err.println(Ratio.create("1.3"));
        System.err.println(Ratio.create(".13"));
        System.err.println(Ratio.create("13."));
        System.err.println(Ratio.create("13.00"));
        System.err.println(new Ratio(4, 1).sqrt());
    }
}

