/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.util.LoggerManager;

public class Expect {
    static final Logger log = LoggerManager.getLogger("expect");
    private final OutputStream output;
    private Pipe.SourceChannel inputChannel;
    private Selector selector;
    private Process process = null;
    private int default_timeout = 60;
    private boolean restart_timeout_upon_receive = false;
    private StringBuffer buffer = new StringBuffer();
    private boolean notransfer = false;
    public String before;
    public String match;
    public boolean isSuccess = false;
    public static final int RETV_TIMEOUT = -1;
    public static final int RETV_EOF = -2;
    public static final int RETV_IOEXCEPTION = -9;
    private IOException thrownIOE;
    private static PrintStream duplicatedTo = null;

    public Expect(InputStream input, OutputStream output) {
        try {
            this.inputChannel = Expect.inputStreamToSelectableChannel(input);
            this.selector = Selector.open();
            this.inputChannel.register(this.selector, 1);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Fatal error when initializing pipe or selector", e);
        }
        this.output = output;
    }

    private static Pipe.SourceChannel inputStreamToSelectableChannel(final InputStream input) throws IOException {
        Pipe pipe = Pipe.open();
        pipe.source().configureBlocking(false);
        final OutputStream out = Channels.newOutputStream(pipe.sink());
        Thread piping = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] buffer = new byte[8192];
                try {
                    int n = 0;
                    while (n != -1) {
                        out.write(buffer, 0, n);
                        if (duplicatedTo != null) {
                            String toWrite = new String(buffer, 0, n);
                            duplicatedTo.append(toWrite);
                        }
                        n = input.read(buffer);
                    }
                    log.fine("EOF from InputStream");
                    input.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "IOException when piping from InputStream, now the piping thread will end", e);
                }
                finally {
                    try {
                        log.fine("closing sink of the pipe");
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        piping.setName("Piping InputStream to SelectableChannel Thread");
        piping.setDaemon(true);
        piping.start();
        return pipe.source();
    }

    public Process getProcess() {
        return this.process;
    }

    public static Expect spawn(String command) {
        Process p;
        ProcessBuilder pb = new ProcessBuilder(command.split(" "));
        pb.redirectErrorStream(true);
        try {
            p = pb.start();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error when spawning command: " + command, e);
            throw new IllegalArgumentException("Error when spawning command: " + command);
        }
        Expect retv = new Expect(p.getInputStream(), p.getOutputStream());
        retv.process = p;
        return retv;
    }

    public void send(String str) {
        this.send(str.getBytes());
    }

    public void send(byte[] toWrite) {
        log.log(Level.INFO, "sending: {0}", Expect.bytesToPrintableString(toWrite));
        try {
            this.output.write(toWrite);
            this.output.flush();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error when sending bytes to output", e);
        }
    }

    public int expect(Object ... patterns) {
        return this.expect(this.default_timeout, patterns);
    }

    public int expect(int timeout, Object ... patterns) {
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        for (Object o : patterns) {
            if (o instanceof String) {
                list.add(Pattern.compile(Pattern.quote((String)o)));
                continue;
            }
            if (o instanceof Pattern) {
                list.add((Pattern)o);
                continue;
            }
            log.log(Level.WARNING, "Object {0} (class: {1}) is neither a String nor a java.util.regex.Pattern, using as a literal String", new Object[]{o.toString(), o.getClass().getName()});
            list.add(Pattern.compile(Pattern.quote(o.toString())));
        }
        return this.expect(timeout, list);
    }

    public int expect(int timeout, List<Pattern> list) {
        log.log(Level.FINE, "Expecting {0}", list);
        this.clearGlobalVariables();
        long endTime = System.currentTimeMillis() + (long)timeout * 1000L;
        try {
            ByteBuffer bytes = ByteBuffer.allocate(8192);
            while (true) {
                for (int i = 0; i < list.size(); ++i) {
                    log.log(Level.FINER, "trying to match {0} against buffer \"{1}\"", new Object[]{list.get(i), this.buffer});
                    Matcher m = list.get(i).matcher(this.buffer);
                    if (!m.find()) continue;
                    log.finer("success!");
                    int matchStart = m.start();
                    int matchEnd = m.end();
                    this.before = this.buffer.substring(0, matchStart);
                    this.match = m.group();
                    this.isSuccess = true;
                    if (!this.notransfer) {
                        this.buffer.delete(0, matchEnd);
                    }
                    return i;
                }
                long waitTime = endTime - System.currentTimeMillis();
                if (this.restart_timeout_upon_receive) {
                    waitTime = timeout * 1000;
                }
                if (waitTime <= 0L) {
                    log.log(Level.FINE, "Timeout when expecting {0}", list);
                    return -1;
                }
                this.selector.select(waitTime);
                if (this.selector.selectedKeys().isEmpty()) {
                    log.log(Level.FINE, "Timeout when expecting {0}", list);
                    return -1;
                }
                this.selector.selectedKeys().clear();
                int n = this.inputChannel.read(bytes);
                if (n == -1) {
                    log.log(Level.FINE, "EOF when expecting {0}", list);
                    return -2;
                }
                log.log(Level.FINEST, "read bytes: {0}", n);
                StringBuilder tmp = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    this.buffer.append((char)bytes.get(i));
                    tmp.append(Expect.byteToPrintableString(bytes.get(i)));
                }
                log.log(Level.FINE, "Obtained following from InputStream: {0}", tmp);
                bytes.clear();
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "IOException when selecting or reading", e);
            this.thrownIOE = e;
            return -9;
        }
    }

    public void printDebugInfo() {
        System.err.println("before: " + this.before);
        System.err.println("isSuccess: " + this.isSuccess);
        System.err.println("match: " + this.match);
    }

    public int expectEOF(int timeout) {
        int retv = this.expect(timeout, new ArrayList<Pattern>());
        if (retv == -2) {
            this.isSuccess = true;
            this.before = this.buffer.toString();
            this.buffer.delete(0, this.buffer.length());
        }
        return retv;
    }

    public int expectEOF() {
        return this.expectEOF(this.default_timeout);
    }

    public int expectEOFOrThrow(int timeout) throws TimeoutException, IOException {
        int retv = this.expectEOF(timeout);
        if (retv == -1) {
            throw new TimeoutException();
        }
        if (retv == -9) {
            throw this.thrownIOE;
        }
        return retv;
    }

    public int expectEOFOrThrow() throws TimeoutException, IOException {
        return this.expectEOFOrThrow(this.default_timeout);
    }

    public int expectOrThrow(int timeout, Object ... patterns) throws TimeoutException, EOFException, IOException {
        int retv = this.expect(timeout, patterns);
        switch (retv) {
            case -1: {
                throw new TimeoutException();
            }
            case -2: {
                throw new EOFException();
            }
            case -9: {
                throw this.thrownIOE;
            }
        }
        return retv;
    }

    public int expectOrThrow(Object ... patterns) throws TimeoutException, EOFException, IOException {
        return this.expectOrThrow(this.default_timeout, patterns);
    }

    private void clearGlobalVariables() {
        this.isSuccess = false;
        this.match = null;
        this.before = null;
    }

    public void close() {
        try {
            this.output.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Exception when closing OutputStream", e);
        }
        try {
            this.inputChannel.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Exception when closing input Channel", e);
        }
    }

    public int getDefault_timeout() {
        return this.default_timeout;
    }

    public void setDefault_timeout(int default_timeout) {
        this.default_timeout = default_timeout;
    }

    public boolean isRestart_timeout_upon_receive() {
        return this.restart_timeout_upon_receive;
    }

    public void setRestart_timeout_upon_receive(boolean restart_timeout_upon_receive) {
        this.restart_timeout_upon_receive = restart_timeout_upon_receive;
    }

    public void setNotransfer(boolean notransfer) {
        this.notransfer = notransfer;
    }

    public boolean isNotransfer() {
        return this.notransfer;
    }

    public static String bytesToPrintableString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(Expect.byteToPrintableString(b));
        }
        return sb.toString();
    }

    public static String byteToPrintableString(byte b) {
        String s = new String(new byte[]{b});
        if (b >= 0 && b < 32) {
            s = "^" + (char)(b + 64);
        } else if (b == 127) {
            s = "^?";
        }
        if (b == 9) {
            s = "\\t";
        }
        if (b == 10) {
            s = "\\n";
        }
        if (b == 13) {
            s = "\\r";
        }
        return s;
    }

    public static void forwardInputStreamTo(PrintStream duplicatedTo) {
        Expect.duplicatedTo = duplicatedTo;
    }

    public static class EOFException
    extends Exception {
    }

    public static class TimeoutException
    extends Exception {
    }
}

