/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.Glob;

public class FileUtil {
    static final Logger logger = LoggerManager.getLogger("das2.util");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean fileCompare(File file1, File file2) {
        if (file1.length() != file2.length()) {
            return false;
        }
        try (FileInputStream b1 = new FileInputStream(file1);
             FileInputStream b2 = new FileInputStream(file2);){
            long l = file1.length();
            long i = 0L;
            while (i < l) {
                if (b1.read() != b2.read()) {
                    boolean bl = false;
                    return bl;
                }
                ++i;
            }
            return true;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return true;
    }

    private FileUtil() {
    }

    public static boolean isParent(File possibleParent, File maybeChild) {
        URI childURI;
        if (possibleParent == null || maybeChild == null) {
            return false;
        }
        if (!(possibleParent = possibleParent.getAbsoluteFile()).exists() || !possibleParent.isDirectory()) {
            return false;
        }
        maybeChild = maybeChild.getAbsoluteFile();
        URI parentURI = possibleParent.toURI();
        return !parentURI.relativize(childURI = maybeChild.toURI()).isAbsolute();
    }

    public static boolean deleteFileTree(File root) throws IllegalArgumentException {
        return FileUtil.deleteFileTree(root, null);
    }

    public static boolean deleteFileTree(File root, Set<String> exclude) throws IllegalArgumentException {
        if (!root.exists()) {
            return true;
        }
        if (!root.canRead()) {
            throw new IllegalArgumentException("cannot read folder " + root);
        }
        File[] children = root.listFiles();
        if (children == null) {
            throw new IllegalArgumentException("listFiles returns null, root must be a directory and not a file.");
        }
        boolean success = true;
        boolean noExclude = true;
        for (File children1 : children) {
            if (exclude != null && exclude.contains(children1.getName())) {
                noExclude = false;
                continue;
            }
            if (children1.isDirectory()) {
                success = success && FileUtil.deleteFileTree(children1, exclude);
                continue;
            }
            boolean bl = success = success && (!children1.exists() || children1.delete());
            if (success) continue;
            throw new IllegalArgumentException("unable to delete file " + children1);
        }
        if (noExclude) {
            boolean bl = success = success && (!root.exists() || root.delete());
        }
        if (!success) {
            throw new IllegalArgumentException("unable to delete folder " + root);
        }
        return success;
    }

    public static boolean deleteWithinFileTree(File root, String name) throws IllegalArgumentException {
        if (!root.exists()) {
            return true;
        }
        if (!root.canRead()) {
            System.err.println("unable to read folder: " + root);
            return true;
        }
        File[] children = root.listFiles();
        if (children == null) {
            throw new IllegalArgumentException("listFiles returns null, root must be a directory and not a file.");
        }
        boolean success = true;
        for (File children1 : children) {
            if (children1.isDirectory()) {
                success = success && FileUtil.deleteWithinFileTree(children1, name);
                continue;
            }
            if (!children1.getName().equals(name)) continue;
            boolean bl = success = success && (!children1.exists() || children1.delete());
            if (success) continue;
            throw new IllegalArgumentException("unable to delete file " + children1);
        }
        return success;
    }

    public static File find(File root, String name) throws IllegalArgumentException {
        if (!root.exists()) {
            throw new IllegalArgumentException("File does not exist:" + root);
        }
        if (!root.isDirectory()) {
            throw new IllegalArgumentException("root should be a directory: " + root);
        }
        if (!root.canRead()) {
            throw new IllegalArgumentException("unable to read root: " + root);
        }
        File[] children = root.listFiles();
        if (children == null) {
            throw new IllegalArgumentException("should not happen because it is known to exist.");
        }
        for (File children1 : children) {
            if (children1.isDirectory()) {
                File f = FileUtil.find(children1, name);
                if (f == null) continue;
                return f;
            }
            if (!children1.getName().equals(name)) continue;
            return children1;
        }
        return null;
    }

    public static int find(File root, Pattern pattern, List<String> result) throws IllegalArgumentException {
        if (result == null) {
            result = new ArrayList<String>();
        }
        if (!root.exists()) {
            throw new IllegalArgumentException("File does not exist:" + root);
        }
        if (!root.isDirectory()) {
            throw new IllegalArgumentException("root should be a directory: " + root);
        }
        if (!root.canRead()) {
            throw new IllegalArgumentException("unable to read root: " + root);
        }
        int count = 0;
        File[] children = root.listFiles();
        if (children == null) {
            throw new IllegalArgumentException("should not happen because it is known to exist.");
        }
        for (File children1 : children) {
            if (children1.isDirectory()) {
                count += FileUtil.find(children1, pattern, result);
                continue;
            }
            if (!pattern.matcher(children1.getName()).matches()) continue;
            result.add(children1.getAbsolutePath());
            ++count;
        }
        return count;
    }

    public static File find(File[] roots, String name) {
        for (File root : roots) {
            File r;
            if (!root.exists() || (r = FileUtil.find(root, name)) == null) continue;
            return r;
        }
        return null;
    }

    public static List<File> listRecursively(File root, Pattern name, List<File> matches) {
        File[] children;
        if (!root.exists()) {
            throw new IllegalArgumentException("File does not exist:" + root);
        }
        if (!root.isDirectory()) {
            throw new IllegalArgumentException("root is not a folder:" + root);
        }
        if (!root.canRead()) {
            return Collections.emptyList();
        }
        if (matches == null) {
            matches = new ArrayList<File>();
        }
        if ((children = root.listFiles()) == null) {
            return Collections.emptyList();
        }
        for (File children1 : children) {
            if (children1.isDirectory()) {
                FileUtil.listRecursively(children1, name, matches);
                continue;
            }
            if (!name.matcher(children1.getName()).matches()) continue;
            matches.add(children1);
        }
        return matches;
    }

    public static File[] listRecursively(File root, String glob) {
        String regex = Glob.getRegex(glob);
        boolean b = new File(root, "xxx").equals(new File(root, "XXX"));
        if (b) {
            regex = "(?i)" + regex;
        }
        Pattern name = Pattern.compile(".*" + regex);
        List<File> result = FileUtil.listRecursively(root, name, null);
        return result.toArray(new File[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileCopy(File src, File dst) throws FileNotFoundException, IOException {
        if (!src.exists()) {
            throw new IllegalArgumentException("src does not exist.");
        }
        if (!src.canRead()) {
            throw new IllegalArgumentException("src cannot be read.");
        }
        if (src.equals(dst)) {
            throw new IllegalArgumentException("src and dst files are the same");
        }
        if (src.isDirectory() && (!dst.exists() || dst.isDirectory())) {
            if (!dst.exists() && !dst.mkdirs()) {
                throw new IOException("unable to mkdir " + dst);
            }
            File dst1 = new File(dst, src.getName());
            if (!dst1.exists() && !dst1.mkdir()) {
                throw new IOException("unable to mkdir " + dst1);
            }
            dst = dst1;
            File[] files = src.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                if (f.isDirectory()) {
                    dst1 = new File(dst, f.getName());
                    if (!dst1.exists() && !dst1.mkdir()) {
                        throw new IOException("unable to mkdir " + dst1);
                    }
                } else {
                    dst1 = dst;
                }
                FileUtil.fileCopy(f, dst1);
            }
            return;
        }
        if (dst.isDirectory()) {
            dst = new File(dst, src.getName());
        }
        FileChannel ic = new FileInputStream(src).getChannel();
        FileChannel oc = new FileOutputStream(dst).getChannel();
        try {
            ic.transferTo(0L, ic.size(), oc);
        }
        finally {
            ic.close();
            oc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMagic(File src) throws FileNotFoundException, IOException {
        byte[] four = new byte[4];
        ByteBuffer buf = ByteBuffer.wrap(four);
        try (FileChannel ic = new FileInputStream(src).getChannel();){
            int bytes;
            for (int bytesRead = 0; bytesRead < 4; bytesRead += bytes) {
                bytes = ic.read(buf);
                if (bytes != -1) continue;
                if (bytesRead == 0) {
                    throw new IllegalArgumentException("File is empty: " + src);
                }
                throw new IllegalArgumentException("File has less than four bytes: " + src);
            }
        }
        return new String(four);
    }

    public static String readInputStreamToString(InputStream ins) throws IOException {
        String result = new BufferedReader(new InputStreamReader(ins)).lines().collect(Collectors.joining("\n"));
        return result;
    }

    public static String readFileToString(File f) throws IOException {
        byte[] bb = Files.readAllBytes(Paths.get(f.toURI()));
        return new String(bb, Charset.forName("UTF-8"));
    }

    public static void writeStringToFile(File f, String src) throws IOException {
        try {
            Files.write(Paths.get(f.toURI()), src.getBytes("UTF-8"), new OpenOption[0]);
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public static int lineCount(File f) throws FileNotFoundException, IOException {
        try (BufferedReader r = new BufferedReader(new FileReader(f));){
            String line = r.readLine();
            int lineCount = 0;
            while (line != null) {
                ++lineCount;
                line = r.readLine();
            }
            int n = lineCount;
            return n;
        }
    }

    public static int consumeStream(InputStream in) throws IOException {
        byte[] buf = new byte[2048];
        int totalBytesRead = 0;
        int bytesRead = in.read(buf, 0, buf.length);
        while (bytesRead > -1) {
            totalBytesRead += bytesRead;
            bytesRead = in.read(buf, 0, buf.length);
        }
        return totalBytesRead;
    }
}

