/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.ColorUtil;
import org.das2.util.Entities;
import org.das2.util.LoggerManager;

public class GrannyTextRenderer {
    public static final float LEFT_ALIGNMENT = 0.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    private Rectangle bounds = null;
    private ArrayList<Rectangle> lineBounds;
    private String str;
    private String[] tokens;
    private float alignment = 0.0f;
    private static final Logger logger = LoggerManager.getLogger("das2.graph.text");
    private boolean underline;
    private Map<String, Painter> painters = new HashMap<String, Painter>();
    private boolean glow = false;
    public static final String PROP_GLOW = "glow";
    private static Graphics headlessGraphics = null;

    public void addPainter(String id, Painter p) {
        this.painters.put(id, p);
    }

    public void removePainter(String id) {
        this.painters.remove(id);
    }

    public void clearPainters() {
        this.painters.clear();
    }

    public Rectangle getBounds() {
        if (this.lineBounds == null) {
            throw new IllegalArgumentException("string is not set");
        }
        Rectangle r = this.maybeInitBounds();
        return new Rectangle(r);
    }

    public Rectangle2D getBounds2D() {
        Rectangle r = this.getBounds();
        Rectangle2D.Double result = new Rectangle2D.Double(r.x, r.y, r.width, r.height);
        return result;
    }

    private Rectangle calculateBounds(ArrayList<Rectangle> llineBounds) {
        Rectangle lbounds;
        if (this.lineBounds == null) {
            logger.fine("lineBounds not set");
            return new Rectangle(0, -12, 12, 12);
        }
        if (llineBounds.size() > 0 && llineBounds.get(0) != null) {
            lbounds = new Rectangle(llineBounds.get(0));
            for (int i = 1; i < llineBounds.size(); ++i) {
                lbounds.add(llineBounds.get(i));
            }
        } else {
            logger.fine("lineBounds size is 0");
            lbounds = new Rectangle(0, -12, 12, 12);
        }
        return lbounds;
    }

    private Rectangle maybeInitBounds() {
        Rectangle bounds = this.bounds;
        if (bounds == null) {
            bounds = this.calculateBounds(this.lineBounds);
        }
        return bounds;
    }

    public double getWidth() {
        if (this.lineBounds == null) {
            throw new IllegalArgumentException("string is not set");
        }
        this.maybeInitBounds();
        return this.bounds.getWidth();
    }

    public double getLineOneWidth() {
        if (this.lineBounds == null) {
            throw new IllegalArgumentException("string is not set");
        }
        return this.getLineWidth(1);
    }

    private double getLineWidth(int lineNumber) {
        if (this.lineBounds == null) {
            throw new IllegalArgumentException("string is not set");
        }
        return this.lineBounds.get(lineNumber - 1).getWidth();
    }

    public double getHeight() {
        if (this.lineBounds == null) {
            throw new IllegalArgumentException("string is not set");
        }
        this.maybeInitBounds();
        return this.bounds.getHeight();
    }

    public double getAscent() {
        if (this.lineBounds == null) {
            throw new IllegalArgumentException("string is not set");
        }
        if (this.lineBounds.isEmpty()) {
            throw new IllegalArgumentException("getAscent called but string has not been drawn");
        }
        return -1.0 * this.lineBounds.get(0).getY();
    }

    public double getDescent() {
        if (this.lineBounds == null) {
            throw new IllegalArgumentException("string is not set");
        }
        this.maybeInitBounds();
        return this.bounds.getHeight() + this.bounds.getY();
    }

    public void setString(Component c, String str) {
        this.bounds = null;
        this.lineBounds = new ArrayList();
        this.str = Entities.decodeEntities(str);
        this.tokens = GrannyTextRenderer.buildTokenArray(this.str);
        this.draw(c.getGraphics(), c.getFont(), 0.0f, 0.0f, false);
    }

    public void setString(Graphics g, String str) {
        this.bounds = null;
        this.lineBounds = new ArrayList();
        this.str = Entities.decodeEntities(str);
        this.tokens = GrannyTextRenderer.buildTokenArray(this.str);
        this.draw(g, g.getFont(), 0.0f, 0.0f, false);
        if (this.lineBounds.isEmpty() || this.lineBounds.get(0) == null) {
            System.err.println("rte_0015749633");
        }
    }

    public void setString(Font font, String label) {
        this.bounds = null;
        this.lineBounds = new ArrayList();
        this.str = Entities.decodeEntities(label);
        this.tokens = GrannyTextRenderer.buildTokenArray(this.str);
        this.draw(null, font, 0.0f, 0.0f, false);
    }

    public String getString() {
        return this.str;
    }

    public float getAlignment() {
        return this.alignment;
    }

    public void setAlignment(float a) {
        if (a != 0.0f && a != 0.5f && a != 1.0f) {
            throw new IllegalArgumentException("alignment should 0., 0.5, or 1.0");
        }
        this.alignment = a;
    }

    public boolean isGlow() {
        return this.glow;
    }

    public void setGlow(boolean glow) {
        this.glow = glow;
    }

    public void draw(Graphics ig, float ix, float iy) {
        if (this.glow) {
            Color color0 = ig.getColor();
            Color backColor0 = color0.getRed() < 128 ? Color.WHITE : Color.BLACK;
            ig.setColor(backColor0);
            this.draw(ig, ig.getFont(), ix - 1.0f, iy, true);
            this.draw(ig, ig.getFont(), ix + 1.0f, iy, true);
            this.draw(ig, ig.getFont(), ix, iy - 1.0f, true);
            this.draw(ig, ig.getFont(), ix, iy + 1.0f, true);
            ig.setColor(color0);
        }
        this.draw(ig, ig.getFont(), ix, iy, true);
    }

    private static void drawText(Graphics ig, boolean draw, float y, boolean underline, String strl, Font font, TextPosition current, Rectangle boundsl) {
        if (draw) {
            ig.setFont(font);
            Graphics2D g = (Graphics2D)ig;
            g.drawString(strl, current.x, y);
            int w = g.getFontMetrics(font).stringWidth(strl);
            if (underline) {
                g.draw(new Line2D.Double(current.x, y + 2.0f, current.x + (float)w, y + 2.0f));
            }
            current.x += (float)w;
            logger.log(Level.FINER, "draw string \"{0}\" over next {1} pixels", new Object[]{strl, w});
        } else {
            FontMetrics fm = ig.getFontMetrics(font);
            boundsl.add(current.x, y + (float)fm.getDescent());
            boundsl.add(current.x + (float)fm.stringWidth(strl), y - (float)fm.getAscent());
            current.x += (float)ig.getFontMetrics(font).stringWidth(strl);
        }
    }

    private void draw(Graphics ig, Font baseFont, float ix, float iy, boolean draw) {
        logger.entering("GrannyTextRenderer", "draw", new Object[]{baseFont, Float.valueOf(ix), Float.valueOf(iy), draw, this.str});
        Font activeFont = baseFont;
        boolean debug = false;
        if (debug && !draw && this.tokens.length > 1) {
            logger.info("draw debug");
        }
        ArrayList<Rectangle> llineBounds = new ArrayList<Rectangle>();
        Graphics2D g = null;
        Rectangle boundsl = null;
        if (draw) {
            g = (Graphics2D)ig.create();
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHints(hints);
        }
        Color color0 = g != null ? g.getColor() : Color.BLACK;
        boolean NONE = false;
        boolean SUB_U = true;
        int SUB_D = 2;
        int SUB_L = 3;
        int EXP = 4;
        int IND = 5;
        int LOWCAPS = 10;
        int SUB_A = 11;
        int SUB_B = 12;
        if (ig == null) {
            ig = GrannyTextRenderer.getHeadlessGraphicsContext();
        }
        if (baseFont == null) {
            baseFont = Font.decode("sans-10");
        }
        int lineNum = 1;
        TextPosition current = new TextPosition(0, 0, ix, iy);
        if (draw) {
            if (this.alignment == 0.5f) {
                current.x = (float)((double)current.x + (this.getWidth() - this.getLineOneWidth()) / 2.0);
            } else if (this.alignment == 1.0f) {
                current.x = (float)((double)current.x + (this.getWidth() - this.getLineOneWidth()));
            }
        }
        if (!draw) {
            boundsl = new Rectangle((int)ix, (int)iy, 0, 0);
        }
        Stack<TextPosition> saveStack = new Stack<TextPosition>();
        block32: for (String strl : this.tokens) {
            if (!strl.equals("!!") && strl.charAt(0) == '!') {
                if (strl.length() == 1) break;
                switch (strl.charAt(1)) {
                    case 'A': 
                    case 'a': {
                        current.sub = 11;
                        current.ei = 0;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        current.sub = 12;
                        current.ei = 0;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        ++lineNum;
                        current.sub = 0;
                        current.ei = 0;
                        current.x = ix;
                        current.y += baseFont.getSize2D();
                        if (draw) {
                            g.setFont(baseFont);
                            if (this.alignment == 0.5f) {
                                current.x = (float)((double)current.x + (this.getWidth() - this.getLineWidth(lineNum)) / 2.0);
                            } else if (this.alignment == 1.0f) {
                                current.x = (float)((double)current.x + (this.getWidth() - this.getLineWidth(lineNum)));
                            }
                        }
                        saveStack.clear();
                        if (draw) continue block32;
                        llineBounds.add(boundsl);
                        boundsl = new Rectangle((int)current.x, (int)current.y, 0, 0);
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        current.sub = 1;
                        current.ei = 0;
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        current.sub = 2;
                        current.ei = 0;
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        current.sub = 3;
                        current.ei = 0;
                        break;
                    }
                    case 'K': 
                    case 'k': {
                        current.ei = 10;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        current.ei = 4;
                        break;
                    }
                    case 'I': 
                    case 'i': {
                        current.ei = 5;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        saveStack.push(new TextPosition(current));
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        if (!saveStack.empty()) {
                            if (saveStack.peek() == null) {
                                return;
                            }
                            current.copy((TextPosition)saveStack.pop());
                            break;
                        }
                        logger.log(Level.WARNING, "saveStack was empty: missing !s from: {0}", this.str);
                        break;
                    }
                    case 'N': 
                    case 'n': {
                        current.sub = 0;
                        current.ei = 0;
                        if (!draw || g.getColor() == color0) continue block32;
                        g.setColor(color0);
                        break;
                    }
                    case '(': {
                        String command;
                        int i = strl.indexOf(";");
                        if (i == -1) {
                            i = strl.indexOf(")");
                        }
                        if ((command = strl.substring(2, i)).indexOf(44) > -1) {
                            logger.log(Level.INFO, "command cannot contain comma: {0}", command);
                            break;
                        }
                        if (command.equals("color")) {
                            String scolor;
                            if (!draw) continue block32;
                            String string = scolor = i == strl.length() - 1 ? "" : strl.substring(i + 1, strl.length() - 1);
                            if (scolor.length() == 0) {
                                g.setColor(color0);
                                break;
                            }
                            try {
                                Color c = ColorUtil.decodeColor(scolor);
                                g.setColor(c);
                            }
                            catch (IllegalArgumentException ex) {
                                logger.log(Level.INFO, "could not decode color: {0}", scolor);
                            }
                            break;
                        }
                        if (command.equals("font")) {
                            Font f;
                            String sfont;
                            String string = sfont = i == strl.length() - 1 ? "" : strl.substring(i + 1, strl.length() - 1);
                            if (sfont.length() == 0) {
                                if (draw) {
                                    g.setFont(baseFont);
                                }
                                activeFont = baseFont;
                                break;
                            }
                            activeFont = f = Font.decode(sfont).deriveFont(baseFont.getSize2D());
                            if (!draw) continue block32;
                            g.setFont(f);
                            break;
                        }
                        if (command.equals("painter")) {
                            Rectangle2D b1;
                            Graphics2D g4;
                            String p = i == strl.length() - 1 ? "" : strl.substring(i + 1, strl.length() - 1);
                            String[] pp = p.split("\\;");
                            Painter painter = this.painters.get(pp[0]);
                            if (painter == null) {
                                logger.log(Level.INFO, "no such painter: {0}", pp[0]);
                                break;
                            }
                            String[] args = Arrays.copyOfRange(pp, 1, pp.length);
                            if (draw) {
                                g4 = (Graphics2D)g.create((int)current.x, (int)current.y, 100, 100);
                                g4.setClip(null);
                            } else {
                                g4 = (Graphics2D)ig.create((int)current.x, (int)current.y, 100, 100);
                            }
                            g4.setFont(activeFont);
                            try {
                                b1 = painter.paint(g4, args);
                                g4.dispose();
                                if (b1 == null) {
                                    logger.warning("width not reported, using 16px");
                                    b1 = new Rectangle2D.Float(0.0f, 0.0f, 16.0f, 16.0f);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                b1 = new Rectangle2D.Float(0.0f, 0.0f, 16.0f, 16.0f);
                            }
                            if (!draw) {
                                boundsl.add(new Rectangle2D.Float(current.x + (float)b1.getX(), current.y + (float)b1.getY(), (float)b1.getWidth(), (float)b1.getHeight()));
                            }
                            current.x = (float)((double)current.x + b1.getWidth());
                            break;
                        }
                        if (command.equals("bold")) {
                            if (activeFont.isItalic()) {
                                activeFont = activeFont.deriveFont(3);
                                break;
                            }
                            activeFont = activeFont.deriveFont(1);
                            break;
                        }
                        if (command.equals("unbold")) {
                            if (activeFont.isItalic()) {
                                activeFont = activeFont.deriveFont(2);
                                break;
                            }
                            activeFont = activeFont.deriveFont(0);
                            break;
                        }
                        if (command.equals("italic")) {
                            if (activeFont.isBold()) {
                                activeFont = activeFont.deriveFont(3);
                                break;
                            }
                            activeFont = activeFont.deriveFont(2);
                            break;
                        }
                        if (command.equals("unitalic")) {
                            if (activeFont.isBold()) {
                                activeFont = activeFont.deriveFont(1);
                                break;
                            }
                            activeFont = activeFont.deriveFont(0);
                            break;
                        }
                        if (command.equals("underline")) {
                            this.underline = true;
                            break;
                        }
                        if (command.equals("ununderline")) {
                            this.underline = false;
                            break;
                        }
                        logger.log(Level.INFO, "unrecognized command: {0}", command);
                        break;
                    }
                    case '!': {
                        break;
                    }
                }
                continue;
            }
            Font font = activeFont;
            float size = activeFont.getSize2D();
            float y = current.y;
            switch (current.sub) {
                case 1: {
                    font = activeFont.deriveFont(size * 0.62f);
                    y -= 0.38f * size;
                    size *= 0.62f;
                    break;
                }
                case 2: {
                    font = activeFont.deriveFont(size * 0.62f);
                    y += 0.31f * size;
                    size *= 0.62f;
                    break;
                }
                case 3: {
                    font = activeFont.deriveFont(size * 0.62f);
                    y += 0.62f * size;
                    size *= 0.62f;
                    break;
                }
                case 11: {
                    y = current.y - size / 2.0f;
                    break;
                }
                case 12: {
                    y = current.y + size / 2.0f;
                    break;
                }
            }
            switch (current.ei) {
                case 4: {
                    font = font.deriveFont(size * 0.44f);
                    y -= 0.56f * size;
                    break;
                }
                case 5: {
                    font = font.deriveFont(size * 0.44f);
                    y += 0.22f * size;
                    break;
                }
                case 10: {
                    font = font.deriveFont(size * 0.8f);
                    break;
                }
            }
            if (strl.equals("!!")) {
                strl = "!";
            }
            if (draw) {
                GrannyTextRenderer.drawText(g, draw, y, this.underline, strl, font, current, boundsl);
                continue;
            }
            GrannyTextRenderer.drawText(ig, draw, y, this.underline, strl, font, current, boundsl);
        }
        if (!draw) {
            llineBounds.add(boundsl);
            this.lineBounds = llineBounds;
            this.bounds = this.calculateBounds(llineBounds);
        }
        if (debug && draw && this.bounds != null) {
            Rectangle r = new Rectangle(this.bounds);
            r.translate((int)current.x - r.width, (int)current.y);
            g.setColor(new Color(150, 100, 100, 100));
            g.fill(r);
        }
        if (draw) {
            g.dispose();
        }
        logger.exiting("GrannyTextRenderer", "draw");
    }

    private static String[] buildTokenArray(String str) {
        ArrayList<String> vector = new ArrayList<String>();
        int end = 0;
        str = str.replaceAll("\\<br\\>", "!c");
        str = str.replaceAll("\\<sup\\>", "!u");
        str = str.replaceAll("\\</sup\\>", "!n");
        str = str.replaceAll("\\<sub\\>", "!d");
        str = str.replaceAll("\\</sub\\>", "!n");
        str = str.replaceAll("\\<b>", "!(bold)");
        str = str.replaceAll("\\</b>", "!(unbold)");
        str = str.replaceAll("\\<i>", "!(italic)");
        str = str.replaceAll("\\</i>", "!(unitalic)");
        str = str.replaceAll("\\<u>", "!(underline)");
        str = str.replaceAll("\\</u>", "!(ununderline)");
        while (end < str.length()) {
            int begin = end;
            if (str.charAt(begin) == '!') {
                if (str.length() > begin + 2) {
                    char p = str.charAt(begin + 1);
                    if (p == '(') {
                        int i = str.indexOf(41, begin + 2);
                        if (i == -1) {
                            logger.info("no closing paren found.");
                            end = begin + 2;
                        } else {
                            end = i + 1;
                        }
                    } else {
                        end = begin + 2;
                    }
                } else {
                    end = begin + 2;
                }
                if (end >= str.length()) {
                    end = str.length();
                }
            } else {
                end = str.indexOf(33, begin);
                if (end == -1) {
                    end = str.length();
                }
            }
            vector.add(str.substring(begin, end));
        }
        String[] list = vector.toArray(new String[vector.size()]);
        return list;
    }

    public String toString() {
        this.maybeInitBounds();
        StringBuilder buffer = new StringBuilder(this.getClass().getName());
        buffer.append(": ").append(this.str).append(", ");
        buffer.append("bounds: ").append(this.bounds).append(", ").append("lineBounds:").append(this.lineBounds).append(", ");
        return buffer.toString();
    }

    public static int lineCount(String s) {
        int emptyLines;
        String[] ss = s.split("(\\!c|\\!C|\\<br\\>)");
        for (emptyLines = 0; emptyLines < ss.length && ss[emptyLines].trim().length() == 0; ++emptyLines) {
        }
        return ss.length - emptyLines;
    }

    private static synchronized Graphics getHeadlessGraphicsContext() {
        if (headlessGraphics == null) {
            headlessGraphics = new BufferedImage(10, 10, 2).getGraphics();
        }
        return headlessGraphics;
    }

    private static final class TextPosition {
        public int sub;
        public int ei;
        public float x;
        public float y;

        public TextPosition(int sub, int ei, float x, float y) {
            this.sub = sub;
            this.ei = ei;
            this.x = x;
            this.y = y;
        }

        public TextPosition(TextPosition p) {
            this.copy(p);
        }

        public void copy(TextPosition p) {
            this.sub = p.sub;
            this.ei = p.ei;
            this.x = p.x;
            this.y = p.y;
        }

        public String toString() {
            return "x: " + this.x + " y: " + this.y;
        }
    }

    public static interface Painter {
        public Rectangle2D paint(Graphics2D var1, String[] var2);
    }
}

