/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import org.das2.util.IDLValue;

public class IDLParser {
    public static final int EXPR = 1;
    public static final int EXPR_LIST = 2;
    public static final int FACTOR = 3;
    public static final int TERM = 4;
    public static final int NUMBER = 5;
    public static final int NOPARSER = 6;

    public String[] IDLTokenizer(String s) {
        String delimiters = " \t[,]()^*/+-";
        StringTokenizer st = new StringTokenizer(s, delimiters, true);
        int countTokens = st.countTokens();
        String[] tokens = new String[countTokens];
        for (int i = 0; i < countTokens; ++i) {
            tokens[i] = st.nextToken();
        }
        int nullcount = 0;
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i].equals(" ") || tokens[i].equals("\t")) {
                tokens[i] = null;
                ++nullcount;
                continue;
            }
            if (!tokens[i].endsWith("e") && !tokens[i].endsWith("E") || !tokens[i + 1].endsWith("-")) continue;
            tokens[i] = tokens[i] + tokens[i + 1] + tokens[i + 2];
            tokens[i + 1] = null;
            tokens[i + 2] = null;
            i += 2;
            nullcount += 2;
        }
        if (nullcount > 0) {
            String[] temp = new String[tokens.length - nullcount];
            int tIndex = 0;
            for (int i = 0; i < tokens.length; ++i) {
                if (tokens[i] == null) continue;
                temp[tIndex] = tokens[i];
                ++tIndex;
            }
            tokens = temp;
        }
        return tokens;
    }

    public double parseIDLScalar(String s) {
        String[] tokens = this.IDLTokenizer(s);
        IDLValue expr = this.parseIDLArrayTokens(tokens, 1);
        if (expr == null) {
            return Double.NaN;
        }
        return expr.toScalar();
    }

    public double[] parseIDLArray(String s) {
        String[] tokens = this.IDLTokenizer(s);
        IDLValue expr = this.parseIDLArrayTokens(tokens, 1);
        if (expr == null) {
            return null;
        }
        return expr.toArray();
    }

    private IDLValue parseIDLExprList(String[] tokens) {
        int ileft = 0;
        int nleft = 0;
        int iright = 0;
        Vector<IDLValue> exprs = new Vector<IDLValue>();
        ileft = 1;
        for (int itok = 1; itok < tokens.length; ++itok) {
            if (tokens[itok].equals(",") && nleft == 0 || tokens[itok].equals("]") && nleft == 0) {
                iright = itok - 1;
                String[] expr = new String[iright - ileft + 1];
                for (int i = 0; i < expr.length; ++i) {
                    expr[i] = tokens[i + ileft];
                }
                IDLValue expr1 = this.parseIDLArrayTokens(expr, 1);
                exprs.add(expr1);
                ileft = itok + 1;
                continue;
            }
            if (tokens[itok].equals("(")) {
                ++nleft;
                continue;
            }
            if (tokens[itok].equals(")")) {
                --nleft;
                continue;
            }
            if (tokens[itok].equals("[")) {
                ++nleft;
                continue;
            }
            if (!tokens[itok].equals("]")) continue;
            --nleft;
        }
        IDLValue result = new IDLValue();
        result.type = IDLValue.ARRAY;
        Vector<Double> aValue = new Vector<Double>();
        for (int iexpr = 0; iexpr < exprs.size(); ++iexpr) {
            IDLValue expr = (IDLValue)exprs.get(iexpr);
            if (expr.type == IDLValue.SCALAR) {
                aValue.add(expr.sValue);
                continue;
            }
            for (int i = 0; i < expr.aValue.length; ++i) {
                aValue.add(expr.aValue[i]);
            }
        }
        result.aValue = new double[aValue.size()];
        for (int i = 0; i < aValue.size(); ++i) {
            result.aValue[i] = (Double)aValue.get(i);
        }
        return result;
    }

    public IDLValue parseIDLArrayTokens(String[] tokens, int type) {
        int next_parser;
        IDLValue expr1 = null;
        IDLValue result = null;
        if (tokens.length == 0) {
            return null;
        }
        if (tokens.length == 1) {
            expr1 = new IDLValue(Double.parseDouble(tokens[0]));
            return expr1;
        }
        String[] ops = null;
        if (type == 1) {
            ops = new String[]{"+", "-"};
            next_parser = 4;
        } else if (type == 4) {
            ops = new String[]{"*", "/"};
            next_parser = 3;
        } else if (type == 3) {
            ops = new String[]{"^"};
            next_parser = 5;
            if (tokens[0].equals("-")) {
                String[] expr = new String[tokens.length - 1];
                for (int i = 0; i < expr.length; ++i) {
                    expr[i] = tokens[i + 1];
                }
                expr1 = this.parseIDLArrayTokens(expr, 3);
                result = expr1.IDLmultiply(new IDLValue(-1.0));
                return result;
            }
        } else {
            int next_parser2 = 6;
            if (tokens[0].equals("(") && tokens[tokens.length - 1].equals(")")) {
                int ileft = 1;
                int iright = tokens.length - 2;
                String[] expr = new String[iright - ileft + 1];
                for (int i = 0; i < expr.length; ++i) {
                    expr[i] = tokens[i + ileft];
                }
                expr1 = this.parseIDLArrayTokens(expr, 1);
                return expr1;
            }
            if (tokens[0].equals("[") && tokens[tokens.length - 1].equals("]")) {
                expr1 = this.parseIDLExprList(tokens);
                return expr1;
            }
            if (tokens[0].equalsIgnoreCase("findgen") || tokens[0].equalsIgnoreCase("dindgen")) {
                String[] expr = new String[tokens.length - 3];
                for (int i = 0; i < expr.length; ++i) {
                    expr[i] = tokens[i + 2];
                }
                expr1 = this.parseIDLArrayTokens(expr, 1);
                if (expr1.type != IDLValue.SCALAR) {
                    Logger.getLogger("das2.anon").info("Syntax error in findgen argument");
                    System.exit(-1);
                } else {
                    expr1 = IDLValue.findgen((int)expr1.sValue);
                }
            } else if (tokens[0].equalsIgnoreCase("alog10")) {
                String[] expr = new String[tokens.length - 3];
                for (int i = 0; i < expr.length; ++i) {
                    expr[i] = tokens[i + 2];
                }
                expr1 = this.parseIDLArrayTokens(expr, 1);
                expr1 = IDLValue.alog10(expr1);
            } else if (tokens[0].equalsIgnoreCase("sin")) {
                String[] expr = new String[tokens.length - 3];
                for (int i = 0; i < expr.length; ++i) {
                    expr[i] = tokens[i + 2];
                }
                expr1 = this.parseIDLArrayTokens(expr, 1);
                expr1 = IDLValue.sin(expr1);
            } else {
                return null;
            }
            return expr1;
        }
        int ileftop = 9999;
        String leftop = "";
        int nleft_paren = 0;
        int nleft_bracket = 0;
        for (int iop = 0; iop < ops.length; ++iop) {
            for (int itok = 0; itok < tokens.length; ++itok) {
                if (tokens[itok].equals("[")) {
                    ++nleft_bracket;
                }
                if (tokens[itok].equals("(")) {
                    ++nleft_paren;
                }
                if (tokens[itok].equals("]")) {
                    --nleft_bracket;
                }
                if (tokens[itok].equals(")")) {
                    --nleft_paren;
                }
                if (!tokens[itok].equals(ops[iop]) || itok == 0 || iop >= ileftop || nleft_paren != 0 || nleft_bracket != 0) continue;
                ileftop = itok;
                leftop = ops[iop];
            }
        }
        if (ileftop == 9999) {
            result = this.parseIDLArrayTokens(tokens, next_parser);
        } else {
            int i;
            String[] expr = new String[ileftop];
            for (i = 0; i < ileftop; ++i) {
                expr[i] = tokens[i];
            }
            expr1 = this.parseIDLArrayTokens(expr, next_parser);
            expr = new String[tokens.length - ileftop - 1];
            for (i = 0; i < expr.length; ++i) {
                expr[i] = tokens[i + ileftop + 1];
            }
            IDLValue expr2 = this.parseIDLArrayTokens(expr, type);
            if (expr1 == null || expr2 == null) {
                result = next_parser == 6 ? null : this.parseIDLArrayTokens(tokens, next_parser);
            } else if (leftop.equals("+")) {
                result = expr1.IDLadd(expr2);
            } else if (leftop.equals("-")) {
                result = expr1.IDLsubtract(expr2);
            } else if (leftop.equals("*")) {
                result = expr1.IDLmultiply(expr2);
            } else if (leftop.equals("/")) {
                result = expr1.IDLdivide(expr2);
            } else if (leftop.equals("^")) {
                result = expr1.IDLexponeniate(expr2);
            }
        }
        return result;
    }
}

