/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.awt;

import com.itextpdf.awt.FontMapper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.awt.GraphicsOutput;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.monitor.NullProgressMonitor;

public class PdfGraphicsOutput
implements GraphicsOutput {
    private static final Logger logger = LoggerManager.getLogger("das2.graphics.pdf");
    private float width;
    private float height;
    private int ppi = 72;
    private boolean oldMethod = true;
    private OutputStream out;
    private Document doc;
    private PdfWriter writer;
    private PdfContentByte cb;
    private Graphics2D graphics;
    public static final String READING_FONTS = "PleaseWait";
    public static final Object STATE_IDLE = "idle";
    public static final Object STATE_READING = "reading";
    public static final Object STATE_READY = "ready";
    private static Map<String, File> fontToTtfMap;
    private static Object state;
    private static final Object lockObject;
    private static final String MAC_FONT_HOME = "/Library/Fonts/";
    private static final String WINDOWS_FONT_HOME_1 = "C:/Windows/Fonts";
    private static final String WINDOWS_FONT_HOME_2 = "D:/Windows/Fonts";
    private static final String LINUX_FONT_HOME = "/usr/share/fonts/";
    private static final String SOLARIS_FONT_HOME = "/usr/X/lib/X11/fonts/TrueType/";
    private final FontMapper fontMapper = new FontMapper(){

        public BaseFont awtToPdf(Font font) {
            try {
                String ffile = PdfGraphicsOutput.ttfFromName(font);
                if (ffile == null) {
                    logger.log(Level.WARNING, "couldn''t find ttf font file for {0}", font.getName());
                    return BaseFont.createFont();
                }
                return BaseFont.createFont((String)ffile, (String)"Identity-H", (boolean)true);
            }
            catch (DocumentException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            return null;
        }

        public Font pdfToAwt(BaseFont font, int size) {
            return null;
        }
    };
    private boolean graphicsShapes = true;

    public static synchronized Map<String, File> resetFontToTtfMap() {
        fontToTtfMap = null;
        return PdfGraphicsOutput.getFontToTtfMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Map<String, File> getFontToTtfMap() {
        File[] dirs;
        String osName = System.getProperty("os.name");
        String userhome = System.getProperty("user.home");
        if (osName.startsWith("Mac")) {
            dirs = new File[]{new File(userhome + MAC_FONT_HOME), new File(MAC_FONT_HOME)};
        } else if (osName.startsWith("Linux")) {
            dirs = new File[]{new File(userhome, ".fonts"), new File(LINUX_FONT_HOME)};
        } else if (osName.startsWith("Windows")) {
            dirs = new File[]{new File(WINDOWS_FONT_HOME_1), new File(WINDOWS_FONT_HOME_2)};
        } else if (osName.startsWith("SunOS")) {
            dirs = new File[]{new File(userhome, "fonts"), new File(SOLARIS_FONT_HOME)};
        } else {
            logger.warning("unknown os.name, no fonts will be embedded");
            dirs = new File[]{};
        }
        if (fontToTtfMap == null) {
            String[] ss;
            state = STATE_READING;
            logger.log(Level.FINE, "indexing fonts...");
            long t0 = System.currentTimeMillis();
            HashMap<String, File> fontToTtfMap1 = new HashMap<String, File>();
            for (File dir : dirs) {
                if (!dir.exists()) continue;
                File[] ttfFonts = FileUtil.listRecursively(dir, "*.ttf");
                int nttfFonts = ttfFonts.length;
                File[] otfFonts = FileUtil.listRecursively(dir, "*.otf");
                ttfFonts = Arrays.copyOf(ttfFonts, ttfFonts.length + otfFonts.length);
                System.arraycopy(otfFonts, 0, ttfFonts, nttfFonts, otfFonts.length);
                for (File f : ttfFonts) {
                    FileInputStream in = null;
                    try {
                        BaseFont.createFont((String)f.toString(), (String)"Identity-H", (boolean)true);
                        in = new FileInputStream(f);
                        Font font = Font.createFont(0, in);
                        logger.log(Level.FINEST, "adding {0} -> {1}", new Object[]{font.getFontName(), f});
                        fontToTtfMap1.put(font.getFontName(), f);
                    }
                    catch (DocumentException | FontFormatException | IOException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    finally {
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                }
            }
            for (String s : ss = new String[]{"Roboto-Regular.ttf", "ArchitectsDaughter.ttf", "scheme_bk.otf", "xkcd-script.ttf"}) {
                try {
                    URL u = PdfGraphics2D.class.getResource("/resources/" + s);
                    if (u == null) continue;
                    File fout = File.createTempFile("temp", s);
                    logger.log(Level.FINER, "copy font to temporary file {0}", fout);
                    try (FileOutputStream ffout = new FileOutputStream(fout);
                         InputStream ins = u.openStream();){
                        FileSystemUtil.copyStream(ins, ffout, new NullProgressMonitor());
                    }
                    InputStream in = null;
                    try {
                        BaseFont.createFont((String)fout.toString(), (String)"Identity-H", (boolean)true);
                        in = PdfGraphics2D.class.getResourceAsStream("/resources/" + s);
                        Font font = Font.createFont(0, in);
                        logger.log(Level.FINEST, "adding {0} -> {1}", new Object[]{font.getFontName(), s});
                        fontToTtfMap1.put(font.getFontName(), fout);
                    }
                    catch (DocumentException | FontFormatException | IOException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    finally {
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(PdfGraphicsOutput.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            fontToTtfMap = fontToTtfMap1;
            state = STATE_READY;
            logger.log(Level.FINE, "{0}fonts indexed in {1} millis", new Object[]{fontToTtfMap.size(), System.currentTimeMillis() - t0});
        }
        return fontToTtfMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ttfFromNameInteractive(final Font font) {
        Object object = lockObject;
        synchronized (object) {
            if (state == STATE_READY) {
                return PdfGraphicsOutput.ttfFromName(font);
            }
            if (fontToTtfMap == null) {
                if (state == STATE_IDLE) {
                    state = STATE_READING;
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            String x = PdfGraphicsOutput.ttfFromName(font);
                            logger.log(Level.FINEST, "ttfFromName()->{0}", x);
                        }
                    };
                    new Thread(run).start();
                }
                return READING_FONTS;
            }
            return PdfGraphicsOutput.ttfFromName(font);
        }
    }

    public static void dumpMapToFile(File f) {
        Map<String, File> map = PdfGraphicsOutput.getFontToTtfMap();
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        try (PrintWriter out = null;){
            out = new PrintWriter(f);
            for (String k : keys) {
                out.printf("\"%s\" \"%s\"\n", k, map.get(k));
            }
        }
    }

    public static String ttfFromName(Font font) {
        File f;
        Map<String, File> map = PdfGraphicsOutput.getFontToTtfMap();
        if (logger.isLoggable(Level.FINER)) {
            map.entrySet().stream().filter(e -> ((String)e.getKey()).contains(font.getName())).forEachOrdered(e -> System.err.println((String)e.getKey()));
        }
        if ((f = map.get(font.getFontName())) == null) {
            String s = font.getFamily();
            if ((font.getStyle() & 1) == 1) {
                s = s + " Bold";
            }
            if ((font.getStyle() & 2) == 2) {
                s = s + " Italic";
            }
            if ((f = map.get(s)) == null) {
                return null;
            }
            return f.toString();
        }
        return f.toString();
    }

    @Override
    public Graphics2D getGraphics2D() {
        if (this.graphics != null) {
            return this.graphics;
        }
        this.graphics = this.graphicsShapes ? new PdfGraphics2D(this.cb, this.width, this.height, true) : new PdfGraphics2D(this.cb, this.width, this.height, this.fontMapper);
        if (this.ppi != 72) {
            this.graphics.setTransform(AffineTransform.getScaleInstance(72.0 / (double)this.ppi, 72.0 / (double)this.ppi));
        }
        return this.graphics;
    }

    @Override
    public void finish() throws IOException {
        this.graphics.dispose();
        this.cb.restoreState();
        this.doc.close();
    }

    @Override
    public Graphics getGraphics() {
        return this.getGraphics2D();
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setGraphicsShapes(boolean graphicsShapes) {
        this.graphicsShapes = graphicsShapes;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setPixelsPerInch(int ppi) {
        this.ppi = ppi;
        this.oldMethod = false;
    }

    @Override
    public void start() {
        try {
            if (this.oldMethod) {
                Rectangle rect = new Rectangle(this.width, this.height);
                this.doc = new Document(rect, 0.0f, 0.0f, 0.0f, 0.0f);
            } else {
                this.doc = new Document(PageSize.LETTER, 0.0f, 0.0f, 0.0f, 0.0f);
            }
            this.doc.addCreator("das2.org");
            this.doc.addCreationDate();
            this.writer = PdfWriter.getInstance((Document)this.doc, (OutputStream)this.out);
            this.doc.open();
            this.cb = this.writer.getDirectContent();
            this.cb.saveState();
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
    }

    public static void main(String[] args) {
        Map<String, File> map = PdfGraphicsOutput.getFontToTtfMap();
        System.err.println(map.size());
    }

    static {
        state = STATE_IDLE;
        lockObject = new Object();
    }
}

