/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.DefaultExceptionHandler;
import org.das2.util.ExceptionHandler;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.ThrowRuntimeExceptionHandler;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystemFactory;
import org.das2.util.filesystem.FileSystemSettings;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.FtpFileSystemFactory;
import org.das2.util.filesystem.HttpFileSystemFactory;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.filesystem.LocalFileSystemFactory;
import org.das2.util.filesystem.SubFileSystem;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.filesystem.ZipFileSystemFactory;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public abstract class FileSystem {
    URI root;
    protected static final Logger logger = LoggerManager.getLogger("das2.filesystem");
    protected static final Logger loggerUrl = LoggerManager.getLogger("das2.url");
    private static final Map<URI, FileSystem> instances = Collections.synchronizedMap(new HashMap());
    private static final Map<URI, Object> blocks = Collections.synchronizedMap(new HashMap());
    private static final int WAIT_TIMEOUT_MS = 100;
    private static FileSystemSettings settings = new FileSystemSettings();
    private static final HashMap registry = new HashMap();
    public static final String PROP_CASE_INSENSITIVE = "caseInsensitive";
    protected HashMap properties = new HashMap(5);
    private static ExceptionHandler exceptionHandler;
    public static final DirectoryEntry NULL;

    public static FileSystem create(URL root) throws FileSystemOfflineException, UnknownHostException, FileNotFoundException {
        try {
            return FileSystem.create(root.toURI(), (ProgressMonitor)new NullProgressMonitor());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static FileSystem create(String s) throws FileSystemOfflineException, UnknownHostException, FileNotFoundException {
        return FileSystem.create(s, (ProgressMonitor)new NullProgressMonitor());
    }

    public static FileSystem create(String s, ProgressMonitor mon) throws FileSystemOfflineException, UnknownHostException, FileNotFoundException {
        String[] parts = s.split(":", 2);
        if (parts.length == 1) {
            throw new IllegalArgumentException("name must start with scheme like 'file:', no colon found");
        }
        try {
            return FileSystem.create(new URI(FileSystemUtil.uriEncode(s)), mon);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static FileSystem create(URL root, ProgressMonitor mon) throws FileSystemOfflineException, UnknownHostException, FileNotFoundException {
        try {
            return FileSystem.create(root.toURI(), mon);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static FileSystem recreate(URI root) throws FileSystemOfflineException, UnknownHostException, FileNotFoundException {
        return FileSystem.recreate(root, new NullProgressMonitor());
    }

    public static FileSystem create(URI root) throws FileSystemOfflineException, UnknownHostException, FileNotFoundException {
        return FileSystem.create(root, (ProgressMonitor)new NullProgressMonitor());
    }

    public static FileSystem recreate(URI root, ProgressMonitor mon) throws FileSystemOfflineException, UnknownHostException, FileNotFoundException {
        FileSystem result = instances.get(root);
        if (result != null) {
            return instances.remove(root);
        }
        return FileSystem.create(root, mon);
    }

    public static FileSystem peek(URI root) {
        root = FileSystem.toCanonicalFolderName(root);
        FileSystem result = instances.get(root);
        return result;
    }

    public static synchronized void reset() {
        instances.clear();
        blocks.clear();
        KeyChain.getDefault().clearAll();
    }

    public static synchronized void reset(FileSystem fs) {
        instances.remove(fs.getRootURI());
        blocks.remove(fs.getRootURI());
        KeyChain.getDefault().clearUserPassword(fs.getRootURI());
        if (!FileUtil.deleteWithinFileTree(fs.getLocalRoot(), ".listing")) {
            logger.log(Level.WARNING, "delete all .listing files within tree {0} failed.", FileSystem.settings().getLocalCacheDir());
        }
    }

    private static boolean pathIncludesZipFileSystem(URI root) {
        String p = root.getPath();
        return p.contains(".zip") || p.contains(".ZIP") || p.contains(".kmz") || p.contains(".3mf") || p.contains(".npz");
    }

    private static boolean pathIncludesTarFileSystem(URI root) {
        String p = root.getPath();
        return p.contains(".tar") || p.contains(".tgz");
    }

    private static String[] pathZipSplit(URI root) {
        String surl = FileSystemUtil.fromUri(root);
        int i = surl.indexOf(".zip");
        if (i == -1) {
            i = surl.indexOf(".ZIP");
        }
        if (i == -1) {
            i = surl.indexOf(".kmz");
        }
        if (i == -1) {
            i = surl.indexOf(".3mf");
        }
        if (i == -1) {
            i = surl.indexOf(".npz");
        }
        String subdir = surl.substring(i + 4);
        String[] ss = FileSystem.splitUrl(surl.substring(0, i + 4));
        return new String[]{ss[2], ss[3].substring(ss[2].length()), subdir};
    }

    private static String[] pathTarSplit(URI root) {
        String surl = FileSystemUtil.fromUri(root);
        int i = surl.indexOf(".tar");
        if (i == -1) {
            i = surl.indexOf(".tgz");
        }
        String subdir = surl.substring(i + 4);
        String[] ss = FileSystem.splitUrl(surl.substring(0, i + 4));
        return new String[]{ss[2], ss[3].substring(ss[2].length()), subdir};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileSystem create(URI root, ProgressMonitor mon) throws FileSystemOfflineException, UnknownHostException, FileNotFoundException {
        Object object;
        Object waitObject;
        FileSystem result;
        logger.log(Level.FINER, "request for filesystem {0}", root);
        if (!root.toString().endsWith("/")) {
            try {
                root = new URI(root.toString() + "/");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if ((result = instances.get(root)) != null) {
            return result;
        }
        if ("user".equals(root.getUserInfo())) {
            try {
                URI test = new URI(root.getScheme(), null, root.getHost(), root.getPort(), root.getPath(), root.getQuery(), root.getFragment());
                result = instances.get(test);
                if (result != null) {
                    return result;
                }
            }
            catch (URISyntaxException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        boolean ishouldwait = false;
        Object object2 = blocks;
        synchronized (object2) {
            if (blocks.containsKey(root)) {
                waitObject = blocks.get(root);
                ishouldwait = true;
                logger.log(Level.FINE, "this thread should wait for waitObject {0} {1}", new Object[]{waitObject, root});
            } else {
                waitObject = new Object();
                blocks.put(root, waitObject);
                logger.log(Level.FINE, "created waitObject {0} {1}", new Object[]{waitObject, root});
            }
        }
        if (ishouldwait) {
            try {
                object2 = waitObject;
                synchronized (object2) {
                    while (blocks.get(root) != null) {
                        logger.log(Level.FINE, "waiting for {0} {1}", new Object[]{waitObject, root});
                        waitObject.wait(100L);
                    }
                    logger.log(Level.FINE, "done waiting for {0}", root);
                }
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            result = instances.get(root);
            if (result != null) {
                logger.log(Level.FINE, "using existing filesystem {0}", root);
                return result;
            }
            throw new FileSystemOfflineException("other thread failed to create filesystem.");
        }
        FileSystemFactory factory = null;
        if (root.getPath() != null) {
            String[] pzs;
            if (FileSystem.pathIncludesZipFileSystem(root) && registry.containsKey("zip")) {
                try {
                    pzs = FileSystem.pathZipSplit(root);
                    URI parent = new URI(pzs[0].replaceAll(" ", "%20"));
                    String zipname = pzs[1];
                    String subdir = pzs[2];
                    FileSystem remote = FileSystem.create(parent);
                    mon.setProgressMessage("loading zip file");
                    File localZipFile = remote.getFileObject(zipname).getFile(mon);
                    factory = (FileSystemFactory)registry.get("zip");
                    FileSystem zipfs = factory.createFileSystem(localZipFile.toURI());
                    if (subdir.equals("") || subdir.equals("/")) {
                        result = zipfs;
                    }
                    result = new SubFileSystem(zipfs, subdir);
                }
                catch (FileNotFoundException | UnknownHostException ex) {
                    throw ex;
                }
                catch (URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IOException ex) {
                    throw new FileSystemOfflineException(ex);
                }
                finally {
                    logger.log(Level.FINE, "created zip new filesystem {0}", root);
                    if (result != null) {
                        instances.put(root, result);
                    }
                    blocks.remove(root);
                }
            } else if (FileSystem.pathIncludesTarFileSystem(root) && registry.containsKey("tar")) {
                try {
                    pzs = FileSystem.pathTarSplit(root);
                    URI parent = new URI(pzs[0].replaceAll(" ", "%20"));
                    String tarname = pzs[1];
                    String subdir = pzs[2];
                    FileSystem remote = FileSystem.create(parent);
                    mon.setProgressMessage("loading tar file");
                    File localTarFile = remote.getFileObject(tarname).getFile(mon);
                    factory = (FileSystemFactory)registry.get("tar");
                    String ext = localTarFile.getName();
                    int i = ext.lastIndexOf(".");
                    ext = ext.substring(i + 1);
                    if (ext.equals("tgz")) {
                        int bytesRead;
                        int bytesReadOnce;
                        FileChannel fc = new FileInputStream(localTarFile).getChannel();
                        ByteBuffer bb = ByteBuffer.allocate(262);
                        for (bytesRead = 0; bytesRead < 262 && (bytesReadOnce = fc.read(bb)) != -1; bytesRead += bytesReadOnce) {
                        }
                        bb.flip();
                        if (bytesRead == 262 && bb.get(257) == 117 && bb.get(258) == 115 && bb.get(259) == 116 && bb.get(260) == 97 && bb.get(261) == 114) {
                            ext = "tar";
                        }
                    }
                    FileSystem tarfs = factory.createFileSystem(new URI(ext, null, localTarFile.getAbsolutePath(), null));
                    result = subdir.equals("") || subdir.equals("/") ? tarfs : new SubFileSystem(tarfs, subdir);
                }
                catch (FileNotFoundException | UnknownHostException ex) {
                    throw ex;
                }
                catch (URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IOException ex) {
                    throw new FileSystemOfflineException(ex);
                }
                finally {
                    logger.log(Level.FINE, "created tar new filesystem {0}", root);
                    if (result != null) {
                        instances.put(root, result);
                    }
                    blocks.remove(root);
                }
            }
        }
        if (factory == null) {
            factory = (FileSystemFactory)registry.get(root.getScheme());
        }
        if (factory == null) {
            object = waitObject;
            synchronized (object) {
                logger.log(Level.FINE, "releasing waitObject after factory=null {0}", waitObject);
                blocks.remove(root);
                logger.log(Level.FINE, "releasing waitObject after factory=null {0} (repeat)", waitObject);
                waitObject.notifyAll();
            }
            logger.log(Level.SEVERE, "unsupported protocol: {0}", root);
            throw new IllegalArgumentException("unsupported protocol: " + root);
        }
        try {
            if (result == null) {
                result = factory.createFileSystem(root);
            }
        }
        finally {
            logger.log(Level.FINE, "created new filesystem {0}", root);
            if (result != null) {
                instances.put(root, result);
                if (!result.getRootURI().equals(root)) {
                    instances.put(result.getRootURI(), result);
                }
            }
            object = waitObject;
            synchronized (object) {
                blocks.remove(root);
                logger.log(Level.FINE, "releasing waitObject {0}", waitObject);
                waitObject.notifyAll();
            }
        }
        if (settings.isOffline() && result instanceof WebFileSystem) {
            logger.log(Level.FINE, "filesystem is now offline because of settings {0}", root);
            ((WebFileSystem)result).setOffline(true);
        }
        logger.log(Level.FINE, "create provides filesystem: {0}", result);
        return result;
    }

    public static FileSystemSettings settings() {
        return settings;
    }

    public static void registerFileSystemFactory(String proto, FileSystemFactory factory) {
        registry.put(proto, factory);
    }

    protected FileSystem(URI root) {
        logger.log(Level.FINE, "create new FileSystem: {0}", root);
        if (!root.toString().endsWith("/")) {
            String s = root.toString();
            try {
                root = new URI(s + "/");
            }
            catch (URISyntaxException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                throw new RuntimeException(ex);
            }
        }
        this.root = root;
    }

    public URI getRootURI() {
        return this.root;
    }

    private static String getRegexFromGlob(String glob) {
        String regex = glob.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\.\\*").replaceAll("\\?", "\\.");
        return regex;
    }

    public static String toCanonicalFilename(String filename) {
        if ((filename = filename.replaceAll("\\\\", "/")).length() == 0 || filename.charAt(0) != '/') {
            filename = "/" + filename;
        }
        filename = filename.replaceAll("//", "/");
        return filename;
    }

    public static String toCanonicalFolderName(String name) {
        if (!(name = FileSystem.toCanonicalFilename(name)).endsWith("/")) {
            name = name + "/";
        }
        return name;
    }

    protected static URI toCanonicalFolderName(URI name) {
        try {
            String sname = name.toString();
            if (!sname.endsWith("/")) {
                sname = sname + "/";
            }
            return new URI(sname);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public abstract FileObject getFileObject(String var1);

    public abstract boolean isDirectory(String var1) throws IOException;

    public abstract String[] listDirectory(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listDirectory(String directory, ProgressMonitor monitor) throws IOException {
        monitor.started();
        monitor.setProgressMessage("listing " + directory);
        try {
            String[] result;
            String[] stringArray = result = this.listDirectory(directory);
            return stringArray;
        }
        finally {
            monitor.finished();
        }
    }

    public abstract String[] listDirectory(String var1, String var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listDirectory(String directory, String regex, ProgressMonitor monitor) throws IOException {
        monitor.started();
        monitor.setProgressMessage("listing " + directory);
        try {
            String[] result;
            String[] stringArray = result = this.listDirectory(directory, regex);
            return stringArray;
        }
        finally {
            monitor.finished();
        }
    }

    public String[] listDirectoryDeep(String directory, String regex) throws IOException {
        Object[] arrayResult = this.listDirectoryDeep(directory, regex, 1);
        Arrays.sort(arrayResult);
        return arrayResult;
    }

    private String[] listDirectoryDeep(String directory, String regex, int level) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        int i = regex.indexOf("/");
        logger.fine(String.format("listDirectoryDeep(%s,%s)\n", directory, regex));
        switch (i) {
            case -1: {
                String[] ss = this.listDirectory(directory, regex);
                for (int j = 0; j < ss.length; ++j) {
                    ss[j] = directory + ss[j];
                }
                return ss;
            }
            case 0: {
                String[] ss = this.listDirectory(directory, regex.substring(1));
                for (int j = 0; j < ss.length; ++j) {
                    ss[j] = directory + ss[j];
                }
                return ss;
            }
        }
        String[] ss = this.listDirectory(directory, regex.substring(0, i));
        if (ss.length == 1 && ss[0].length() == i + 1 && ss[0].substring(0, i).equals(regex.substring(0, i))) {
            String dir = ss[0];
            String[] ss1 = this.listDirectoryDeep(directory + dir, regex.substring(dir.length()), level + 1);
            return ss1;
        }
        for (String s : ss) {
            String[] ss1;
            if (!s.endsWith("/")) continue;
            for (String s1 : ss1 = this.listDirectoryDeep(directory + s, regex.substring(i + 1), level + 1)) {
                result.add(s1);
            }
        }
        logger.fine(String.format("listDirectoryDeep(%s,%s,%d)->%d items\n", directory, regex, level, result.size()));
        String[] arrayResult = result.toArray(new String[result.size()]);
        return arrayResult;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public abstract File getLocalRoot();

    public FileSystem createFileSystem(String directory) throws URISyntaxException {
        try {
            return new SubFileSystem(this, FileSystem.toCanonicalFolderName(directory));
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String[] splitUrl(String surl) {
        int i3;
        int fileEnd;
        int icolon = surl.indexOf(":");
        if (surl.charAt(0) == '/') {
            surl = "file://" + surl;
            icolon = 4;
        }
        if (!registry.keySet().contains(surl.substring(0, icolon).toLowerCase()) && icolon == 1) {
            surl = "file://" + (surl.charAt(0) == '/' ? surl : '/' + surl);
        }
        String params = null;
        int i = surl.indexOf("?");
        if (i != -1) {
            fileEnd = i;
            params = surl.substring(i + 1);
            if ((i = surl.indexOf("?", i + 1)) != -1) {
                throw new IllegalArgumentException("too many ??'s!");
            }
        } else {
            fileEnd = surl.length();
        }
        i = surl.lastIndexOf("/");
        String surlDir = surl.substring(0, i);
        String file = surl.substring(i, fileEnd);
        String ext = (i = file.lastIndexOf(46)) != -1 ? file.substring(i + 1) : "";
        int i2 = surl.indexOf("://") + 3;
        if (i2 == 2 && surl.startsWith("file:/")) {
            i2 = 5;
        }
        if ((i3 = surl.indexOf("/", i2 + 1)) == -1) {
            i3 = i2;
        }
        String[] result = new String[]{surl.substring(0, i2), surl.substring(0, i3), surlDir + "/", surl.substring(0, fileEnd), ext, params};
        return result;
    }

    public static synchronized ExceptionHandler getExceptionHandler() {
        if (exceptionHandler == null) {
            String val;
            String name = "java.awt.headless";
            String deft = "false";
            try {
                val = System.getProperty(name, deft);
            }
            catch (SecurityException ex) {
                val = deft;
            }
            boolean headless = "true".equals(val);
            exceptionHandler = headless ? new ThrowRuntimeExceptionHandler() : new DefaultExceptionHandler();
        }
        return exceptionHandler;
    }

    public static synchronized void setExceptionHandler(ExceptionHandler eh) {
        exceptionHandler = eh;
    }

    public static String[] getListing(DirectoryEntry[] des) {
        String[] result = new String[des.length];
        for (int i = 0; i < des.length; ++i) {
            result[i] = des[i].name + (des[i].type == 'd' ? "/" : "");
        }
        return result;
    }

    public static String[] getListing(Map<String, DirectoryEntry> des) {
        String[] result = new String[des.size()];
        Collection<DirectoryEntry> ddes = des.values();
        int i = 0;
        for (DirectoryEntry ent : ddes) {
            result[i] = ent.name + (ent.type == 'd' ? "/" : "");
            ++i;
        }
        return result;
    }

    public static FileSystem[] peekInstances() {
        int s = instances.size();
        return instances.values().toArray(new FileSystem[s]);
    }

    static {
        registry.put("file", new LocalFileSystemFactory());
        registry.put("http", new HttpFileSystemFactory());
        registry.put("https", new HttpFileSystemFactory());
        registry.put("ftp", new FtpFileSystemFactory());
        registry.put("zip", new ZipFileSystemFactory());
        exceptionHandler = null;
        NULL = new DirectoryEntry();
    }

    public static class DirectoryEntry {
        public String name;
        public char type;
        public long size;
        public long modified;
    }

    public static class FileSystemOfflineException
    extends IOException {
        public FileSystemOfflineException() {
        }

        public FileSystemOfflineException(String message) {
            super(message);
        }

        public FileSystemOfflineException(IOException e) {
            super(e.getMessage());
            this.initCause(e);
        }

        public FileSystemOfflineException(IOException e, URI root) {
            super(e.getMessage() + ": " + root);
            this.initCause(e);
        }
    }
}

