/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Date;
import org.das2.util.filesystem.WebFileObject;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.filesystem.WriteCapability;

public class GitHubFileObject
extends WebFileObject {
    public GitHubFileObject(WebFileSystem wfs, String pathname, Date modifiedDate) {
        super(wfs, pathname, modifiedDate);
    }

    @Override
    public <T> T getCapability(Class<T> clazz) {
        boolean enable = true;
        if (enable && clazz == WriteCapability.class) {
            final File localClone = this.wfs.getReadOnlyCache();
            if (localClone != null) {
                return (T)new WriteCapability(){

                    @Override
                    public OutputStream getOutputStream() throws IOException {
                        File f = Paths.get(localClone.getAbsolutePath(), GitHubFileObject.this.getNameExt()).toFile();
                        return new FileOutputStream(f);
                    }

                    @Override
                    public boolean canWrite() {
                        File f = Paths.get(localClone.getAbsolutePath(), GitHubFileObject.this.getNameExt()).toFile();
                        if (f.exists()) {
                            return f.canWrite();
                        }
                        return f.getParentFile().canWrite();
                    }

                    @Override
                    public boolean delete() throws IOException {
                        File f = Paths.get(localClone.getAbsolutePath(), GitHubFileObject.this.getNameExt()).toFile();
                        if (f.exists()) {
                            return f.delete();
                        }
                        return false;
                    }

                    @Override
                    public boolean commit(String message) throws IOException {
                        return true;
                    }
                };
            }
            return null;
        }
        return null;
    }
}

