/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import com.itextpdf.text.io.StreamUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemSettings;
import org.das2.util.filesystem.GitHubFileObject;
import org.das2.util.filesystem.HtmlUtil;
import org.das2.util.filesystem.HttpFileSystem;
import org.das2.util.filesystem.HttpUtil;
import org.das2.util.filesystem.WebFileObject;
import org.das2.util.filesystem.WebProtocol;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitHubFileSystem
extends HttpFileSystem {
    private static final Logger logger = LoggerManager.getLogger("das2.filesystem.wfs.githubfs");
    private String branch = "master";
    private int baseOffset = 0;

    private boolean isNeedLoginPage(File partFile) throws IOException {
        int MAX_LINE_COUNT = 100;
        try (PushbackInputStream is = new PushbackInputStream(new FileInputStream(partFile));){
            int bytesRead;
            byte[] cc = new byte[60];
            int p = bytesRead = is.read(cc);
            while (p < 15 && bytesRead > -1) {
                bytesRead = is.read(cc, p, 15 - p);
            }
            if (bytesRead == -1) {
                boolean bl = false;
                return bl;
            }
            boolean isLogin = false;
            if (new String(cc, "US-ASCII").trim().startsWith("<!DOCTYPE html>")) {
                try (BufferedReader r = new BufferedReader(new InputStreamReader(is));){
                    String line = r.readLine();
                    int lineCount = 0;
                    while (line != null) {
                        ++lineCount;
                        if (line.contains("Sign in")) {
                            isLogin = true;
                            break;
                        }
                        if (lineCount > MAX_LINE_COUNT) {
                            break;
                        }
                        line = r.readLine();
                    }
                }
            }
            boolean bl = isLogin;
            return bl;
        }
    }

    protected GitHubFileSystem(URI root, File localRoot, String branch, int baseOffset) {
        super(root, localRoot);
        File localRoCache;
        File f = this.getReadOnlyCache();
        if (f == null && (localRoCache = this.lookForROCacheGH(localRoot, branch)) != null) {
            this.setReadOnlyCache(localRoCache);
        }
        this.baseOffset = baseOffset;
        this.branch = branch;
        this.protocol = new GitHubHttpProtocol();
    }

    public static GitHubFileSystem createGitHubFileSystem(URI root) {
        return GitHubFileSystem.createGitHubFileSystem(root, 0);
    }

    public static File getLocalRoot(URI root) {
        String suri = root.toString();
        Pattern fsp1 = Pattern.compile("(https?://[a-zA-Z0-9+.\\-]+/)(.*)(tree|blob|raw)/(.*?)/(.*)");
        Matcher m1 = fsp1.matcher(suri);
        if (m1.matches()) {
            String project = m1.group(2);
            if (project.endsWith("/-/")) {
                project = project.substring(0, project.length() - 2);
            }
            suri = m1.group(1) + project + m1.group(4) + "/" + m1.group(5);
            try {
                root = new URI(suri);
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }
        File local = GitHubFileSystem.localRoot(root);
        logger.log(Level.FINER, "initializing httpfs {0} at {1}", new Object[]{root, local});
        return local;
    }

    public static String isGithubFileSystem(String h, String path) {
        if (h.equals("github.com")) {
            return "";
        }
        if (h.equals("git.uiowa.edu")) {
            return "";
        }
        if (h.equals("abbith.physics.uiowa.edu")) {
            return "";
        }
        if (h.equals("research-git.uiowa.edu")) {
            return "";
        }
        if (h.equals("git.physics.uiowa.edu")) {
            return "";
        }
        if (h.equals("github.umn.edu")) {
            return "";
        }
        if (h.equals("jfaden.net") && path.startsWith("/git")) {
            return "/git";
        }
        if (h.equals("gitlab.com")) {
            return "";
        }
        return null;
    }

    public static GitHubFileSystem createGitHubFileSystem(URI root, int baseOffset) {
        File local;
        String branch = "master";
        String suri = root.toString();
        Pattern fsp1 = Pattern.compile("(https?://[a-zA-Z0-9+.\\-]+/)(.*)(tree|blob|raw)/(.*?)/(.*)");
        Matcher m1 = fsp1.matcher(suri);
        if (m1.matches()) {
            String project = m1.group(2);
            branch = m1.group(4);
            if (project.endsWith("/-/")) {
                project = project.substring(0, project.length() - 2);
            }
            suri = m1.group(1) + project + branch + "/" + m1.group(5);
            try {
                root = new URI(suri);
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (FileSystemSettings.hasAllPermission()) {
            local = GitHubFileSystem.localRoot(root);
            logger.log(Level.FINER, "initializing httpfs {0} at {1}", new Object[]{root, local});
        } else {
            local = null;
            logger.log(Level.FINER, "initializing httpfs {0} in applet mode", root);
        }
        return new GitHubFileSystem(root, local, branch, baseOffset);
    }

    private static boolean mysteryDash(String host) {
        return host.contains("https://abbith.physics.uiowa.edu");
    }

    private String getGitProjectRoot() {
        String[] ss = this.root.toString().split("/");
        StringBuilder sb = new StringBuilder(ss[0]);
        int ni = Math.min(this.baseOffset + 5, ss.length);
        for (int i = 1; i < ni; ++i) {
            sb.append("/").append(ss[i]);
        }
        return sb.toString();
    }

    public String[] listDirectoryGitLabHowever(String directory) throws IOException {
        int i;
        String[] maybeListing;
        String[] path = this.root.getPath().split("/", -2);
        if ((this.root.getHost().startsWith("research-git.uiowa.edu") || this.root.getHost().startsWith("jfaden.net")) && (maybeListing = this.listDirectoryGitLab(directory)) != null) {
            return maybeListing;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.root.getScheme()).append("://").append(this.root.getHost()).append('/').append(path[1]).append('/').append(path[2]).append("/-/refs/").append(this.branch).append("/logs_tree");
        if (path.length > 3 && path[3].equals(this.branch)) {
            for (i = 4; i < path.length - 1; ++i) {
                sb.append("/");
                sb.append(path[i]);
            }
        } else {
            for (i = 1; i < path.length - 1; ++i) {
                sb.append("/");
                sb.append(path[i]);
            }
        }
        sb.append("?format=json&offset=0");
        URL url = new URL(sb.toString());
        try {
            String s = HtmlUtil.readToString(url);
            JSONArray ja = new JSONArray(s);
            String[] result = new String[ja.length()];
            for (int i2 = 0; i2 < result.length; ++i2) {
                result[i2] = ja.getJSONObject(i2).getString("file_name");
            }
            return result;
        }
        catch (JSONException ex) {
            logger.log(Level.SEVERE, "JSON not returned from Gitlab server, try again soon: {0}", url);
            return new String[0];
        }
        catch (CancelledOperationException ex) {
            throw new IOException("cancel pressed");
        }
    }

    public String[] listDirectoryGithub(String directory) throws IOException {
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        if (directory.equals("/") && this.root.getRawPath().equals("/")) {
            File dir = new File(FileSystem.settings().getLocalCacheDir() + "/" + this.root.getScheme() + "/" + this.root.getHost());
            String[] ss = dir.list();
            if (ss == null) {
                throw new IllegalArgumentException("dir was not a directory");
            }
            for (int i = 0; i < ss.length; ++i) {
                ss[i] = ss[i] + '/';
            }
            return ss;
        }
        if (!this.root.toString().startsWith("https://github.com/")) {
            throw new IllegalArgumentException("listDirectoryGithub can't be used here");
        }
        String[] path = this.root.getPath().split("/", -2);
        if (path.length < 4) {
            return null;
        }
        if (path[3].equals(this.branch)) {
            String[] npath = new String[path.length - 1];
            System.arraycopy(path, 0, npath, 0, 3);
            System.arraycopy(path, 4, npath, 3, path.length - 4);
            path = npath;
        }
        if (path.length < 5) {
            return null;
        }
        String spath = path[0] + '/' + path[1] + '/' + path[2];
        CharSequence[] pathsub = Arrays.copyOfRange(path, 3, path.length);
        URL url = new URL("https://api.github.com/repos" + path[0] + "/" + path[1] + "/" + path[2] + "/contents/" + String.join((CharSequence)"/", pathsub));
        try {
            String jsonListing = HtmlUtil.readToString(url);
            JSONArray jo = new JSONArray(jsonListing);
            String[] result = new String[jo.length()];
            for (int i = 0; i < result.length; ++i) {
                JSONObject item = jo.getJSONObject(i);
                String surl = item.getString("path");
                int k = surl.lastIndexOf("/");
                String type = item.getString("type");
                result[i] = type.equals("dir") ? surl.substring(k + 1) + "/" : surl.substring(k + 1);
            }
            return result;
        }
        catch (JSONException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (CancelledOperationException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public String[] listDirectoryGitLab(String directory) throws IOException {
        String path;
        String project;
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        if (directory.equals("/") && this.root.getRawPath().equals("/")) {
            File dir = new File(FileSystem.settings().getLocalCacheDir() + "/" + this.root.getScheme() + "/" + this.root.getHost());
            String[] ss = dir.list();
            if (ss == null) {
                throw new IllegalArgumentException("dir was not a directory");
            }
            for (int i = 0; i < ss.length; ++i) {
                ss[i] = ss[i] + '/';
            }
            return ss;
        }
        if (!this.root.getHost().equals("research-git.uiowa.edu")) {
            throw new IllegalArgumentException("only supported for research-git.uiowa.edu");
        }
        String[] pathComponents = this.root.getPath().split("/", -2);
        if (pathComponents.length < 4) {
            return null;
        }
        if (pathComponents[1].equals("space-physics")) {
            project = String.join((CharSequence)"%2F", Arrays.copyOfRange(pathComponents, 1, 4));
            path = String.join((CharSequence)"/", Arrays.copyOfRange(pathComponents, 4, pathComponents.length));
        } else {
            project = String.join((CharSequence)"%2F", Arrays.copyOfRange(pathComponents, 1, 3));
            path = String.join((CharSequence)"/", Arrays.copyOfRange(pathComponents, 3, pathComponents.length));
        }
        if (path.startsWith(this.branch + '/')) {
            path = path.substring(this.branch.length() + 1);
        }
        URL url = new URL(this.root.getScheme() + "://" + this.root.getHost() + "/api/v4/projects/" + project + "/repository/tree?path=" + path + "&ref=" + this.branch);
        try {
            String jsonListing = HtmlUtil.readToString(url);
            JSONArray jo = new JSONArray(jsonListing);
            String[] result = new String[jo.length()];
            for (int i = 0; i < result.length; ++i) {
                JSONObject item = jo.getJSONObject(i);
                String surl = item.getString("path");
                int k = surl.lastIndexOf("/");
                String type = item.getString("type");
                result[i] = type.equals("tree") ? surl.substring(k + 1) + "/" : surl.substring(k + 1);
            }
            return result;
        }
        catch (JSONException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (CancelledOperationException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public String[] listDirectory(String directory) throws IOException {
        String[] resultGithubMaybe;
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        if (directory.equals("/") && this.root.getRawPath().equals("/")) {
            File dir = new File(FileSystem.settings().getLocalCacheDir() + "/" + this.root.getScheme() + "/" + this.root.getHost());
            String[] ss = dir.list();
            if (ss == null) {
                throw new IllegalArgumentException("dir was not a directory");
            }
            for (int i = 0; i < ss.length; ++i) {
                ss[i] = ss[i] + '/';
            }
            return ss;
        }
        if (this.root.toString().startsWith("https://research-git.uiowa.edu/")) {
            try {
                return this.listDirectoryGitLabHowever(directory);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return new String[0];
            }
        }
        String[] path = this.root.getPath().split("/", -2);
        if (this.root.toString().startsWith("https://github.com/") && (resultGithubMaybe = this.listDirectoryGithub(directory)) != null) {
            return resultGithubMaybe;
        }
        String spath = path[0] + '/' + path[1] + '/' + path[2];
        if (this.baseOffset == 1) {
            spath = spath + '/' + path[3];
        }
        InputStream urlStream = null;
        try {
            String surl;
            URL url;
            if (path.length > 3) {
                url = this.gitHubMapDir(this.root, directory);
                surl = url.toString();
                if (GitHubFileSystem.mysteryDash(surl)) {
                    surl = surl.replace("raw/master", "-/tree/master");
                    url = new URL(surl);
                } else {
                    surl = surl.replace("raw/master", "tree/master");
                    url = new URL(surl);
                }
                logger.log(Level.FINE, "translated list URL to {0}", url);
            } else {
                url = this.root.toURL();
                surl = url.toString();
            }
            urlStream = HtmlUtil.getInputStream(url);
            URL[] listing = HtmlUtil.getDirectoryListing(url, urlStream, false);
            String sroot = this.root.toString();
            ArrayList<String> result = new ArrayList<String>();
            int parentLen = sroot.length() + (directory.length() - 1);
            String mysteryDash = GitHubFileSystem.mysteryDash(surl) ? "/-" : "";
            String projectRoot = this.getGitProjectRoot();
            int ii = sroot.indexOf(spath) + spath.length();
            if (sroot.substring(ii).startsWith("/" + this.branch + "/")) {
                ii = ii + this.branch.length() + 1;
            }
            String searchChild1 = projectRoot + mysteryDash + "/tree/" + this.branch + sroot.substring(ii);
            String searchChild2 = projectRoot + mysteryDash + "/blob/" + this.branch + sroot.substring(ii);
            for (URL u : listing) {
                String sub;
                String su = u.toString();
                if (!su.startsWith(searchChild1) && !su.startsWith(searchChild2)) continue;
                if (su.contains("/blob/" + this.branch + "/") && !su.endsWith(".gitkeep")) {
                    String k = su.substring(searchChild1.length());
                    if (result.contains(k)) continue;
                    result.add(k);
                    continue;
                }
                if (su.contains("/tree/" + this.branch + "/")) {
                    String ss;
                    if (su.length() <= parentLen || (ss = su.substring(searchChild1.length())).length() <= 1 || ss.contains("#start-of-content") || ss.contains("#content-body") || su.contains("return_to=") || su.endsWith("/..") || result.contains(ss = ss + "/")) continue;
                    result.add(ss);
                    continue;
                }
                if (!su.startsWith(surl) || (sub = su.substring(surl.length())).length() <= 0 || sub.charAt(0) == '#' || sub.contains("/") || result.contains(sub + "/")) continue;
                result.add(sub + "/");
            }
            Object[] objectArray = result.toArray(new String[result.size()]);
            return objectArray;
        }
        catch (CancelledOperationException ex) {
            throw new IOException("cancel pressed");
        }
        finally {
            try {
                if (urlStream != null) {
                    urlStream.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    public static String strjoin(String[] c, String delim, int start, int end) {
        StringBuilder result = new StringBuilder();
        if (start < 0) {
            start = c.length + start;
        }
        if (end < 0) {
            end = c.length + end;
        }
        for (int i = start; i < end; ++i) {
            String s = c[i];
            if (result.length() > 0) {
                result.append(delim);
            }
            result.append(s);
        }
        return result.toString();
    }

    private File lookForROCacheGH(File start, String branch) {
        File _localRoot = start = new File(start, branch);
        File stopFile = FileSystem.settings().getLocalCacheDir();
        File result = null;
        if (!_localRoot.toString().startsWith(stopFile.toString())) {
            throw new IllegalArgumentException("localRoot filename (" + stopFile + ") must be parent of local root: " + start);
        }
        block11: while (!_localRoot.equals(stopFile)) {
            File f = new File(_localRoot, "ro_cache.txt");
            if (f.exists()) {
                try (BufferedReader read = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));){
                    String s = read.readLine();
                    while (s != null) {
                        int i = s.indexOf("#");
                        if (i > -1) {
                            s = s.substring(0, i);
                        }
                        if (s.trim().length() > 0) {
                            if (s.startsWith("http:") || s.startsWith("https:") || s.startsWith("ftp:")) {
                                throw new IllegalArgumentException("ro_cache should contain the name of a local folder");
                            }
                            String sf = s.trim();
                            result = new File(sf);
                            break block11;
                        }
                        s = read.readLine();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
                break;
            }
            _localRoot = _localRoot.getParentFile();
        }
        if (result == null) {
            return result;
        }
        String tail = start.getAbsolutePath().substring(_localRoot.getAbsolutePath().length());
        if (tail.length() > 0) {
            if (tail.substring(1).startsWith(branch)) {
                tail = tail.substring(1 + branch.length());
            }
            return new File(result, tail);
        }
        return result;
    }

    public URL gitHubMapFile(URI root, String filename) throws MalformedURLException {
        int gitPathElements;
        int base;
        filename = GitHubFileSystem.toCanonicalFilename(filename);
        String[] path = root.getPath().split("/", -2);
        String spath = path[0] + '/' + path[1] + '/' + path[2];
        if (path[3 + this.baseOffset].equals(this.branch)) {
            base = 4;
            gitPathElements = 3;
        } else if (path.length > 4 + this.baseOffset && path[4 + this.baseOffset].equals(this.branch)) {
            base = 5;
            gitPathElements = 4;
            spath = path[0] + '/' + path[1] + '/' + path[2] + '/' + path[3];
        } else {
            base = 3;
            gitPathElements = 3;
        }
        for (int i = 0; i < this.baseOffset; ++i) {
            spath = spath + "/" + path[i + gitPathElements];
        }
        if (spath.startsWith("/")) {
            spath = spath.substring(1);
        }
        if (path[base + this.baseOffset].equals("blob")) {
            String n = root.getScheme() + "://" + root.getHost() + '/' + spath + "/raw/" + GitHubFileSystem.strjoin(path, "/", base + 1 + this.baseOffset, -1) + filename;
            URL url = new URL(n);
            return url;
        }
        if (root.getHost().equals("github.com") && filename.endsWith(".vap")) {
            String n = root.getScheme() + "://raw.githubusercontent.com" + '/' + spath + "/" + this.branch + "/" + GitHubFileSystem.strjoin(path, "/", base + this.baseOffset, -1) + filename;
            if (n.indexOf("//", 8) > -1) {
                n = n.substring(0, 8) + n.substring(8).replaceAll("//", "/");
            }
            URL url = new URL(n);
            return url;
        }
        if (base == 5) {
            String n = root.getScheme() + "://" + root.getHost() + '/' + spath + "/raw/" + this.branch + "/" + GitHubFileSystem.strjoin(path, "/", base + this.baseOffset, -1) + filename;
            URL url = new URL(n);
            return url;
        }
        String pp = GitHubFileSystem.strjoin(path, "/", base + this.baseOffset, -1);
        if (pp.length() > 0) {
            pp = "/" + pp;
        }
        String n = root.getScheme() + "://" + root.getHost() + '/' + spath + "/raw/" + this.branch + pp + filename;
        URL url = new URL(n);
        return url;
    }

    public URL gitHubMapDir(URI root, String filename) throws MalformedURLException {
        URL ff = this.gitHubMapFile(root, filename + "/readme.md");
        String s = ff.toString();
        if ((s = s.substring(0, s.length() - 10)).endsWith("raw/" + this.branch + "/")) {
            int len = ("raw/" + this.branch + "/").length();
            return new URL(s.substring(0, s.length() - len));
        }
        return new URL(s);
    }

    @Override
    public URI getURI(String filename) {
        try {
            return this.getURL(filename).toURI();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public URL getURL(String filename) {
        if ((filename = FileSystem.toCanonicalFilename(filename)).endsWith("/")) {
            try {
                return this.gitHubMapDir(this.root, filename);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            return this.gitHubMapFile(this.root, filename);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected Map<String, String> downloadFile(String filename, File targetFile, File partFile, ProgressMonitor monitor) throws IOException {
        Map<String, String> result;
        Lock lock = this.getDownloadLock(filename, targetFile, monitor);
        if (lock == null) {
            return Collections.EMPTY_MAP;
        }
        logger.log(Level.WARNING, "Thread {0} downloading {1}", new Object[]{Thread.currentThread(), filename});
        logger.log(Level.FINE, "downloadFile({0})", filename);
        FileOutputStream out = null;
        InputStream is = null;
        try {
            filename = GitHubFileSystem.toCanonicalFilename(filename);
            URL url = this.gitHubMapFile(this.root, filename);
            logger.log(Level.FINE, "downloading {0}", url);
            URLConnection urlc = url.openConnection();
            result = this.reduceMeta(urlc);
            int expectedContentLength = urlc.getContentLength();
            monitor.setTaskSize(expectedContentLength);
            out = new FileOutputStream(partFile);
            loggerUrl.log(Level.FINE, "GET {0}", new Object[]{urlc.getURL()});
            is = urlc.getInputStream();
            monitor.started();
            long totalBytesRead = this.copyStream(is, out, monitor);
            if (totalBytesRead < (long)urlc.getContentLength()) {
                logger.log(Level.WARNING, "fewer bytes downloaded than expected: {0} of {1}", new Object[]{totalBytesRead, expectedContentLength});
                throw new IOException("fewer bytes in HTTP response than stated in header.");
            }
            monitor.finished();
            out.close();
            is.close();
            if (this.isNeedLoginPage(partFile)) {
                throw new IOException("GitHub/GitLabs which requires authentication is not supported");
            }
            if (targetFile.exists() && !targetFile.delete()) {
                throw new IllegalArgumentException("unable to delete existing file " + targetFile);
            }
            if (!partFile.renameTo(targetFile)) {
                if (!partFile.renameTo(targetFile)) {
                    throw new IllegalArgumentException("unable to rename " + partFile + " to " + targetFile);
                }
                throw new IllegalArgumentException("unable to rename " + partFile + " to " + targetFile);
            }
        }
        catch (IOException e) {
            if (out != null) {
                out.close();
            }
            if (is != null) {
                is.close();
            }
            if (partFile.exists() && !partFile.delete()) {
                throw new IllegalArgumentException("unable to delete " + partFile);
            }
            throw e;
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    @Override
    public FileObject getFileObject(String filename) {
        return new GitHubFileObject(this, filename, new Date(Long.MAX_VALUE));
    }

    @Override
    public String toString() {
        return "githubfs " + this.root + (this.isOffline() ? " (offline)" : "");
    }

    private class GitHubHttpProtocol
    implements WebProtocol {
        private GitHubHttpProtocol() {
        }

        @Override
        public InputStream getInputStream(WebFileObject fo, ProgressMonitor mon) throws IOException {
            URL gitHubURL = GitHubFileSystem.this.gitHubMapFile(GitHubFileSystem.this.root, fo.getNameExt());
            logger.log(Level.FINE, "get InputStream from {0}", gitHubURL);
            try {
                InputStream result = HtmlUtil.getInputStream(gitHubURL);
                if (gitHubURL.toString().endsWith(".vap")) {
                    byte[] bb = StreamUtil.inputStreamToArray((InputStream)result);
                    logger.log(Level.FINE, "downloaded {0} got {1} bytes.", new Object[]{result, bb.length});
                    return new ByteArrayInputStream(bb);
                }
                return result;
            }
            catch (CancelledOperationException ex) {
                throw new InterruptedIOException(ex.getMessage());
            }
        }

        @Override
        public Map<String, String> getMetadata(WebFileObject fo) throws IOException {
            if (fo.wfs.offline) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("exist", String.valueOf(fo.localFile.exists()));
                result.put("LastModified", String.valueOf(fo.localFile.lastModified()));
                result.put("ContentLength", String.valueOf(fo.localFile.length()));
                result.put("ContentType", Files.probeContentType(fo.localFile.toPath()));
                return result;
            }
            URL ur = GitHubFileSystem.this.gitHubMapFile(GitHubFileSystem.this.root, fo.getNameExt());
            return HttpUtil.getMetadata(ur, null);
        }
    }
}

