/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.das2.util.Base64;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.OsUtil;
import org.das2.util.filesystem.AppletHttpProtocol;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemSettings;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.HtmlUtil;
import org.das2.util.filesystem.HttpUtil;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.filesystem.WebFileObject;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class HttpFileSystem
extends WebFileSystem {
    protected static final Logger logger = LoggerManager.getLogger("das2.filesystem.http");
    private final Map<String, FileSystem.DirectoryEntry> listingEntries = new HashMap<String, FileSystem.DirectoryEntry>();
    private final Map<String, Long> listingEntryFreshness = new HashMap<String, Long>();
    private String cookie = null;

    protected HttpFileSystem(URI root, File localRoot) {
        super(root, localRoot);
    }

    protected String getCookie() {
        return this.cookie;
    }

    public static HttpFileSystem createHttpFileSystem(URI rooturi) throws FileSystem.FileSystemOfflineException, UnknownHostException, FileNotFoundException {
        try {
            File local;
            HttpFileSystem parent;
            String[] ss;
            String auth = rooturi.getAuthority();
            if (auth == null) {
                throw new MalformedURLException("URL does not contain authority, check for ///");
            }
            if (rooturi.toString().contains("$Y")) {
                logger.fine("somehow template leaked into FileSystem code.");
            }
            if ((ss = auth.split("@")).length > 3) {
                throw new IllegalArgumentException("user info section can contain at most two at (@) symbols");
            }
            if (ss.length == 3) {
                StringBuilder userInfo = new StringBuilder(ss[0]);
                for (int i = 1; i < 2; ++i) {
                    userInfo.append("%40").append(ss[i]);
                }
                auth = ss[2];
                try {
                    URI rooturi2;
                    rooturi = rooturi2 = new URI(rooturi.getScheme() + "://" + userInfo.toString() + "@" + auth + rooturi.getPath());
                }
                catch (URISyntaxException ex) {
                    throw new IllegalArgumentException("unable to handle: " + rooturi);
                }
            }
            URL root = rooturi.toURL();
            logger.log(Level.FINER, "See https://www.draw.io/#G0B1Ywc5_Vexx1d3ctdGZxZDNkM3M");
            logger.log(Level.FINER, "URL Reference: {0}", root);
            boolean doCheck = true;
            URI parentURI = FileSystemUtil.getParentUri(rooturi);
            if (parentURI != null && (parent = (HttpFileSystem)HttpFileSystem.peek(parentURI)) != null && parent.isOffline()) {
                logger.finer("parent is offline, do not check...");
                doCheck = false;
            }
            boolean offline = true;
            String offlineMessage = "";
            int offlineResponseCode = 0;
            String cookie = null;
            while (doCheck && !FileSystem.settings().isOffline()) {
                String userInfo;
                HttpURLConnection urlc = (HttpURLConnection)root.openConnection();
                urlc.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
                urlc.setReadTimeout(FileSystem.settings().getReadTimeoutMs());
                try {
                    logger.log(Level.FINER, "Check keychain: ", root);
                    userInfo = KeyChain.getDefault().getUserInfo(root);
                }
                catch (CancelledOperationException ex) {
                    logger.log(Level.FINER, "user cancelled credentials for {0}", rooturi);
                    break;
                }
                if (userInfo != null) {
                    String encode = Base64.getEncoder().encodeToString(userInfo.getBytes());
                    urlc.setRequestProperty("Authorization", "Basic " + encode);
                }
                if ((cookie = KeyChain.getDefault().getCookie(root)) != null) {
                    urlc.setRequestProperty("Cookie", cookie);
                }
                int responseCode = -1;
                try {
                    logger.log(Level.FINER, "Verify Credentials {0}", urlc);
                    if (userInfo != null && !userInfo.contains(":")) {
                        logger.log(Level.INFO, "urlc={0}", urlc);
                        logger.log(Level.INFO, "userInfo does not appear to contain password: {0}", userInfo);
                    } else {
                        logger.log(Level.FINER, "userInfo.length={0}", userInfo == null ? -1 : userInfo.length());
                    }
                    urlc.connect();
                    responseCode = urlc.getResponseCode();
                    logger.log(Level.FINER, "made connection, now consume rest of stream: {0}", urlc);
                    try {
                        HttpUtil.consumeStream(urlc.getInputStream());
                    }
                    catch (IOException ex) {
                        logger.fine("exception when politely consuming stream after initial check");
                    }
                    logger.log(Level.FINER, "done consuming and initial connection is complete: {0}");
                    urlc.disconnect();
                    offline = false;
                    doCheck = false;
                    logger.finer("Verify Credentials exits with okay");
                }
                catch (SocketTimeoutException ex) {
                    logger.finer("Socket timeout");
                    HttpUtil.consumeStream(urlc.getErrorStream());
                    responseCode = 504;
                    offlineMessage = "socket timeout";
                    offlineResponseCode = 504;
                    doCheck = false;
                }
                catch (IOException ex) {
                    String msg;
                    logger.finer("Error with credentials");
                    int code = 0;
                    try {
                        code = urlc.getResponseCode();
                        msg = urlc.getResponseMessage();
                    }
                    catch (IOException ex2) {
                        logger.log(Level.SEVERE, ex2.getMessage(), ex2);
                        msg = ex2.getMessage();
                    }
                    HttpUtil.consumeStream(urlc.getErrorStream());
                    if (code == 404) {
                        logger.log(Level.SEVERE, String.format("%d: folder not found: %s\n%s", code, root, msg), ex);
                        throw (FileNotFoundException)ex;
                    }
                    if (code == 400) {
                        offlineMessage = "listing results in bad request";
                        logger.log(Level.SEVERE, String.format("%d: folder cannot be listed: %s\n%s", code, root, msg), ex);
                        doCheck = false;
                    } else if (code != 401) {
                        logger.log(Level.SEVERE, String.format("%d: failed to connect to %s\n%s", code, root, msg), ex);
                        if (FileSystem.settings().isAllowOffline()) {
                            logger.info("remote filesystem is offline, allowing access to local cache.");
                            break;
                        }
                        throw new FileSystem.FileSystemOfflineException("" + code + ": " + msg);
                    }
                    if ("true".equals(System.getProperty("java.awt.headless")) && userInfo != null) {
                        logger.finer("Headless mode means we have to give up");
                        if (FileSystem.settings().isAllowOffline()) {
                            logger.info("remote filesystem is offline, allowing access to local cache.");
                            break;
                        }
                        throw new FileSystem.FileSystemOfflineException("" + code + ": " + msg);
                    }
                    if (offlineMessage.length() == 0) {
                        offlineMessage = msg;
                    }
                    offlineResponseCode = code;
                }
                if (responseCode == 404) {
                    throw new FileNotFoundException("root returns 404, indicating it does not exist");
                }
                if (responseCode == 504) continue;
                if (responseCode != 200 && responseCode != 403) {
                    if (responseCode == 401) {
                        if (userInfo != null) {
                            KeyChain.getDefault().clearUserPassword(root);
                        }
                        if (userInfo != null) continue;
                        String port = root.getPort() == -1 ? "" : ":" + root.getPort();
                        URL rootAuth = new URL(root.getProtocol() + "://user@" + root.getHost() + port + root.getFile());
                        try {
                            URI rootAuthUri;
                            rooturi = rootAuthUri = rootAuth.toURI();
                            root = rooturi.toURL();
                            continue;
                        }
                        catch (URISyntaxException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    if (responseCode == 400) {
                        offline = true;
                        continue;
                    }
                    offline = false;
                    continue;
                }
                offline = false;
            }
            if (FileSystemSettings.hasAllPermission()) {
                local = HttpFileSystem.localRoot(rooturi);
                logger.log(Level.FINER, "initializing httpfs {0} at {1}", new Object[]{root, local});
            } else {
                local = null;
                logger.log(Level.FINER, "initializing httpfs {0} in applet mode", root);
            }
            HttpFileSystem result = new HttpFileSystem(rooturi, local);
            if (offline) {
                logger.log(Level.WARNING, "filesystem is offline: {0}", rooturi);
            }
            result.offline = offline;
            result.offlineMessage = offlineMessage;
            result.offlineResponseCode = offlineResponseCode;
            result.cookie = cookie;
            return result;
        }
        catch (FileNotFoundException | UnknownHostException | FileSystem.FileSystemOfflineException e) {
            throw e;
        }
        catch (IOException e) {
            throw new FileSystem.FileSystemOfflineException(e, rooturi);
        }
    }

    private boolean waitDownloadExternal(File f, File partFile, ProgressMonitor monitor) {
        monitor.setProgressMessage("waiting for other process load");
        while (partFile.exists() && System.currentTimeMillis() - partFile.lastModified() < 60000L) {
            try {
                Thread.sleep(300L);
                logger.log(Level.FINEST, "waiting for external process to download {0}", partFile);
                monitor.setTaskProgress(partFile.length());
                if (!monitor.isCancelled()) continue;
                return false;
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if (partFile.exists()) {
            logger.finer("timeout waiting for partFile to be deleted");
            return false;
        }
        if (f.exists()) {
            logger.finer("successfully waited for external download to complete");
            return true;
        }
        logger.finer("part file removed but complete file is not found");
        return false;
    }

    protected Map<String, String> reduceMeta(URLConnection connect) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("ETag", connect.getHeaderField("ETag"));
        result.put("ContentType", connect.getHeaderField("ContentType"));
        if (connect instanceof HttpURLConnection) {
            try {
                result.put("_ResponseCode", String.valueOf(((HttpURLConnection)connect).getResponseCode()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private Map<String, String> doTryDownload(URLConnection urlc, URL remoteURL, String filename, File f, File partFile, ProgressMonitor monitor) throws IOException {
        Map<String, String> result;
        block29: {
            if (loggerUrl.isLoggable(Level.FINE) && urlc.getURL().getPath().endsWith("/")) {
                loggerUrl.log(Level.FINE, "GET to get listing {0}", new Object[]{urlc.getURL()});
            } else {
                loggerUrl.log(Level.FINE, "GET to get data {0}", new Object[]{urlc.getURL()});
            }
            InputStream in = urlc.getInputStream();
            HttpURLConnection hurlc = (HttpURLConnection)urlc;
            if (hurlc.getResponseCode() == 404) {
                logger.log(Level.INFO, "{0} URL: {1}", new Object[]{hurlc.getResponseCode(), remoteURL});
                throw new FileNotFoundException("not found: " + remoteURL);
            }
            if (hurlc.getResponseCode() != 200) {
                logger.log(Level.INFO, "{0} URL: {1}", new Object[]{hurlc.getResponseCode(), remoteURL});
                throw new IOException(hurlc.getResponseCode() + ": " + hurlc.getResponseMessage() + "\n" + remoteURL);
            }
            List<String> sd = urlc.getHeaderFields().get("Last-Modified");
            Date d = sd != null && sd.size() > 0 ? new Date(sd.get(sd.size() - 1)) : new Date();
            long expectedContentLength = urlc.getContentLengthLong();
            monitor.setTaskSize(expectedContentLength);
            if (!f.getParentFile().exists()) {
                logger.log(Level.FINER, "make dirs {0}", f.getParentFile());
                FileSystemUtil.maybeMkdirs(f.getParentFile());
            }
            if (partFile.exists()) {
                logger.log(Level.FINER, "partFile exists {0}", partFile);
                long ageMillis = System.currentTimeMillis() - partFile.lastModified();
                if (ageMillis < 60000L) {
                    if (this.waitDownloadExternal(f, partFile, monitor)) {
                        return Collections.EMPTY_MAP;
                    }
                    if (monitor.isCancelled()) {
                        throw new InterruptedIOException("interrupt while waiting for external process to download " + partFile);
                    }
                    throw new IOException("timeout waiting for external process to download " + partFile);
                }
                if (!partFile.delete()) {
                    logger.log(Level.INFO, "Unable to delete part file {0}, using new name for part file.", partFile);
                    partFile = new File(f.toString() + ".part." + System.currentTimeMillis());
                }
            }
            if (partFile.createNewFile()) {
                logger.log(Level.FINER, "transferring bytes of {0}", filename);
                FileOutputStream out = new FileOutputStream(partFile);
                monitor.setLabel("downloading file");
                monitor.started();
                try {
                    long totalBytesRead;
                    boolean doUnzip;
                    String contentLocation = urlc.getHeaderField("Content-Location");
                    String contentType = urlc.getHeaderField("Content-Type");
                    result = this.reduceMeta(urlc);
                    boolean bl = doUnzip = !filename.endsWith(".gz") && "application/x-gzip".equals(contentType) && (contentLocation == null || contentLocation.endsWith(".gz"));
                    if (doUnzip) {
                        in = new GZIPInputStream(in);
                    }
                    if ((totalBytesRead = this.copyStream(in, out, monitor)) < (long)urlc.getContentLength()) {
                        logger.log(Level.WARNING, "fewer bytes downloaded than expected: {0} of {1}", new Object[]{totalBytesRead, expectedContentLength});
                        throw new IOException("fewer bytes in HTTP response than stated in header.");
                    }
                    monitor.finished();
                    out.close();
                    in.close();
                    try {
                        partFile.setLastModified(d.getTime() + 10000L);
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "unable to setLastModified", ex);
                    }
                    if (f.exists()) {
                        if (f.isDirectory()) {
                            logger.finer("file was once a directory.");
                            if (!FileUtil.deleteFileTree(f)) {
                                throw new IllegalArgumentException("unable to folder to make way for file: " + f);
                            }
                        } else {
                            if (f.length() == partFile.length()) {
                                if (OsUtil.contentEquals(f, partFile)) {
                                    logger.finer("another thread must have downloaded file.");
                                    if (f.lastModified() == 0L) {
                                        logger.finer("existing file didn't have a proper timetag, copy timetag from part file.");
                                        if (!f.setLastModified(partFile.lastModified())) {
                                            logger.log(Level.INFO, "unable to set last modified on {0}", f);
                                        }
                                    }
                                    if (!partFile.delete()) {
                                        throw new IllegalArgumentException("unable to delete " + partFile);
                                    }
                                    return result;
                                }
                                logger.finer("another thread must have downloaded different file.");
                            }
                            logger.log(Level.FINER, "deleting old file {0}", f);
                            if (!f.delete()) {
                                throw new IllegalArgumentException("unable to delete " + f);
                            }
                        }
                    }
                    if (!partFile.renameTo(f)) {
                        logger.log(Level.WARNING, "rename failed {0} to {1}", new Object[]{partFile, f});
                        throw new IllegalArgumentException("rename failed " + partFile + " to " + f);
                    }
                    break block29;
                }
                catch (IOException e) {
                    out.close();
                    in.close();
                    logger.log(Level.FINER, "deleting partial download file {0}", partFile);
                    if (partFile.exists() && !partFile.delete()) {
                        throw new IllegalArgumentException("unable to delete " + partFile);
                    }
                    throw e;
                }
            }
            throw new IOException("could not create local file: " + f);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, String> doDownload(String filename, URL remoteURL, File f, File partFile, ProgressMonitor monitor) throws IOException, FileNotFoundException {
        String userInfo;
        logger.log(Level.FINE, "doDownload {0}", remoteURL);
        Map<String, String> result = null;
        loggerUrl.log(Level.FINE, "open connection to {0}", remoteURL);
        HttpURLConnection urlc = (HttpURLConnection)remoteURL.openConnection();
        urlc.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
        urlc.setReadTimeout(FileSystem.settings().getReadTimeoutMs());
        urlc.setUseCaches(false);
        try {
            userInfo = KeyChain.getDefault().getUserInfo(this.root);
        }
        catch (CancelledOperationException ex) {
            throw new IOException("user cancelled at credentials entry");
        }
        if (userInfo != null) {
            String encode = Base64.getEncoder().encodeToString(userInfo.getBytes());
            urlc.setRequestProperty("Authorization", "Basic " + encode);
        }
        if (this.cookie != null) {
            urlc.addRequestProperty("Cookie", this.cookie);
        }
        HttpURLConnection oldurlc = urlc;
        if (!(urlc = (HttpURLConnection)HttpUtil.checkRedirect(urlc)).equals(oldurlc) && (userInfo = KeyChain.getDefault().checkUserInfo(urlc.getURL())) != null) {
            String encode = Base64.getEncoder().encodeToString(userInfo.getBytes());
            try {
                urlc.setRequestProperty("Authorization", "Basic " + encode);
            }
            catch (IllegalStateException ex) {
                logger.info("We are already connected, so resetting credentials would cause Already connected error");
            }
        }
        try {
            boolean haveIt = false;
            while (!haveIt) {
                try {
                    result = this.doTryDownload(urlc, remoteURL, filename, f, partFile, monitor);
                    haveIt = true;
                }
                catch (IOException ex) {
                    if (ex.getCause() != null && ex.getCause() instanceof CancelledOperationException) {
                        throw ex;
                    }
                    if (urlc.getResponseCode() != 401) throw ex;
                    if (result == null) {
                        result = new HashMap<String, String>();
                    }
                    result.put("_ResponseCode", String.valueOf(urlc.getResponseCode()));
                    URL theUrl = urlc.getURL();
                    try {
                        KeyChain.getDefault().clearUserPassword(theUrl);
                        userInfo = KeyChain.getDefault().getUserInfo(theUrl, "user:pass");
                    }
                    catch (CancelledOperationException ex1) {
                        throw ex;
                    }
                    HttpURLConnection newConnection = (HttpURLConnection)theUrl.openConnection();
                    HttpUtil.copyConnectProperties(urlc, newConnection);
                    String encode = Base64.getEncoder().encodeToString(userInfo.getBytes());
                    newConnection.setRequestProperty("Authorization", "Basic " + encode);
                    urlc.disconnect();
                    urlc = newConnection;
                    continue;
                    return result;
                }
            }
        }
        finally {
            if (urlc instanceof HttpURLConnection) {
                if (remoteURL.getPath().endsWith("/")) {
                    logger.fine("not closing, because it was a listing file.");
                } else {
                    urlc.disconnect();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, String> downloadFile(String filename, File targetFile, File partFile, ProgressMonitor monitor) throws IOException {
        Map<String, String> meta;
        block8: {
            Lock lock = this.getDownloadLock(filename, targetFile, monitor);
            if (lock == null) {
                return Collections.EMPTY_MAP;
            }
            meta = Collections.EMPTY_MAP;
            filename = HttpFileSystem.toCanonicalFilename(filename);
            logger.log(Level.FINER, "downloadFile {0}, using temporary file {1}", new Object[]{filename, partFile});
            try {
                URL remoteURL = this.getURL(filename);
                try {
                    meta = this.doDownload(filename, remoteURL, targetFile, partFile, monitor);
                }
                catch (FileNotFoundException ex) {
                    if (filename.endsWith("/")) break block8;
                    remoteURL = new URL(this.root.toString() + filename.substring(1) + ".gz");
                    try {
                        this.doDownload(filename, remoteURL, targetFile, partFile, monitor);
                    }
                    catch (FileNotFoundException exgz) {
                        throw ex;
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
        return meta;
    }

    protected Map<String, Object> getHeadMeta(String f) throws IOException, CancelledOperationException {
        try {
            URL ur = new URL(this.root.toURL().toString() + (f.length() > 0 ? f.substring(1) : f));
            Map<String, String> meta = HttpUtil.getMetadata(ur, null);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.putAll(meta);
            result.put("EXIST", Boolean.parseBoolean(meta.get("exist")));
            result.put("exist", Boolean.parseBoolean(meta.get("exist")));
            result.put("ContentLength", Long.parseLong(meta.get("ContentLength")));
            result.put("LastModified", Long.parseLong(meta.get("LastModified")));
            return result;
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public boolean isDirectory(String filename) throws IOException {
        if (this.localRoot == null) {
            return filename.endsWith("/");
        }
        File f = new File(this.localRoot, filename);
        if (f.exists()) {
            return f.isDirectory();
        }
        if (filename.endsWith("/")) {
            return true;
        }
        File parentFile = f.getParentFile();
        String parent = this.getLocalName(parentFile);
        if (!parent.endsWith("/")) {
            parent = parent + "/";
        }
        String[] list = this.listDirectory(parent);
        String lookFor = filename.startsWith("/") ? filename.substring(1) + "/" : filename + "/";
        for (String list1 : list) {
            if (!list1.equals(lookFor)) continue;
            return true;
        }
        return false;
    }

    private List<String> hideExtensions() {
        return Arrays.asList(".css", ".php", ".jnlp", ".part");
    }

    @Override
    public String[] listDirectory(String directory) throws IOException {
        logger.log(Level.FINE, "** listDirectory({0}{1})", new Object[]{this.root, directory});
        FileSystem.DirectoryEntry[] cached = this.listDirectoryFromMemory(directory);
        if (cached != null) {
            return FileSystem.getListing(cached);
        }
        if (this.protocol != null && this.protocol instanceof AppletHttpProtocol) {
            URL[] list;
            try (InputStream in = this.protocol.getInputStream(new WebFileObject(this, directory, new Date()), new NullProgressMonitor());){
                list = HtmlUtil.getDirectoryListing(this.getURL(directory), in);
            }
            catch (CancelledOperationException ex) {
                throw new IllegalArgumentException(ex);
            }
            String[] result = new String[list.length];
            int n = directory.length();
            for (int i = 0; i < list.length; ++i) {
                URL url = list[i];
                result[i] = this.getLocalName(url).substring(n);
            }
            return result;
        }
        if (this.isListingCached(directory = HttpFileSystem.toCanonicalFolderName(directory))) {
            URL[] list;
            logger.log(Level.FINER, "using cached listing for {0}", directory);
            File listing = this.listingFile(directory);
            try {
                URL[] url = null;
                try (FileInputStream fin = new FileInputStream(listing);){
                    list = HtmlUtil.getDirectoryListing(this.getURL(directory), fin);
                }
                catch (Throwable object) {
                    url = object;
                    throw object;
                }
            }
            catch (CancelledOperationException ex) {
                throw new IllegalArgumentException(ex);
            }
            Map<String, FileSystem.DirectoryEntry> result = new LinkedHashMap<String, FileSystem.DirectoryEntry>(list.length);
            int n = directory.length();
            for (URL url : list) {
                FileSystem.DirectoryEntry directoryEntry = new FileSystem.DirectoryEntry();
                directoryEntry.modified = Long.MAX_VALUE;
                directoryEntry.name = this.getLocalName(url).substring(n);
                directoryEntry.type = (char)102;
                directoryEntry.size = Long.MAX_VALUE;
                result.put(directoryEntry.name, directoryEntry);
            }
            result = this.addRoCacheEntries(directory, result);
            this.cacheListing(directory, result.values().toArray(new FileSystem.DirectoryEntry[result.size()]));
            return FileSystem.getListing(result);
        }
        boolean successOrCancel = false;
        if (this.isOffline()) {
            File f = new File(this.localRoot, directory).getCanonicalFile();
            logger.log(Level.FINER, "this filesystem is offline, using local listing: {0}", f);
            Map<String, FileSystem.DirectoryEntry> result = this.addRoCacheEntries(directory, new LinkedHashMap<String, FileSystem.DirectoryEntry>());
            if (!f.exists() && result.isEmpty()) {
                throw new FileSystem.FileSystemOfflineException("unable to list " + f + " when offline");
            }
            ArrayList<String> result1 = new ArrayList<String>();
            if (f.exists()) {
                File[] listing = f.listFiles();
                if (listing == null) {
                    throw new IllegalArgumentException("expected resource to be a directory: " + f);
                }
                for (Object object : listing) {
                    if (((File)object).getName().endsWith(".listing")) continue;
                    if (((File)object).isDirectory()) {
                        result1.add(((File)object).getName() + '/');
                        continue;
                    }
                    result1.add(((File)object).getName());
                }
            }
            for (FileSystem.DirectoryEntry f1 : result.values()) {
                if (f1.type == 'd') {
                    int n = f1.name.length();
                    if (n > 0 && f1.name.charAt(n - 1) == '/') {
                        result1.add(f1.name);
                        continue;
                    }
                    result1.add(f1.name + '/');
                    continue;
                }
                result1.add(f1.name);
            }
            return result1.toArray(new String[result1.size()]);
        }
        while (!successOrCancel) {
            logger.log(Level.FINER, "list {0}", directory);
            try {
                URL[] list;
                File listing = this.listingFile(directory);
                Map<String, String> metaz = this.downloadFile(directory, listing, this.getPartFile(listing), new NullProgressMonitor());
                String code = metaz.get("_ResponseCode");
                if (code != null && Integer.parseInt(code) == 401) {
                    URL remoteURL = this.getURL(directory);
                    KeyChain.getDefault().clearUserPassword(remoteURL);
                    continue;
                }
                if (!listing.setLastModified(System.currentTimeMillis())) {
                    logger.log(Level.WARNING, "failed to setLastModified: {0}", listing);
                }
                try (FileInputStream fin = new FileInputStream(listing);){
                    list = HtmlUtil.getDirectoryListing(this.getURL(directory), fin);
                }
                int n = FileSystemUtil.uriEncode(directory).length();
                ArrayList<URL> newlist = new ArrayList<URL>();
                List<String> list2 = this.hideExtensions();
                for (URL s : list) {
                    boolean hide = false;
                    if (!s.getFile().endsWith("/")) {
                        for (String e : list2) {
                            if (!s.getFile().endsWith(e)) continue;
                            hide = true;
                        }
                    }
                    try {
                        String ss = this.getLocalName(s).substring(n);
                        if (ss.split("/").length > 1) {
                            hide = true;
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        hide = true;
                    }
                    if (hide) continue;
                    newlist.add(s);
                }
                list = newlist.toArray(new URL[newlist.size()]);
                Map<String, FileSystem.DirectoryEntry> result = new LinkedHashMap<String, FileSystem.DirectoryEntry>();
                for (URL url : list) {
                    FileSystem.DirectoryEntry de1 = new FileSystem.DirectoryEntry();
                    de1.modified = Long.MAX_VALUE;
                    de1.name = this.getLocalName(url).substring(n);
                    de1.type = (char)102;
                    de1.size = Long.MAX_VALUE;
                    result.put(de1.name, de1);
                }
                result = this.addRoCacheEntries(directory, result);
                this.cacheListing(directory, result.values().toArray(new FileSystem.DirectoryEntry[result.size()]));
                return FileSystem.getListing(result);
            }
            catch (CancelledOperationException ex) {
                throw new IOException("user cancelled at credentials");
            }
            catch (IOException ex) {
                if (this.isOffline()) {
                    logger.info("** using local listing because remote is not available");
                    logger.info("or some other error occurred. **");
                    File localFile = new File(this.localRoot, directory);
                    return localFile.list();
                }
                throw ex;
            }
        }
        return new String[]{"should not get here"};
    }

    public static boolean isRegexNoWild(String regex) {
        return regex.equals("screen.png");
    }

    @Override
    public String[] listDirectory(String directory, String regex) throws IOException {
        logger.log(Level.FINE, "listDirectory({0},{1})", new Object[]{directory, regex});
        if (regex.endsWith("/")) {
            regex = regex.substring(0, regex.length() - 1);
        }
        if (!this.isDirectory(directory = HttpFileSystem.toCanonicalFilename(directory))) {
            throw new IllegalArgumentException("is not a directory: " + directory);
        }
        if (HttpFileSystem.isRegexNoWild(regex)) {
            try {
                Map<String, Object> meta = this.getHeadMeta(directory + regex);
                if (Boolean.TRUE.equals(meta.get("exist"))) {
                    return new String[]{regex};
                }
            }
            catch (CancelledOperationException ex) {
                Logger.getLogger(HttpFileSystem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        String[] listing = this.listDirectory(directory);
        Pattern pattern = Pattern.compile(regex);
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = listing;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String s;
            String c = s = stringArray[i];
            if (s.charAt(s.length() - 1) == '/') {
                c = s.substring(0, s.length() - 1);
            }
            if (!pattern.matcher(c).matches()) continue;
            result.add(s);
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem.DirectoryEntry maybeUpdateDirectoryEntry(String filename, boolean force) throws IOException {
        Long fresh = this.listingEntryFreshness.get(filename);
        if (fresh != null) {
            if (new Date().getTime() - fresh < 10000L) {
                return this.listingEntries.get(filename);
            }
            HttpFileSystem httpFileSystem = this;
            synchronized (httpFileSystem) {
                this.listingEntryFreshness.remove(filename);
                this.listingEntries.remove(filename);
            }
        }
        try {
            Map<String, Object> meta = this.getHeadMeta(filename);
            FileSystem.DirectoryEntry de = new FileSystem.DirectoryEntry();
            String odate = (String)meta.get("Date");
            String osize = (String)meta.get("Content-Length");
            de.type = (char)(filename.endsWith("/") ? 100 : 102);
            if (odate != null && osize != null) {
                de.modified = new Date(odate).getTime();
                de.size = Long.parseLong(osize);
                HttpFileSystem httpFileSystem = this;
                synchronized (httpFileSystem) {
                    this.listingEntries.put(filename, de);
                    this.listingEntryFreshness.put(filename, new Date().getTime());
                }
                return de;
            }
            return super.maybeUpdateDirectoryEntry(filename, force);
        }
        catch (CancelledOperationException ex) {
            return super.maybeUpdateDirectoryEntry(filename, force);
        }
    }
}

