/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.das2.util.Base64;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemSettings;
import org.das2.util.filesystem.HttpUtil;
import org.das2.util.monitor.CancelledOperationException;

public class KeyChain {
    private static final Logger logger = LoggerManager.getLogger("das2.filesystem.keychain");
    private static KeyChain instance;
    private static Map<String, KeyChain> instances;
    private final Map<String, String> keys = new LinkedHashMap<String, String>();
    private final Map<String, String> cookies = new HashMap<String, String>();
    private Component parent = null;
    private Map<String, Lock> locks = new HashMap<String, Lock>();
    private Map<String, Long> cancelPressTimers = new HashMap<String, Long>();
    private static final int CANCEL_PRESS_TIMEOUT = 2000;

    public static synchronized KeyChain getDefault() {
        if (instance == null) {
            instance = new KeyChain();
            instance.loadInitial();
        }
        return instance;
    }

    public static synchronized KeyChain getInstance(String name) {
        if (name == null || name.length() == 0) {
            return KeyChain.getDefault();
        }
        KeyChain t = instances.get(name);
        if (t != null) {
            return t;
        }
        t = new KeyChain();
        instances.put(name, t);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInitial() {
        File keysFile = new File(FileSystem.settings().getLocalCacheDir(), "keychain.txt");
        if (keysFile.exists()) {
            logger.log(Level.FINE, "loading keys from {0}", keysFile);
            BufferedReader r = null;
            try {
                r = new BufferedReader(new FileReader(keysFile));
                String line = r.readLine();
                while (line != null) {
                    int i = line.indexOf("#");
                    if (i > -1) {
                        line = line.substring(0, i);
                    }
                    if ((line = line.trim()).length() > 0) {
                        String[] ss = line.split("\\t");
                        if (ss.length == 1) {
                            ss = line.split(" ");
                        }
                        if (ss.length != 2) {
                            logger.log(Level.WARNING, "skipping line because wrong number of fields, line starts with: {0}", ss[0]);
                        } else {
                            String hash = ss[0].trim();
                            String storedUserInfo = ss[1].trim();
                            if (!hash.endsWith("/")) {
                                int k = hash.lastIndexOf("/");
                                hash = hash.substring(0, k + 1);
                            }
                            this.keys.put(hash, storedUserInfo);
                        }
                    }
                    line = r.readLine();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "while loading keychain.txt file " + keysFile, ex);
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                        logger.log(Level.FINE, "loaded keys from keychain file {0}", keysFile);
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            }
        } else {
            logger.log(Level.FINE, "keychain file not found: {0}", keysFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendKeysFile(String url, String key) throws IOException {
        int i = url.lastIndexOf(47);
        url = url.substring(0, i + 1);
        File keysFile = new File(FileSystem.settings().getLocalCacheDir(), "keychain.txt");
        try (PrintWriter w = null;){
            if (keysFile.exists()) {
                if (!keysFile.canWrite()) throw new IOException("Unable to append to file: " + keysFile);
                w = new PrintWriter(new FileWriter(keysFile, true));
            } else {
                try {
                    w = new PrintWriter(new FileWriter(keysFile));
                    if (!keysFile.setReadable(false)) {
                        logger.warning("setReadable failure");
                    }
                    if (!keysFile.setReadable(false, false)) {
                        logger.warning("setReadable failure");
                    }
                    if (!keysFile.setReadable(true, true)) {
                        logger.warning("setReadable failure");
                    }
                    if (!keysFile.setWritable(false)) {
                        logger.warning("setWritable failure");
                    }
                    if (!keysFile.setWritable(false, false)) {
                        logger.warning("setWritable failure");
                    }
                    if (!keysFile.setWritable(true, true)) {
                        logger.warning("setWritable failure");
                    }
                }
                catch (IOException ex) {
                    throw new IOException("Unable to create file: " + keysFile);
                }
            }
            w.append(url).append("\t").append(key).append("\n");
            return;
        }
    }

    public void writeKeysFile() {
        try {
            this.writeKeysFile(false);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeKeysFile(boolean toFile) throws IOException {
        File keysFile = new File(FileSystem.settings().getLocalCacheDir(), "keychain.txt");
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintWriter w = null;){
            w = new PrintWriter(out);
            w.println("# keys file produced on " + new Date());
            w.println("# " + keysFile);
            for (Map.Entry<String, String> entry : this.keys.entrySet()) {
                w.println(entry.getKey() + "\t" + entry.getValue());
            }
        }
        if (toFile) {
            Throwable throwable = null;
            try (FileOutputStream fout = new FileOutputStream(keysFile);){
                fout.write(out.toByteArray());
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            if (!keysFile.setReadable(false)) {
                logger.warning("setReadable failure");
            }
            if (!keysFile.setReadable(false, false)) {
                logger.warning("setReadable failure");
            }
            if (!keysFile.setReadable(true, true)) {
                logger.warning("setReadable failure");
            }
            if (!keysFile.setWritable(false)) {
                logger.warning("setWritable failure");
            }
            if (!keysFile.setWritable(false, false)) {
                logger.warning("setWritable failure");
            }
            if (!keysFile.setWritable(true, true)) {
                logger.warning("setWritable failure");
            }
        }
        JButton button = new JButton(new AbstractAction("Show Passwords"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextArea ta = new JTextArea();
                ta.setText(new String(out.toByteArray()));
                JOptionPane.showMessageDialog(KeyChain.this.parent, ta);
            }
        });
        String string = toFile ? "The keychain file has been created:" : "You must create a protected file";
        JPanel p = new JPanel(new BorderLayout());
        p.add(new JLabel("<html>******************************<br>" + string + "<br>" + keysFile + "<br>that contains all passwords.<br>Click the button below to show content, <b>which contains passwords.</b><br>******************************"));
        p.add((Component)button, "South");
        JOptionPane.showMessageDialog(this.parent, p);
    }

    public String getUserInfo(URI uri) throws CancelledOperationException {
        try {
            return this.getUserInfo(uri.toURL());
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getUserInfo(URL url) throws CancelledOperationException {
        String userInfo = url.getUserInfo();
        if (userInfo == null) {
            return null;
        }
        return this.getUserInfo(url, userInfo);
    }

    public String checkUserInfo(URL url) {
        String userInfo = url.getUserInfo();
        String userName = null;
        if (userInfo != null) {
            String[] ss = userInfo.split(":", 2);
            userName = ss[0];
        }
        String path = url.getProtocol() + "://" + (userName != null ? userName + "@" : "") + url.getHost() + url.getPath();
        String storedUserInfo = this.lookupStoredUserInfo(path);
        return storedUserInfo;
    }

    public void setUserInfo(URL url, String userInfo) {
        String hash = url.getProtocol() + "://" + url.getHost() + "/";
        this.keys.put(hash, userInfo);
    }

    public String getUserInfoBase64Encoded(URL url) throws CancelledOperationException {
        String userInfo = this.getUserInfo(url);
        if (userInfo != null) {
            return Base64.getEncoder().encodeToString(userInfo.getBytes());
        }
        return null;
    }

    public void setParentGUI(Component c) {
        this.parent = c;
    }

    public String getWWWAuthenticate(URL url) {
        try {
            URLConnection c = url.openConnection();
            c.connect();
            String s = c.getHeaderField("WWW-Authenticate");
            if (s == null) {
                logger.fine("WWW-Authenticate is not provided.");
                return null;
            }
            int i = s.indexOf("\"");
            if (i > -1) {
                s = s.substring(i);
            }
            return s;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private String lookupStoredUserInfo(String path) {
        int stop = path.indexOf("://");
        int i = path.lastIndexOf(47);
        while (i > stop) {
            String hash = path.substring(0, i + 1);
            String storedUserInfo = this.keys.get(hash);
            if (storedUserInfo != null) {
                return storedUserInfo;
            }
            i = path.lastIndexOf(47, i - 1);
        }
        return null;
    }

    private void storeUserInfo(String path, String storedUserInfo) {
        if (storedUserInfo.contains(": ")) {
            logger.warning("refusing to store password which starts with space");
            return;
        }
        int stop = path.indexOf("://") + 3;
        int i = path.lastIndexOf(47);
        while (i > stop) {
            String hash = path.substring(0, i + 1);
            if (this.keys.get(hash) == null) {
                this.keys.put(hash, storedUserInfo);
            }
            i = path.lastIndexOf(47, i - 1);
        }
    }

    private void clearUserInfo(String path) {
        int stop = path.indexOf("://") + 3;
        int i = path.lastIndexOf(47);
        while (i > stop) {
            String hash = path.substring(0, i + 1);
            if (this.keys.get(hash) != null) {
                this.keys.remove(hash);
            }
            i = path.lastIndexOf(47, i - 1);
        }
    }

    private synchronized Lock getLockForURL(URL url) {
        String hostUrl = url.getProtocol() + "://" + url.getHost();
        Lock lock = this.locks.get(hostUrl);
        if (lock == null) {
            lock = new ReentrantLock();
            this.locks.put(hostUrl, lock);
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserInfo(URL url, String userInfo) throws CancelledOperationException {
        block32: {
            String path;
            String storedUserInfo;
            if (userInfo == null) {
                return null;
            }
            String userName = null;
            String[] ss = userInfo.split(":", -2);
            if (!ss[0].equals("user") && (userName = ss[0]).contains("%40")) {
                userName = userName.replaceAll("%40", "@");
                StringBuilder userInfob = new StringBuilder(userName);
                for (int i = 1; i < ss.length; ++i) {
                    userInfob.append(":").append(ss[i]);
                }
                userInfo = userInfob.toString();
            }
            if ((storedUserInfo = this.lookupStoredUserInfo(path = url.getProtocol() + "://" + (userName != null ? userName + "@" : "") + url.getHost() + url.getPath())) != null) {
                return storedUserInfo;
            }
            Lock lock = this.getLockForURL(url);
            try {
                lock.lock();
                storedUserInfo = this.lookupStoredUserInfo(path);
                if (storedUserInfo != null) {
                    String string = storedUserInfo;
                    return string;
                }
                String n = "";
                if (url.getProtocol().startsWith("http") && (n = this.getWWWAuthenticate(url)) == null) {
                    n = "";
                }
                if (n.length() > 0) {
                    path = url.getProtocol() + "://" + (userName != null ? userName + "@" : "") + url.getHost() + "/" + n;
                }
                if ((storedUserInfo = this.lookupStoredUserInfo(path)) != null) {
                    String string = storedUserInfo;
                    return string;
                }
                String proto = url.getProtocol();
                String s = proto + "://" + (userName != null ? userName + "@" : "") + url.getHost() + url.getFile();
                if (ss.length >= 2 && ss[1].length() != 0 && !userInfo.endsWith(":pass") && !userInfo.endsWith(":password")) break block32;
                if (!FileSystemSettings.hasAllPermission() || !"true".equals(System.getProperty("java.awt.headless"))) {
                    int r;
                    JPanel panel = new JPanel();
                    panel.setAlignmentX(0.0f);
                    panel.setLayout(new BoxLayout(panel, 1));
                    if (n.length() > 0) {
                        panel.add(new JLabel("<html>Enter Login details to access<br>" + n + " on<br>" + s));
                    } else {
                        panel.add(new JLabel(url.getHost()));
                    }
                    JSeparator sep = new JSeparator(0);
                    sep.setPreferredSize(new Dimension(0, 16));
                    panel.add(sep);
                    JLabel usernameLabel = new JLabel("Username:");
                    usernameLabel.setAlignmentX(0.0f);
                    panel.add(usernameLabel);
                    JTextField userTf = new JTextField();
                    userTf.setAlignmentX(0.0f);
                    if (!ss[0].equals("user")) {
                        userTf.setText(userName);
                    }
                    panel.add(userTf);
                    userTf.setAlignmentX(0.0f);
                    JLabel passwordLabel = new JLabel("Password:");
                    panel.add(passwordLabel);
                    JPasswordField passTf = new JPasswordField();
                    if (ss.length > 1 && !ss[1].equals("pass") && !ss[1].equals("password")) {
                        passTf.setText(ss[1]);
                    }
                    passTf.setAlignmentX(0.0f);
                    panel.add(passTf);
                    JCheckBox storeKeychain = new JCheckBox("store password in keychain.txt file");
                    storeKeychain.setToolTipText("<html>passwords can be stored in keychain.txt files in your cache, but beware of security implications and confusion this can cause.");
                    panel.add(storeKeychain);
                    Long cancelPressed = this.cancelPressTimers.get(path);
                    if (cancelPressed != null) {
                        long millis = System.currentTimeMillis() - cancelPressed;
                        if (millis < 2000L) {
                            throw new CancelledOperationException("Cancel was pressed within the last two seconds");
                        }
                        logger.fine("cancel press expired");
                        this.cancelPressTimers.remove(path);
                    }
                    if (0 == (r = JOptionPane.showConfirmDialog(this.parent, panel, proto + " Authentication Required", 2, 3, null))) {
                        char[] pass = passTf.getPassword();
                        storedUserInfo = userTf.getText() + ":" + new String(pass);
                        this.storeUserInfo(path, storedUserInfo);
                        if (storeKeychain.isSelected()) {
                            try {
                                this.appendKeysFile(path, storedUserInfo);
                            }
                            catch (IOException ex) {
                                logger.log(Level.WARNING, null, ex);
                            }
                        }
                        String string = storedUserInfo;
                        return string;
                    }
                    if (2 == r) {
                        this.cancelPressTimers.put(path, System.currentTimeMillis());
                        throw new CancelledOperationException();
                    }
                    break block32;
                }
                if ("true".equals(System.getProperty("java.awt.headless"))) {
                    String user;
                    Console c = System.console();
                    if (c == null) {
                        logger.log(Level.WARNING, "** java.awt.headless=true: HEADLESS MODE means needed credentials cannot be queried");
                        throw new CancelledOperationException("HEADLESS MODE means needed credentials cannot be queried");
                    }
                    c.printf("Enter Login details to access \n%s on\n%s\n", n, s);
                    if (!ss[0].equals("user")) {
                        user = c.readLine("Username (leave empty for %s): ", ss[0]);
                        if (user.trim().length() == 0) {
                            user = ss[0];
                        }
                    } else {
                        user = c.readLine("Username: ", new Object[0]);
                    }
                    char[] pass = c.readPassword("Password: ", new Object[0]);
                    String string = storedUserInfo = user + ":" + new String(pass);
                    return string;
                }
                String string = userInfo;
                return string;
            }
            finally {
                lock.unlock();
            }
        }
        return userInfo;
    }

    public void clearAll() {
        logger.fine("clear all cached passwords in the keychain, and reload all keychain.txt files.");
        this.keys.clear();
        this.loadInitial();
    }

    public void clearUserPassword(URI uri) {
        try {
            this.clearUserPassword(uri.toURL());
        }
        catch (MalformedURLException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void clearUserPassword(URL url) {
        String userName = null;
        String userInfo = url.getUserInfo();
        if (userInfo == null) {
            userInfo = this.lookupStoredUserInfo(url.toString());
        } else {
            String[] ss = userInfo.split(":", -2);
            if (!ss[0].equals("user") && (userName = ss[0]).contains("%40")) {
                userName = userName.replaceAll("%40", "@");
            }
        }
        if (userInfo == null) {
            return;
        }
        String hash = url.getProtocol() + "://" + (userName != null ? userName + "@" : "") + url.getHost() + url.getPath();
        if (hash.endsWith("/")) {
            // empty if block
        }
        this.clearUserInfo(hash);
    }

    public URI resolveUserInfo(URI root) throws CancelledOperationException {
        try {
            String userInfo = this.getUserInfo(root);
            URI newuri = new URI(root.getScheme(), userInfo, root.getHost(), root.getPort(), root.getPath(), root.getQuery(), root.getFragment());
            return newuri;
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String hideUserInfo(URI root) {
        String userInfo = root.getUserInfo();
        int i = userInfo.indexOf(":");
        if (i > -1) {
            userInfo = userInfo.substring(0, i) + ":*****";
        }
        try {
            URI uri = new URI(root.getScheme(), userInfo, root.getHost(), root.getPort(), root.getPath(), root.getQuery(), root.getFragment());
            return uri.toString();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] args) throws MalformedURLException, CancelledOperationException {
        KeyChain.getDefault().getUserInfo(new URL("http://junomwg@www-pw.physics.uiowa.edu/juno/mwg/"));
        KeyChain.getDefault().getUserInfo(new URL("ftp://jbf@localhost/"));
    }

    public void addCookie(String url, String cookie) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (!url.equals("https://lasp.colorado.edu/mms/sdc/about/browse")) {
            System.err.println("Warning: This is only works for https://lasp.colorado.edu/mms/sdc/about/browse");
        }
        this.cookies.put(url, cookie);
    }

    protected String getCookie(URL url) {
        String hash;
        String cookie = null;
        if (url.toString().contains("https://lasp.colorado.edu/mms/sdc/about/browse/") && (cookie = this.cookies.get(hash = "https://lasp.colorado.edu/mms/sdc/about/browse")) == null) {
            try {
                System.err.println("See http://stackoverflow.com/questions/9619030/resolving-javax-net-ssl-sslhandshakeexception-sun-security-validator-validatore");
                System.err.println("jsse.enableSNIExtension=" + System.getProperty("jsse.enableSNIExtension"));
                URL urlr = new URL("https://lasp-login.colorado.edu/idp/Authn/UserPassword");
                HttpURLConnection conn = (HttpURLConnection)urlr.openConnection();
                conn.setDoOutput(true);
                conn.connect();
                HttpUtil.consumeStream(conn.getErrorStream());
                HttpUtil.consumeStream(conn.getInputStream());
                String cookie0 = conn.getHeaderField("Set-Cookie");
                conn.disconnect();
                String user = this.getUserInfo(new URL("https://lasp.colorado.edu/mms/sdc/about/browse"), "user:");
                conn = (HttpURLConnection)urlr.openConnection();
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                int i = user.indexOf(":");
                String username = user.substring(0, i);
                String password = user.substring(i + 1);
                String encodedData = "j_username=" + URLEncoder.encode(username, "US-ASCII") + "&j_password=" + URLEncoder.encode(password, "US-ASCII");
                conn.setRequestProperty("Referer", "https://lasp-login.colorado.edu/Authn/UserPassword");
                conn.setRequestProperty("Content-Length", String.valueOf(encodedData.length()));
                conn.setRequestProperty("Cookie", cookie0);
                conn.connect();
                OutputStream os = conn.getOutputStream();
                os.write(encodedData.getBytes("US-ASCII"));
                os.close();
                String cookie1 = conn.getHeaderField("Set-Cookie");
                os.close();
                cookie = cookie1;
            }
            catch (MalformedURLException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            catch (IOException | CancelledOperationException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        return cookie;
    }

    static {
        instances = new HashMap<String, KeyChain>();
    }
}

