/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.provider.VfsComponent;
import org.apache.commons.vfs.provider.local.LocalFileSystem;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.filesystem.VFSFileObject;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.ProgressMonitor;

public class VFSFileSystem
extends FileSystem {
    private final FileSystemManager mgr = VFS.getManager();
    private org.apache.commons.vfs.FileSystem vfsSystem;
    private org.apache.commons.vfs.FileObject fsRoot;
    private final File cacheRoot;
    private final URI fsuri;
    private final Map downloads = new HashMap();

    private VFSFileSystem(URI root, boolean createFolder) throws IOException {
        super(root);
        String userInfo = root.getUserInfo();
        if (userInfo != null && userInfo.contains(":")) {
            int i = userInfo.indexOf(":");
            userInfo = userInfo.substring(0, i) + "@";
        } else if (userInfo != null) {
            userInfo = userInfo + "@";
        } else {
            userInfo = System.getProperty("user.name");
            logger.log(Level.INFO, "using {0} as sftp user name", userInfo);
            try {
                root = new URI(root.getScheme(), userInfo, root.getHost(), root.getPort(), root.getPath(), root.getQuery(), root.getFragment());
            }
            catch (URISyntaxException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            userInfo = userInfo + "@";
        }
        String subFolderName = "vfsCache/" + root.getScheme() + "/" + userInfo + root.getHost() + root.getPath();
        this.cacheRoot = new File(VFSFileSystem.settings().getLocalCacheDir(), subFolderName);
        if (root.getPath().length() < 2) {
            logger.warning("This will hang because directory name is needed.");
        }
        if (root.getPort() > -1) {
            logger.warning("Ports are not always supported.");
        }
        logger.fine("attempt resolveFile(root.toString())");
        this.fsRoot = this.mgr.resolveFile(root.toString());
        if (!this.fsRoot.exists() && createFolder) {
            this.fsRoot.createFolder();
        }
        if (!this.fsRoot.exists()) {
            throw new FileSystem.FileSystemOfflineException("Specified filesystem root does not exist: " + KeyChain.getDefault().hideUserInfo(root));
        }
        this.vfsSystem = this.fsRoot.getFileSystem();
        String roots = root.toString();
        if (!roots.endsWith("/")) {
            roots = roots + "/";
        }
        this.fsuri = this.fsRoot.getType() == FileType.FOLDER ? URI.create(roots) : URI.create(roots.substring(0, root.toString().lastIndexOf(47) + 1));
    }

    public void close() {
        ((VfsComponent)this.vfsSystem).close();
    }

    public static VFSFileSystem createVFSFileSystem(URI root) throws FileSystem.FileSystemOfflineException, UnknownHostException {
        return VFSFileSystem.createVFSFileSystem(root, false);
    }

    public static VFSFileSystem createVFSFileSystem(URI root, boolean createFolder) throws FileSystem.FileSystemOfflineException, UnknownHostException {
        if (root.getScheme().equals("ftp")) {
            while (true) {
                URI authUri;
                try {
                    authUri = KeyChain.getDefault().resolveUserInfo(root);
                }
                catch (CancelledOperationException ex) {
                    throw new FileSystem.FileSystemOfflineException("access cancelled");
                }
                try {
                    VFSFileSystem result = new VFSFileSystem(authUri, createFolder);
                    return result;
                }
                catch (IOException e) {
                    if (e instanceof FileSystemException) {
                        FileSystemException vfse = (FileSystemException)((Object)e);
                        if (vfse.getCode().contains("login.error")) {
                            KeyChain.getDefault().clearUserPassword(authUri);
                            if (authUri.getUserInfo() != null) continue;
                            throw new FileSystem.FileSystemOfflineException(e);
                        }
                        if (vfse.getCode().contains("connect.error")) {
                            if (authUri.getUserInfo() == null) {
                                throw new FileSystem.FileSystemOfflineException(e);
                            }
                            KeyChain.getDefault().clearUserPassword(authUri);
                            continue;
                        }
                        throw new FileSystem.FileSystemOfflineException(e);
                    }
                    throw new FileSystem.FileSystemOfflineException(e);
                }
                break;
            }
        }
        try {
            return new VFSFileSystem(root, createFolder);
        }
        catch (IOException e) {
            if (e instanceof FileSystemException) {
                FileSystemException vfse = (FileSystemException)((Object)e);
                if (vfse.getCode().contains("login.error")) {
                    throw new FileSystem.FileSystemOfflineException(e);
                }
                if (vfse.getCode().equals("vfs.provider.sftp/connect.error")) {
                    throw new FileSystem.FileSystemOfflineException(e);
                }
                if (vfse.getCode().contains("connect.error")) {
                    throw new FileSystem.FileSystemOfflineException(e);
                }
                if (e.getMessage().startsWith("Could not connect to ")) {
                    throw new UnknownHostException(root.getHost());
                }
                if (vfse.getCode().contains("invalid-absolute-uri")) {
                    throw new UnknownHostException(vfse.getMessage());
                }
                throw new FileSystem.FileSystemOfflineException(e);
            }
            if (e.getMessage().startsWith("Could not connect to ")) {
                throw new UnknownHostException(root.getHost());
            }
            throw new FileSystem.FileSystemOfflineException(e);
        }
    }

    protected org.apache.commons.vfs.FileObject getVFSFileObject() throws FileSystemException {
        return this.fsRoot;
    }

    @Override
    public FileObject getFileObject(String filename) {
        org.apache.commons.vfs.FileObject vfsob;
        try {
            vfsob = filename.startsWith("/") ? this.mgr.resolveFile(this.fsRoot, filename.substring(1)) : this.mgr.resolveFile(this.fsRoot, filename);
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
        return new VFSFileObject(this, vfsob);
    }

    @Override
    public boolean isDirectory(String filename) throws IOException {
        org.apache.commons.vfs.FileObject vfsob = this.mgr.resolveFile(this.fsRoot, filename);
        return vfsob.getType() == FileType.FOLDER;
    }

    @Override
    public String[] listDirectory(String directory) throws IOException {
        if (directory.startsWith("/")) {
            directory = directory.substring(1);
        }
        directory = this.fsuri.toString() + directory;
        org.apache.commons.vfs.FileObject vfsob = this.mgr.resolveFile(directory);
        org.apache.commons.vfs.FileObject[] children = vfsob.getChildren();
        String[] r = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            r[i] = children[i].getType() == FileType.FOLDER ? children[i].getName().getBaseName() + "/" : children[i].getName().getBaseName();
        }
        return r;
    }

    @Override
    public String[] listDirectory(String directory, String regex) throws IOException {
        String[] listing = this.listDirectory(directory);
        Pattern pattern = Pattern.compile(regex);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < listing.length; ++i) {
            String s = listing[i];
            if (s.charAt(s.length() - 1) == '/') {
                s = s.substring(0, s.length() - 1);
            }
            if (!pattern.matcher(s).matches()) continue;
            result.add(listing[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public File getLocalRoot() {
        if (this.isLocal()) {
            org.apache.commons.vfs.FileObject vfsob;
            try {
                vfsob = this.vfsSystem.getRoot();
            }
            catch (FileSystemException e) {
                throw new RuntimeException(e);
            }
            return new File(vfsob.getName().getPath());
        }
        return this.cacheRoot;
    }

    public boolean isLocal() {
        return this.vfsSystem instanceof LocalFileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock getDownloadLock(String filename, File f, ProgressMonitor monitor) throws IOException {
        logger.log(Level.FINER, "{0} wants download lock for {1} wfs impl {2}", new Object[]{Thread.currentThread().getName(), filename, this.hashCode()});
        Map map = this.downloads;
        synchronized (map) {
            ProgressMonitor mon = (ProgressMonitor)this.downloads.get(filename);
            if (mon != null) {
                logger.log(Level.FINE, "another thread is downloading {0}, waiting...", filename);
                this.waitForDownload(monitor, filename);
                if (f.exists()) {
                    return null;
                }
                throw new FileNotFoundException("expected to find " + f);
            }
            logger.log(Level.FINE, "this thread will download {0}.", filename);
            this.downloads.put(filename, monitor);
            monitor.started();
            return new LocalReentrantLock(filename);
        }
    }

    private void waitForDownload(ProgressMonitor monitor, String filename) {
        monitor.setProgressMessage("waiting for file to download");
        ProgressMonitor downloadMonitor = (ProgressMonitor)this.downloads.get(filename);
        monitor.started();
        while (downloadMonitor != null) {
            monitor.setTaskSize(downloadMonitor.getTaskSize());
            boolean isCancelled = monitor.isCancelled();
            if (isCancelled) {
                downloadMonitor.cancel();
            } else {
                monitor.setTaskProgress(downloadMonitor.getTaskProgress());
            }
            try {
                this.downloads.wait(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            downloadMonitor = (ProgressMonitor)this.downloads.get(filename);
        }
        monitor.finished();
    }

    protected void copyStream(InputStream is, OutputStream out, ProgressMonitor monitor) throws IOException {
        byte[] buffer = new byte[2048];
        int bytesRead = is.read(buffer, 0, 2048);
        long totalBytesRead = bytesRead;
        while (bytesRead > -1) {
            if (monitor.isCancelled()) {
                throw new InterruptedIOException();
            }
            monitor.setTaskProgress(totalBytesRead);
            out.write(buffer, 0, bytesRead);
            bytesRead = is.read(buffer, 0, 2048);
            totalBytesRead += (long)bytesRead;
            logger.finest("transferring data");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadFile(String filename, File f, File partfile, ProgressMonitor monitor) throws IOException {
        block17: {
            if (this.isLocal()) {
                return;
            }
            Lock lock = this.getDownloadLock(filename, f, monitor);
            if (lock == null) {
                return;
            }
            try {
                if (filename.startsWith(this.fsuri.getPath())) {
                    logger.log(Level.INFO, "something is funny, we have the path twice:{0} {1}", new Object[]{filename, this.fsuri});
                }
                if (this.fsuri.getScheme().equals("sftp")) {
                    filename = this.fsuri.getPath() + filename;
                } else {
                    logger.fine("filename is correct already");
                }
                org.apache.commons.vfs.FileObject vfsob = this.vfsSystem.resolveFile(filename);
                if (!vfsob.exists()) {
                    throw new FileNotFoundException("attempt to download non-existent file: " + vfsob);
                }
                long size = vfsob.getContent().getSize();
                monitor.setTaskSize(size);
                if (!f.getParentFile().exists()) {
                    logger.log(Level.FINE, "Creating destination directory {0}", f.getParentFile());
                    FileSystemUtil.maybeMkdirs(f.getParentFile());
                }
                if (partfile.exists()) {
                    logger.fine("Deleting existing partfile.");
                    if (!partfile.delete()) {
                        throw new IllegalArgumentException("unable to delete " + partfile);
                    }
                }
                if (partfile.createNewFile()) {
                    InputStream is = vfsob.getContent().getInputStream();
                    FileOutputStream os = new FileOutputStream(partfile);
                    monitor.setLabel("Downloading file...");
                    monitor.started();
                    try {
                        this.copyStream(is, os, monitor);
                        is.close();
                        os.close();
                        partfile.setReadable(false, false);
                        partfile.setReadable(true, true);
                        if (!partfile.renameTo(f)) {
                            throw new IllegalArgumentException("unable to rename file " + partfile + " to " + f);
                        }
                        break block17;
                    }
                    catch (IOException e) {
                        is.close();
                        os.close();
                        if (partfile.exists() && !partfile.delete()) {
                            throw new IOException("unable to delete file " + partfile);
                        }
                        throw e;
                    }
                }
                throw new IOException("Error creating local file " + f);
            }
            finally {
                lock.unlock();
                monitor.finished();
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private class LocalReentrantLock
    extends ReentrantLock {
        String filename;

        private LocalReentrantLock(String filename) {
            this.filename = filename;
        }

        @Override
        public void lock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock() {
            Map map = VFSFileSystem.this.downloads;
            synchronized (map) {
                VFSFileSystem.this.downloads.remove(this.filename);
                VFSFileSystem.this.downloads.notifyAll();
            }
        }
    }
}

