/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import org.das2.util.Base64;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemSettings;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.HttpFileSystem;
import org.das2.util.filesystem.HttpUtil;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class WebFileObject
extends FileObject {
    protected static final Logger logger = LoggerManager.getLogger("das2.filesystem.wfs");
    final WebFileSystem wfs;
    String pathname;
    File localFile;
    boolean isRoot;
    boolean isFolder;
    Map<String, String> metadata;
    long metaFresh = 0L;
    Date modifiedDate;
    long size = -1L;
    boolean isFolderResolved = false;
    public int METADATA_FRESH_TIMEOUT_MS = 10000;

    @Override
    public boolean canRead() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeLoadMetadata() throws IOException {
        Map<String, String> localMetadata;
        WebFileObject webFileObject = this;
        synchronized (webFileObject) {
            localMetadata = this.metadata;
        }
        if (localMetadata == null) {
            logger.log(Level.FINER, "loading new metadata for {0}", this.pathname);
            webFileObject = this;
            synchronized (webFileObject) {
                if (this.metadata == null) {
                    if (this.wfs.offline) {
                        if (FileSystem.settings().isOffline()) {
                            logger.finer("offline check of metadata based on local file");
                            this.metadata = new HashMap<String, String>();
                            this.metadata.put("exist", this.isLocal() ? "true" : "false");
                        } else if (this.wfs.protocol != null) {
                            logger.finer("offline check of metadata based on wfs.protocol");
                            this.metadata = this.wfs.protocol.getMetadata(this);
                        } else {
                            logger.finer("no load of metadata");
                        }
                    } else if (this.wfs.protocol != null) {
                        logger.finer("wfs.protocol used to get metadata");
                        this.metadata = this.wfs.protocol.getMetadata(this);
                    } else {
                        logger.finer("no load of metadata");
                    }
                    this.metaFresh = System.currentTimeMillis();
                } else {
                    logger.finer("double check says we have metadata now");
                }
            }
        } else {
            logger.finer("using local metadata");
        }
    }

    @Override
    public FileObject[] getChildren() throws IOException {
        if (!this.isFolder) {
            throw new IllegalArgumentException(this.toString() + "is not a folder");
        }
        String[] list = this.wfs.listDirectory(this.pathname);
        FileObject[] result = new FileObject[list.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new WebFileObject(this.wfs, list[i], new Date(System.currentTimeMillis()));
        }
        return result;
    }

    @Override
    public InputStream getInputStream(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        if (this.wfs.protocol != null && !this.wfs.offline) {
            logger.log(Level.FINE, "get inputstream from {0}", this.wfs.protocol);
            return this.wfs.protocol.getInputStream(this, monitor);
        }
        if (this.isFolder) {
            throw new IllegalArgumentException("is a folder");
        }
        if (this.modifiedDate.getTime() == 0L) {
            this.lastModified();
        }
        if (!this.localFile.exists() || this.modifiedDate.getTime() - this.localFile.lastModified() > 10L && !this.wfs.isOffline()) {
            File partFile = new File(this.localFile.toString() + ".part");
            this.wfs.downloadFile(this.pathname, this.localFile, partFile, monitor);
        }
        logger.log(Level.FINE, "read local file {0}", this.localFile);
        return new FileInputStream(this.localFile);
    }

    @Override
    public FileObject getParent() {
        return new WebFileObject(this.wfs, this.wfs.getLocalName(this.localFile.getParentFile()), new Date(System.currentTimeMillis()));
    }

    @Override
    public boolean isData() {
        return !this.isFolder;
    }

    @Override
    public boolean isFolder() {
        if (this.isFolderResolved) {
            return this.isFolder;
        }
        try {
            this.isFolder = this.wfs.isDirectory(this.pathname);
            this.isFolderResolved = true;
            return this.isFolder;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date lastModified() {
        long localMetaFresh;
        WebFileObject webFileObject = this;
        synchronized (webFileObject) {
            localMetaFresh = this.metaFresh;
        }
        if (System.currentTimeMillis() - localMetaFresh > (long)this.METADATA_FRESH_TIMEOUT_MS) {
            this.metadata = null;
            this.modifiedDate = new Date(Long.MAX_VALUE);
        }
        if (this.modifiedDate.getTime() == Long.MAX_VALUE) {
            try {
                this.maybeLoadMetadata();
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "unable to load metadata: {0}", ex);
                this.modifiedDate = new Date(this.localFile.lastModified());
            }
            if (this.metadata != null && this.metadata.containsKey("Last-Modified")) {
                long date = Date.parse(this.metadata.get("Last-Modified"));
                this.modifiedDate = new Date(date);
            } else {
                logger.fine("metadata doesn't contain Last-Modified, using localFile");
                this.modifiedDate = new Date(this.localFile.lastModified());
            }
        }
        return new Date(this.modifiedDate.getTime());
    }

    @Override
    public long getSize() {
        if (this.isFolder) {
            throw new IllegalArgumentException("is a folder");
        }
        if (this.size == -1L) {
            try {
                this.maybeLoadMetadata();
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "unable to load metadata: {0}", ex);
                this.size = this.localFile.length();
            }
            if (this.metadata.containsKey("Content-Length")) {
                this.size = Long.parseLong(this.metadata.get("Content-Length"));
            } else {
                logger.fine("remote length is not known");
                this.size = this.localFile.length();
            }
        }
        return this.size;
    }

    protected void setLastModified(Date d) {
        if (this.modifiedDate.getTime() == 0L || this.modifiedDate.getTime() == Long.MAX_VALUE) {
            this.modifiedDate = d;
        } else if (!d.equals(this.modifiedDate)) {
            throw new IllegalArgumentException("valid date cannot be modified");
        }
    }

    protected void setSize(long size) {
        if (this.size == -1L) {
            this.size = size;
        } else if (size != this.size) {
            throw new IllegalArgumentException("valid size cannot be modified");
        }
    }

    protected File getLocalFile() {
        return this.localFile;
    }

    @Override
    public boolean removeLocalFile() {
        if (this.localFile == null) {
            logger.fine("failed to removeLocalFile, it is null.  Applet mode");
            return true;
        }
        if (!this.localFile.exists()) {
            logger.fine("localfile does not exist.");
            return true;
        }
        if (this.localFile.canWrite()) {
            if (!this.localFile.delete()) {
                logger.log(Level.FINE, "failed to removeLocalFile: {0}", this.localFile);
                return false;
            }
            logger.log(Level.FINER, "local file was removed: {0}", this.localFile);
            return true;
        }
        logger.log(Level.FINE, "user does not have access to delete the local file: {0}", this.localFile);
        return true;
    }

    @Override
    public boolean exists() {
        File f;
        File ff;
        if (this.wfs.getReadOnlyCache() != null && (ff = new File(f = this.wfs.getReadOnlyCache(), this.pathname)).exists()) {
            return true;
        }
        if (this.localFile != null && this.localFile.exists() && this.wfs.isAppletMode()) {
            return true;
        }
        try {
            if (this.wfs.protocol != null) {
                this.maybeLoadMetadata();
                return "true".equals(this.metadata.get("exist"));
            }
            logger.fine("This implementation of WebFileObject.exists() is not optimal");
            File partFile = new File(this.localFile.toString() + ".part");
            this.wfs.downloadFile(this.pathname, this.localFile, partFile, new NullProgressMonitor());
            return this.localFile.exists();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        catch (SocketTimeoutException ex) {
            this.wfs.setOffline(true);
            return false;
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return false;
        }
    }

    protected WebFileObject(WebFileSystem wfs, String pathname, Date modifiedDate) {
        this.modifiedDate = modifiedDate;
        this.wfs = wfs;
        this.pathname = pathname;
        this.isFolderResolved = false;
        if (!wfs.isAppletMode()) {
            this.localFile = new File(wfs.getLocalRoot(), pathname);
            if (FileSystem.settings().getPersistence() == FileSystemSettings.Persistence.SESSION) {
                this.localFile.deleteOnExit();
            }
            try {
                if (!this.localFile.canRead()) {
                    if (pathname.equals("") || pathname.endsWith("/")) {
                        FileSystemUtil.maybeMkdirs(this.localFile);
                        this.isFolder = true;
                        if ("".equals(pathname)) {
                            this.isRoot = true;
                        }
                        this.isFolderResolved = true;
                    } else {
                        this.isFolderResolved = false;
                    }
                } else {
                    this.isFolder = this.localFile.isDirectory();
                    this.isFolderResolved = true;
                }
            }
            catch (ConnectException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "unable to construct web file object", ex);
                this.isFolderResolved = false;
            }
        }
    }

    public String toString() {
        return "[" + this.wfs + "]" + this.getNameExt();
    }

    @Override
    public String getNameExt() {
        return this.pathname;
    }

    @Override
    public ReadableByteChannel getChannel(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        InputStream in = this.getInputStream(monitor);
        return Channels.newChannel(in);
    }

    @Override
    public File getFile(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        File cacheFile;
        File cacheFile2;
        if (this.wfs.isAppletMode()) {
            throw new SecurityException("getFile cannot be used with applets.");
        }
        if (monitor == null) {
            throw new NullPointerException("monitor may not be null");
        }
        if (this.wfs.getReadOnlyCache() != null && (cacheFile2 = new File(this.wfs.getReadOnlyCache(), this.getNameExt())).exists()) {
            logger.log(Level.FINE, "using file from ro_cache: {0}", cacheFile2.getPath());
            return cacheFile2;
        }
        HashMap<String, Object> firstMeta = new HashMap<String, Object>();
        boolean download = this.doCheckFreshness(firstMeta);
        Date remoteDate = (Date)firstMeta.get("remoteDate");
        long remoteLength = (Long)firstMeta.get("remoteLength");
        logger.log(Level.FINER, "remoteDate: {0}", remoteDate);
        logger.log(Level.FINER, "remoteLength: {0}", remoteLength);
        if (download && this.wfs.getReadOnlyCache() != null && (cacheFile = new File(this.wfs.getReadOnlyCache(), this.getNameExt())).exists()) {
            logger.log(Level.FINE, "using file from ro_cache: {0}", cacheFile.getPath());
            return cacheFile;
        }
        if (download) {
            try {
                File partFile;
                Map<String, String> meta;
                logger.log(Level.FINE, "downloading file {0}", this.getNameExt());
                if (!this.localFile.getParentFile().exists()) {
                    FileSystemUtil.maybeMkdirs(this.localFile.getParentFile());
                }
                if ((meta = this.wfs.downloadFile(this.pathname, this.localFile, partFile = this.wfs.getPartFile(this.localFile), monitor.getSubtaskMonitor("download file"))) != null && meta.size() > 0) {
                    this.cacheMeta(this.getLocalFile(), meta);
                }
                if (remoteDate.getTime() > 0L && !this.localFile.setLastModified(remoteDate.getTime())) {
                    logger.log(Level.FINE, "unable to modify date of {0}", this.localFile);
                }
                logger.log(Level.FINE, "downloaded local file has date {0}", new Date(this.localFile.lastModified()));
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException ex) {
                if (ex.getMessage() != null) {
                    if (ex.getMessage().contains("Forbidden")) {
                        throw ex;
                    }
                    if (ex.getMessage().contains("requires authentication")) {
                        throw ex;
                    }
                }
                if (this.wfs instanceof HttpFileSystem && !(ex instanceof InterruptedIOException) && this.wfs.isOffline()) {
                    logger.log(Level.SEVERE, "unable getFile", ex);
                    throw new FileSystem.FileSystemOfflineException("not found in local cache: " + this.getNameExt());
                }
                throw ex;
            }
            finally {
                if (!monitor.isFinished()) {
                    monitor.finished();
                }
            }
        }
        return this.localFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLocal() {
        boolean download;
        block13: {
            Object cacheFile;
            if (this.wfs.isAppletMode()) {
                return false;
            }
            if (this.wfs.getReadOnlyCache() != null && ((File)(cacheFile = new File(this.wfs.getReadOnlyCache(), this.getNameExt()))).exists()) {
                logger.log(Level.FINE, "file exists in ro_cache, so trivially local: {0}", this.getNameExt());
                return true;
            }
            if (this.localFile.exists()) {
                if (!this.wfs.isOffline()) {
                    try {
                        cacheFile = this.wfs;
                        synchronized (cacheFile) {
                            FileSystem.DirectoryEntry remoteMeta = (FileSystem.DirectoryEntry)this.wfs.accessCache.doOp(this.getNameExt());
                            long localFileLastModified = this.localFile.lastModified();
                            if (remoteMeta.modified > 0L) {
                                this.setLastModified(new Date(remoteMeta.modified));
                            }
                            if (remoteMeta.size > -1L) {
                                this.setSize(remoteMeta.size);
                            }
                            if (remoteMeta.modified > localFileLastModified) {
                                logger.log(Level.FINE, "remote file is newer than local copy of {0}, download.", this.getNameExt());
                                download = true;
                            } else {
                                download = remoteMeta.size > -1L && remoteMeta.size != this.localFile.length();
                            }
                            break block13;
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, ex.getMessage(), ex);
                        return false;
                    }
                }
                logger.log(Level.FINE, "wfs is offline, and local file exists: {0}", this.getNameExt());
                return true;
            }
            download = true;
        }
        return !download;
    }

    private String getLocalETag(File localFile) {
        File parentFile = localFile.getParentFile();
        File meta = new File(parentFile, ".meta");
        File localFileMeta = new File(meta, localFile.getName() + ".meta");
        if (!localFileMeta.exists()) {
            return "";
        }
        try {
            String etag = "";
            try (BufferedReader r = new BufferedReader(new FileReader(localFileMeta));){
                String l = r.readLine();
                while (l != null) {
                    if (l.startsWith("ETag: ")) {
                        etag = l.substring(6).trim();
                        break;
                    }
                    l = r.readLine();
                }
            }
            return etag;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
            return "";
        }
    }

    private void cacheMeta(File localFile, Map<String, String> metap) throws IOException {
        File parentFile = localFile.getParentFile();
        File meta = new File(parentFile, ".meta");
        if (!meta.exists() && !meta.mkdirs()) {
            logger.log(Level.WARNING, "unable to create local directory: {0}", meta);
            return;
        }
        File localFileMeta = new File(meta, localFile.getName() + ".meta");
        File localFileMetaTemp = new File(meta, localFile.getName() + ".meta.temp");
        try (PrintWriter write = new PrintWriter(new FileWriter(localFileMetaTemp));){
            write.println("ETag: " + metap.get("ETag"));
        }
        if (localFileMeta.exists() && !localFileMeta.delete()) {
            logger.log(Level.WARNING, "unable to delete metadata file: {0}", localFileMeta);
        }
        if (!localFileMetaTemp.renameTo(localFileMeta)) {
            logger.log(Level.WARNING, "unable to rename metadata file: {0}", localFileMetaTemp);
        }
    }

    private synchronized boolean doCheckFreshness(Map<String, Object> firstMeta) throws FileSystem.FileSystemOfflineException, IOException {
        boolean download;
        Date remoteDate;
        long remoteLength = 0L;
        if (this.isLocal()) {
            remoteDate = new Date(this.localFile.lastModified());
            remoteLength = this.localFile.length();
        } else if (this.wfs instanceof HttpFileSystem && !this.wfs.isOffline()) {
            String contentLocation;
            Map<String, String> meta;
            int responseCode;
            URL url = this.wfs.getURL(this.getNameExt());
            String userInfo = null;
            do {
                String cookie;
                try {
                    userInfo = KeyChain.getDefault().getUserInfo(url);
                }
                catch (CancelledOperationException ex) {
                    throw new FileSystem.FileSystemOfflineException("user cancelled credentials");
                }
                HashMap<String, String> requestProperties = new HashMap<String, String>();
                if (userInfo != null) {
                    String encode = Base64.getEncoder().encodeToString(userInfo.getBytes());
                    requestProperties.put("Authorization", "Basic " + encode);
                }
                if ((cookie = ((HttpFileSystem)this.wfs).getCookie()) != null) {
                    requestProperties.put("Cookie", cookie);
                }
                if ((meta = HttpUtil.getMetadata(url, requestProperties)).containsKey("_ResponseCode")) {
                    responseCode = Integer.parseInt(meta.get("_ResponseCode"));
                    if (responseCode != 401) continue;
                    KeyChain.getDefault().clearUserPassword(url);
                    continue;
                }
                responseCode = 200;
            } while (responseCode == 401);
            long lastModified = Long.parseLong(meta.get("LastModified"));
            remoteDate = new Date(lastModified);
            logger.log(Level.FINE, "HEAD request reports connection.getLastModified()={0}", remoteDate);
            long contentLength = Long.parseLong(meta.get("ContentLength"));
            if (contentLength > -1L) {
                remoteLength = contentLength;
            }
            if ("application/x-gzip".equals(meta.get("ContentType")) && (contentLocation = meta.get("Content-Location")) != null && contentLocation.endsWith(".gz")) {
                remoteLength = -1L;
            }
        } else {
            if (this.lastModified().getTime() == 0L || this.lastModified().getTime() == Long.MAX_VALUE) {
                FileSystem.DirectoryEntry result = this.wfs.maybeUpdateDirectoryEntry(this.getNameExt(), true);
                if (result == null) {
                    logger.fine("file does not exist on remote filesystem");
                } else {
                    result = this.wfs.maybeUpdateDirectoryEntry(this.getNameExt(), true);
                    remoteDate = new Date(result.modified);
                    remoteLength = result.size;
                    this.setLastModified(remoteDate);
                    this.setSize(remoteLength);
                }
            }
            remoteDate = this.lastModified();
            remoteLength = this.getSize();
        }
        if (this.localFile.exists()) {
            String remoteETag;
            download = false;
            Date localFileLastModified = new Date(this.localFile.lastModified());
            if (this.lastModified().getTime() == 0L) {
                logger.fine("server doesn't provide dates, download unless etag suggests otherwise");
                download = true;
            }
            if (remoteDate.after(localFileLastModified) || remoteLength > -1L && remoteLength != this.localFile.length()) {
                logger.log(Level.FINE, "remote file length is different or is newer than local copy of {0}, download.", this.getNameExt());
                download = true;
            }
            String string = remoteETag = this.metadata == null ? null : this.metadata.get("ETag");
            if (remoteETag != null) {
                String localETag;
                if (download) {
                    localETag = this.getLocalETag(this.getLocalFile());
                    if (localETag.length() > 0 && localETag.equals(remoteETag)) {
                        logger.fine("etag hasn't changed, don't download.");
                        download = false;
                    }
                } else {
                    localETag = this.getLocalETag(this.getLocalFile());
                    if (localETag.length() > 0 && !localETag.equals(remoteETag)) {
                        logger.fine("etag has changed, do download.");
                        download = true;
                    }
                }
            }
        } else {
            download = true;
        }
        firstMeta.put("remoteDate", remoteDate);
        firstMeta.put("remoteLength", remoteLength);
        logger.log(Level.FINE, "doCheckFreshness says download={0}", download);
        return download;
    }
}

