/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.das2.util.LoggerManager;

public class ZipFiles {
    private static final Logger logger = LoggerManager.getLogger("das2.filesystem");
    private final List<String> filesListInDir = new ArrayList<String>();

    public static void main(String[] args) {
        File file = new File("/Users/pankaj/sitemap.xml");
        String zipFileName = "/Users/pankaj/sitemap.zip";
        File dir = new File("/Users/pankaj/tmp");
        String zipDirName = "/Users/pankaj/tmp.zip";
        ZipFiles.zipSingleFile(file, zipFileName);
        ZipFiles zipFiles = new ZipFiles();
        zipFiles.zipDirectory(dir, zipDirName);
    }

    public void zipDirectory(File dir, String zipDirName) {
        try {
            this.populateFilesList(dir);
            try (FileOutputStream fos = new FileOutputStream(zipDirName);
                 ZipOutputStream zos = new ZipOutputStream(fos);){
                for (String filePath : this.filesListInDir) {
                    logger.log(Level.FINE, "Zipping {0}", filePath);
                    ZipEntry ze = new ZipEntry(filePath.substring(dir.getAbsolutePath().length() + 1, filePath.length()));
                    zos.putNextEntry(ze);
                    FileInputStream fis = new FileInputStream(filePath);
                    Throwable throwable = null;
                    try {
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = fis.read(buffer)) > 0) {
                            zos.write(buffer, 0, len);
                        }
                        zos.closeEntry();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fis == null) continue;
                        if (throwable != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fis.close();
                    }
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void populateFilesList(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isFile()) {
                this.filesListInDir.add(file.getAbsolutePath());
                continue;
            }
            this.populateFilesList(file);
        }
    }

    private static void zipSingleFile(File file, String zipFileName) {
        try {
            try (FileOutputStream fos = new FileOutputStream(zipFileName);
                 ZipOutputStream zos = new ZipOutputStream(fos);){
                ZipEntry ze = new ZipEntry(file.getName());
                zos.putNextEntry(ze);
                try (FileInputStream fis = new FileInputStream(file);){
                    int len;
                    byte[] buffer = new byte[8192];
                    while ((len = fis.read(buffer)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                    zos.closeEntry();
                }
            }
            logger.log(Level.FINE, "{0} is zipped to {1}", new Object[]{file.getCanonicalPath(), zipFileName});
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }
}

