/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.monitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class SubTaskMonitor
implements ProgressMonitor {
    private static final Logger logger = LoggerManager.getLogger("das2.system");
    ProgressMonitor parent;
    long min;
    long max;
    long progress;
    long size;
    String label;
    boolean doEchoToParent = false;
    boolean cancelCheck;
    private boolean finished = false;
    boolean started = false;

    private SubTaskMonitor(ProgressMonitor parent, long min, long max, boolean cancelChecked) {
        this.parent = parent;
        this.min = min;
        this.max = max;
        this.size = -1L;
        this.cancelCheck = cancelChecked;
    }

    public static SubTaskMonitor create(ProgressMonitor parent, long min, long max) {
        return new SubTaskMonitor(parent, min, max, false);
    }

    public static SubTaskMonitor create(ProgressMonitor parent, long min, long max, boolean cancelChecked) {
        return new SubTaskMonitor(parent, min, max, cancelChecked);
    }

    public static SubTaskMonitor create(ProgressMonitor parent, boolean cancelChecked) {
        SubTaskMonitor result = new SubTaskMonitor(parent, -1L, -1L, cancelChecked);
        result.doEchoToParent = true;
        return result;
    }

    @Override
    public void cancel() {
        if (this.parent.canBeCancelled()) {
            this.parent.cancel();
        }
    }

    @Override
    public void finished() {
        if (this.finished) {
            logger.warning("SubTaskMonitor.finished called twice, which could cause problems in the future");
        } else {
            logger.fine("enter monitor finished");
        }
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public long getTaskProgress() {
        return this.progress;
    }

    @Override
    public boolean isCancelled() {
        return this.parent.isCancelled();
    }

    @Override
    @Deprecated
    public void setAdditionalInfo(String s) {
    }

    @Override
    public void setTaskProgress(long position) throws IllegalArgumentException {
        this.progress = position;
        if (this.cancelCheck) {
            this.parent.isCancelled();
        }
        if (this.max != this.min || this.min != -1L) {
            if (this.size == -1L) {
                this.parent.setTaskProgress(this.min);
            } else {
                this.parent.setTaskProgress(this.min + (this.max - this.min) * position / this.size);
            }
        }
    }

    @Override
    public void setTaskSize(long taskSize) {
        if (taskSize < 1L) {
            logger.log(Level.FINER, "taskSize set to {0}, resetting", taskSize);
            taskSize = -1L;
        }
        this.size = taskSize;
        if (this.max == this.min && this.min == -1L && this.doEchoToParent) {
            this.min = 0L;
            this.max = taskSize;
            this.parent.setTaskSize(taskSize);
        }
    }

    @Override
    public long getTaskSize() {
        return this.size;
    }

    @Override
    public void started() {
        this.started = true;
        if (!this.parent.isStarted()) {
            this.parent.started();
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
        if (this.doEchoToParent) {
            this.parent.setLabel(label);
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public String toString() {
        if (this.label == null) {
            return this.parent.toString();
        }
        return this.parent.toString() + ">" + this.label;
    }

    @Override
    public void setProgressMessage(String message) {
        if (this.doEchoToParent) {
            this.parent.setProgressMessage(message);
        }
    }

    @Override
    public ProgressMonitor getSubtaskMonitor(int start, int end, String label) {
        if (this.min == -1L && this.max == -1L) {
            return SubTaskMonitor.create(this, this.cancelCheck);
        }
        return SubTaskMonitor.create(this, start, end, this.cancelCheck);
    }

    @Override
    public ProgressMonitor getSubtaskMonitor(String label) {
        return SubTaskMonitor.create(this, this.cancelCheck);
    }

    @Override
    public boolean canBeCancelled() {
        return this.cancelCheck;
    }
}

