/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.ftp4j.connectors;

import it.sauronsoftware.ftp4j.FTPCommunicationChannel;
import it.sauronsoftware.ftp4j.FTPConnector;
import it.sauronsoftware.ftp4j.FTPIllegalReplyException;
import it.sauronsoftware.ftp4j.FTPReply;
import java.io.IOException;
import java.net.Socket;

public class FTPProxyConnector
extends FTPConnector {
    public static final int STYLE_SITE_COMMAND = 0;
    public static final int STYLE_OPEN_COMMAND = 1;
    private String proxyHost;
    private int proxyPort;
    private String proxyUser;
    private String proxyPass;
    public int style = 0;

    public FTPProxyConnector(String proxyHost, int proxyPort, String proxyUser, String proxyPass) {
        super(true);
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPass = proxyPass;
    }

    public FTPProxyConnector(String proxyHost, int proxyPort) {
        this(proxyHost, proxyPort, "anonymous", "ftp4j");
    }

    public void setStyle(int style) {
        if (style != 1 && style != 0) {
            throw new IllegalArgumentException("Invalid style");
        }
        this.style = style;
    }

    @Override
    public Socket connectForCommunicationChannel(String host, int port) throws IOException {
        FTPReply r;
        Socket socket = this.tcpConnectForCommunicationChannel(this.proxyHost, this.proxyPort);
        FTPCommunicationChannel communication = new FTPCommunicationChannel(socket, "ASCII");
        try {
            r = communication.readFTPReply();
        }
        catch (FTPIllegalReplyException e) {
            throw new IOException("Invalid proxy response");
        }
        if (r.getCode() != 220) {
            throw new IOException("Invalid proxy response");
        }
        if (this.style == 0) {
            boolean passwordRequired;
            communication.sendFTPCommand("USER " + this.proxyUser);
            try {
                r = communication.readFTPReply();
            }
            catch (FTPIllegalReplyException e) {
                throw new IOException("Invalid proxy response");
            }
            switch (r.getCode()) {
                case 230: {
                    passwordRequired = false;
                    break;
                }
                case 331: {
                    passwordRequired = true;
                    break;
                }
                default: {
                    throw new IOException("Proxy authentication failed");
                }
            }
            if (passwordRequired) {
                communication.sendFTPCommand("PASS " + this.proxyPass);
                try {
                    r = communication.readFTPReply();
                }
                catch (FTPIllegalReplyException e) {
                    throw new IOException("Invalid proxy response");
                }
                if (r.getCode() != 230) {
                    throw new IOException("Proxy authentication failed");
                }
            }
            communication.sendFTPCommand("SITE " + host + ":" + port);
        } else if (this.style == 1) {
            communication.sendFTPCommand("OPEN " + host + ":" + port);
        }
        return socket;
    }

    @Override
    public Socket connectForDataTransferChannel(String host, int port) throws IOException {
        return this.tcpConnectForDataTransferChannel(host, port);
    }
}

