/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.das2.util.filesystem.FileSystem;

public final class AutoplotSettings {
    private static final Logger logger = Logger.getLogger("apdss");
    private static AutoplotSettings instance;
    public static final String PREF_LAST_OPEN_FOLDER = "last_open_folder";
    public static final String PREF_RECENTLY_OPENED_FILES = "recently_opened_files";
    public static final String PREF_LAST_OPEN_VAP_FOLDER = "last_open_vap_folder";
    public static final String PREF_LAST_OPEN_VAP_FILE = "last_open_vap_file";
    PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() instanceof String) {
                prefs.put(evt.getPropertyName(), (String)evt.getNewValue());
            } else if (evt.getNewValue() instanceof Boolean) {
                prefs.putBoolean(evt.getPropertyName(), (Boolean)evt.getNewValue());
            } else {
                throw new RuntimeException("unsupported property type needs to be implemented: " + evt.getPropertyName() + "  " + evt.getNewValue().getClass());
            }
        }
    };
    static Preferences prefs;
    protected String autoplotData = "";
    public static final String PROP_AUTOPLOTDATA = "autoplotData";
    private String fscache = "";
    public static final String PROP_FSCACHE = "fscache";
    private String resolvedAutoplotData = null;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public static synchronized AutoplotSettings settings() {
        if (instance == null) {
            instance = new AutoplotSettings();
        }
        return instance;
    }

    private AutoplotSettings() {
        try {
            prefs = this.getPreferences(AutoplotSettings.class);
            this.addPropertyChangeListener(this.listener);
            this.loadPreferences();
        }
        catch (Exception ex) {
            logger.warning("Problem encountered when attempting to load user preferences, continuing with autoplot_data in $HOME");
            this.autoplotData = "${HOME}/autoplot_data";
            this.fscache = this.autoplotData + "/fscache";
        }
    }

    public void loadPreferences() {
        this.autoplotData = prefs.get(PROP_AUTOPLOTDATA, "${HOME}/autoplot_data");
        String p = System.getProperty("AUTOPLOT_DATA");
        if (p == null) {
            p = System.getenv("AUTOPLOT_DATA");
            if (p != null) {
                logger.log(Level.FINE, "AUTOPLOT_DATA environment variable used to set AUTOPLOT_DATA={0}", p);
            }
        } else {
            logger.log(Level.FINE, "AUTOPLOT_DATA system property (-D on cmd line) used to set AUTOPLOT_DATA={0}", p);
        }
        if (p != null) {
            File f = new File(p);
            try {
                if (f.getCanonicalPath().equals(f.getAbsolutePath())) {
                    logger.log(Level.FINE, "Canonical path is not equal to path, may be a link: {0}", f);
                }
                this.autoplotData = f.getAbsolutePath();
            }
            catch (IOException ex) {
                this.autoplotData = p;
            }
        }
        this.fscache = prefs.get(PROP_FSCACHE, this.autoplotData + "/fscache");
        p = System.getProperty("AUTOPLOT_FSCACHE");
        if (p != null) {
            this.fscache = p;
        }
        if (p == null) {
            p = System.getenv("AUTOPLOT_FSCACHE");
            if (p != null) {
                logger.log(Level.FINE, "AUTOPLOT_FSCACHE environment variable used to set AUTOPLOT_FSCACHE={0}", p);
            }
        } else {
            logger.log(Level.FINE, "AUTOPLOT_FSCACHE system property (-D on cmd line) used to set AUTOPLOT_FSCACHE={0}", p);
        }
    }

    public Preferences getPreferences(Class c) {
        String s = c.getPackage().getName();
        Preferences p1 = Preferences.userRoot().node("/" + s.replace('.', '/'));
        return p1;
    }

    public String getAutoplotData() {
        return this.autoplotData;
    }

    public String getFscache() {
        return this.fscache;
    }

    public void setFscache(String val) {
        String old = this.fscache;
        if (old.equals(val)) {
            return;
        }
        String tval = val;
        tval = tval.replaceAll("\\$\\{HOME\\}", System.getProperty("user.home"));
        FileSystem.settings().setLocalCacheDir(new File(tval));
        this.fscache = val;
        String home = System.getProperty("user.home");
        if (val.startsWith(home)) {
            val = "${HOME}" + val.substring(home.length());
        }
        this.propertyChangeSupport.firePropertyChange(PROP_FSCACHE, old, val);
    }

    private static String maybeFixWindows(String n) {
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            return n.replace('\\', '/');
        }
        return n;
    }

    public String resolveProperty(String name) {
        if (name.equals(PROP_AUTOPLOTDATA)) {
            String l = this.resolvedAutoplotData;
            if (l != null) {
                return l;
            }
            String s = this.getAutoplotData().replace("${HOME}", AutoplotSettings.maybeFixWindows(System.getProperty("user.home")));
            File f = new File(s);
            f = f.getAbsoluteFile();
            this.resolvedAutoplotData = f.toString();
            return AutoplotSettings.maybeFixWindows(f.toString());
        }
        if (name.equals(PROP_FSCACHE)) {
            String result = this.getFscache();
            result = result.replace("${autoplotData}", this.resolveProperty(PROP_AUTOPLOTDATA));
            result = result.replace("${HOME}", AutoplotSettings.maybeFixWindows(System.getProperty("user.home")));
            return result;
        }
        throw new IllegalArgumentException("unable to resolve property: " + name);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

