/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.net.URI;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.URISplit;

public class CompletionContext {
    public static final Object CONTEXT_AUTOPLOT_SCHEME = "vap";
    public static final Object CONTEXT_FILESYSTEM = "fs";
    public static final Object CONTEXT_FILE = "file";
    public static final Object CONTEXT_PARAMETER_NAME = "paramName";
    public static final Object CONTEXT_PARAMETER_VALUE = "paramValue";
    public String surl;
    public int surlpos;
    public URI resourceURI;
    public String params;
    public Object context;
    public String completable;
    public int completablepos;
    public String implicitName;
    public String doc;
    public String label;
    public boolean maybePlot;

    public CompletionContext() {
    }

    public CompletionContext(Object context, String completable) {
        this(context, completable, null, null, null, null);
    }

    public CompletionContext(Object context, String completable, DataSourceFactory owner, String implicitName, String label, String doc) {
        this(context, completable, owner, implicitName, label, doc, false);
    }

    public CompletionContext(Object context, String completable, DataSourceFactory owner, String implicitName) {
        this(context, completable, owner, implicitName, null, null, false);
    }

    public CompletionContext(Object context, String completable, String doc) {
        this(context, completable, null, null, null, doc, false);
    }

    public CompletionContext(Object context, String completable, String label, String doc) {
        this(context, completable, null, null, label, doc, false);
    }

    public CompletionContext(Object context, String completable, DataSourceFactory owner, String implicitName, String doc) {
        this(context, completable, owner, implicitName, null, doc, false);
    }

    public CompletionContext(Object context, String completable, DataSourceFactory owner, String implicitName, String label, String doc, boolean maybePlot) {
        this.context = context;
        this.completable = completable;
        this.implicitName = implicitName;
        this.label = label == null ? completable : label;
        this.doc = doc;
        this.maybePlot = maybePlot;
    }

    public static String get(Object context, CompletionContext cc) {
        if (context == CONTEXT_FILESYSTEM || context == CONTEXT_FILE) {
            URISplit split = URISplit.parse(cc.surl);
            return split.file;
        }
        if (context == CONTEXT_PARAMETER_NAME || context == CONTEXT_PARAMETER_VALUE) {
            int i0 = cc.surl.lastIndexOf(38, cc.surlpos - 1);
            int i1 = cc.surl.lastIndexOf(63, cc.surlpos);
            if (i0 == -1 && i1 == -1) {
                int i3 = cc.surl.indexOf(":", 4);
                if (cc.surl.startsWith("vap") && i3 > 0) {
                    i0 = i3;
                }
            } else {
                i0 = Math.max(i0, i1);
            }
            if (i0 == -1) {
                return null;
            }
            i1 = cc.surl.indexOf(38, i0 + 1);
            if (i1 == -1) {
                i1 = cc.surl.length();
            }
            int i2 = cc.surl.indexOf(61, i0);
            if (context == CONTEXT_PARAMETER_NAME) {
                if (i2 == -1) {
                    return cc.surl.substring(i0 + 1, i1);
                }
                return cc.surl.substring(i0 + 1, i2);
            }
            if (i2 == -1) {
                return null;
            }
            return cc.surl.substring(i2 + 1, i1);
        }
        throw new IllegalArgumentException("invalid context");
    }

    public static String insert(CompletionContext cc, CompletionContext ccnew) {
        Object context = ccnew.context;
        if (context == CONTEXT_FILESYSTEM || context == CONTEXT_FILE) {
            String surl = cc.surl;
            boolean isURI = false;
            URISplit split = URISplit.parse(surl);
            split.file = ccnew.completable;
            return URISplit.format(split);
        }
        if (context == CONTEXT_PARAMETER_NAME || context == CONTEXT_PARAMETER_VALUE) {
            int i2;
            int i0 = cc.surl.lastIndexOf(38, cc.surlpos - 1);
            int i1 = cc.surl.lastIndexOf(63, cc.surlpos - 1);
            if (i0 == -1 && i1 == -1) {
                int i3 = cc.surl.indexOf(":", 4);
                if (cc.surl.startsWith("vap") && i3 > 0) {
                    i0 = i3;
                }
            } else {
                i0 = Math.max(i0, i1);
            }
            if (i0 == -1) {
                return null;
            }
            i1 = cc.surl.indexOf(38, i0 + 1);
            if (i1 == -1) {
                i1 = cc.surl.length();
            }
            if ((i2 = cc.surl.indexOf(61, i0)) > i1) {
                i2 = -1;
            }
            String delima = "";
            if (context == CONTEXT_PARAMETER_NAME) {
                String completable = ccnew.completable;
                String after = i2 == -1 ? cc.surl.substring(i1) : cc.surl.substring(i2);
                if (completable.endsWith("=") && delima.length() == 0 && after.startsWith("=")) {
                    completable = completable.substring(0, completable.length() - 1);
                }
                if (i2 == -1) {
                    return cc.surl.substring(0, i0 + 1) + completable + delima + cc.surl.substring(i1);
                }
                return cc.surl.substring(0, i0 + 1) + completable + delima + cc.surl.substring(i2);
            }
            if (i2 == -1) {
                return null;
            }
            return cc.surl.substring(0, i2 + 1) + ccnew.completable + cc.surl.substring(i1);
        }
        throw new IllegalArgumentException("invalid context");
    }

    public String toString() {
        return this.context + "=" + this.completable;
    }
}

