/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import ftpfs.FTPBeanFileSystemFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.channels.Channels;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.autoplot.aggregator.AggregatingDataSourceFactory;
import org.autoplot.aggregator.AggregatingDataSourceFormat;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.DataSourceRecognizer;
import org.autoplot.datasource.DataSourceRegistry;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.EmptyFileException;
import org.autoplot.datasource.FileSystemUtil;
import org.autoplot.datasource.HtmlResponseIOException;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.wgetfs.WGetFileSystemFactory;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.HttpUtil;
import org.das2.fsm.FileStorageModel;
import org.das2.qds.ops.Ops;
import org.das2.util.Base64;
import org.das2.util.DasProgressMonitorInputStream;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemFactory;
import org.das2.util.filesystem.FileSystemSettings;
import org.das2.util.filesystem.GitHubFileSystem;
import org.das2.util.filesystem.HtmlUtil;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.filesystem.LocalFileSystem;
import org.das2.util.filesystem.URIException;
import org.das2.util.filesystem.VFSFileSystemFactory;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.monitor.AlertNullProgressMonitor;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class DataSetURI {
    private static final Object ACTION_WAIT_EXISTS = "WAIT_EXISTS";
    private static final Object ACTION_DOWNLOAD = "DOWNLOAD";
    private static final Object ACTION_USE_CACHE = "USE_CACHE";
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.uri");
    static WeakHashMap<DataSource, DataSourceFactory> dsToFactory;
    public static final String RECOGNIZE_FILE_EXTENSION_JSON = "json";
    public static final String RECOGNIZE_FILE_EXTENSION_XML = "xml";

    public static String getExt(String surl) {
        if (surl == null) {
            throw new NullPointerException();
        }
        String explicitExt = DataSetURI.getExplicitExt(surl);
        if (explicitExt != null) {
            return explicitExt;
        }
        URISplit split = URISplit.parse(surl);
        if (split.file != null) {
            int i0 = split.file.lastIndexOf(47);
            if (i0 == -1) {
                return null;
            }
            int i1 = split.file.lastIndexOf(46);
            if (i1 != -1 && i1 > i0) {
                return split.file.substring(i1 + 1);
            }
            return null;
        }
        if (!surl.contains("/") && !surl.contains("\\")) {
            int i = surl.lastIndexOf(".");
            if (i > -1) {
                return surl.substring(i + 1);
            }
            return null;
        }
        return null;
    }

    public static String getExplicitExt(String surl) {
        URISplit split = URISplit.parse(surl);
        if (split.vapScheme == null) {
            return null;
        }
        int i = split.vapScheme.indexOf(43);
        if (i != -1) {
            return split.vapScheme.substring(i + 1);
        }
        return null;
    }

    public static DataSource getDataSource(URI uri) throws Exception {
        DataSourceFactory factory = DataSetURI.getDataSourceFactory(uri, (ProgressMonitor)new NullProgressMonitor());
        if (factory == null) {
            throw new IllegalArgumentException("unable to resolve URI: " + uri);
        }
        DataSource result = factory.getDataSource(uri);
        dsToFactory.put(result, factory);
        return result;
    }

    public static DataSource getDataSource(String suri) throws Exception {
        return DataSetURI.getDataSource(DataSetURI.getURIValid(suri));
    }

    public static String getDataSourceUri(DataSource ds) {
        DataSourceFactory factory = dsToFactory.get(ds);
        if (factory instanceof AggregatingDataSourceFactory) {
            return ds.getURI();
        }
        if (factory == null) {
            return ds.getURI();
        }
        URISplit split = URISplit.parse(ds.getURI());
        String fext = DataSourceRegistry.getInstance().getExtensionFor(factory).substring(1);
        if (DataSourceRegistry.getInstance().hasSourceByExt(split.ext)) {
            DataSourceFactory f2 = DataSourceRegistry.getInstance().getSource(split.ext);
            if (!factory.getClass().isInstance(f2)) {
                split.vapScheme = "vap+" + fext;
            }
        } else {
            split.vapScheme = "vap+" + fext;
        }
        return URISplit.format(split);
    }

    public static boolean isAggregating(String surl) {
        int ipercy;
        if (!DataSourceRegistry.getInstance().hasResourceUri(surl)) {
            return false;
        }
        int iquest = surl.indexOf(63);
        if (iquest > 0) {
            surl = surl.substring(0, iquest);
        }
        if ((ipercy = (surl = surl.replaceAll("%25", "%")).lastIndexOf("%Y")) == -1) {
            ipercy = surl.lastIndexOf("$Y");
        }
        if (ipercy == -1) {
            ipercy = surl.lastIndexOf("%y");
        }
        if (ipercy == -1) {
            ipercy = surl.lastIndexOf("$y");
        }
        if (ipercy == -1) {
            ipercy = surl.lastIndexOf("$(o");
        }
        if (ipercy == -1) {
            ipercy = surl.lastIndexOf("%{o");
        }
        if (ipercy == -1) {
            ipercy = surl.lastIndexOf("$(periodic");
        }
        if (ipercy == -1) {
            ipercy = surl.lastIndexOf("%{periodic");
        }
        if (ipercy == -1) {
            ipercy = surl.lastIndexOf("$v");
        }
        if (ipercy == -1) {
            ipercy = surl.lastIndexOf("$(v");
        }
        if (ipercy == -1) {
            ipercy = surl.lastIndexOf("$x");
        }
        if (ipercy == -1) {
            ipercy = surl.lastIndexOf(42);
        }
        return ipercy != -1;
    }

    public static String[] unaggregate(String resourceURI, DatumRange timerange) throws FileSystem.FileSystemOfflineException, UnknownHostException, IOException {
        int i = AggregatingDataSourceFactory.splitIndex(resourceURI);
        String root = resourceURI.substring(0, i);
        String template = resourceURI.substring(i);
        FileSystem fs = FileSystem.create((String)root);
        FileStorageModel fsm = FileStorageModel.create((FileSystem)fs, (String)template);
        String[] names = fsm.getNamesFor(timerange);
        ArrayList<String> result = new ArrayList<String>();
        for (String n : names) {
            result.add(root + n);
        }
        return result.toArray(new String[result.size()]);
    }

    public static URI getResourceURI(URI uri) {
        URISplit split = URISplit.parse(uri);
        return split.resourceUri;
    }

    public static URI getResourceURI(String surl) {
        if (surl.matches("file\\:[A-Z]\\:\\\\.*")) {
            surl = "file://" + surl.substring(5).replace('\\', '/');
        }
        if (surl.matches("file\\:/[A-Z]\\:\\\\.*")) {
            surl = "file://" + surl.substring(5).replace('\\', '/');
        }
        URISplit split = URISplit.parse(surl);
        return split.resourceUri;
    }

    public static URL getWebURL(URI uri) {
        try {
            URI uri1 = DataSetURI.getResourceURI(uri);
            if (uri1 == null) {
                return null;
            }
            URL rurl = uri1.toURL();
            String surl = rurl.toString();
            return new URL(surl);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    static String newUri(String context, String newUri) {
        URISplit scontext = URISplit.parse(context, 0, false);
        URISplit newURLSplit = URISplit.parse(newUri);
        if (newURLSplit.file != null && !newURLSplit.file.equals("")) {
            scontext.file = newURLSplit.file;
        }
        if (newURLSplit.params != null && !newURLSplit.params.equals("")) {
            scontext.params = newURLSplit.params;
        }
        return URISplit.format(scontext);
    }

    public static String blurTsbUri(String value) {
        try {
            DataSourceFactory dsf = DataSetURI.getDataSourceFactory(DataSetURI.toUri(value), (ProgressMonitor)new NullProgressMonitor());
            if (dsf == null) {
                return null;
            }
            TimeSeriesBrowse tsb = dsf.getCapability(TimeSeriesBrowse.class);
            if (tsb == null) {
                return value;
            }
            tsb.setURI(value);
            return tsb.blurURI();
        }
        catch (IOException | IllegalArgumentException | URISyntaxException | ParseException ex) {
            return null;
        }
    }

    public static String blurTsbResolutionUri(String value) {
        try {
            DataSourceFactory dsf = DataSetURI.getDataSourceFactory(new URI(value), (ProgressMonitor)new NullProgressMonitor());
            TimeSeriesBrowse tsb = dsf.getCapability(TimeSeriesBrowse.class);
            if (tsb == null) {
                logger.fine("Unable to update the URI because factory doesn't provide TSB");
                return null;
            }
            tsb.setURI(value);
            tsb.setTimeResolution(null);
            return tsb.getURI();
        }
        catch (IOException | IllegalArgumentException | URISyntaxException | ParseException ex) {
            return null;
        }
    }

    public static String resetUriTsbTime(String value, DatumRange timeRange) {
        if (timeRange == null) {
            return value;
        }
        try {
            DataSourceFactory dsf = DataSetURI.getDataSourceFactory(new URI(value), (ProgressMonitor)new NullProgressMonitor());
            TimeSeriesBrowse tsb = dsf.getCapability(TimeSeriesBrowse.class);
            if (tsb == null) {
                logger.fine("Unable to update the URI because factory doesn't provide TSB");
                return null;
            }
            tsb.setURI(value);
            tsb.setTimeRange(timeRange);
            return tsb.getURI();
        }
        catch (IOException | IllegalArgumentException | URISyntaxException | ParseException ex) {
            return null;
        }
    }

    public static String abbreviateForHumanComsumption(String ssuri, int len) {
        if (ssuri.length() > len) {
            return "..." + ssuri.substring(ssuri.length() - len - 3);
        }
        return ssuri;
    }

    public static DataSourceFormat getDataSourceFormat(URI uri) {
        URL url;
        String file;
        int i2;
        int i = uri.getScheme().indexOf(46);
        if (DataSetURI.isAggregating(uri.toString())) {
            AggregatingDataSourceFormat agg = new AggregatingDataSourceFormat();
            return agg;
        }
        String ext = i != -1 ? uri.getScheme().substring(0, i) : ((i2 = uri.getScheme().indexOf(43)) != -1 ? uri.getScheme().substring(i2 + 1) : ((i = (file = (url = DataSetURI.getWebURL(uri)).getPath()).lastIndexOf(46)) == -1 ? "" : file.substring(i)));
        return DataSourceRegistry.getInstance().getFormatByExt(ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSourceFactory getDataSourceFactory(URI uri, ProgressMonitor mon) throws IOException, IllegalArgumentException, URISyntaxException {
        DataSourceFactory factory;
        String suri = DataSetURI.fromUri(uri);
        if (DataSetURI.isAggregating(suri)) {
            String eext = DataSetURI.getExplicitExt(suri);
            if (eext != null) {
                DataSourceFactory delegateFactory;
                if (eext.equals(RECOGNIZE_FILE_EXTENSION_XML) || eext.equals(RECOGNIZE_FILE_EXTENSION_JSON)) {
                    String ff = AggregatingDataSourceFactory.getRepresentativeFile(uri, mon.getSubtaskMonitor("find representative file"));
                    if (ff == null) {
                        mon.finished();
                        throw new IllegalArgumentException("Unable to find file from aggregation: " + uri);
                    }
                    File f = DataSetURI.getFile(ff, mon.getSubtaskMonitor("get representative file"));
                    mon.finished();
                    String extr = DataSourceRecognizer.guessDataSourceType(f);
                    delegateFactory = extr != null && extr.startsWith("vap+") ? DataSourceRegistry.getInstance().getSource(extr) : DataSourceRegistry.getInstance().getSource(eext);
                } else {
                    delegateFactory = DataSourceRegistry.getInstance().getSource(eext);
                }
                AggregatingDataSourceFactory factory2 = new AggregatingDataSourceFactory();
                factory2.setDelegateDataSourceFactory(delegateFactory);
                return factory2;
            }
            return new AggregatingDataSourceFactory();
        }
        String ext = DataSetURI.getExplicitExt(suri);
        if (ext != null && !suri.startsWith("vap+X:")) {
            File f;
            String extr;
            if ((ext.equals(RECOGNIZE_FILE_EXTENSION_XML) || ext.equals(RECOGNIZE_FILE_EXTENSION_JSON)) && (extr = DataSourceRecognizer.guessDataSourceType(f = DataSetURI.getFile(uri.getRawSchemeSpecificPart(), mon))) != null) {
                ext = extr;
            }
            return DataSourceRegistry.getInstance().getSource(ext);
        }
        String resourceSuri = uri.getRawSchemeSpecificPart();
        if (resourceSuri.startsWith("'")) {
            throw new IllegalArgumentException("URI starts with single quote");
        }
        URI resourceUri = new URI(resourceSuri);
        ext = DataSetURI.getExt(uri.toString());
        if (ext == null) {
            ext = "";
        }
        if ((factory = DataSourceRegistry.getInstance().getSource(ext)) == null && resourceUri.getScheme() != null && (resourceUri.getScheme().equals("http") || resourceUri.getScheme().equals("https"))) {
            URL url = resourceUri.toURL();
            mon.setTaskSize(-1L);
            mon.started();
            mon.setProgressMessage("doing HEAD request to find dataset type");
            try {
                Pattern p;
                Matcher m;
                URLConnection c = url.openConnection();
                c = HtmlUtil.checkRedirect((URLConnection)c);
                c.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
                c.setReadTimeout(FileSystem.settings().getReadTimeoutMs());
                String mime = c.getContentType();
                if (mime == null) {
                    throw new IOException("failed to connect");
                }
                String cd = c.getHeaderField("Content-Disposition");
                if (cd != null && (m = (p = Pattern.compile(".*filename=\"?(.+)\"?")).matcher(cd)).matches()) {
                    String filename = m.group(1);
                    int i0 = filename.lastIndexOf(46);
                    ext = filename.substring(i0);
                    factory = DataSourceRegistry.getInstance().getSource(ext);
                }
                if (factory == null) {
                    factory = DataSourceRegistry.getInstance().getSourceByMime(mime);
                }
                if (c instanceof HttpURLConnection) {
                    ((HttpURLConnection)c).disconnect();
                }
            }
            finally {
                mon.finished();
            }
        }
        if (factory == null) {
            if (ext.equals("") || ext.equals("X")) {
                throw new NonResourceException("resource has no extension or mime type");
            }
            factory = DataSourceRegistry.getInstance().getSource(ext);
        }
        if (factory == null) {
            throw new IllegalArgumentException("Unsupported extension: " + ext);
        }
        return factory;
    }

    public static InputStream getInputStream(URL url, ProgressMonitor mon) throws IOException {
        URISplit split = URISplit.parse(url.toString());
        try {
            URI spath = DataSetURI.getWebURL(DataSetURI.toUri(split.path)).toURI();
            FileSystem fs = FileSystem.create((URI)spath);
            FileObject fo = fs.getFileObject(split.file.substring(split.path.length()));
            if (!fo.isLocal()) {
                logger.log(Level.FINE, "getInputStream(URL): downloading file {0} from {1}", new Object[]{fo.getNameExt(), url.toString()});
            }
            return fo.getInputStream(mon);
        }
        catch (URISyntaxException ex) {
            throw new IOException("URI Syntax Exception: " + ex.getMessage());
        }
    }

    public static InputStream getInputStream(URI uri, ProgressMonitor mon) throws IOException {
        FileObject fo;
        logger.entering("DataSetURI", "getInputStream", uri);
        URISplit split = URISplit.parse(uri);
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri(split.path));
        String filename = split.file.substring(split.path.length());
        if (fs instanceof LocalFileSystem) {
            filename = DataSourceUtil.unescape(filename);
        }
        if (!(fo = fs.getFileObject(filename)).isLocal()) {
            logger.log(Level.FINE, "getInputStream(URI): downloading file {0} from {1}{2}", new Object[]{fo.getNameExt(), fs.getRootURI(), filename});
        }
        InputStream result = fo.getInputStream(mon);
        logger.exiting("DataSetURI", "getInputStream");
        return result;
    }

    public static URI toUri(String suri) {
        try {
            if (!URISplit.isUriEncoded(suri)) {
                suri = suri.replaceAll("%([^0-9])", "%25$1");
                suri = suri.replaceAll("<", "%3C");
                suri = suri.replaceAll(">", "%3E");
                suri = suri.replaceAll(" ", "%20");
                suri = suri.replaceAll("\\[", "%5B");
                suri = suri.replaceAll("\\]", "%5D");
                suri = suri.replaceAll("\\^", "%5E");
            }
            if (suri.startsWith("\\")) {
                return new File(suri).toURI();
            }
            return new URI(suri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String fromUri(URI uri) {
        String query;
        String surl = uri.toString();
        int i = surl.indexOf(63);
        String string = query = i == -1 ? "" : surl.substring(i);
        if (i != -1) {
            return URISplit.uriDecode(surl.substring(0, i)) + query;
        }
        return URISplit.uriDecode(surl);
    }

    public static String fromFile(File file) {
        String s = file.getAbsolutePath().replaceAll("\\\\", "/");
        if (s.length() > 0 && s.charAt(0) != '/') {
            return "file:///" + s;
        }
        return "file://" + s;
    }

    public static String maybePlusToSpace(String ssheet) {
        if (ssheet.contains(" ")) {
            return ssheet;
        }
        return ssheet.replaceAll("\\+", " ");
    }

    public static void checkLength(File file) throws EmptyFileException {
        if (file.length() == 0L) {
            throw new EmptyFileException(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkNonHtml(File tfile, URL source) throws HtmlResponseIOException, FileNotFoundException {
        FileInputStream fi = null;
        HtmlResponseIOException ex2 = null;
        try {
            String ss;
            fi = new FileInputStream(tfile);
            byte[] magic = new byte[5];
            int bytes = fi.read(magic);
            if (bytes == 5 && DataSourceUtil.isHtmlStream(ss = new String(magic, "UTF-8"))) {
                ex2 = new HtmlResponseIOException("file appears to be html: " + tfile, source);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if (ex2 != null) {
            throw ex2;
        }
    }

    public static File getFile(URL url, ProgressMonitor mon) throws IOException {
        if (mon == null) {
            mon = new AlertNullProgressMonitor("loading " + url);
        }
        URISplit split = URISplit.parse(url.toString());
        try {
            File tfile;
            FileObject fo;
            if (split.path == null || split.path.length() == 0) {
                throw new IllegalArgumentException("expected file but didn't find one, check URI for question mark");
            }
            FileSystem fs = FileSystem.create((URI)DataSetURI.getWebURL(DataSetURI.toUri(split.path)).toURI());
            String filename = split.file.substring(split.path.length());
            if (fs instanceof LocalFileSystem) {
                filename = DataSourceUtil.unescape(filename);
            }
            if (!(fo = fs.getFileObject(filename)).isLocal()) {
                logger.log(Level.FINE, "getFile: downloading file {0} from {1}", new Object[]{fo.getNameExt(), url.toString()});
            } else {
                logger.log(Level.FINE, "using local copy of {0}", fo.getNameExt());
            }
            if (fo.exists()) {
                tfile = fo.getFile(mon);
                DataSetURI.checkNonHtml(tfile, url);
            } else {
                FileObject foz = fs.getFileObject(filename + ".gz");
                if (foz.exists()) {
                    File fz = foz.getFile(mon);
                    DataSetURI.checkNonHtml(fz, url);
                    File tfile1 = new File(fz.getPath().substring(0, fz.getPath().length() - 3) + ".temp");
                    tfile = new File(fz.getPath().substring(0, fz.getPath().length() - 3));
                    org.das2.util.filesystem.FileSystemUtil.gunzip((File)fz, (File)tfile1);
                    if (tfile.exists() && !tfile.delete()) {
                        throw new IllegalArgumentException("unable to delete " + tfile);
                    }
                    if (!tfile1.renameTo(tfile)) {
                        throw new IllegalArgumentException("unable to rename " + tfile1 + " to " + tfile);
                    }
                } else {
                    if (split.path.endsWith("/tmp/")) {
                        return DataSetURI.downloadResourceAsTempFile(url, -1, mon);
                    }
                    throw new FileNotFoundException("File not found: " + url);
                }
            }
            return tfile;
        }
        catch (URISyntaxException ex) {
            throw new IOException("URI Syntax Exception: " + ex.getMessage());
        }
    }

    private static boolean isUrl(URI uri) {
        String s = uri.getScheme();
        return s.equals("http") || s.equals("https") || s.equals("ftp") || s.equals("file");
    }

    public static File getCacheFilename(URI suri) {
        URISplit split = URISplit.parse(suri);
        if (split.scheme.equals("http") || split.scheme.equals("https") || split.scheme.equals("ftp") || split.scheme.equals("sftp")) {
            try {
                URI root = new URI(split.file);
                File local = FileSystem.settings().getLocalCacheDir();
                if (null != GitHubFileSystem.isGithubFileSystem((String)root.getHost(), (String)root.getPath())) {
                    String file = split.file.substring(split.path.length());
                    return new File(GitHubFileSystem.getLocalRoot((URI)DataSetURI.getResourceURI(split.path)), file);
                }
                logger.log(Level.FINE, "WFS localRoot={0}", local);
                String s = root.getScheme() + "/" + root.getHost() + "/" + root.getPath();
                local = new File(local, s);
                return local;
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(DataSetURI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getFile(String suri, boolean allowHtml, ProgressMonitor mon) throws IOException {
        if (mon == null) {
            mon = new AlertNullProgressMonitor("loading " + suri);
        }
        URISplit split = URISplit.parse(suri);
        if (split.resourceUri == null) {
            throw new IllegalArgumentException("suri is not a URI or URL: " + suri);
        }
        URL url = DataSetURI.isUrl(split.resourceUri) ? split.resourceUri.toURL() : null;
        try {
            File tfile;
            FileSystem fs = FileSystem.create((URI)DataSetURI.toUri(split.path), (ProgressMonitor)mon.getSubtaskMonitor("create filesystem"));
            String filename = split.file.substring(split.path.length());
            FileObject fo = fs.getFileObject(filename);
            if (fo.exists()) {
                tfile = fo.getFile(mon);
                if (allowHtml || !tfile.exists() || url == null) return tfile;
                DataSetURI.checkNonHtml(tfile, url);
                return tfile;
            }
            Class<DataSetURI> clazz = DataSetURI.class;
            synchronized (DataSetURI.class) {
                FileObject foz = fs.getFileObject(filename + ".gz");
                if (foz.exists()) {
                    logger.log(Level.FINE, "getting file from compressed version: {0}", foz);
                    File fz = foz.getFile(mon);
                    if (!allowHtml && fz.exists() && url != null) {
                        DataSetURI.checkNonHtml(fz, url);
                    }
                    File tfile1 = new File(fz.getPath().substring(0, fz.getPath().length() - 3) + ".temp");
                    tfile = new File(fz.getPath().substring(0, fz.getPath().length() - 3));
                    if (!tfile.exists()) {
                        org.das2.util.filesystem.FileSystemUtil.gunzip((File)fz, (File)tfile1);
                        if (tfile.exists() && !tfile.delete()) {
                            throw new IllegalArgumentException("unable to delete " + tfile);
                        }
                        if (tfile1.renameTo(tfile) || tfile.exists()) return tfile;
                        throw new IllegalArgumentException("unable to rename " + tfile1 + " to " + tfile);
                    } else {
                        logger.log(Level.FINE, "another thread appears to have already prepared {0}", tfile);
                    }
                } else {
                    if (split.path.endsWith("/tmp/") && url != null) {
                        // ** MonitorExit[var9_15] (shouldn't be in output)
                        return DataSetURI.downloadResourceAsTempFile(url, mon);
                    }
                    if (fs instanceof WebFileSystem && ((WebFileSystem)fs).isOffline()) {
                        String msg = ((WebFileSystem)fs).getOfflineMessage();
                        msg = msg != null && msg.length() > 0 ? "File not found in cache of offline filesystem: " + split.resourceUri + "\n(Offline because of \"" + msg + "\")" : "File not found in cache of offline filesystem: " + split.resourceUri;
                        throw new FileNotFoundException(msg);
                    }
                    if (!fo.exists()) throw new FileNotFoundException("File not found: " + split.resourceUri);
                    throw new IOException("Unknown I/O Exception occurred");
                }
                // ** MonitorExit[var9_15] (shouldn't be in output)
                return tfile;
            }
        }
        catch (URIException ex) {
            throw new IOException(ex);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            if (ex.getMessage().startsWith("root does not exist")) {
                throw new FileNotFoundException(ex.getMessage());
            }
            if (ex.getMessage().startsWith("local root does not exist")) {
                throw new FileNotFoundException(ex.getMessage());
            }
            if (ex.getMessage().contains("unable to create")) {
                IOException ex2 = new IOException(ex);
                throw ex2;
            }
            if (ex.getMessage().contains("unable to delete")) {
                IOException ex2 = new IOException(ex);
                throw ex2;
            }
            if (ex.getMessage().contains("root must contain user name")) {
                IOException ex2 = new IOException(ex);
                throw ex2;
            }
            IOException ex2 = new IOException("Unsupported protocol: " + suri, ex);
            throw ex2;
        }
    }

    public static File getFile(URI uri, ProgressMonitor mon) throws IOException {
        String suri = DataSetURI.fromUri(uri);
        return DataSetURI.getFile(suri, false, mon);
    }

    public static File downloadResourceAsTempFile(URL url, ProgressMonitor mon) throws IOException {
        return DataSetURI.downloadResourceAsTempFile(url, -1, mon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadResourceAsTempFile(URL url, int timeoutSeconds, ProgressMonitor mon) throws IOException {
        String userInfo;
        if (timeoutSeconds == -1) {
            timeoutSeconds = 10;
        }
        if (timeoutSeconds > 43200) {
            throw new IllegalArgumentException("timeoutSeconds is greater than 12 hours.");
        }
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        try {
            userInfo = KeyChain.getDefault().getUserInfo(url);
        }
        catch (CancelledOperationException ex) {
            userInfo = null;
        }
        URISplit split = URISplit.parse(url.toString());
        if (("https".equals(split.scheme) || "http".equals(split.scheme)) && split.params == null && !split.file.endsWith("/") && !split.path.endsWith("/tmp/")) {
            try {
                File f = DataSetURI.getFile(url, mon);
                return f;
            }
            catch (IOException ex) {
                logger.fine("fail to load with FileSystem API, doing what we did before.");
            }
        }
        if (split.file.startsWith("file:/")) {
            if (split.params != null && split.params.length() > 0) {
                throw new IllegalArgumentException("local file URLs cannot have arguments");
            }
            try {
                return new File(new URL(split.file).toURI());
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        File local = FileSystem.settings().getLocalCacheDir();
        int is = split.path.contains("@") ? split.path.indexOf("@") + 1 : split.scheme.length() + 3;
        String id = split.scheme + "/" + split.path.substring(is);
        final long tnow = System.currentTimeMillis();
        Class<DataSetURI> clazz = DataSetURI.class;
        synchronized (DataSetURI.class) {
            File localCache1 = new File(local, "temp");
            FileSystemUtil.deleteFilesInTree(localCache1, new FileSystemUtil.Check(){

                @Override
                public boolean check(File f) {
                    return tnow - f.lastModified() > 86400000L;
                }
            });
            // ** MonitorExit[var10_13] (shouldn't be in output)
            File localCache = new File(local, "temp");
            localCache = new File(localCache, id);
            if (!localCache.exists() && !localCache.mkdirs()) {
                throw new IOException("unable to make directory: " + localCache);
            }
            String filename = split.file.substring(split.path.length());
            if (split.params != null && split.params.length() > 0) {
                String safe = split.params;
                safe = safe.replaceAll("\\+", "_");
                safe = safe.replaceAll("-", ".");
                safe = Ops.safeName((String)safe);
                filename = filename.replaceAll("@", "_") + "@" + safe.replaceAll("@", "_");
            } else {
                filename = filename.replaceAll("@", "_");
            }
            if (filename.length() > 50) {
                String args;
                String[] ss = filename.split("@", -2);
                String base = ss[0];
                if (base.length() > 50) {
                    base = base.substring(0, 50);
                }
                String string = args = ss.length == 2 ? ss[1] : "";
                if (args.length() > 0) {
                    args = String.format("%09x", args.hashCode());
                }
                filename = base + String.format("%09x", ss[0].hashCode()) + "@" + args;
            }
            filename = new File(localCache, filename).toString();
            File result = new File(filename);
            File tempfile = new File(filename + ".temp");
            logger.log(Level.FINEST, "downloadResourceAsTempFile:\n  sURL: {0}\n  file: {1}", new Object[]{url, tempfile});
            Class<DataSetURI> clazz2 = DataSetURI.class;
            synchronized (DataSetURI.class) {
                HttpURLConnection huc;
                Object action;
                long tlimit = Math.min(timeoutSeconds, 3600);
                if (tempfile.exists()) {
                    logger.log(Level.FINEST, "tlimit= {0}", tlimit);
                    logger.log(Level.FINEST, "(tnow-newf.lastModified())/1000 {0}", tnow - tempfile.lastModified());
                    if ((tnow - tempfile.lastModified()) / 1000L > tlimit) {
                        if (!tempfile.delete()) {
                            logger.log(Level.FINEST, "old temp file could not be deleted");
                        } else {
                            logger.log(Level.FINEST, "old temp file was deleted");
                        }
                    }
                }
                if (result.exists()) {
                    logger.log(Level.FINEST, "tlimit= {0}", tlimit);
                    logger.log(Level.FINEST, "(tnow-result.lastModified())/1000 = {0}", tnow - result.lastModified());
                    if ((tnow - result.lastModified()) / 1000L > tlimit) {
                        if (!result.delete()) {
                            logger.log(Level.FINEST, "old file could not be deleted");
                        } else {
                            logger.log(Level.FINEST, "old file was deleted");
                        }
                    }
                }
                if (result.exists() && (tnow - result.lastModified()) / 1000L < (long)timeoutSeconds && !tempfile.exists()) {
                    logger.log(Level.FINE, "using young temp file {0}", result);
                    action = ACTION_USE_CACHE;
                } else if (tempfile.exists()) {
                    logger.log(Level.FINE, "waiting for other thread to load temp resource {0}", tempfile);
                    action = ACTION_WAIT_EXISTS;
                } else {
                    File newName = result;
                    while (newName.exists()) {
                        String[] ss = filename.split("@", -2);
                        switch (ss.length) {
                            case 1: {
                                filename = ss[0] + "@@0";
                                break;
                            }
                            case 2: {
                                filename = ss[0] + "@" + ss[1] + "@0";
                                break;
                            }
                            default: {
                                int i = Integer.parseInt(ss[2]);
                                filename = ss[0] + "@" + ss[1] + "@" + (i + 1);
                            }
                        }
                        newName = new File(filename);
                    }
                    if (!newName.equals(result) && !result.renameTo(newName)) {
                        logger.log(Level.INFO, "unable to move old file out of the way.  Using alternate name {0}", newName);
                        result = newName;
                        tempfile = new File(filename + ".temp");
                    }
                    logger.log(Level.FINE, "this thread will downloading temp resource {0}", tempfile);
                    action = ACTION_DOWNLOAD;
                    try (FileOutputStream out = new FileOutputStream(result);){
                        ((OutputStream)out).write("DataSetURI.downloadResourceAsTempFile: This placeholding temporary file should not be used.\n".getBytes());
                    }
                    FileOutputStream outf = new FileOutputStream(tempfile);
                    ((OutputStream)outf).close();
                }
                // ** MonitorExit[var15_19] (shouldn't be in output)
                if (action == ACTION_USE_CACHE) {
                    logger.log(Level.FINEST, "downloadResourceAsTempFile-> use cache");
                    return result;
                }
                if (action == ACTION_WAIT_EXISTS) {
                    long t0 = System.currentTimeMillis();
                    logger.log(Level.FINEST, "downloadResourceAsTempFile-> waitExists");
                    mon.setProgressMessage("waiting for resource");
                    mon.started();
                    try {
                        long l0 = tempfile.length();
                        long tlength = System.currentTimeMillis();
                        while (tempfile.exists()) {
                            try {
                                Thread.sleep(300L);
                                if (System.currentTimeMillis() - t0 > 60000L) {
                                    logger.log(Level.FINE, "waiting for other process to finish loading %s...{0}", tempfile);
                                }
                                if (tempfile.length() != l0) {
                                    l0 = tempfile.length();
                                    tlength = System.currentTimeMillis();
                                } else if (System.currentTimeMillis() - tlength > (long)(3 * FileSystem.settings().getConnectTimeoutMs())) {
                                    logger.log(Level.WARNING, "timeout waiting for lengthening of file {0} which another thread is loading", tempfile);
                                    throw new IOException("timeout waiting for lengthening of file " + tempfile + " which another thread is loading");
                                }
                                if (!mon.isCancelled()) continue;
                                throw new InterruptedIOException("cancel pressed");
                            }
                            catch (InterruptedException ex) {
                                logger.log(Level.SEVERE, ex.getMessage(), ex);
                            }
                        }
                    }
                    finally {
                        mon.finished();
                    }
                    return result;
                }
                boolean fail = true;
                Logger loggerUrl = LoggerManager.getLogger((String)"das2.url");
                mon.setProgressMessage("downloading " + url);
                mon.started();
                logger.log(Level.FINEST, "downloadResourceAsTempFile-> transfer");
                logger.log(Level.FINE, "reading URL {0}", url);
                loggerUrl.log(Level.FINE, "GET to get data {0}", url);
                URLConnection urlc = url.openConnection();
                urlc.setRequestProperty("Accept-Encoding", "gzip");
                urlc.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
                urlc.setReadTimeout(FileSystem.settings().getReadTimeoutMs());
                urlc.setAllowUserInteraction(false);
                if (userInfo != null) {
                    String encode = Base64.getEncoder().encodeToString(userInfo.getBytes());
                    urlc.setRequestProperty("Authorization", "Basic " + encode);
                }
                if ((urlc = HttpUtil.checkRedirect((URLConnection)urlc)) instanceof HttpURLConnection && (huc = (HttpURLConnection)urlc).getResponseCode() == 400) {
                    FileUtil.consumeStream((InputStream)huc.getErrorStream());
                    throw new IOException(url.toString());
                }
                try (InputStream in = urlc.getInputStream();){
                    Map<String, List<String>> headers = urlc.getHeaderFields();
                    List<String> contentEncodings = headers.get("Content-Encoding");
                    boolean hasGzipHeader = false;
                    if (contentEncodings != null) {
                        for (String header : contentEncodings) {
                            if (!header.equalsIgnoreCase("gzip")) continue;
                            hasGzipHeader = true;
                            break;
                        }
                    }
                    long contentLength = -1L;
                    List<String> contentLengths = headers.get("Content-Length");
                    if (contentLengths != null && !contentLengths.isEmpty()) {
                        contentLength = Long.parseLong(contentLengths.get(0));
                    }
                    InputStream fin = in;
                    if (hasGzipHeader) {
                        logger.fine("temp file is compressed");
                        fin = new GZIPInputStream(fin);
                    } else {
                        logger.fine("temp file is not compressed");
                    }
                    ProgressMonitor loadMonitor = mon.getSubtaskMonitor("loading");
                    if (contentLength > -1L) {
                        loadMonitor.setTaskSize(contentLength);
                    }
                    fin = new DasProgressMonitorInputStream(fin, loadMonitor);
                    if (urlc instanceof HttpURLConnection) {
                        final HttpURLConnection hurlc = (HttpURLConnection)urlc;
                        ((DasProgressMonitorInputStream)fin).addRunWhenClosedRunnable(new Runnable(){

                            @Override
                            public void run() {
                                hurlc.disconnect();
                            }
                        });
                    }
                    if (contentLength > -1L) {
                        ((DasProgressMonitorInputStream)fin).setStreamLength(contentLength);
                    }
                    FileOutputStream out = new FileOutputStream(tempfile);
                    DataSourceUtil.transfer(Channels.newChannel(fin), Channels.newChannel(out));
                    fail = false;
                    logger.log(Level.FINE, "downloadResourceAsTempFile-> transfer was successful");
                }
                catch (IOException ex) {
                    throw new IOException(url.toString(), ex);
                }
                finally {
                    if (fail) {
                        if (!tempfile.delete()) {
                            logger.log(Level.WARNING, "failed to delete after exception: {0}", tempfile);
                        }
                        if (!result.delete()) {
                            logger.log(Level.WARNING, "failed to delete after exception: {0}", result);
                        }
                    }
                    mon.finished();
                }
                Class<DataSetURI> clazz3 = DataSetURI.class;
                synchronized (DataSetURI.class) {
                    if (!result.delete()) {
                        throw new IllegalArgumentException("unable to delete " + result + " to make way for " + tempfile);
                    }
                    if (!tempfile.renameTo(result)) {
                        throw new IllegalArgumentException("unable to rename " + tempfile + " to " + result);
                    }
                    // ** MonitorExit[var15_22] (shouldn't be in output)
                    return result;
                }
            }
        }
    }

    public static File getFile(String uri, ProgressMonitor mon) throws IOException {
        return DataSetURI.getFile(uri, false, mon);
    }

    public static File getFile(String uri) throws IOException {
        return DataSetURI.getFile(uri, false, (ProgressMonitor)new AlertNullProgressMonitor("downloading " + uri));
    }

    public static File getHtmlFile(URL url, ProgressMonitor mon) throws IOException {
        return DataSetURI.getFile(url.toString(), true, mon);
    }

    public static URI getURIValid(String surl) throws URISyntaxException {
        URI result = DataSetURI.getURI(surl);
        if (result == null) {
            throw new IllegalArgumentException("URI cannot be formed from \"" + surl + "\"");
        }
        return result;
    }

    public static URI getURI(String surl) throws URISyntaxException {
        URISplit split = URISplit.maybeAddFile(surl, 0);
        if (split == null) {
            return null;
        }
        surl = split.surl;
        if (surl.endsWith("://")) {
            surl = surl + "/";
        }
        surl = surl.replaceAll("%([^0-9])", "%25$1");
        surl = surl.replaceAll("<", "%3C");
        surl = surl.replaceAll(">", "%3E");
        surl = surl.replaceAll(" ", "%20");
        surl = surl.replaceAll("\\^", "%5E");
        surl = surl.replaceAll("\\\\", "%5C");
        surl = surl.replaceAll("\\{", "%7B");
        surl = surl.replaceAll("\\|", "%7C");
        surl = surl.replaceAll("\\}", "%7D");
        if (split.vapScheme != null) {
            if (split.vapScheme.contains(" ")) {
                split.vapScheme = split.vapScheme.replace(" ", "+");
            }
            surl = split.vapScheme + ":" + surl;
        }
        if (!(surl = URISplit.format(URISplit.parse(surl))).startsWith("vap")) {
            URISplit split2 = URISplit.parse(surl);
            String vapScheme = URISplit.implicitVapScheme(split2);
            if (vapScheme.contains("&")) {
                throw new IllegalArgumentException("Address contains ampersand in what looks like a filename: " + surl);
            }
            if (vapScheme.equals("")) {
                vapScheme = "vap+X";
            }
            surl = vapScheme + ":" + surl;
        }
        URI result = new URI(surl);
        return result;
    }

    public static URL getURL(String surl) throws MalformedURLException {
        try {
            URI uri = DataSetURI.getURIValid(surl);
            return DataSetURI.getWebURL(uri);
        }
        catch (URISyntaxException ex) {
            throw new MalformedURLException(ex.getMessage());
        }
    }

    public static List<CompletionResult> getCompletions(String surl, int carotpos, ProgressMonitor mon) throws Exception {
        int firstSlashAfterHost;
        if (carotpos == 0 || !surl.substring(0, carotpos).contains(":") && (carotpos < 4 && surl.substring(0, carotpos).equals("vap".substring(0, carotpos)) || surl.length() > 3 && surl.substring(0, 3).equals("vap"))) {
            return DataSetURI.getTypesCompletions(surl, carotpos, mon);
        }
        URISplit split = URISplit.parse(surl, carotpos, true);
        if (split.vapScheme != null && split.file == null || split.file != null && split.resourceUriCarotPos > split.file.length() && DataSourceRegistry.getInstance().hasSourceByExt(DataSetURI.getExt(surl))) {
            return DataSetURI.getFactoryCompletions(URISplit.format(split), split.formatCarotPos, mon);
        }
        if (split.vapScheme == null && split.scheme == null) {
            String[] types = new String[]{"ftp://", "http://", "https://", "file:/", "sftp://"};
            ArrayList<CompletionResult> result = new ArrayList<CompletionResult>();
            String completable = surl.substring(0, carotpos);
            for (String type : types) {
                if (type.length() < carotpos || !type.startsWith(completable)) continue;
                result.add(new CompletionResult(type, null, type, completable, false));
            }
            return result;
        }
        int n = firstSlashAfterHost = split.authority == null ? 0 : split.authority.length();
        if (split.resourceUriCarotPos <= firstSlashAfterHost) {
            return DataSetURI.getHostCompletions(URISplit.format(split), split.formatCarotPos, mon);
        }
        return DataSetURI.getFileSystemCompletions(URISplit.format(split), split.formatCarotPos, true, true, null, mon);
    }

    public static List<CompletionResult> getHostCompletions(String surl, int carotpos, ProgressMonitor mon) throws IOException {
        String surlDir;
        String prefix;
        URISplit split = URISplit.parse(surl.substring(0, carotpos));
        if (split.path == null) {
            prefix = "";
            surlDir = "";
        } else {
            prefix = split.file.substring(split.path.length());
            surlDir = split.path;
        }
        mon.setLabel("getting list of cache hosts");
        if (split.scheme == null) {
            String[] s;
            ArrayList<CompletionResult> completions = new ArrayList<CompletionResult>();
            for (String item : s = new String[]{"ftp://", "http://", "https://", "file:///", "sftp://"}) {
                completions.add(new CompletionResult(item + surl + "/", item + surl + "/"));
            }
            return completions;
        }
        File cacheF = new File(FileSystem.settings().getLocalCacheDir(), split.scheme);
        if (!cacheF.exists()) {
            return Collections.emptyList();
        }
        String[] s = cacheF.list();
        if (s == null) {
            return Collections.emptyList();
        }
        boolean foldCase = true;
        if (foldCase) {
            prefix = prefix.toLowerCase();
        }
        ArrayList<CompletionResult> completions = new ArrayList<CompletionResult>(s.length);
        for (String item : s) {
            String scomp;
            String string = scomp = foldCase ? item.toLowerCase() : item;
            if (!scomp.startsWith(prefix)) continue;
            StringBuilder result1 = new StringBuilder(item);
            result1.append("/");
            String[] s2 = new File(cacheF, result1.toString()).list();
            if (s2 == null) {
                s2 = new String[]{};
            }
            while (s2.length == 1 && new File(cacheF, result1 + "/" + s2[0]).isDirectory()) {
                result1.append(s2[0]).append("/");
                s2 = new File(cacheF, result1.toString()).list();
                if (s2 != null) continue;
                s2 = new String[]{};
            }
            completions.add(new CompletionResult(surlDir + result1.toString(), result1.toString(), null, surl.substring(0, carotpos), true));
        }
        if (completions.size() != 1 || ((CompletionResult)completions.get((int)0)).completion.equals(surlDir + prefix + "/")) {
            // empty if block
        }
        Collections.sort(completions, new Comparator<CompletionResult>(){

            @Override
            public int compare(CompletionResult o1, CompletionResult o2) {
                return o1.completion.compareTo(o2.completion);
            }
        });
        return completions;
    }

    public static List<CompletionResult> getFileSystemAggCompletions(String surl, int carotpos, ProgressMonitor mon) throws IOException, URISyntaxException {
        URISplit split = URISplit.parse(surl.substring(0, carotpos), carotpos, false);
        String surlDir = URISplit.uriDecode(split.path);
        mon.setLabel("getting remote listing");
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri(surlDir));
        Object[] s = fs.listDirectory("/");
        Arrays.sort(s);
        ArrayList<CompletionResult> completions = new ArrayList<CompletionResult>(5);
        String[] s2 = new String[s.length];
        for (int i = 0; i < s.length; ++i) {
            s2[i] = surlDir + (String)s[i];
        }
        if (s2.length > 0) {
            LinkedList<String> files = new LinkedList<String>(Arrays.asList(s2));
            List<String> saggs = DataSourceUtil.findAggregations(files, true);
            for (String sagg : saggs) {
                sagg = URISplit.removeParam(sagg, "timerange");
                completions.add(new CompletionResult(sagg, "Use aggregation", "", true));
            }
        }
        return completions;
    }

    public static List<CompletionResult> getFileSystemCompletions(String surl, int carotpos, boolean inclAgg, boolean inclFiles, String acceptPattern, ProgressMonitor mon) throws IOException, URISyntaxException {
        return DataSetURI.getFileSystemCompletions(surl, carotpos, inclAgg, inclFiles ? null : new ArrayList<String>(), acceptPattern, mon);
    }

    public static List<CompletionResult> getFileSystemCacheCompletions(String surl, int carotpos, boolean inclAgg, boolean inclFiles, String acceptPattern, ProgressMonitor mon) throws IOException, URISyntaxException {
        String surlDir;
        String prefix;
        URISplit split = URISplit.parse(surl.substring(0, carotpos));
        if (split.path == null) {
            prefix = "";
            surlDir = "";
        } else {
            prefix = split.file.substring(split.path.length());
            surlDir = split.path;
        }
        mon.setLabel("getting list of cached folders");
        if (split.scheme == null) {
            throw new IllegalArgumentException("need scheme and hostname");
        }
        File cacheF = new File(FileSystem.settings().getLocalCacheDir(), split.scheme + '/' + split.path.substring(split.scheme.length() + 3));
        if (!cacheF.exists()) {
            return Collections.emptyList();
        }
        String[] s = cacheF.list();
        if (s == null) {
            return Collections.emptyList();
        }
        boolean foldCase = true;
        if (foldCase) {
            prefix = prefix.toLowerCase();
        }
        ArrayList<CompletionResult> completions = new ArrayList<CompletionResult>(s.length);
        for (String item : s) {
            String[] ss;
            File ff;
            String scomp;
            String string = scomp = foldCase ? item.toLowerCase() : item;
            if (!scomp.startsWith(prefix) || scomp.endsWith(".listing") || !(ff = new File(cacheF, item)).isDirectory() || (ss = ff.list()) == null || ss.length == 0) continue;
            StringBuilder result1 = new StringBuilder(item);
            result1.append("/");
            String[] s2 = new File(cacheF, result1.toString()).list();
            if (s2 == null) {
                s2 = new String[]{};
            }
            while (s2.length == 1 && new File(cacheF, result1 + "/" + s2[0]).isDirectory()) {
                result1.append(s2[0]).append("/");
                s2 = new File(cacheF, result1.toString()).list();
                if (s2 != null) continue;
                s2 = new String[]{};
            }
            completions.add(new CompletionResult(surlDir + result1.toString(), result1.toString(), null, surl.substring(0, carotpos), true));
        }
        if (completions.size() != 1 || ((CompletionResult)completions.get((int)0)).completion.equals(surlDir + prefix + "/")) {
            // empty if block
        }
        return completions;
    }

    /*
     * WARNING - void declaration
     */
    public static List<CompletionResult> getFileSystemCompletions(String surl, int carotpos, boolean inclAgg, List<String> inclFiles, String acceptPattern, ProgressMonitor mon) throws IOException, URISyntaxException {
        WebFileSystem wfs;
        String[] s;
        FileSystem fs;
        URISplit split = URISplit.parse(surl.substring(0, carotpos), carotpos, false);
        if (split.file == null) {
            logger.info("url passed to getFileSystemCompletions does not appear to be a filesystem.");
            return Collections.emptyList();
        }
        String prefix = URISplit.uriDecode(split.file.substring(split.path.length()));
        String[] surlDir = URISplit.uriDecode(split.path);
        mon.setLabel("getting remote listing");
        if (surlDir.equals("file:") || surlDir.equals("file://")) {
            CompletionResult t0 = split.vapScheme != null ? new CompletionResult(split.vapScheme + ":file:///", "need three slashes") : new CompletionResult("file:///", "need three slashes");
            List<CompletionResult> completions = Collections.singletonList(t0);
            return completions;
        }
        boolean onlyAgg = false;
        String prefixPrefix = "";
        if (surlDir.contains("$Y")) {
            DatumRange timeRange = null;
            try {
                URISplit split1 = URISplit.parse(surl);
                LinkedHashMap<String, String> parms = URISplit.parseParams(split1.params);
                String stimeRange = (String)parms.get("timerange");
                if (stimeRange != null) {
                    timeRange = DatumRangeUtil.parseTimeRange((String)stimeRange);
                }
            }
            catch (ParseException e) {
                logger.log(Level.WARNING, "parse exception: {0}", e);
            }
            int ip = surlDir.indexOf("$Y");
            String[] s1 = surlDir.substring(0, ip);
            String s2 = surlDir.substring(ip, surlDir.length() - 1);
            FileSystem fsp = FileSystem.create((URI)DataSetURI.toUri((String)s1), (ProgressMonitor)mon);
            FileStorageModel fsm = FileStorageModel.create((FileSystem)fsp, (String)s2);
            fs = fsp;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (timeRange != null) {
                String ss1 = fsm.getRepresentativeFile(mon);
                timeRange = fsm.getRangeFor(ss1);
            }
            String[] ss2 = fsm.getNamesFor(timeRange);
            int nn = Math.min(2, ss2.length);
            for (int i = 0; i < nn; ++i) {
                if (i == 1) {
                    i = ss2.length - 1;
                }
                FileSystem fsm2 = FileSystem.create((URI)DataSetURI.toUri((String)s1 + ss2[i]));
                String[] ss3 = fsm2.listDirectory("/");
                for (int ii = 0; ii < ss3.length; ++ii) {
                    ss3[ii] = ss2[i] + '/' + ss3[ii];
                }
                arrayList.addAll(Arrays.asList(ss3));
            }
            s = arrayList.toArray(new String[arrayList.size()]);
            surlDir = s1;
            onlyAgg = true;
            prefixPrefix = s2 + '/';
        } else {
            fs = FileSystem.create((String)surlDir, (ProgressMonitor)mon);
            s = fs.listDirectory("/");
        }
        for (int i = 0; i < s.length; ++i) {
            if (!s[i].endsWith(".gz")) continue;
            s[i] = s[i].substring(0, s[i].length() - 3);
        }
        if (acceptPattern != null) {
            Pattern p = Pattern.compile(acceptPattern);
            ArrayList<String> res = new ArrayList<String>(s.length);
            for (String item : s) {
                if (item.endsWith("/")) {
                    res.add(item);
                    continue;
                }
                if (!p.matcher(item).matches()) continue;
                res.add(item);
            }
            s = res.toArray(new String[res.size()]);
        }
        Arrays.sort(s, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                boolean d2;
                boolean d1 = o1.startsWith(".");
                if (d1 == (d2 = o2.startsWith("."))) {
                    return o1.compareTo(o2);
                }
                if (d1) {
                    return 1;
                }
                return -1;
            }
        });
        boolean foldCase = Boolean.TRUE.equals(fs.getProperty("caseInsensitive"));
        if (foldCase) {
            prefix = prefix.toLowerCase();
        }
        if (prefixPrefix.length() > 0) {
            prefix = prefixPrefix + prefix;
        }
        ArrayList<CompletionResult> completions = new ArrayList<CompletionResult>(s.length);
        String[] s2 = new String[s.length];
        for (int i = 0; i < s.length; ++i) {
            s2[i] = (String)surlDir + s[i];
        }
        if (s2.length > 0 && inclAgg) {
            LinkedList<String> files = new LinkedList<String>(Arrays.asList(s2));
            List<String> saggs = DataSourceUtil.findAggregations(files, true, onlyAgg);
            if (onlyAgg) {
                completions.clear();
            }
            for (String string : saggs) {
                URISplit split2 = URISplit.parse(string);
                LinkedHashMap<String, String> params2 = URISplit.parseParams(split2.params);
                String tr = (String)params2.remove("timerange");
                split2.params = params2.isEmpty() ? null : URISplit.formatParams(params2);
                if (split2.vapScheme != null && !string.startsWith(split2.vapScheme)) {
                    split2.vapScheme = null;
                }
                String scomp = URISplit.format(split2);
                if (split2.vapScheme == null && split.vapScheme != null) {
                    split2.vapScheme = split.vapScheme;
                }
                String string2 = URISplit.format(split2);
                if (!(scomp = scomp.substring(surlDir.length())).startsWith(prefix)) continue;
                String doc = "Use aggregation (" + tr + " available)";
                int splitIndex = AggregatingDataSourceFactory.splitIndex(string2);
                String label = ".../" + string2.substring(splitIndex);
                completions.add(new CompletionResult(string2, label, doc, prefix, true));
            }
        }
        if (!onlyAgg) {
            for (int j = 0; j < s.length; ++j) {
                void var19_44;
                String scomp;
                String string = scomp = foldCase ? s[j].toLowerCase() : s[j];
                if (!scomp.startsWith(prefix)) continue;
                if (s[j].endsWith("contents.html")) {
                    s[j] = s[j].substring(0, s[j].length() - "contents.html".length());
                }
                if (s[j].endsWith(".zip") || s[j].endsWith(".ZIP")) {
                    s[j] = s[j] + "/";
                }
                if (s[j].endsWith(".tar") || s[j].endsWith(".tgz") || s[j].endsWith(".tar.gz")) {
                    s[j] = s[j] + "/";
                }
                boolean haveMatch = true;
                if (!s[j].endsWith("/") && inclFiles != null) {
                    haveMatch = false;
                    for (String regex : inclFiles) {
                        if (!Pattern.matches(regex, s[j])) continue;
                        haveMatch = true;
                    }
                }
                if (!haveMatch) continue;
                String string4 = (String)surlDir + s[j];
                string4 = DataSetURI.newUri(surl, string4);
                String label = s[j];
                String completable = surl.substring(0, carotpos);
                boolean maybePlot = true;
                if (string4.startsWith("file://" + completable)) {
                    String string5 = string4.substring(7);
                }
                completions.add(new CompletionResult((String)var19_44, label, null, completable, maybePlot));
            }
        }
        if (completions.size() != 1 || ((CompletionResult)completions.get((int)0)).completion.equals((String)surlDir + prefix + "/")) {
            // empty if block
        }
        if (fs instanceof WebFileSystem && (wfs = (WebFileSystem)fs).isOffline()) {
            String offlineMsg = wfs.getOfflineMessage();
            int offlineCode = wfs.getOfflineResponseCode();
            if (offlineMsg.length() > 0) {
                if (offlineMsg.length() > 20) {
                    offlineMsg = offlineMsg.substring(0, 17) + "...";
                }
                if (offlineCode == 0) {
                    completions.add(new CompletionResult(fs.getRootURI().toString(), "(FileSystem is offline: " + offlineMsg + ")", "<html>The filesystem is offline because of<br>" + wfs.getOfflineMessage() + "<br>Use Tools->Cache->Reset Memory Caches to reset", fs.getRootURI().toString(), false));
                } else {
                    completions.add(new CompletionResult(fs.getRootURI().toString(), "(FileSystem is offline: " + offlineMsg + ")", "<html>The filesystem is offline because of<br>" + offlineCode + ": " + wfs.getOfflineMessage() + "<br>Use Tools->Cache->Reset Memory Caches to reset", fs.getRootURI().toString(), false));
                }
            } else {
                completions.add(new CompletionResult(fs.getRootURI().toString(), "(FileSystem is offline)", "The filesystem is offline.  Use Tools->Cache->Reset Memory Caches to reset", fs.getRootURI().toString(), false));
            }
        }
        return completions;
    }

    public static List<CompletionResult> getTypesCompletions(String surl, int carotpos, ProgressMonitor mon) throws Exception {
        String home;
        List<String> dexts = DataSetURI.getDiscoverableExtensions();
        ArrayList<CompletionResult> completions = new ArrayList<CompletionResult>();
        String prefix = surl.substring(0, carotpos);
        for (String ext : dexts) {
            String vapext = "vap+" + ext.substring(1);
            if (!vapext.startsWith(prefix)) continue;
            completions.add(new CompletionResult(vapext + ":", DataSourceRegistry.getDescriptionFor(vapext), prefix, true));
        }
        if ("http://".startsWith(prefix)) {
            completions.add(new CompletionResult("http://", null, prefix, true));
        }
        if ("ftp://".startsWith(prefix)) {
            completions.add(new CompletionResult("ftp://", null, prefix, true));
        }
        if ("file://".startsWith(prefix)) {
            completions.add(new CompletionResult("file:///", null, prefix, true));
        }
        if ((home = "file://" + FileSystem.toCanonicalFolderName((String)System.getProperty("user.home"))).startsWith(prefix)) {
            completions.add(new CompletionResult(home, null, prefix, true));
        }
        return completions;
    }

    public static List<String> getDiscoverableExtensions() {
        List<String> exts = DataSourceRegistry.getInstance().getSourceEditorExtensions();
        ArrayList<String> result = new ArrayList<String>();
        for (String ext : exts) {
            try {
                DataSourceFactory o = DataSourceRegistry.getInstance().getSource(ext);
                if (o == null || !o.supportsDiscovery() || ext.equals(".dc")) continue;
                result.add(ext);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.toString(), ex);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSortedDiscoverableExtentions() {
        List<String> exts = DataSetURI.getDiscoverableExtensions();
        exts.add("file:");
        File f = new File(AutoplotSettings.settings().resolveProperty("autoplotData") + "/bookmarks/discovery.txt");
        if (f.exists() && f.canRead()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(f));
                String s = reader.readLine();
                while (s != null) {
                    if (s.length() > 29) {
                        String ss;
                        switch (ss = s.substring(25, 29)) {
                            case "file": {
                                String ex1 = "file:";
                                if (!exts.contains(ex1)) break;
                                exts.remove(ex1);
                                exts.add(0, ex1);
                                break;
                            }
                            case "vap+": {
                                int i = s.indexOf(":", 29);
                                String ex1 = "." + s.substring(29, i);
                                if (!exts.contains(ex1)) break;
                                exts.remove(ex1);
                                exts.add(0, ex1);
                                break;
                            }
                        }
                    }
                    s = reader.readLine();
                }
            }
            catch (IOException ex) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        return exts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CompletionResult> getFactoryCompletions(String surl1, int carotPos, ProgressMonitor mon) throws Exception {
        CompletionContext cc = new CompletionContext();
        URISplit split = URISplit.parse(surl1);
        if (carotPos == 0 && surl1.trim().length() > 0) {
            return Collections.singletonList(new CompletionResult("No completions", "No completions", "", false));
        }
        int qpos = surl1.lastIndexOf(63, carotPos);
        if (qpos == -1 && surl1.contains(":") && (surl1.endsWith(":") || surl1.contains("&"))) {
            qpos = surl1.indexOf(":");
        }
        if (qpos == -1 && surl1.contains(":") && split.file == null) {
            qpos = surl1.indexOf(":");
        }
        cc.surl = surl1;
        cc.surlpos = carotPos;
        boolean hasResourceUri = split.vapScheme == null || DataSourceRegistry.getInstance().hasResourceUri(split.vapScheme);
        ArrayList<CompletionResult> result = new ArrayList();
        if (qpos == -1 && !hasResourceUri || qpos != -1 && qpos < carotPos) {
            int eqpos = surl1.lastIndexOf(61, carotPos - 1);
            int amppos = surl1.lastIndexOf(38, carotPos - 1);
            if (amppos == -1) {
                amppos = qpos;
            }
            if (eqpos > amppos) {
                cc.context = CompletionContext.CONTEXT_PARAMETER_VALUE;
                cc.completable = surl1.substring(eqpos + 1, carotPos);
                cc.completablepos = carotPos - (eqpos + 1);
            } else {
                cc.context = CompletionContext.CONTEXT_PARAMETER_NAME;
                cc.completable = surl1.substring(amppos + 1, carotPos);
                cc.completablepos = carotPos - (amppos + 1);
                if (surl1.length() > carotPos && surl1.charAt(carotPos) != '&') {
                    int aftaCarotPos = surl1.indexOf("&", carotPos);
                    if (aftaCarotPos == -1) {
                        aftaCarotPos = surl1.length();
                    }
                    if (aftaCarotPos < (surl1 = surl1.substring(0, carotPos)).length()) {
                        surl1 = '&' + surl1.substring(aftaCarotPos);
                    }
                    split = URISplit.parse(surl1);
                }
            }
        } else {
            cc.context = CompletionContext.CONTEXT_FILE;
            qpos = surl1.indexOf(63, carotPos);
            cc.completable = qpos == -1 ? surl1 : surl1.substring(0, qpos);
            cc.completablepos = carotPos;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            int i;
            String suri;
            DataSourceFactory factory = DataSetURI.getDataSourceFactory(DataSetURI.getURIValid(surl1), (ProgressMonitor)new NullProgressMonitor());
            if (factory == null) {
                throw new IllegalArgumentException("unable to find data source factory");
            }
            if (hasResourceUri) {
                suri = CompletionContext.get(CompletionContext.CONTEXT_FILE, cc);
                if (suri == null) {
                    suri = cc.surl;
                }
            } else {
                suri = surl1;
                int i2 = cc.completable.indexOf(":");
                if (i2 > 0) {
                    cc.completable = cc.completable.substring(i2 + 1);
                    cc.completablepos -= i2 + 1;
                }
            }
            URI uri = DataSetURI.getURIValid(suri);
            cc.resourceURI = DataSetURI.getResourceURI(uri);
            cc.params = split.params;
            List<CompletionContext> completions = factory.getCompletions(cc, mon);
            LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
            LinkedHashMap<String, String> paramsArgN = URISplit.parseParams(split.params);
            for (i = 0; i < 3; ++i) {
                params.remove("arg_" + i);
            }
            i = 0;
            for (CompletionContext cc1 : completions) {
                String ss;
                LinkedHashMap<String, String> paramsCopy;
                boolean dontYetHave;
                String paramName;
                boolean useArgN = false;
                String string = paramName = cc1.implicitName != null ? cc1.implicitName : cc1.completable;
                if (paramName.contains("=")) {
                    paramName = paramName.substring(0, paramName.indexOf("="));
                    useArgN = true;
                }
                boolean bl = dontYetHave = !params.containsKey(paramName);
                boolean startsWith = cc1.completable.startsWith(cc.completable);
                if (!startsWith) continue;
                if (useArgN) {
                    paramsCopy = new LinkedHashMap<String, String>(paramsArgN);
                    if (cc.completable.length() > 0) {
                        String rm = null;
                        for (Map.Entry<String, String> e : paramsCopy.entrySet()) {
                            String k = e.getKey();
                            String v = e.getValue();
                            if (!v.startsWith(cc.completable)) continue;
                            rm = k;
                        }
                        if (rm != null) {
                            paramsCopy.remove(rm);
                        } else {
                            logger.log(Level.FINE, "expected to find in completions: {0}", cc.completable);
                        }
                    }
                } else {
                    paramsCopy = new LinkedHashMap<String, String>(params);
                }
                if (cc1.implicitName != null) {
                    paramsCopy.put(cc1.implicitName, cc1.completable);
                } else {
                    paramsCopy.put(cc1.completable, null);
                }
                String string2 = ss = split.vapScheme == null ? "" : split.vapScheme + ":";
                if (split.file != null && hasResourceUri) {
                    ss = ss + split.file + "?";
                }
                ss = ss + URISplit.formatParams(paramsCopy);
                if (!dontYetHave) continue;
                String label = cc1.label.startsWith(cc1.completable) ? cc1.label : cc1.completable + ": " + cc1.label;
                result.add(new CompletionResult(ss, label, cc1.doc, surl1.substring(0, carotPos), cc1.maybePlot));
                ++i;
            }
            return result;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String file = CompletionContext.get(CompletionContext.CONTEXT_FILE, cc);
            DataSourceFactory factory = DataSetURI.getDataSourceFactory(DataSetURI.getURIValid(surl1), mon);
            if (file != null) {
                URI uri = DataSetURI.getURIValid(file);
                cc.resourceURI = DataSetURI.getResourceURI(uri);
            }
            cc.params = split.params;
            if (factory == null) {
                throw new IllegalArgumentException("unable to find data source factory");
            }
            List<CompletionContext> completions = factory.getCompletions(cc, mon);
            int i = 0;
            for (CompletionContext cc1 : completions) {
                if (!cc1.completable.startsWith(cc.completable)) continue;
                String ss = CompletionContext.insert(cc, cc1);
                if (split.vapScheme != null && !ss.startsWith(split.vapScheme)) {
                    ss = split.vapScheme + ":" + ss;
                }
                String label = cc1.label.startsWith(cc1.completable) ? cc1.label : cc1.completable + ": " + cc1.label;
                result.add(new CompletionResult(ss, label, cc1.doc, surl1.substring(0, carotPos), cc1.maybePlot));
                ++i;
            }
            return result;
        }
        try {
            int newCarotPos;
            int i;
            mon.setProgressMessage("listing directory");
            mon.started();
            String surl = CompletionContext.get(CompletionContext.CONTEXT_FILE, cc);
            if (surl == null) {
                throw new MalformedURLException("unable to process");
            }
            int surlPos = cc.surl.indexOf(surl);
            if (surlPos == -1) {
                surlPos = 0;
            }
            String surlDir = (i = surl.lastIndexOf("/", (newCarotPos = carotPos - surlPos) - 1)) <= 0 ? surl : surl.substring(0, i + 1);
            URI url = DataSetURI.getURIValid(surlDir);
            String prefix = surl.substring(i + 1, newCarotPos);
            FileSystem fs = FileSystem.create((URL)DataSetURI.getWebURL(url), (ProgressMonitor)new NullProgressMonitor());
            String[] s = fs.listDirectory("/");
            mon.finished();
            for (String item : s) {
                if (!item.startsWith(prefix)) continue;
                CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_FILE, surlDir + item);
                result.add(new CompletionResult(CompletionContext.insert(cc, cc1), cc1.label, cc1.doc, surl1.substring(0, carotPos), true));
            }
        }
        catch (MalformedURLException ex) {
            result = Collections.singletonList(new CompletionResult("Malformed URI", "Something in the URL prevents processing " + surl1.substring(0, carotPos), "", false));
        }
        catch (FileSystem.FileSystemOfflineException ex) {
            result = Collections.singletonList(new CompletionResult("FileSystem offline", "FileSystem is offline." + surl1.substring(0, carotPos), "", false));
        }
        finally {
            mon.finished();
        }
        return result;
    }

    public static void init() {
    }

    public static void main(String[] args) throws MalformedURLException, IOException {
        logger.fine(DataSetURI.getResourceURI("file:C:\\documents and settings\\jbf\\pngwalk").toString());
        URL url = new URL("http://autoplot.org/data/logos/logo64.png");
        File x = DataSetURI.downloadResourceAsTempFile(url, (ProgressMonitor)new NullProgressMonitor());
        logger.fine(x.toString());
    }

    static {
        logger.fine("load class DataSetURI");
        DataSourceRegistry registry = DataSourceRegistry.getInstance();
        registry.discoverFactories();
        registry.discoverRegistryEntries();
        FileSystem.registerFileSystemFactory((String)"tar", (FileSystemFactory)new VFSFileSystemFactory());
        FileSystem.registerFileSystemFactory((String)"ftp", (FileSystemFactory)new FTPBeanFileSystemFactory());
        if (System.getProperty("AP_CURL") != null || System.getProperty("AP_WGET") != null) {
            FileSystem.registerFileSystemFactory((String)"http", (FileSystemFactory)new WGetFileSystemFactory());
            FileSystem.registerFileSystemFactory((String)"https", (FileSystemFactory)new WGetFileSystemFactory());
            FileSystem.registerFileSystemFactory((String)"ftp", (FileSystemFactory)new WGetFileSystemFactory());
            logger.fine("using wget implementation for http,https and ftp because AP_CURL or AP_WGET is set.");
        }
        FileSystem.registerFileSystemFactory((String)"sftp", (FileSystemFactory)new VFSFileSystemFactory());
        FileSystem.settings().setPersistence(FileSystemSettings.Persistence.EXPIRES);
        if (FileSystemSettings.hasAllPermission()) {
            File apDataHome = new File(AutoplotSettings.settings().resolveProperty("fscache"));
            FileSystem.settings().setLocalCacheDir(apDataHome);
        }
        dsToFactory = new WeakHashMap();
    }

    public static class CompletionResult {
        public String completion;
        public String doc;
        public String label;
        public String completable;
        public boolean maybePlot;
        public static final CompletionResult SEPARATOR = new CompletionResult("====", "Used to request a separator");

        protected CompletionResult(String completion, String doc) {
            this(completion, null, doc, null, false);
        }

        protected CompletionResult(String completion, String doc, String completable, boolean maybePlot) {
            this(completion, null, doc, completable, maybePlot);
        }

        protected CompletionResult(String completion, String label, String doc, String completable, boolean maybePlot) {
            this.completion = completion;
            this.completable = completable;
            this.label = label != null ? label : (completion != null ? completion : completable);
            this.doc = doc;
            this.maybePlot = maybePlot;
        }

        public String toString() {
            return "CompletionResult " + this.completion;
        }
    }

    public static class NonResourceException
    extends IllegalArgumentException {
        public NonResourceException(String msg) {
            super(msg);
        }
    }
}

