/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.das2.util.LoggerManager;
import org.jdesktop.layout.GroupLayout;

public class DataSourceEditorDialog
extends JDialog {
    protected boolean cancelled = true;
    public static final String PROP_CANCELLED = "cancelled";
    protected int modifiers = 0;
    public static final String PROP_MODIFIERS = "modifiers";
    private JButton cancelButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton okayButton;
    private JButton overplotButton;
    private JButton plotBelowButton;
    private JComboBox problemsList;

    public DataSourceEditorDialog(Frame parent, Component message, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jPanel1.add(message, "Center");
        this.setLocationRelativeTo(parent);
        this.problemsList.setVisible(false);
        this.validate();
        this.setName(message.getName());
    }

    public DataSourceEditorDialog(Dialog parent, Component message, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jPanel1.add(message, "Center");
        this.setLocationRelativeTo(parent);
        this.validate();
        this.setName(message.getName());
    }

    public void setProblems(List<String> problems) {
        if (problems == null || problems.isEmpty()) {
            this.problemsList.setVisible(false);
        } else {
            String[] prob = new String[problems.size() + 1];
            prob[0] = "Problems indicated...";
            for (int i = 0; i < problems.size(); ++i) {
                prob[i + 1] = "<html><em>&bull;&nbsp;" + problems.get(i);
            }
            this.problemsList.setModel(new DefaultComboBoxModel<String>(prob));
            this.problemsList.setVisible(true);
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setExpertMode(boolean expert) {
        if (this.overplotButton.isVisible()) {
            this.overplotButton.setVisible(expert);
            this.plotBelowButton.setVisible(expert);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.okayButton = new JButton();
        this.cancelButton = new JButton();
        this.plotBelowButton = new JButton();
        this.overplotButton = new JButton();
        this.problemsList = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setLayout(new BorderLayout());
        this.okayButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/go.png")));
        this.okayButton.setText("Plot");
        this.okayButton.setToolTipText("Plot, replacing any previous plot.");
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceEditorDialog.this.okayButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceEditorDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.plotBelowButton.setText("Plot Below");
        this.plotBelowButton.setToolTipText("Plot below the current plot.  Holding shift will plot above.");
        this.plotBelowButton.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                DataSourceEditorDialog.this.plotBelowButtonMouseMoved(evt);
            }
        });
        this.plotBelowButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                DataSourceEditorDialog.this.plotBelowButtonMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                DataSourceEditorDialog.this.plotBelowButtonMouseEntered(evt);
            }
        });
        this.plotBelowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceEditorDialog.this.plotBelowButtonActionPerformed(evt);
            }
        });
        this.overplotButton.setText("Overplot");
        this.overplotButton.setToolTipText("Add this to the current plot as an overplot");
        this.overplotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceEditorDialog.this.overplotButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.cancelButton, -2, 94, -2).addPreferredGap(0).add((Component)this.overplotButton).addPreferredGap(0).add((Component)this.plotBelowButton).addPreferredGap(0).add((Component)this.okayButton, -2, 83, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.okayButton, -2, 29, -2).add((Component)this.cancelButton).add((Component)this.plotBelowButton).add((Component)this.overplotButton)));
        this.problemsList.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.problemsList, 0, -1, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jPanel2, -2, -1, -2)).add((Component)this.jPanel1, -1, 850, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -1, 444, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -2, -1, -2).add((Component)this.problemsList, -2, -1, -2))));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.cancelled = true;
        this.setVisible(false);
    }

    private void okayButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.cancelled = false;
        this.setModifiers(evt.getModifiers());
        this.setVisible(false);
    }

    private void plotBelowButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.cancelled = false;
        this.setModifiers(2 | evt.getModifiers());
        this.setVisible(false);
    }

    private void overplotButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.cancelled = false;
        this.setModifiers(1);
        this.setVisible(false);
    }

    private void plotBelowUpdate(boolean above) {
        if (above) {
            this.plotBelowButton.setText("Plot Above");
        } else {
            this.plotBelowButton.setText("Plot Below");
        }
    }

    private void plotBelowButtonMouseMoved(MouseEvent evt) {
        this.plotBelowUpdate(evt.isShiftDown());
    }

    private void plotBelowButtonMouseEntered(MouseEvent evt) {
        this.plotBelowUpdate(evt.isShiftDown());
    }

    private void plotBelowButtonMouseExited(MouseEvent evt) {
        this.plotBelowUpdate(evt.isShiftDown());
    }

    void setPlayButton(boolean b) {
        if (b) {
            this.okayButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/go.png")));
            this.okayButton.setText("Plot");
        } else {
            this.okayButton.setIcon(null);
            this.okayButton.setText("OK");
        }
        this.plotBelowButton.setVisible(b);
        this.overplotButton.setVisible(b);
    }
}

