/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.URISplit;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.HtmlUtil;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.ProgressMonitor;

public class FileSystemUtil {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.util.fsutil");

    public static String getNameRelativeTo(FileSystem fs, String resource) {
        String s = fs.getRootURI().toString();
        if (resource.startsWith(s)) {
            return resource.substring(s.length());
        }
        return resource;
    }

    public static boolean isChildOf(File possibleParent, File maybeChild) {
        return FileUtil.isParent((File)possibleParent, (File)maybeChild);
    }

    public static File getPresentWorkingDirectory() throws IOException {
        String pwd = new File(".").getCanonicalPath();
        if (pwd.length() > 2) {
            if (pwd.endsWith(".")) {
                pwd = pwd.substring(0, pwd.length() - 1);
            }
            if (!pwd.endsWith(File.separator)) {
                pwd = pwd + File.separator;
            }
        }
        return new File(pwd);
    }

    public static boolean resourceExists(String suri) throws FileSystem.FileSystemOfflineException, UnknownHostException, URISyntaxException {
        URISplit split = URISplit.parse(suri);
        try {
            FileSystem fs = FileSystem.create((URI)DataSetURI.toUri(split.path));
            return fs.getFileObject(split.file.substring(split.path.length())).exists();
        }
        catch (FileNotFoundException | IllegalArgumentException ex) {
            return false;
        }
    }

    public static File doDownload(String suri, ProgressMonitor mon) throws FileSystem.FileSystemOfflineException, IOException, URISyntaxException {
        URISplit split = URISplit.parse(suri);
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri(split.path));
        File result = fs.getFileObject(split.file.substring(split.path.length())).getFile(mon);
        return result;
    }

    public static boolean resourceIsLocal(String suri) throws FileSystem.FileSystemOfflineException, UnknownHostException, FileNotFoundException {
        URISplit split = URISplit.parse(suri);
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri(split.path));
        return fs.getFileObject(split.file.substring(split.path.length())).isLocal();
    }

    protected static boolean resourceIsFile(String suri) throws FileSystem.FileSystemOfflineException, UnknownHostException, URISyntaxException, FileNotFoundException {
        URISplit split = URISplit.parse(suri);
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri(split.path));
        return fs.getFileObject(split.file.substring(split.path.length())).isData();
    }

    public static boolean isLocalResource(String file) {
        if (file.trim().length() == 0) {
            return false;
        }
        URISplit split = URISplit.parse(file);
        if (split.path == null) {
            return false;
        }
        URI resource = DataSetURI.toUri(split.path);
        String scheme = resource.getScheme();
        if (scheme == null) {
            return false;
        }
        if (scheme.equals("file") || scheme.equals("sftp")) {
            if (resource.getPath().contains(FileSystem.settings().getLocalCacheDir().toString())) {
                logger.info("path within local cache dir is considered non-local");
                return false;
            }
            if (resource.getPath().contains("upload")) {
                logger.info("path containing upload is considered non-local");
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean hasParent(URL url) {
        String surl = url.toExternalForm();
        String p = surl;
        if (p.endsWith("/")) {
            p = p.substring(0, p.length() - 1);
        }
        int is = p.lastIndexOf(47);
        p = p.substring(0, is + 1);
        try {
            URL[] kids;
            URL purl = new URL(p);
            for (URL k : kids = HtmlUtil.getDirectoryListing((URL)purl)) {
                if (!k.toExternalForm().equals(surl)) continue;
                return true;
            }
        }
        catch (MalformedURLException ex) {
            logger.log(Level.FINE, null, ex);
        }
        catch (IOException | CancelledOperationException ex) {
            logger.log(Level.FINE, null, ex);
        }
        return false;
    }

    public static boolean deleteFilesInTree(File root, Check shouldDelete) throws IllegalArgumentException {
        if (!root.exists()) {
            return true;
        }
        if (!root.canRead()) {
            throw new IllegalArgumentException("cannot read folder: " + root);
        }
        File[] children = root.listFiles();
        if (children == null) {
            return true;
        }
        boolean success = true;
        for (File children1 : children) {
            if (children1.isDirectory()) {
                success = success && FileSystemUtil.deleteFilesInTree(children1, shouldDelete);
                continue;
            }
            if (shouldDelete != null && !shouldDelete.check(children1)) continue;
            boolean bl = success = success && (!children1.exists() || children1.delete());
            if (success) continue;
            throw new IllegalArgumentException("unable to delete file " + children1);
        }
        children = root.listFiles();
        if (children == null) {
            children = new File[]{};
        }
        if (children.length == 0) {
            boolean bl = success = success && (!root.exists() || root.delete());
        }
        if (!success) {
            throw new IllegalArgumentException("unable to delete folder " + root);
        }
        return success;
    }

    public static boolean copyFile(File partFile, File targetFile) throws IOException {
        logger.log(Level.FINER, "ftpBeanFilesystem copyFile({0},{1}", new Object[]{partFile, targetFile});
        try (WritableByteChannel dest = Channels.newChannel(new FileOutputStream(targetFile));
             ReadableByteChannel src = Channels.newChannel(new FileInputStream(partFile));){
            DataSourceUtil.transfer(src, dest);
        }
        return true;
    }

    public static interface Check {
        public boolean check(File var1);
    }
}

