/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.InputVerifier;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.LoggerManager;
import org.das2.datum.Orbits;
import org.das2.datum.TimeUtil;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasRow;
import org.jdesktop.layout.GroupLayout;

public final class TimeRangeTool
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.gui");
    private boolean timeRangeFocus = true;
    private String orbit = "";
    private DatumRange pendingTimeRange;
    private DasAxis dasAxis;
    private final Preferences prefs;
    private static final String PREF_SPACECRAFT = "spacecraft";
    private final InputVerifier verifier = new InputVerifier(){

        @Override
        public boolean verify(String value) {
            try {
                DatumRangeUtil.parseTimeRange((String)value);
                return true;
            }
            catch (ParseException ex) {
                return false;
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        }
    };
    private static String[] extraSpacecraft = new String[0];
    private JLabel feedbackLabel;
    private JLabel interpretationLabel;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JButton nextIntervalButton;
    private JComboBox nrtComboBox;
    private JLabel orbitFeedbackLabel;
    private JList orbitList;
    private JTextField orbitNumberTF;
    private JButton prevIntervalButton;
    private JList recentTimesList;
    private JScrollPane recentTimesListSP;
    private JComboBox scComboBox;
    private JTextField startTextField;
    private JTextField stopTextField;
    private JTextField timeRangeTextField;
    private JButton zoomOutButton;

    private static String interpretIso8601Range(String range) {
        int ispace = range.indexOf(32);
        if (ispace > -1) {
            range = range.substring(0, ispace);
        }
        try {
            int[] digits = DatumRangeUtil.parseISO8601Duration((String)range);
            String[] sdigits = new String[]{"years", "months", "days", "hours", "minutes", "seconds"};
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < digits.length; ++i) {
                String sd;
                if (digits[i] <= 0) continue;
                int d = digits[i];
                String string = sd = d == 1 ? sdigits[i].substring(0, sdigits[i].length() - 1) : sdigits[i];
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(digits[i]).append(" ").append(sd);
            }
            return "last " + result.toString();
        }
        catch (ParseException ex) {
            if (range.startsWith("now/now+")) {
                return "next " + TimeRangeTool.interpretIso8601Range(range.substring(8)).substring(5);
            }
            switch (range) {
                case "P1D/lastday": {
                    return "24 hours leading up to the last day boundary";
                }
                case "P1Y/lastyear": {
                    return "last calendar year";
                }
                case "lastyear/P1Y": {
                    return "the current year";
                }
                case "lastday/P1D": {
                    return "the current day (in UT)";
                }
                case "P2M/lastmonth": {
                    return TimeRangeTool.interpretIso8601Range(range.substring(0, 3)).substring(5) + " leading up to the last month boundary";
                }
            }
            try {
                DatumRange dr = DatumRangeUtil.parseDatumRange((String)range);
                return dr.toString();
            }
            catch (ParseException ex1) {
                return range + "(parse error)";
            }
        }
    }

    public TimeRangeTool() {
        this.initComponents();
        this.nrtComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component parent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (parent instanceof JLabel) {
                    String s = TimeRangeTool.interpretIso8601Range((String)value);
                    if (s.equals(value)) {
                        ((JLabel)parent).setText(s);
                    } else {
                        ((JLabel)parent).setText(value + ": " + s);
                    }
                }
                return parent;
            }
        });
        this.interpretationLabel.setText(TimeRangeTool.interpretIso8601Range(this.nrtComboBox.getSelectedItem().toString()));
        DasCanvas canvas = new DasCanvas(528, 89);
        DasRow row = new DasRow(canvas, 0.3, 0.5);
        DasColumn column = new DasColumn(canvas, 0.1, 0.9);
        this.dasAxis = new DasAxis(DatumRangeUtil.parseTimeRangeValid((String)this.nrtComboBox.getSelectedItem().toString()), 2){

            protected void paintComponent(Graphics graphics) {
                Graphics g = graphics.create();
                super.paintComponent(graphics);
                g.translate(-this.getX(), -this.getY());
                g.setClip(null);
                int inow = (int)TimeRangeTool.this.dasAxis.transform(TimeUtil.now());
                int iy = TimeRangeTool.this.dasAxis.getRow().getDMaximum();
                g.setColor(Color.BLUE);
                g.fillPolygon(new int[]{inow - 7, inow, inow + 7, inow - 7}, new int[]{iy - 11, iy, iy - 11, iy - 11}, 4);
                g.setColor(Color.BLUE.darker());
                g.drawPolygon(new int[]{inow - 7, inow, inow + 7, inow - 7}, new int[]{iy - 11, iy, iy - 11, iy - 11}, 4);
            }
        };
        this.dasAxis.removeMouseListener((MouseListener)this.dasAxis.getDasMouseInputAdapter());
        this.dasAxis.setAnimated(true);
        canvas.add((DasCanvasComponent)this.dasAxis, row, column);
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel5.add((Component)canvas, "Center");
        this.jPanel5.revalidate();
        this.scComboBox.setModel(new DefaultComboBoxModel<String>(this.getSpacecraft()));
        this.prefs = AutoplotSettings.settings().getPreferences(TimeRangeTool.class);
        final String sc = this.prefs.get(PREF_SPACECRAFT, "rbspa-pp");
        this.scComboBox.setSelectedItem(sc);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                TimeRangeTool.this.resetSpacecraft(sc);
            }
        };
        new Thread(run, "loadOrbits").start();
        this.feedbackLabel.setText("loading orbits for rbspa");
        this.timeRangeTextField.addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    DatumRange dr = DatumRangeUtil.parseTimeRange((String)TimeRangeTool.this.timeRangeTextField.getText());
                    TimeRangeTool.this.startTextField.setText(TimeDatumFormatter.DEFAULT.format(dr.min()));
                    TimeRangeTool.this.stopTextField.setText(TimeDatumFormatter.DEFAULT.format(dr.max()));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        this.timeRangeTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    DatumRange dr = DatumRangeUtil.parseTimeRange((String)TimeRangeTool.this.timeRangeTextField.getText());
                    TimeRangeTool.this.startTextField.setText(TimeDatumFormatter.DEFAULT.format(dr.min()));
                    TimeRangeTool.this.stopTextField.setText(TimeDatumFormatter.DEFAULT.format(dr.max()));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        Runnable resetRecentRunnable = new Runnable(){

            @Override
            public void run() {
                TimeRangeTool.this.resetRecent();
            }
        };
        new Thread(resetRecentRunnable, "resetRecent").start();
        DefaultListModel<String> mm = new DefaultListModel<String>();
        mm.add(0, "Loading recent time ranges...");
        this.recentTimesList.setModel(mm);
    }

    public void setSelectedRange(String s) {
        DatumRange dr = null;
        try {
            this.pendingTimeRange = dr = DatumRangeUtil.parseTimeRange((String)s);
        }
        catch (ParseException ex) {
            logger.log(Level.FINE, "failed to parse as timerange: {0}", s);
        }
        this.resetSpacecraft(this.scComboBox.getSelectedItem().toString(), dr);
        if (s.startsWith("orbit:")) {
            String[] ss = s.split(":", 2);
            if (ss[1].startsWith("http://") || ss[1].startsWith("https://") || ss[1].startsWith("sftp://") || ss[1].startsWith("ftp://") || ss[1].startsWith("file:/")) {
                int i = ss[1].indexOf(58, 6);
                if (i == -1) {
                    this.scComboBox.setSelectedItem(ss[1]);
                } else {
                    this.scComboBox.setSelectedItem(ss[1].substring(0, i));
                    this.orbit = ss[1].substring(i + 1);
                }
            } else {
                int i = ss[1].indexOf(58);
                if (i == -1) {
                    this.scComboBox.setSelectedItem(ss[1]);
                    this.orbitList.setSelectedValue(ss[1], true);
                } else {
                    this.scComboBox.setSelectedItem(ss[1].substring(0, i));
                    this.orbit = ss[1].substring(i + 1);
                    this.orbitList.setSelectedValue(ss[1].substring(0, i), true);
                }
            }
            if (dr != null) {
                this.startTextField.setText(TimeDatumFormatter.DEFAULT.format(dr.min()));
                this.stopTextField.setText(TimeDatumFormatter.DEFAULT.format(dr.max()));
                this.timeRangeTextField.setText(dr.toString());
            } else {
                this.timeRangeTextField.setText(s);
            }
            this.resetSpacecraft((String)this.scComboBox.getSelectedItem(), this.pendingTimeRange);
            this.jTabbedPane1.setSelectedIndex(1);
        } else if (s.startsWith("p")) {
            this.nrtComboBox.setSelectedItem(s);
            this.jTabbedPane1.setSelectedIndex(2);
        } else {
            this.jTabbedPane1.setSelectedIndex(0);
            if (dr != null) {
                this.timeRangeTextField.setText(dr.toString());
                this.startTextField.setText(TimeDatumFormatter.DEFAULT.format(dr.min()));
                this.stopTextField.setText(TimeDatumFormatter.DEFAULT.format(dr.max()));
            } else {
                this.timeRangeTextField.setText(s);
                this.startTextField.setText("");
                this.stopTextField.setText("");
            }
        }
    }

    public String getSelectedRange() {
        int idx = this.jTabbedPane1.getSelectedIndex();
        switch (idx) {
            case 0: {
                try {
                    if (this.timeRangeFocus) {
                        String txt = this.timeRangeTextField.getText();
                        return DatumRangeUtil.parseTimeRange((String)txt).toString();
                    }
                    String min = this.startTextField.getText();
                    String max = this.stopTextField.getText();
                    Datum tmin = TimeUtil.create((String)min);
                    Datum tmax = TimeUtil.create((String)max);
                    return new DatumRange(tmin, tmax).toString();
                }
                catch (ParseException ex) {
                    return this.timeRangeTextField.getText();
                }
            }
            case 1: {
                String sc = (String)this.scComboBox.getSelectedItem();
                String orb = (String)this.orbitList.getSelectedValue();
                List indexes = this.orbitList.getSelectedValuesList();
                if (indexes.size() > 1) {
                    StringBuilder orbits = new StringBuilder();
                    int i = orb.indexOf(58);
                    if (i > -1) {
                        orbits.append(orb.substring(0, i));
                    } else {
                        orbits.append(orb);
                    }
                    orbits.append("-");
                    orb = String.valueOf(indexes.get(indexes.size() - 1));
                    i = orb.indexOf(58);
                    if (i > -1) {
                        orbits.append(orb.substring(0, i));
                    } else {
                        orbits.append(orb);
                    }
                    orb = orbits.toString();
                } else {
                    int i;
                    if (orb == null) {
                        this.orbitList.setSelectedIndex(0);
                        orb = this.orbitList.getSelectedValue().toString();
                    }
                    if ((i = orb.indexOf(58)) > -1) {
                        orb = orb.substring(0, i);
                    }
                }
                return "orbit:" + sc + ":" + orb;
            }
            case 2: {
                String s = (String)this.nrtComboBox.getSelectedItem();
                int i = s.indexOf(32);
                if (i == -1) {
                    return s;
                }
                return s.substring(0, i);
            }
            case 3: {
                String s = (String)this.recentTimesList.getSelectedValue();
                if (s.startsWith("Loading")) {
                    try {
                        if (this.timeRangeFocus) {
                            String txt = this.timeRangeTextField.getText();
                            return DatumRangeUtil.parseTimeRange((String)txt).toString();
                        }
                        String min = this.startTextField.getText();
                        String max = this.stopTextField.getText();
                        Datum tmin = TimeUtil.create((String)min);
                        Datum tmax = TimeUtil.create((String)max);
                        return new DatumRange(tmin, tmax).toString();
                    }
                    catch (ParseException ex) {
                        s = this.timeRangeTextField.getText();
                    }
                }
                return s;
            }
        }
        throw new IllegalArgumentException("not implemented");
    }

    private String[] getSpacecraft() {
        Map scs = Orbits.getSpacecraftIdExamples();
        String[] ss = scs.keySet().toArray(new String[scs.size()]);
        int n = ss.length;
        String[] result = new String[n + extraSpacecraft.length];
        System.arraycopy(ss, 0, result, 0, n);
        System.arraycopy(extraSpacecraft, 0, result, n, extraSpacecraft.length);
        return result;
    }

    public static void setAdditionalSpacecraftForOrbit(String[] scs) {
        extraSpacecraft = Arrays.copyOf(scs, scs.length);
    }

    private void resetSpacecraft(String sc) {
        this.resetSpacecraft(sc, null);
    }

    private void resetSpacecraft(final String sc, DatumRange focusRange) {
        Orbits o;
        logger.log(Level.FINE, "resetSpacecraft({0})", sc);
        final DefaultListModel<String> mm = new DefaultListModel<String>();
        this.prefs.put(PREF_SPACECRAFT, sc);
        String focusItem = null;
        try {
            boolean gotFocus;
            o = Orbits.getOrbitsFor((String)sc);
            ArrayList<String> ss = new ArrayList<String>();
            String orb = o.first();
            boolean bl = gotFocus = focusRange == null;
            while (orb != null) {
                try {
                    String str = String.valueOf(o.getDatumRange(orb));
                    ss.add(orb + ": " + str);
                    if (!gotFocus && o.getDatumRange(orb).intersects(focusRange)) {
                        if (DatumRangeUtil.normalize((DatumRange)focusRange, (Datum)o.getDatumRange(orb).max()) < 0.5) {
                            logger.fine("trivial overlap ignored");
                        } else {
                            gotFocus = true;
                            focusItem = orb + ": " + str;
                        }
                    }
                }
                catch (ParseException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
                orb = o.next(orb);
            }
            for (String s : ss) {
                mm.addElement(s);
            }
        }
        catch (IllegalArgumentException ex) {
            o = null;
            mm.addElement(ex.getMessage());
        }
        final Orbits finalOrbits = o;
        final String ffocusItem = focusItem;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimeRangeTool.this.orbitList.setModel(mm);
                if (finalOrbits != null && TimeRangeTool.this.orbit.length() > 0) {
                    try {
                        finalOrbits.getDatumRange(TimeRangeTool.this.orbit);
                        if (ffocusItem != null) {
                            TimeRangeTool.this.orbitList.setSelectedValue(ffocusItem, true);
                        }
                    }
                    catch (ParseException parseException) {}
                } else {
                    TimeRangeTool.this.orbitList.setSelectedIndex(0);
                }
                String s = (String)TimeRangeTool.this.orbitList.getSelectedValue();
                if (s != null) {
                    TimeRangeTool.this.showOrbit(s);
                }
                if (sc.contains(":")) {
                    TimeRangeTool.this.feedbackLabel.setText("orbits from " + sc);
                } else if (finalOrbits == null) {
                    TimeRangeTool.this.feedbackLabel.setText("orbits from ERROR");
                } else {
                    TimeRangeTool.this.feedbackLabel.setText("orbits from " + finalOrbits.getURL());
                }
            }
        });
    }

    private void resetRecent() {
        int RECENT_SIZE = 20;
        File bookmarksFolder = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks");
        File recentFile = new File(bookmarksFolder, "recent.timerange.txt");
        List items = new ArrayList<String>(RECENT_SIZE + 2);
        try {
            if (recentFile.exists()) {
                try (BufferedReader r = new BufferedReader(new FileReader(recentFile));){
                    String s = r.readLine();
                    while (s != null) {
                        if (this.verifier != null && !this.verifier.verify(s)) {
                            logger.log(Level.INFO, "invalid time found in recent.timerange.txt, dropping: {0}", s);
                            s = r.readLine();
                            continue;
                        }
                        items.add(s);
                        s = r.readLine();
                    }
                }
            }
            Collections.reverse(items);
            ArrayList<String> nitems = new ArrayList<String>(items.size());
            for (int i = 0; i < items.size(); ++i) {
                String item = (String)items.get(i);
                if (nitems.contains(item)) continue;
                nitems.add(item);
            }
            items = nitems;
            int n = items.size();
            if (n > RECENT_SIZE) {
                items = items.subList(0, RECENT_SIZE);
            }
            final DefaultListModel dlm = new DefaultListModel();
            for (int i = 0; i < items.size(); ++i) {
                dlm.add(i, items.get(i));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimeRangeTool.this.recentTimesList.setModel(dlm);
                }
            });
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel7 = new JLabel();
        this.timeRangeTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.startTextField = new JTextField();
        this.stopTextField = new JTextField();
        this.jButton1 = new JButton();
        this.nextIntervalButton = new JButton();
        this.prevIntervalButton = new JButton();
        this.zoomOutButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.scComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.orbitFeedbackLabel = new JLabel();
        this.jLabel10 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.orbitList = new JList();
        this.feedbackLabel = new JLabel();
        this.orbitNumberTF = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.nrtComboBox = new JComboBox();
        this.jPanel5 = new JPanel();
        this.interpretationLabel = new JLabel();
        this.jPanel4 = new JPanel();
        this.recentTimesListSP = new JScrollPane();
        this.recentTimesList = new JList();
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TimeRangeTool.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jLabel3.setText("Select Time By Calendar Dates");
        this.jLabel7.setText("Enter Time Range:");
        this.jLabel7.setToolTipText("This time range is interpretted a flexible parser that understands many time formats");
        this.timeRangeTextField.setText("jTextField1");
        this.timeRangeTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TimeRangeTool.this.timeRangeTextFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                TimeRangeTool.this.timeRangeTextFieldFocusLost(evt);
            }
        });
        this.jLabel6.setText("Or Enter Separate Times (ISO8601):");
        this.jLabel6.setToolTipText("Enter the start and stop times separately, using ISO8601 standard time representation.");
        this.jLabel8.setText("Begin:");
        this.jLabel9.setText("End:");
        this.startTextField.setText("jTextField2");
        this.startTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TimeRangeTool.this.startTextFieldFocusGained(evt);
            }
        });
        this.stopTextField.setText("jTextField3");
        this.stopTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TimeRangeTool.this.stopTextFieldFocusGained(evt);
            }
        });
        this.jButton1.setText("Copy");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeRangeTool.this.jButton1ActionPerformed(evt);
            }
        });
        this.nextIntervalButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/nextNext.png")));
        this.nextIntervalButton.setText("Next Interval");
        this.nextIntervalButton.setToolTipText("Scan to the next interval");
        this.nextIntervalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeRangeTool.this.nextIntervalButtonActionPerformed(evt);
            }
        });
        this.prevIntervalButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/prevPrev.png")));
        this.prevIntervalButton.setText("Previous Interval");
        this.prevIntervalButton.setToolTipText("Scan to the previous interval");
        this.prevIntervalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeRangeTool.this.prevIntervalButtonActionPerformed(evt);
            }
        });
        this.zoomOutButton.setText("Zoom Out");
        this.zoomOutButton.setToolTipText("Zoom out, making the span three times as wide with the same center");
        this.zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeRangeTool.this.zoomOutButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel3, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel7).add((Component)this.jLabel6).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.timeRangeTextField).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel8).add((Component)this.jLabel9)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.stopTextField, -2, 371, -2).add((Component)this.startTextField, -2, 390, -2))).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.prevIntervalButton).addPreferredGap(0).add((Component)this.zoomOutButton).addPreferredGap(0).add((Component)this.nextIntervalButton))).add(0, 0, Short.MAX_VALUE).add((Component)this.jButton1))))).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.startTextField, this.stopTextField}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel3).add(18, 18, 18).add((Component)this.jLabel7).addPreferredGap(0).add((Component)this.timeRangeTextField, -2, -1, -2).addPreferredGap(1).add((Component)this.jLabel6).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.startTextField, -2, -1, -2).add((Component)this.jButton1)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel9).add((Component)this.stopTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.nextIntervalButton).add((Component)this.prevIntervalButton).add((Component)this.zoomOutButton)).addContainerGap(203, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Calendar", this.jPanel1);
        this.jLabel2.setText("Time Ranges by Orbit");
        this.scComboBox.setEditable(true);
        this.scComboBox.setToolTipText("Id of the orbits file or URL to orbits file");
        this.scComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TimeRangeTool.this.scComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel4.setText("Spacecraft:");
        this.jLabel5.setText("Orbit:");
        this.orbitFeedbackLabel.setFont(this.orbitFeedbackLabel.getFont().deriveFont((float)this.orbitFeedbackLabel.getFont().getSize() - 2.0f));
        this.orbitFeedbackLabel.setText("Shows selected timerange for orbit");
        this.jLabel10.setFont(this.jLabel10.getFont().deriveFont((float)this.jLabel10.getFont().getSize() - 4.0f));
        this.jLabel10.setText("Select from predefined orbits, or spacecraft may be a URL to any three-column text file.");
        this.orbitList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Loading orbits..."};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.orbitList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TimeRangeTool.this.orbitListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.orbitList);
        this.feedbackLabel.setFont(this.feedbackLabel.getFont().deriveFont((float)this.feedbackLabel.getFont().getSize() - 2.0f));
        this.feedbackLabel.setText("jLabel11");
        this.orbitNumberTF.setToolTipText("Enter orbit id and press Enter key");
        this.orbitNumberTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeRangeTool.this.orbitNumberTFActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel2, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.feedbackLabel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel4, -2, 107, -2).add(18, 18, 18).add((Component)this.scComboBox, 0, -1, Short.MAX_VALUE)).add(1, (Component)this.jLabel10, -1, 591, Short.MAX_VALUE).add(1, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel5).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jScrollPane1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.orbitFeedbackLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.orbitNumberTF, -2, 96, -2))))).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel2).add(3, 3, 3).add((Component)this.jLabel10).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.scComboBox, -2, -1, -2)).add(3, 3, 3).add((Component)this.feedbackLabel).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.orbitFeedbackLabel).add((Component)this.orbitNumberTF, -2, -1, -2)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 282, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Orbits", this.jPanel2);
        this.jLabel1.setText("Near Real Time timeranges");
        this.nrtComboBox.setEditable(true);
        this.nrtComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"PT2H", "P1D", "P5D", "P30D", "now/now+P1D", "now/now+P5D", "now/now+P30D", "P1D/lastday", "lastday/P1D", "P2M/lastmonth", "lastyear/P1Y"}));
        this.nrtComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeRangeTool.this.nrtComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add(0, 528, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add(0, 89, Short.MAX_VALUE));
        this.interpretationLabel.setText("---------");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jLabel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(12, 12, 12).add((Component)this.nrtComboBox, 0, -1, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel5, -2, -1, -2)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.interpretationLabel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.nrtComboBox, -2, -1, -2).addPreferredGap(0).add((Component)this.interpretationLabel).add(9, 9, 9).add((Component)this.jPanel5, -2, -1, -2).addContainerGap(233, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("NRT", this.jPanel3);
        this.recentTimesList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.recentTimesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TimeRangeTool.this.recentTimesListValueChanged(evt);
            }
        });
        this.recentTimesListSP.setViewportView(this.recentTimesList);
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.recentTimesListSP, -1, 603, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.recentTimesListSP, -1, 400, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("Recent Times", this.jPanel4);
        this.jTabbedPane1.setSelectedIndex(1);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTabbedPane1, -1, 603, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTabbedPane1, -1, 435, Short.MAX_VALUE));
    }

    private void scComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        final String sc = (String)this.scComboBox.getSelectedItem();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                TimeRangeTool.this.resetSpacecraft(sc, TimeRangeTool.this.pendingTimeRange);
            }
        };
        new Thread(run, String.format("loadOrbits-%010d", System.currentTimeMillis())).start();
        if (sc.contains(":")) {
            this.feedbackLabel.setText("loading orbits from " + sc);
        } else {
            this.feedbackLabel.setText("loading orbits for " + sc);
        }
    }

    private void timeRangeTextFieldFocusLost(FocusEvent evt) {
        try {
            DatumRange dr = DatumRangeUtil.parseTimeRange((String)this.timeRangeTextField.getText());
            this.startTextField.setText(TimeDatumFormatter.DEFAULT.format(dr.min()));
            this.stopTextField.setText(TimeDatumFormatter.DEFAULT.format(dr.max()));
            this.pendingTimeRange = dr;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void timeRangeTextFieldFocusGained(FocusEvent evt) {
        this.timeRangeFocus = true;
    }

    private void startTextFieldFocusGained(FocusEvent evt) {
        this.timeRangeFocus = false;
    }

    private void stopTextFieldFocusGained(FocusEvent evt) {
        this.timeRangeFocus = false;
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (this.jTabbedPane1.getSelectedIndex() == 1) {
            if (this.pendingTimeRange != null) {
                this.resetSpacecraft((String)this.scComboBox.getSelectedItem(), this.pendingTimeRange);
            }
        } else if (this.jTabbedPane1.getSelectedIndex() == 3 && this.pendingTimeRange != null) {
            ListModel m = this.recentTimesList.getModel();
            for (int i = 0; i < m.getSize(); ++i) {
                try {
                    DatumRange tr = DatumRangeUtil.parseTimeRange((String)((String)m.getElementAt(i)));
                    if (!tr.intersects(this.pendingTimeRange)) continue;
                    this.recentTimesList.setSelectedIndex(i);
                    break;
                }
                catch (ParseException ex) {
                    logger.log(Level.WARNING, null, ex);
                }
            }
            if (this.recentTimesList.getSelectedIndex() == -1) {
                this.recentTimesList.setSelectedIndex(0);
            }
        }
    }

    private void orbitListValueChanged(ListSelectionEvent evt) {
        String sel = (String)this.orbitList.getSelectedValue();
        if (sel != null) {
            this.orbit = this.showOrbit(sel);
        } else {
            this.orbitFeedbackLabel.setText("Any orbit number can be entered by editing the text.");
        }
    }

    private void recentTimesListValueChanged(ListSelectionEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.stopTextField.setText(this.startTextField.getText());
    }

    private void nextIntervalButtonActionPerformed(ActionEvent evt) {
        try {
            String min = this.startTextField.getText();
            String max = this.stopTextField.getText();
            Datum tmin = TimeUtil.create((String)min);
            Datum tmax = TimeUtil.create((String)max);
            DatumRange dr = new DatumRange(tmin, tmax);
            String s = this.timeRangeTextField.getText();
            DatumRange dr0 = DatumRangeUtil.parseTimeRange((String)s);
            if (dr.equals((Object)dr0)) {
                dr = dr0;
            }
            dr = dr.next();
            this.startTextField.setText(dr.min().toString());
            this.stopTextField.setText(dr.max().toString());
            this.timeRangeTextField.setText(dr.toString());
        }
        catch (ParseException ex) {
            Logger.getLogger(TimeRangeTool.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void prevIntervalButtonActionPerformed(ActionEvent evt) {
        try {
            String min = this.startTextField.getText();
            String max = this.stopTextField.getText();
            Datum tmin = TimeUtil.create((String)min);
            Datum tmax = TimeUtil.create((String)max);
            DatumRange dr = new DatumRange(tmin, tmax);
            String s = this.timeRangeTextField.getText();
            DatumRange dr0 = DatumRangeUtil.parseTimeRange((String)s);
            if (dr.equals((Object)dr0)) {
                dr = dr0;
            }
            dr = dr.previous();
            this.startTextField.setText(dr.min().toString());
            this.stopTextField.setText(dr.max().toString());
            this.timeRangeTextField.setText(dr.toString());
        }
        catch (ParseException ex) {
            Logger.getLogger(TimeRangeTool.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void zoomOutButtonActionPerformed(ActionEvent evt) {
        try {
            String min = this.startTextField.getText();
            String max = this.stopTextField.getText();
            Datum tmin = TimeUtil.create((String)min);
            Datum tmax = TimeUtil.create((String)max);
            DatumRange dr = new DatumRange(tmin, tmax);
            String s = this.timeRangeTextField.getText();
            DatumRange dr0 = DatumRangeUtil.parseTimeRange((String)s);
            if (dr.equals((Object)dr0)) {
                dr = dr0;
            }
            DatumRange pp = dr.previous();
            DatumRange pn = dr.next();
            dr = pp.union(dr).union(pn);
            this.startTextField.setText(dr.min().toString());
            this.stopTextField.setText(dr.max().toString());
            this.timeRangeTextField.setText(dr.toString());
        }
        catch (ParseException ex) {
            Logger.getLogger(TimeRangeTool.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void orbitNumberTFActionPerformed(ActionEvent evt) {
        String orbit1 = this.orbitNumberTF.getText();
        String s = this.showOrbit(orbit1);
        this.setSelectedRange("orbit:" + (String)this.scComboBox.getSelectedItem() + ":" + s);
    }

    private void nrtComboBoxActionPerformed(ActionEvent evt) {
        this.interpretationLabel.setText(TimeRangeTool.interpretIso8601Range(this.nrtComboBox.getSelectedItem().toString()));
        try {
            this.dasAxis.setDatumRange(DatumRangeUtil.parseTimeRange((String)this.nrtComboBox.getSelectedItem().toString()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private String showOrbit(String sorbit) {
        try {
            Orbits o = Orbits.getOrbitsFor((String)((String)this.scComboBox.getSelectedItem()));
            int i = sorbit.indexOf(58);
            if (i > -1) {
                sorbit = sorbit.substring(0, i);
            }
            try {
                DatumRange dr = o.getDatumRange(sorbit);
                this.orbitFeedbackLabel.setText(sorbit + ": " + dr.toString());
                this.pendingTimeRange = dr;
            }
            catch (ParseException ex) {
                this.orbitFeedbackLabel.setText("No such orbit found: " + sorbit);
            }
            return sorbit;
        }
        catch (IllegalArgumentException ex) {
            return "";
        }
    }

    public static void main(String[] args) {
        TimeRangeTool trt = new TimeRangeTool();
        JOptionPane.showConfirmDialog(null, trt);
    }
}

